/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.enums.CheckSchemaDisParamEnum;

public class QulityJob {
    private static final Log log = LogFactory.getLog(QulityJob.class);
    private DynamicObject[] unDisTaskcol = null;
    private static final String TASK_QUALITYSAMPLELIBRARY = "task_qualitysamplelibrary";
    private Set<Long> qJobAllOrSourcelibSet = new HashSet<Long>();
    private static final String TASK_TASHHISTORY = "task_taskhistory";
    private Map<Long, Long> taskIdHisTaskType = new HashMap<Long, Long>();
    private Map<Long, Long> sourceTaskPerson = new HashMap<Long, Long>();
    private boolean printLog;

    public void prepareData() {
        DynamicObject[] sourceTasks;
        DynamicObject[] qJobAllOrSourceHisTasks;
        DynamicObject[] atAdtQjbAiSBLibs;
        Map<String, Set<Long>> qLibMap = this.buildAdtQLibs(this.unDisTaskcol);
        Set<Long> unDisTaskQLibAudit = qLibMap.get("auditQLib");
        Set<Long> qSourceTaskIds = qLibMap.get("qSourceTask");
        QFilter unDisQjobLibrary = new QFilter("id", "in", unDisTaskQLibAudit);
        QFilter qJobAllOrSourceSchmFilter = this.buildChkSchmAiSBFilter();
        for (DynamicObject qJobAllOrSourcelib : atAdtQjbAiSBLibs = BusinessDataServiceHelper.load((String)TASK_QUALITYSAMPLELIBRARY, (String)"id", (QFilter[])new QFilter[]{unDisQjobLibrary, qJobAllOrSourceSchmFilter})) {
            this.qJobAllOrSourcelibSet.add(qJobAllOrSourcelib.getLong("id"));
        }
        HashSet<Long> undisSourceIds = new HashSet<Long>();
        HashMap<Long, Integer> unDsTskJbIdIndexMap = new HashMap<Long, Integer>();
        int unDisTaskcolLenth = this.unDisTaskcol.length;
        for (int index = 0; index < unDisTaskcolLenth; ++index) {
            DynamicObject unDisTask = this.unDisTaskcol[index];
            if (!this.qJobAllOrSourcelibSet.contains(unDisTask.getLong("qualitysamplelibrary.id"))) continue;
            undisSourceIds.add(unDisTask.getLong("sourcetaskid"));
            unDsTskJbIdIndexMap.put(unDisTask.getLong("sourcetaskid"), index);
        }
        QFilter atAdtQjbScTkFilter = new QFilter("id", "in", undisSourceIds);
        for (DynamicObject qJobAllOrSourceHisTask : qJobAllOrSourceHisTasks = BusinessDataServiceHelper.load((String)TASK_TASHHISTORY, (String)"id,tasktypeid", (QFilter[])new QFilter[]{atAdtQjbScTkFilter})) {
            Long hisTaskId = qJobAllOrSourceHisTask.getLong("id");
            Integer unDisTaskIndex = (Integer)unDsTskJbIdIndexMap.get(hisTaskId);
            if (unDisTaskIndex == null) continue;
            long unDisTaskID = this.unDisTaskcol[unDisTaskIndex].getLong("id");
            long unDisTaskIDSourceType = qJobAllOrSourceHisTask.getLong("tasktypeid.id");
            this.taskIdHisTaskType.put(unDisTaskID, unDisTaskIDSourceType);
        }
        for (DynamicObject task : sourceTasks = BusinessDataServiceHelper.load((String)TASK_TASHHISTORY, (String)"id,personid", (QFilter[])new QFilter[]{new QFilter("id", "in", qSourceTaskIds)})) {
            this.sourceTaskPerson.put(task.getLong("id"), task.getLong("personid.id"));
        }
    }

    public QulityJob(DynamicObject[] unDisTaskcol) {
        this.unDisTaskcol = unDisTaskcol;
    }

    public long getQjobSourceType(DynamicObject task) {
        long id = -1L;
        id = task.getLong("id");
        Long hisTaskType = this.taskIdHisTaskType.get(id);
        if (hisTaskType == null) {
            return -1L;
        }
        return hisTaskType;
    }

    public long getQjobSourcePerson(DynamicObject task) {
        long id = task.getLong("sourcetaskid");
        Long person = this.sourceTaskPerson.get(id);
        if (person == null) {
            person = -1L;
        }
        return person;
    }

    private Map<String, Set<Long>> buildAdtQLibs(DynamicObject[] unDisTasks) {
        HashSet<Long> unDisTaskQLibAudit = new HashSet<Long>(16);
        HashSet<Long> qSourceTask = new HashSet<Long>(16);
        HashMap<String, Set<Long>> qLibMap = new HashMap<String, Set<Long>>(2);
        if (unDisTasks == null || unDisTasks.length == 0) {
            this.logInfo("unDisTask is null or is empty");
            return qLibMap;
        }
        for (DynamicObject unTask : unDisTasks) {
            Long sLib = unTask.getLong("qualitysamplelibrary.id");
            if (this.isAutoAdtQJb(unTask)) {
                unDisTaskQLibAudit.add(sLib);
            }
            if (sLib <= 0L) continue;
            qSourceTask.add(unTask.getLong("sourcetaskid"));
        }
        qLibMap.put("auditQLib", unDisTaskQLibAudit);
        qLibMap.put("qSourceTask", qSourceTask);
        return qLibMap;
    }

    private QFilter buildChkSchmAiSBFilter() {
        HashSet<String> chkSchmAiSBSet = new HashSet<String>();
        chkSchmAiSBSet.add(CheckSchemaDisParamEnum.INTELLIGENT.getCode());
        chkSchmAiSBSet.add(CheckSchemaDisParamEnum.SOURCEBILLRULE.getCode());
        QFilter chkSchmAiSBFilter = new QFilter("checkscheme.disrule", "in", chkSchmAiSBSet);
        chkSchmAiSBFilter.or(new QFilter("smartcheckscheme.disrule", "in", chkSchmAiSBSet));
        return chkSchmAiSBFilter;
    }

    public boolean isAutoAdtQJb(DynamicObject job) {
        boolean result = false;
        String billNumber = job.getString("billnumber");
        this.logInfo("current waitDisTask billNo: " + billNumber + ";");
        boolean isOriJobAD = job.getBoolean("autoprocess");
        this.logInfo("waitDisTask autoApproveTag: " + isOriJobAD);
        boolean isQulityJob = job.getLong("qualitysamplelibrary.id") > 0L;
        this.logInfo("waitDis qualityLib: " + isQulityJob);
        if (isOriJobAD && isQulityJob) {
            result = true;
        }
        return result;
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }
}

