/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.business.service.credit.CreditDelayService;
import kd.ssc.task.dis.CreditDelayDis;
import kd.ssc.task.disRebuild.engine.Distribution4Ask;
import kd.ssc.task.disRebuild.engine.Distribution4DifferentSSC;
import kd.ssc.task.disRebuild.engine.Distribution4MonitorRetry;
import kd.ssc.task.disRebuild.engine.Distribution4Predist;
import kd.ssc.task.disRebuild.engine.Distribution4Redist;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.pojo.ProxyPOJO;
import kd.ssc.task.disRebuild.util.DisExceptionUtil;
import kd.ssc.task.disRebuild.util.DisRequestCtxConstructUtil;
import kd.ssc.task.disRebuild.util.DistributionLockUtil;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.dto.approve.DecisionResult;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;

public class Distribution {
    private static final Log log = LogFactory.getLog(Distribution.class);
    private static final ThreadPool pool = ThreadPools.newFixedThreadPool((String)"SSC_Task_Distribution", (int)4);

    public static void autoDistribution(QFilter unDisFilter, DisTaskSourceEnum disTaskSource, boolean sync) {
        log.info("\u81ea\u52a8\u5206\u914d\u5f00\u59cb");
        long begin = System.currentTimeMillis();
        Map<Long, List<DynamicObject>> disTaskMap = Distribution.getSscUnDisTaskMap(unDisFilter, disTaskSource);
        long end = System.currentTimeMillis();
        log.info("\u81ea\u52a8\u5206\u914d\uff0c\u51c6\u5907\u6570\u636e\u65f6\u95f4\uff1a" + (end - begin));
        if (disTaskMap == null || disTaskMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> allTasks = new ArrayList<DynamicObject>();
        disTaskMap.forEach((k, v) -> allTasks.addAll((Collection<DynamicObject>)v));
        DisRequestCtx baseCtx = DisRequestCtxConstructUtil.constructDisRequestCtx4AutoDisBase(allTasks);
        try {
            for (Map.Entry<Long, List<DynamicObject>> entry : disTaskMap.entrySet()) {
                List<DynamicObject> unDisTaskList = entry.getValue();
                if (CollectionUtils.isEmpty(unDisTaskList)) continue;
                DisRequestCtx ctx = DisRequestCtxConstructUtil.constructDisRequestCtx4AutoDis(entry.getKey(), baseCtx);
                List<Long> taskIdSet = unDisTaskList.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
                Distribution4DifferentSSC distribution4DifferentSSC = new Distribution4DifferentSSC(entry.getKey(), ctx, taskIdSet);
                if (sync) {
                    distribution4DifferentSSC.run();
                    continue;
                }
                pool.execute((Runnable)distribution4DifferentSSC);
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5206\u914d\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u81ea\u52a8\u5206\u914d\u7ed3\u675f");
    }

    public static Map<Long, Set<Long>> manualDistribution(long disTaskId, DynamicObject[] rules, boolean isRectification, List<Long> errRuleDyns) {
        Map<Long, Set<Long>> rtn = Collections.emptyMap();
        try {
            DisRequestCtx ctx = DisRequestCtxConstructUtil.constructDisRequestCtx4ManualDis(disTaskId, rules);
            rtn = Distribution4Redist.matchAllRule4Single(ctx, disTaskId, isRectification, errRuleDyns);
        }
        catch (Throwable e) {
            DisExceptionUtil.saveMonitorException(disTaskId, DisTypeEnum.MANUAL_DIS, e);
        }
        return rtn;
    }

    public static List<Long> manualDisTaskDeal4Batch(Long userGroup, Long userId, List<DynamicObject> taskDynList, StringBuilder errorMsg) {
        log.info("manualDisTaskDeal4Batch begin");
        long begin = System.currentTimeMillis();
        boolean isRobertGroup = UserGroupUtil.isRobotGroup(userGroup);
        ProxyPOJO proxy = new ProxyPOJO();
        ArrayList<Long> successTaskIds = new ArrayList<Long>(taskDynList.size());
        ArrayList<DynamicObject> stateChangeDyos = new ArrayList<DynamicObject>(taskDynList.size());
        DistributionLockUtil lock = new DistributionLockUtil();
        Iterator<DynamicObject> it = taskDynList.iterator();
        while (it.hasNext()) {
            DynamicObject taskDyo = it.next();
            Long taskId = (Long)taskDyo.getPkValue();
            if (!lock.getLock(taskId)) {
                it.remove();
                errorMsg.append(Distribution.getSyncError(taskDyo.getString("billnumber")));
                errorMsg.append("\n");
                continue;
            }
            DynamicObject stateChangeDyo = Distribution.manualDisTaskDeal4Single(userGroup, userId, taskDyo, isRobertGroup, proxy);
            stateChangeDyos.add(stateChangeDyo);
            successTaskIds.add(taskId);
        }
        if (successTaskIds.size() == 0) {
            return new ArrayList<Long>(0);
        }
        DynamicObject[] instNodes = ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDisTask_(taskDynList);
        try (TXHandle h = TX.requiresNew((String)(Distribution.class + ".manualDisTaskDeal4Batch"));){
            try {
                SaveServiceHelper.save((DynamicObject[])taskDynList.toArray(new DynamicObject[taskDynList.size()]));
                SaveServiceHelper.save((DynamicObject[])stateChangeDyos.toArray(new DynamicObject[stateChangeDyos.size()]));
                OtherUtil.deletePriorityLog(successTaskIds);
                if (instNodes != null && instNodes.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])instNodes);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                log.error("an exception occured while executing manualDisTaskDeal4Batch().", e);
                throw e;
            }
            finally {
                lock.releaseLock(successTaskIds);
            }
        }
        OtherUtil.afterDisBatch(DisTypeEnum.MANUAL_DIS, taskDynList);
        long end = System.currentTimeMillis();
        log.info("manualDisTaskDeal4Batch end :{}ms", (Object)(end - begin));
        return successTaskIds;
    }

    public static List<Long> trans2Redist(Map<Long, DecisionResult> taskDecisionResult) {
        ArrayList<Long> successTaskIds = new ArrayList<Long>(taskDecisionResult.size());
        try {
            Distribution.trans2Redistribute(taskDecisionResult, successTaskIds);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5ba1\u6838\u8f6c\u4eba\u5de5\u5206\u914d\u5931\u8d25", (Throwable)e);
        }
        return successTaskIds;
    }

    private static void trans2Redistribute(Map<Long, DecisionResult> taskDecisionResult, List<Long> successTaskIds) {
        Map<Long, DynamicObject> taskMap = Distribution.buildTaskMap(taskDecisionResult.keySet());
        if (taskMap.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> taskGroupBySSCMap = Distribution.buildTaskGroupBySSCMap(taskMap);
        for (Map.Entry<Long, List<DynamicObject>> entry : taskGroupBySSCMap.entrySet()) {
            Long sscid = entry.getKey();
            List<DynamicObject> taskList = entry.getValue();
            DisRequestCtx ctx = DisRequestCtxConstructUtil.constructDisRequestCtx4TransRedist(sscid, taskList);
            for (DynamicObject task : taskList) {
                Long taskId = (Long)task.getPkValue();
                String innerMsg = taskDecisionResult.get(taskId).getErrorInfo();
                if (!StringUtils.isEmpty((Object)innerMsg) && innerMsg.length() > 2000) {
                    innerMsg = innerMsg.substring(0, 2000);
                }
                task.set("innermsg", (Object)innerMsg);
                ctx.setDisTaskId(taskId);
                ctx.setDisTask(task);
                boolean result = Distribution4Redist.distribute4Single(ctx, taskId);
                if (!result) continue;
                successTaskIds.add(taskId);
            }
        }
    }

    public static List<Long> askTaskDistribution(Long userId, Long sscid, QFilter taskExtFilter, int taskNum) {
        long begin = System.currentTimeMillis();
        List<DynamicObject> allTaskIds = OtherUtil.getAllTask(sscid, taskExtFilter, DisTaskSourceEnum.GET_DIS_1);
        if (CollectionUtils.isEmpty(allTaskIds)) {
            return new ArrayList<Long>();
        }
        DisRequestCtx ctx = DisRequestCtxConstructUtil.constructDisRequestCtx4AskTask(userId, sscid, allTaskIds);
        long end = System.currentTimeMillis();
        log.info("\u4e3b\u52a8\u83b7\u53d6\uff0c\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237\uff1a" + userId + " \u6ee1\u8db3\u6761\u4ef6\u7684\u4efb\u52a1\u6570\uff1a" + allTaskIds.size() + " \u6570\u636e\u6784\u5efa\u65f6\u95f4\uff1a" + (end - begin));
        return Distribution4Ask.distribute4GivenUser(ctx, allTaskIds.stream().map(t -> (Long)t.getPkValue()).collect(Collectors.toList()), taskNum);
    }

    public static List<Long> askTaskDistributionFast(Long userId, Long sscid, QFilter taskExtFilter, int taskNum) {
        return Distribution4Ask.distribute4GivenUser(userId, sscid, taskExtFilter, taskNum);
    }

    public static List<Long> preDisTask(List<Long> taskIds, Long sscId) {
        ArrayList<Long> disSuccessTaskIdList = new ArrayList<Long>();
        if (sscId == null || sscId <= 0L || CollectionUtils.isEmpty(taskIds)) {
            return disSuccessTaskIdList;
        }
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"id,creator.id,state", (QFilter[])new QFilter[]{qFilter});
        if (tasks == null || tasks.length == 0) {
            return disSuccessTaskIdList;
        }
        DisRequestCtx ctx = DisRequestCtxConstructUtil.constructPredisCtx(sscId, Arrays.asList(tasks));
        List preDisTaskIds = Arrays.stream(tasks).filter(d -> Distribution.checkState(d.getString("state"))).map(d -> d.getLong("id")).collect(Collectors.toList());
        Iterator iterator = preDisTaskIds.iterator();
        while (iterator.hasNext()) {
            long taskId = (Long)iterator.next();
            if (!Distribution4Predist.preDistribution(taskId, ctx)) continue;
            disSuccessTaskIdList.add(taskId);
        }
        return disSuccessTaskIdList;
    }

    private static DynamicObject manualDisTaskDeal4Single(Long userGroupId, Long userId, DynamicObject task, boolean isRobertGroup, ProxyPOJO proxy) {
        DisTypeEnum disType = DisTypeEnum.MANUAL_DIS;
        Map<String, Object> oldState = OtherUtil.transDyn(0L, userGroupId, userId, task, isRobertGroup);
        DynamicObject tscDyo = OtherUtil.buildTaskSateChange4ManualDis(task, oldState);
        OtherUtil.notifyWf(disType, task, proxy);
        OtherUtil.saveTask(disType, task, proxy);
        OtherUtil.stateChange(disType, task, oldState, proxy);
        OtherUtil.afterDisSingle(disType, task, proxy);
        return tscDyo;
    }

    public static boolean retryDistribution(long taskId, int disType) {
        DisRequestCtx ctx;
        DynamicObject disTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
        ArrayList<DynamicObject> allTasks = new ArrayList<DynamicObject>(8);
        allTasks.add(disTask);
        long sscId = disTask.getLong("sscid.id");
        if (DisTypeEnum.AUTO_DIS.getValue() == disType) {
            DisRequestCtx baseCtx = DisRequestCtxConstructUtil.constructDisRequestCtx4AutoDisBase(allTasks);
            ctx = DisRequestCtxConstructUtil.constructDisRequestCtx4AutoDis((Long)sscId, baseCtx);
        } else if (DisTypeEnum.NOPASS_DIS.getValue() == disType) {
            ctx = DisRequestCtxConstructUtil.constructDisRequestCtx4TransRedist(sscId, allTasks);
        } else {
            return false;
        }
        ctx.setDisTaskId(taskId);
        ctx.setDisTask(disTask);
        return Distribution4MonitorRetry.distribute4Single(ctx, taskId);
    }

    private static String getBizError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u914d\u5f02\u5e38\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"CoreDistributionSyncWrapper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private static String getSyncError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u88ab\u5206\u914d\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"CoreDistributionSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private static String getSyncError(String billNumber) {
        return String.format(ResManager.loadKDString((String)"%s\uff1a\u4efb\u52a1\u6b63\u5728\u88ab\u5206\u914d\u6216\u5ba1\u6279\u4e2d\u3002", (String)"Distribution_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber);
    }

    private static Map<Long, List<DynamicObject>> buildTaskGroupBySSCMap(Map<Long, DynamicObject> taskMap) {
        HashMap<Long, List<DynamicObject>> rtnMap = new HashMap<Long, List<DynamicObject>>();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            DynamicObject value = entry.getValue();
            List taskList = rtnMap.computeIfAbsent(value.getLong("sscid.id"), k -> new ArrayList());
            taskList.add(value);
        }
        return rtnMap;
    }

    private static Map<Long, DynamicObject> buildTaskMap(Set<Long> taskIdSet) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_task");
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((Object[])taskIdSet.toArray(new Object[0]), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        if (taskDos == null || taskDos.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>(taskIdSet.size());
        for (DynamicObject task : taskDos) {
            taskMap.put((Long)task.getPkValue(), task);
        }
        return taskMap;
    }

    private static CreditDelayService loadCreditDelayService(DynamicObject[] unDisTaskcol) {
        DynamicObjectCollection creditDelayDisCollection = DisRequestCtxConstructUtil.getImplementClass("CreditDelayService");
        CreditDelayDis creditDelayService = new CreditDelayDis();
        if (!CollectionUtils.isEmpty((Collection)creditDelayDisCollection)) {
            try {
                String value = (String)((DynamicObject)creditDelayDisCollection.get(0)).get("implementname");
                Class<?> aClass = Class.forName(value);
                creditDelayService = (CreditDelayService)aClass.newInstance();
            }
            catch (Exception e) {
                log.error("kd.ssc.task.disRebuild.engine.Distribution: \u53cd\u5c04CreditDelayService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04CreditDelayService\u5b9e\u73b0\u7c7b\u5f02\u5e38\u3002", (String)"ExceptionTaskReflect_0", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        QFilter poolTypeFil = new QFilter("pooltype", "in", (Object)new String[]{TaskPoolTypeEnum.TO_BE_DIS.getValue(), TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue()});
        QFilter recycleFil = new QFilter("state", "!=", (Object)TaskStateEnum.RECYCLE.getValue());
        QFilter manualDisFil = new QFilter("state", "!=", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
        QFilter taskBaseFilter = poolTypeFil.and(manualDisFil).and(recycleFil);
        creditDelayService.setTaskBaseFilter(taskBaseFilter);
        creditDelayService.setUnDisTaskCol(unDisTaskcol);
        creditDelayService.prepareData();
        return creditDelayService;
    }

    private static List<DynamicObject> delay(List<DynamicObject> taskList) {
        if (!CollectionUtils.isEmpty(taskList)) {
            DynamicObject[] disTaskDos = taskList.toArray(new DynamicObject[0]);
            CreditDelayService creditDelayService = Distribution.loadCreditDelayService(disTaskDos);
            taskList = taskList.stream().filter(arg_0 -> ((CreditDelayService)creditDelayService).match(arg_0)).collect(Collectors.toList());
        }
        return taskList;
    }

    private static Map<Long, List<DynamicObject>> getSscUnDisTaskMap(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        log.info("kd.ssc.task.disRebuild.engine.Distribution.getSscUnDisTaskMap:\u5f00\u59cb\u83b7\u53d6\u5f85\u5206\u914d\u4efb\u52a1");
        List<DynamicObject> allTaskList = OtherUtil.getAllTask(0L, unDisFilter, disTaskSource);
        HashMap<Long, List<DynamicObject>> sscTaskMap = new HashMap<Long, List<DynamicObject>>(8);
        if (!CollectionUtils.isEmpty(allTaskList)) {
            if (disTaskSource.getValue() == DisTaskSourceEnum.AUTO_DIS_1.getValue()) {
                allTaskList = Distribution.delay(allTaskList);
            }
            if (!CollectionUtils.isEmpty(allTaskList)) {
                for (DynamicObject taskDo : allTaskList) {
                    Long sscId = taskDo.getLong("sscid.id");
                    List taskList = sscTaskMap.computeIfAbsent(sscId, k -> new ArrayList(16));
                    taskList.add(taskDo);
                }
            }
        }
        return sscTaskMap;
    }

    private static boolean checkState(String state) {
        return TaskStateEnum.TO_BE_DIS.getValue().equals(state) || TaskStateEnum.DIS_EXCEPTION.getValue().equals(state);
    }
}

