/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.engine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.core.CoreDistribution;
import kd.ssc.task.disRebuild.core.CoreDistributionExceptionWrapper;
import kd.ssc.task.disRebuild.core.CoreDistributionMetricWrapper;
import kd.ssc.task.disRebuild.core.CoreDistributionSyncWrapper;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.pojo.ProxyPOJO;
import kd.ssc.task.disRebuild.util.DistributionLockUtil;
import kd.ssc.task.disRebuild.util.OtherUtil;

public class Distribution4Ask {
    private static final Log logger = LogFactory.getLog(Distribution4Ask.class);

    public static List<Long> distribute4GivenUser(DisRequestCtx ctx, List<Long> taskIds, int taskNum) {
        ArrayList<Long> result = new ArrayList<Long>();
        boolean matched = false;
        ArrayList<DynamicObject> disTaskList = new ArrayList<DynamicObject>(16);
        CoreDistributionExceptionWrapper distribution = new CoreDistributionExceptionWrapper(new CoreDistributionMetricWrapper(new CoreDistributionSyncWrapper()));
        for (long taskId : taskIds) {
            if (result.size() >= taskNum) break;
            matched = ((CoreDistribution)distribution).distribute4Single(ctx, taskId);
            if (!matched) continue;
            disTaskList.add(ctx.getDisTask());
            result.add(taskId);
        }
        OtherUtil.afterDisBatch(ctx.getDisType(), disTaskList);
        return result;
    }

    public static List<Long> distribute4GivenUser(Long userId, Long sscId, QFilter extQFilter, int taskNum) {
        Map<Long, TaskInnerInfo> taskInfoMap;
        long startTime = System.currentTimeMillis();
        List<Long> taskIds = new ArrayList<Long>();
        List<DynamicObject> allTasks = OtherUtil.getAllTask(sscId, extQFilter, DisTaskSourceEnum.GET_DIS_1);
        if (allTasks.isEmpty()) {
            return taskIds;
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u4efb\u52a1\u8017\u65f6\uff1a" + (endTime - startTime));
        startTime = endTime;
        List allTaskIds = allTasks.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("taskid", "in", allTaskIds);
        Map<Long, Integer> groupIds = Distribution4Ask.getGroupIncludeCurrentUser(userId, sscId);
        if (groupIds.isEmpty()) {
            return taskIds;
        }
        List<DynamicObject> toDealTasks = Distribution4Ask.getTasks(sscId, groupIds.keySet(), taskFilter);
        if (toDealTasks.isEmpty()) {
            return taskIds;
        }
        endTime = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u9884\u5206\u914d\u7ed3\u679c\u8017\u65f6\uff1a" + (endTime - startTime));
        startTime = endTime;
        List<DynamicObject> tasks = Distribution4Ask.filterTask(toDealTasks);
        if (tasks.isEmpty()) {
            return taskIds;
        }
        Map<Long, WorkerStatusPojo> workStatistics = Distribution4Ask.buildWorkStatistics4Groups(userId, groupIds);
        if ((tasks = Distribution4Ask.findTopKTask(tasks, workStatistics, taskNum, userId, taskInfoMap = Distribution4Ask.constructTaskInfoMap(allTasks))).isEmpty()) {
            return taskIds;
        }
        endTime = System.currentTimeMillis();
        logger.info("\u4efb\u52a1\u5339\u914d\u8017\u65f6\uff1a" + (endTime - startTime));
        startTime = endTime;
        List<DynamicObject> disTasks = Distribution4Ask.distribution(tasks, userId);
        endTime = System.currentTimeMillis();
        logger.info("\u4efb\u52a1\u5206\u914d\u8017\u65f6\uff1a" + (endTime - startTime));
        if (disTasks.isEmpty()) {
            return taskIds;
        }
        OtherUtil.afterDisBatch(DisTypeEnum.MANUAL_GET, disTasks);
        taskIds = disTasks.stream().map(k -> k.getLong("id")).collect(Collectors.toList());
        Distribution4Ask.removeTasks(taskIds);
        return taskIds;
    }

    private static Map<Long, TaskInnerInfo> constructTaskInfoMap(List<DynamicObject> allTasks) {
        Map<Long, Boolean> beforeDealMap = Distribution4Ask.constructBeforeDealMap(allTasks);
        HashMap<Long, TaskInnerInfo> taskInfoMap = new HashMap<Long, TaskInnerInfo>(allTasks.size());
        for (DynamicObject task : allTasks) {
            int taskLevel = task.getInt("tasklevelid.priority");
            Date createTime = task.getDate("createtime");
            Boolean allowAny = task.getBoolean("billtype.allowanyapplier");
            Long taskId = task.getLong("id");
            Boolean beforeDeal = beforeDealMap.get(taskId);
            TaskInnerInfo info = new TaskInnerInfo(taskLevel, createTime, allowAny, beforeDeal);
            taskInfoMap.put(taskId, info);
        }
        return taskInfoMap;
    }

    private static Map<Long, Boolean> constructBeforeDealMap(List<DynamicObject> allTasks) {
        List typeList = allTasks.stream().map(d -> d.getLong("tasktypeid.id")).collect(Collectors.toList());
        List bizList = allTasks.stream().map(d -> d.getLong("billtype.id")).collect(Collectors.toList());
        String selectFields = "id, entryentity.tasktype, entryentity.childpkid";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", bizList), new QFilter("entryentity.tasktype", "in", typeList)};
        DynamicObjectCollection tmpResult = QueryServiceHelper.query((String)"task_taskbill", (String)selectFields, (QFilter[])filters);
        List childIds = tmpResult.stream().map(d -> d.getLong("entryentity.childpkid")).collect(Collectors.toList());
        DynamicObjectCollection result = QueryServiceHelper.query((String)"task_taskbill_child", (String)"id,issame", (QFilter[])new QFilter[]{new QFilter("id", "in", childIds)});
        HashMap map1 = new HashMap();
        result.forEach(d -> map1.put(d.getLong("id"), d.getBoolean("issame")));
        HashMap map2 = new HashMap();
        tmpResult.forEach(d -> {
            Boolean cfr_ignored_0 = (Boolean)map2.put(d.getLong("id") + "_" + d.getLong("entryentity.tasktype"), map1.get(d.getLong("entryentity.childpkid")));
        });
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        allTasks.forEach(d -> {
            Boolean cfr_ignored_0 = (Boolean)resultMap.put(d.getLong("id"), (Boolean)map2.get(d.getLong("billtype.id") + "_" + d.getLong("tasktypeid.id")));
        });
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DynamicObject> distribution(List<DynamicObject> tasks, Long userId) {
        DistributionLockUtil lock = new DistributionLockUtil();
        DynamicObjectType taskType = BusinessDataServiceHelper.newDynamicObject((String)"task_task").getDynamicObjectType();
        Object[] ids = tasks.stream().map(d -> d.getLong("taskid")).toArray(Object[]::new);
        DynamicObject[] taskAllInfos = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)taskType);
        Map<Long, DynamicObject> taskMap = Distribution4Ask.buildTaskMap(taskAllInfos);
        ProxyPOJO proxy = new ProxyPOJO();
        ArrayList<DynamicObject> disTask = new ArrayList<DynamicObject>();
        SscDistributeCache.put((String)("askTask" + Thread.currentThread()), (Object)0);
        DisTypeEnum disType = DisTypeEnum.MANUAL_GET;
        for (DynamicObject task : tasks) {
            String taskState;
            long taskId = task.getLong("taskid");
            long ruleId = task.getLong("matchrule");
            long groupId = task.getLong("usergroup");
            DynamicObject taskAllInfo = taskMap.get(taskId);
            String poolType = taskAllInfo.getString("pooltype");
            if (!lock.getLock(taskId, poolType, taskState = taskAllInfo.getString("state"), disType)) continue;
            try {
                if (!Distribution4Ask.distribute(disType, ruleId, groupId, userId, taskAllInfo, proxy)) continue;
                disTask.add(taskAllInfo);
            }
            catch (Exception e) {
                logger.error("\u4e3b\u52a8\u83b7\u53d6\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
            }
            finally {
                lock.releaseLock(taskId);
            }
        }
        logger.info("\u901a\u77e5\u5de5\u4f5c\u6d41\u8017\u65f6\uff1a" + SscDistributeCache.get((String)("askTask" + Thread.currentThread())));
        SscDistributeCache.remove((String)("askTask" + Thread.currentThread()));
        return disTask;
    }

    private static Map<Long, DynamicObject> buildTaskMap(DynamicObject[] taskAllInfos) {
        HashMap<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject task : taskAllInfos) {
            taskMap.put(task.getLong("id"), task);
        }
        return taskMap;
    }

    private static boolean distribute(DisTypeEnum disType, long ruleId, long groupId, Long userId, DynamicObject task, ProxyPOJO proxy) {
        Map<String, Object> oldState = OtherUtil.transDyn(ruleId, groupId, userId, task, false);
        Long startTime = System.currentTimeMillis();
        OtherUtil.notifyWf(disType, task, proxy);
        Long endTime = System.currentTimeMillis();
        Long costTime = (Long)SscDistributeCache.get((String)("askTask" + Thread.currentThread()), Long.class);
        costTime = costTime + (endTime - startTime);
        SscDistributeCache.put((String)("askTask" + Thread.currentThread()), (Object)costTime);
        try (TXHandle h = TX.requiresNew((String)"Distribution4Ask.distribute");){
            try {
                OtherUtil.saveTask(disType, task, proxy);
                OtherUtil.stateChange(disType, task, oldState, proxy);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        OtherUtil.afterDisSingle(disType, task, proxy);
        return true;
    }

    private static List<DynamicObject> findTopKTask(List<DynamicObject> tasks, Map<Long, WorkerStatusPojo> workStatistics, int taskNum, Long userId, Map<Long, TaskInnerInfo> taskInfoMap) {
        InnerComparator cmp = new InnerComparator(taskInfoMap);
        tasks.sort(cmp);
        int size = 0;
        ArrayList<DynamicObject> topKTasks = new ArrayList<DynamicObject>();
        for (DynamicObject dyo : tasks) {
            if (size >= taskNum) break;
            if (!Distribution4Ask.match(dyo, workStatistics, userId, taskInfoMap)) continue;
            topKTasks.add(dyo);
            ++size;
        }
        return topKTasks;
    }

    private static boolean match(DynamicObject task, Map<Long, WorkerStatusPojo> workStatistics, Long userId, Map<Long, TaskInnerInfo> taskInfoMap) {
        long taskId = task.getLong("taskid");
        long applicant = task.getLong("creator");
        if (!taskInfoMap.get(taskId).getAllowAny().booleanValue() && userId.equals(applicant)) {
            return false;
        }
        String beforeDealer = task.getString("bfdealer");
        Boolean beforeDeal = taskInfoMap.get(taskId).getBeforeDeal();
        if (beforeDeal != null && beforeDeal.booleanValue() && beforeDealer.contains(userId + "")) {
            return false;
        }
        long groupId = task.getLong("usergroup");
        WorkerStatusPojo currentGroupWorkStatistics = workStatistics.get(groupId);
        if (currentGroupWorkStatistics == null) {
            return false;
        }
        if (currentGroupWorkStatistics.getTaskTotal() >= currentGroupWorkStatistics.getTaskUpper()) {
            return false;
        }
        currentGroupWorkStatistics.setTaskTotal(currentGroupWorkStatistics.getTaskTotal() + 1);
        return true;
    }

    private static List<DynamicObject> filterTask(List<DynamicObject> toDealTasks) {
        Map<Long, List<DynamicObject>> groupTasks = toDealTasks.stream().collect(Collectors.groupingBy(k -> k.getLong("taskId")));
        ArrayList<DynamicObject> retainTasks = new ArrayList<DynamicObject>(32);
        for (Map.Entry<Long, List<DynamicObject>> entry : groupTasks.entrySet()) {
            List<DynamicObject> tasks = entry.getValue();
            retainTasks.add(Distribution4Ask.retainTask(tasks));
        }
        return retainTasks;
    }

    private static void removeTasks(List<Long> allTaskIds) {
        if (allTaskIds.isEmpty()) {
            return;
        }
        DeleteServiceHelper.delete((String)"task_predis_result", (QFilter[])new QFilter[]{new QFilter("taskid", "in", allTaskIds)});
    }

    private static DynamicObject retainTask(List<DynamicObject> tasks) {
        int minRulePriority = Integer.MAX_VALUE;
        long maxGroupId = 0L;
        DynamicObject retainTask = tasks.get(0);
        for (DynamicObject task : tasks) {
            int rulePriority = task.getInt("rulepriority");
            if (rulePriority > minRulePriority) continue;
            if (rulePriority == minRulePriority) {
                long groupId = task.getLong("usergroup");
                if (groupId > maxGroupId) {
                    retainTask = task;
                    maxGroupId = groupId;
                }
            } else {
                retainTask = task;
                maxGroupId = task.getLong("usergroup");
            }
            minRulePriority = rulePriority;
        }
        return retainTask;
    }

    private static List<DynamicObject> getTasks(Long sscId, Set<Long> groupIds, QFilter extQFilter) {
        String selectFields = Distribution4Ask.getTaskSelectFields();
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscId);
        QFilter groupFilter = new QFilter("usergroup", "in", groupIds);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_predis_result", (String)selectFields, (QFilter[])new QFilter[]{sscFilter, groupFilter, extQFilter});
        return tasks;
    }

    private static String getTaskSelectFields() {
        return "taskid,matchrule,usergroup,rulepriority,creator,bfdealer";
    }

    private static Map<Long, Integer> getGroupIncludeCurrentUser(long userId, long sscId) {
        QFilter userFilter = new QFilter("entryentity.userfield", "=", (Object)userId);
        userFilter.and("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue());
        QFilter sscFilter = new QFilter("createorg", "=", (Object)sscId);
        QFilter notRobertFilter = new QFilter("isrobots", "=", (Object)false);
        HashMap<Long, Integer> groupIDs = new HashMap<Long, Integer>(8);
        try (DataSet groupDS = QueryServiceHelper.queryDataSet((String)(Distribution.class.getName() + ".query usergroup for ask Tasks"), (String)"task_usergroup", (String)"id,entryentity.curtasknum_e", (QFilter[])new QFilter[]{userFilter, sscFilter, notRobertFilter}, null);){
            for (Row row : groupDS) {
                groupIDs.put(row.getLong("id"), row.getInteger("entryentity.curtasknum_e"));
            }
        }
        return groupIDs;
    }

    private static Map<Long, WorkerStatusPojo> buildWorkStatistics4Groups(long userId, Map<Long, Integer> groupIds) {
        HashMap<Long, WorkerStatusPojo> group2WorkerStatusPojo = new HashMap<Long, WorkerStatusPojo>(32);
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()).and(new QFilter("personid", "=", (Object)userId));
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        DynamicObjectCollection processingTasks = QueryServiceHelper.query((String)"task_task", (String)"id,usergroup", (QFilter[])new QFilter[]{disedTKFilter});
        Map<Long, List<DynamicObject>> group2Tasks = processingTasks.stream().collect(Collectors.groupingBy(k -> k.getLong("usergroup")));
        for (Map.Entry<Long, Integer> entry : groupIds.entrySet()) {
            Long gId = entry.getKey();
            WorkerStatusPojo workerStatusPojo = new WorkerStatusPojo();
            workerStatusPojo.setUserGroupId(gId);
            workerStatusPojo.setTaskUpper(entry.getValue());
            List<DynamicObject> tasks = group2Tasks.get(gId);
            workerStatusPojo.setTaskTotal(tasks != null ? tasks.size() : 0);
            group2WorkerStatusPojo.put(gId, workerStatusPojo);
        }
        return group2WorkerStatusPojo;
    }

    static class InnerComparator
    implements Comparator<DynamicObject> {
        private final Map<Long, TaskInnerInfo> taskInfoMap;

        public InnerComparator(Map<Long, TaskInnerInfo> taskInfoMap) {
            this.taskInfoMap = taskInfoMap;
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            int p2;
            long i1 = o1.getLong("taskid");
            long i2 = o2.getLong("taskid");
            int p1 = this.taskInfoMap.get(i1).getPriority();
            if (p1 == (p2 = this.taskInfoMap.get(i2).getPriority())) {
                Date t1 = this.taskInfoMap.get(i1).getCreateTime();
                Date t2 = this.taskInfoMap.get(i2).getCreateTime();
                return t1.compareTo(t2);
            }
            return p1 - p2;
        }
    }

    static class TaskInnerInfo {
        private int priority;
        private Date createTime;
        private Boolean allowAny;
        private Boolean beforeDeal;

        public TaskInnerInfo(int priority, Date createTime, Boolean allowAny, Boolean beforeDeal) {
            this.priority = priority;
            this.createTime = createTime;
            this.allowAny = allowAny;
            this.beforeDeal = beforeDeal;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public Boolean getAllowAny() {
            return this.allowAny;
        }

        public void setAllowAny(Boolean allowAny) {
            this.allowAny = allowAny;
        }

        public Boolean getBeforeDeal() {
            return this.beforeDeal;
        }

        public void setBeforeDeal(Boolean beforeDeal) {
            this.beforeDeal = beforeDeal;
        }
    }
}

