/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ssc.task.dis.BillNumPersonPOJO;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.dis.OrgSetUserGroupPojo;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.util.ResultBuildUtil;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;

public class GroupMatchRuleServiceImpl
implements MatchRuleService {
    private DisRequestCtx ctx;

    @Override
    public MatchRuleResult match(long taskId, MatchRuleResult result) {
        result.setSuccess(false);
        long ruleId = this.getRequestCtx().getCurrentRuleId();
        assert (ruleId != 0L);
        CusDisrulePojo ruleInfo = this.getRequestCtx().getRuleInfos().get(ruleId);
        List<OrgSetUserGroupPojo> orgSetUserGroupPojoList = ruleInfo.getOrgSetUserGroupPojoList();
        long groupId = this.getRequestCtx().getUsergroupId();
        assert (groupId != 0L);
        OrgSetUserGroupPojo curPojo = null;
        for (OrgSetUserGroupPojo pojo : orgSetUserGroupPojoList) {
            if (groupId != pojo.getGroup()) continue;
            curPojo = pojo;
            break;
        }
        assert (curPojo != null);
        DynamicObject task = this.getRequestCtx().getDisTask();
        long taskOrg = task.getLong("orgid.id");
        JSONObject g_detail = ResultBuildUtil.getOrDefault_g_detail(result.getDetail(), ruleId, groupId);
        if (curPojo.getOrgSet().contains(taskOrg) && curPojo.isEnable()) {
            if (RobertUserGroupUtil.isRobort(this.getRequestCtx().getSscid(), groupId)) {
                boolean isQuailtyTask = this.getRequestCtx().getQualityTaskIds().contains(taskId);
                if (isQuailtyTask) {
                    g_detail.put("matched", (Object)false);
                    g_detail.put("message", (Object)ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u4e0d\u80fd\u5206\u914d\u5230\u673a\u5668\u4eba\u7ec4\u3002", (String)"GroupMatchRuleServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    result.setSuccess(false);
                } else if (!this.isReturnByRobert(task, groupId)) {
                    g_detail.put("matched", (Object)false);
                    g_detail.put("message", (Object)ResManager.loadKDString((String)"\u81ea\u52a8\u5ba1\u6279\u6253\u56de\u7684\u4efb\u52a1\u4e0d\u80fd\u5206\u914d\u5230\u673a\u5668\u4eba\u7ec4\u3002", (String)"GroupMatchRuleServiceImpl_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    result.setSuccess(false);
                } else {
                    g_detail.put("matched", (Object)true);
                    result.setSuccess(true);
                }
            } else {
                g_detail.put("matched", (Object)true);
                result.setSuccess(true);
            }
        } else {
            g_detail.put("matched", (Object)false);
            g_detail.put("message", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7\u5339\u914d\u5931\u8d25", (String)"GroupMatchRuleServiceImpl_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            result.setMatchRuleId(ruleId);
            result.setMatchGroupId(groupId);
            Map<Long, List<Long>> matchedRuleAndGroups = result.getMatchedRuleAndGroups();
            if (matchedRuleAndGroups == null) {
                matchedRuleAndGroups = new HashMap<Long, List<Long>>(1);
                result.setMatchedRuleAndGroups(matchedRuleAndGroups);
            }
            List groupIds = matchedRuleAndGroups.computeIfAbsent(ruleId, k -> new ArrayList());
            groupIds.add(groupId);
        }
        return result;
    }

    private boolean isReturnByRobert(DynamicObject task, long groupId) {
        List<BillNumPersonPOJO> returnPersonList = this.getRequestCtx().getReturnMatchRulePojos();
        boolean isReturn = true;
        long hisGroupId = -1L;
        long hisPersonId = -1L;
        String autoProcessResult = "";
        boolean hasHistory = false;
        for (BillNumPersonPOJO pojo : returnPersonList) {
            if (!pojo.getBillId().equals(task.get("billid")) || pojo.getTaskTypeId() != task.getLong("tasktypeid.id")) continue;
            hasHistory = true;
            hisGroupId = pojo.getUsergroup();
            hisPersonId = pojo.getPerson();
            autoProcessResult = pojo.getAutoProcessResult();
            break;
        }
        if (hasHistory) {
            if (RobertUserGroupUtil.isRobort(this.getRequestCtx().getSscid(), hisGroupId, hisPersonId)) {
                isReturn = RobertUserGroupUtil.checkRedistribution(true, hisPersonId, hisGroupId);
            } else {
                Map<Long, DynamicObject> robertGroupMap = this.ctx.getRobertGroupMap();
                DynamicObject robertGroup = null;
                if (robertGroupMap != null) {
                    robertGroup = robertGroupMap.get(groupId);
                }
                isReturn = RobertUserGroupUtil.checkRedistributionByLocalNode(false, autoProcessResult, robertGroup);
            }
        }
        return isReturn;
    }

    @Override
    public DisRequestCtx getRequestCtx() {
        return this.ctx;
    }

    @Override
    public void setRequestCtx(DisRequestCtx ctx) {
        this.ctx = ctx;
    }
}

