/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.disRebuild.disenum.DisExceptionEnum;
import kd.ssc.task.helper.MutexCacheHelper;

public class DistributionLockUtil {
    public boolean getLock(long taskId, String poolType, String taskState, DisTypeEnum disType) {
        if (disType == DisTypeEnum.AUTO_DIS || disType == DisTypeEnum.MANUAL_GET) {
            ArrayList<String> taskPoolTypeList = new ArrayList<String>();
            taskPoolTypeList.add(TaskPoolTypeEnum.TO_BE_DIS.getValue());
            taskPoolTypeList.add(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue());
            if (!taskPoolTypeList.contains(poolType)) {
                throw new KDException(new ErrorCode(DisExceptionEnum.SYNCHRONIZEDERROR.getCode(), this.getStateError(taskId)), new Object[0]);
            }
        }
        if (this.taskInDeal(taskState, disType)) {
            throw new KDException(new ErrorCode(DisExceptionEnum.SYNCHRONIZEDERROR.getCode(), this.getStateError(taskId)), new Object[0]);
        }
        boolean locked = this.getLock(taskId);
        if (!locked) {
            throw new KDException(new ErrorCode(DisExceptionEnum.SYNCHRONIZEDERROR.getCode(), this.getSyncError(taskId)), new Object[0]);
        }
        return true;
    }

    private boolean taskInDeal(String taskState, DisTypeEnum disType) {
        if (disType == DisTypeEnum.NOPASS_DIS) {
            return false;
        }
        return TaskStateEnum.TO_BE_AUDIT.getValue().equals(taskState) || TaskStateEnum.CHECKING.getValue().equals(taskState);
    }

    public synchronized boolean getLock(long taskId) {
        if (MutexCacheHelper.containsMutexCache4Dist(taskId)) {
            return false;
        }
        MutexCacheHelper.putMutexCache4Dist(taskId);
        return true;
    }

    public void releaseLock(long taskId) {
        MutexCacheHelper.removeMutexCache4Dist(taskId);
    }

    public void releaseLock(List<Long> taskIds) {
        if (!CollectionUtils.isEmpty(taskIds)) {
            MutexCacheHelper.batchRemoveMutexCache4Dist(taskIds.toArray(new Long[taskIds.size()]));
        }
    }

    private String getStateError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ecf\u88ab\u5206\u914d\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"CoreDistributionSyncWrapper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private String getSyncError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u88ab\u5206\u914d\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"CoreDistributionSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private String getBizError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u914d\u5f02\u5e38\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"CoreDistributionSyncWrapper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }
}

