/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.ssc.task.business.helper.WorkflowApproveRecordHelper;
import kd.ssc.task.formplugin.TaskApprevalHelper;

public class ApprovalDecisionItemListPlugin
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        FormShowParameter param = this.getView().getFormShowParameter();
        List taskIds = (List)param.getCustomParam("taskids");
        String taskId = String.valueOf(taskIds.get(0));
        this.getPageCache().put("taskId", taskId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btdown", "btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        if ("btdown".equalsIgnoreCase(ctrl.getKey())) {
            Object selectItemId;
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b3\u7b56\u9879", (String)"ApprovalDecisionItemListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Object> selectIdList = new ArrayList<Object>();
            FormShowParameter param = this.getView().getFormShowParameter();
            List withdrawalids = (List)param.getCustomParam("withdrawalids");
            if (withdrawalids != null && withdrawalids.size() > 0) {
                for (ListSelectedRow item : selectedRows) {
                    selectItemId = item.getPrimaryKeyValue();
                    if (withdrawalids.contains(selectItemId)) continue;
                    selectIdList.add(selectItemId);
                }
            } else {
                for (ListSelectedRow item : selectedRows) {
                    selectItemId = item.getPrimaryKeyValue();
                    selectIdList.add(selectItemId);
                }
            }
            if (selectIdList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b3\u7b56\u9879", (String)"ApprovalDecisionItemListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String operationkey = (String)param.getCustomParam("operationkey");
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("decisionitemids", selectIdList);
            Long curPkId = (Long)selectIdList.get(0);
            returnData.put("nodeItemId", this.getCurNodeItemId(curPkId));
            returnData.put("taskids", param.getCustomParam("taskids"));
            returnData.put("withdrawalids", withdrawalids);
            returnData.put("opinion", param.getCustomParam("opinion"));
            returnData.put("innermsg", param.getCustomParam("innermsg"));
            returnData.put("operationkey", operationkey);
            returnData.put("isCanRescan", param.getCustomParam("isCanRescan"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("btnok".equalsIgnoreCase(ctrl.getKey())) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b3\u7b56\u9879", (String)"ApprovalDecisionItemListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Object> selectIdList = new ArrayList<Object>();
            for (ListSelectedRow item : selectedRows) {
                Object selectItemId = item.getPrimaryKeyValue();
                selectIdList.add(selectItemId);
            }
            Iterator param = this.getView().getFormShowParameter();
            String operationkey = (String)param.getCustomParam("operationkey");
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("decisionitemids", selectIdList);
            returnData.put("taskids", param.getCustomParam("taskids"));
            returnData.put("operationkey", operationkey);
            returnData.put("isCanRescan", param.getCustomParam("isCanRescan"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String parentFormId = param.getParentFormId();
        String approveFormId = TaskApprevalHelper.getApproveFormId();
        if (approveFormId.equalsIgnoreCase(parentFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btdown"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fielldName = args.getHyperLinkClickEvent().getFieldName();
        args.setCancel(true);
        if ("decisionrejection".equals(fielldName)) {
            this.openDecisionRejectionDialog();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("reDecisionRejection".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            this.reDecisionRejection(closedCallBackEvent);
        }
    }

    private void reDecisionRejection(ClosedCallBackEvent closedCallBackEvent) {
        String jsonString = (String)closedCallBackEvent.getReturnData();
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            Map returnDataMap = (Map)JSON.parseObject((String)jsonString, Map.class);
            String nodeItemId = (String)returnDataMap.get("nodeItemId");
            String nodeShowName = (String)returnDataMap.get("nodeShowName");
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            ListSelectedRow currentRow = selectedRows.get(0);
            Long pKId = (Long)currentRow.getPrimaryKeyValue();
            this.getPageCache().put("pKId", String.valueOf(pKId));
            this.getPageCache().put("nodeItemId", nodeItemId);
            this.getPageCache().put("nodeShowName", nodeShowName);
            list.refresh();
        }
    }

    private void openDecisionRejectionDialog() {
        String taskId = this.getPageCache().get("taskId");
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        ListSelectedRow row = selectedRows.get(0);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"task_decisionitem");
        String decisionValue = dynamicObject.getString("decisionvalue");
        FormShowParameter para = new FormShowParameter();
        para.setFormId("task_decisionrejection");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reDecisionRejection"));
        para.setCustomParam("taskId", (Object)taskId);
        para.setCustomParam("decisionValue", (Object)decisionValue);
        para.setCustomParam("nodeItemId", (Object)this.getPageCache().get("nodeItemId"));
        this.getView().showForm(para);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final IPageCache pageCache = this.getPageCache();
        ListDataProvider provider = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                String taskId = pageCache.get("taskId");
                String nodeShowName = pageCache.get("nodeShowName");
                Long pKId = null;
                if (pageCache.get("pKId") != null) {
                    pKId = Long.valueOf(pageCache.get("pKId"));
                }
                DynamicObject taskDynObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"billid,assignid,itemid");
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                DynamicSimpleProperty decisionRejectionProp = new DynamicSimpleProperty("decisionrejection", String.class, (Object)"");
                dynObjs.getDynamicObjectType().addProperty((DynamicProperty)decisionRejectionProp);
                for (int i = 0; i < dynObjs.size(); ++i) {
                    DynamicObject object = (DynamicObject)dynObjs.get(i);
                    String decisionValue = (String)object.get("decisionvalue");
                    Long id = (Long)object.get("id");
                    if (id.equals(pKId)) {
                        object.set("decisionrejection", (Object)nodeShowName);
                        ApprovalDecisionItemListPlugin.this.putCurNodeItemIdMap(id, pageCache.get("nodeItemId"));
                        continue;
                    }
                    ApprovalRecordItem approvalRecordItem = ApprovalDecisionItemListPlugin.this.getApprovalRecordItemByCache(taskDynObj, decisionValue);
                    String decisionRejection = "";
                    if (approvalRecordItem != null) {
                        decisionRejection = approvalRecordItem.getAssignee() != null ? approvalRecordItem.getActivityName() + "-" + approvalRecordItem.getAssignee() : approvalRecordItem.getActivityName();
                        ApprovalDecisionItemListPlugin.this.putCurNodeItemIdMap(id, approvalRecordItem.getActivityId());
                    }
                    object.set("decisionrejection", (Object)decisionRejection);
                }
                return dynObjs;
            }
        };
        args.setListDataProvider((IListDataProvider)provider);
    }

    private ApprovalRecordItem getApprovalRecordItemByCache(DynamicObject taskDynObj, String decisionValue) {
        String itemMapJson = this.getPageCache().get("approvalRecordItemMap");
        Map<String, String> approvalRecordItemMap = new HashMap(8);
        if (itemMapJson != null) {
            approvalRecordItemMap = (Map)JSON.parseObject((String)itemMapJson, Map.class);
        }
        String billId = taskDynObj.getString("billid");
        Long workFlowId = taskDynObj.getLong("assignid");
        String rejectNodesKey = workFlowId + decisionValue;
        if (!approvalRecordItemMap.containsKey(rejectNodesKey)) {
            List rejectNodeList = WorkflowServiceHelper.getRejectNodes((Long)workFlowId, (String)decisionValue);
            ApprovalRecordItem approvalRecordItem = null;
            if (!CollectionUtils.isEmpty((Collection)rejectNodeList)) {
                WFRejectNodesModel wfRejectNodesModel = (WFRejectNodesModel)rejectNodeList.get(0);
                String itemId = wfRejectNodesModel.getItemId();
                Map latestApprovalRecordMap = WorkflowApproveRecordHelper.getLatestApprovalRecordMap((String)billId);
                approvalRecordItem = (ApprovalRecordItem)latestApprovalRecordMap.get(itemId);
                if (approvalRecordItem == null) {
                    approvalRecordItem = new ApprovalRecordItem();
                    approvalRecordItem.setActivityId(itemId);
                    approvalRecordItem.setActivityName(wfRejectNodesModel.getName());
                }
            }
            String approvalRecordItemJson = JSON.toJSONString(approvalRecordItem);
            approvalRecordItemMap.put(rejectNodesKey, approvalRecordItemJson);
            this.getPageCache().put("approvalRecordItemMap", JSON.toJSONString(approvalRecordItemMap));
        }
        String approvalRecordItemJson = (String)approvalRecordItemMap.get(rejectNodesKey);
        return (ApprovalRecordItem)JSON.parseObject((String)approvalRecordItemJson, ApprovalRecordItem.class);
    }

    private void putCurNodeItemIdMap(Long curPkId, String nodeItemId) {
        String curNodeItemIdJson = this.getPageCache().get("curNodeItemIdMap");
        Map<String, String> curNodeItemIdMap = new HashMap<String, String>(8);
        if (curNodeItemIdJson != null) {
            curNodeItemIdMap = (Map)SerializationUtils.fromJsonString((String)curNodeItemIdJson, Map.class);
        }
        curNodeItemIdMap.put(String.valueOf(curPkId), nodeItemId);
        this.getPageCache().put("curNodeItemIdMap", SerializationUtils.toJsonString(curNodeItemIdMap));
    }

    private String getCurNodeItemId(Long curPkId) {
        String curNodeItemIdJson = this.getPageCache().get("curNodeItemIdMap");
        Map curNodeItemIdMap = new HashMap(8);
        if (curNodeItemIdJson != null) {
            curNodeItemIdMap = (Map)SerializationUtils.fromJsonString((String)curNodeItemIdJson, Map.class);
        }
        return (String)curNodeItemIdMap.get(String.valueOf(curPkId));
    }
}

