/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ApprovalOpinionListPlugin
extends AbstractTreeListPlugin {
    private static final String CK_SSCID = "curSscid";
    private static final String CK_REFRESHTREE = "isRefreshTree";
    private static final String CBK_AFTERCOPY = "afterCopy";
    private static final String CK_AFTERF7REFRESH = "afterF7";
    private static final Log log = LogFactory.getLog(ApprovalOpinionListPlugin.class);
    private static final String ENTITYID = "task_appropinions";
    private static final String ENTITY_NUMBER = "number";
    private static final String ENTITY_LONGNUMBER = "longnumber";
    private static final String LONG_NUMBER_SEPARATOR = ".";

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List columnList = args.getCommonFilterColumns();
        for (FilterColumn singleColumn : columnList) {
            Object firstValueTmp;
            List valueList;
            String fieldName = singleColumn.getFieldName();
            if (!StringUtils.isNotBlank((CharSequence)fieldName) || !fieldName.contains("sscid") || (valueList = singleColumn.getDefaultValues()).isEmpty() || !((firstValueTmp = valueList.get(0)) instanceof String)) continue;
            String sscid = (String)firstValueTmp;
            this.getPageCache().put(CK_REFRESHTREE, "false");
            this.getPageCache().put(CK_AFTERF7REFRESH, "false");
            this.getPageCache().put(CK_SSCID, sscid);
            this.refreshTreeListWithFilter(Long.parseLong(sscid));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String sscidStr;
        List value;
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getSearchClickEvent().getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        List field = (List)currentCommonFilter.get("FieldName");
        int sscIndex = -1;
        for (Object fieldTmp : field) {
            ++sscIndex;
            String fieldName = (String)fieldTmp;
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"sscid.id")) continue;
            break;
        }
        if (sscIndex >= 0 && !(value = (List)currentCommonFilter.get("Value")).isEmpty() && StringUtils.isNotBlank((CharSequence)(sscidStr = (String)value.get(sscIndex)))) {
            this.getPageCache().put(CK_SSCID, sscidStr);
            this.getPageCache().put(CK_REFRESHTREE, "false");
            this.getPageCache().put(CK_AFTERF7REFRESH, "false");
            this.refreshTreeListWithFilter(Long.parseLong(sscidStr));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.getPageCache().put(CK_REFRESHTREE, "false");
        this.getPageCache().put(CK_AFTERF7REFRESH, "false");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"tblcuscopy") && e.getOperationResult().isSuccess()) {
            boolean hasPermission = this.checkCopyOpinionPermission(appId);
            if (!hasPermission) {
                return;
            }
            this.showCopyOpinionForm();
        }
    }

    private boolean checkCopyOpinionPermission(String appId) {
        boolean permissionResult;
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        IListView listView = (IListView)this.getView();
        List sscIds = listView.getSelectedMainOrgIds();
        Long sscId = (Long)sscIds.get(0);
        Long userId = RequestContext.get().getCurrUserId();
        int isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)(appId = AppMetadataCache.getAppInfo((String)appId).getId()), (String)ENTITYID, (String)"16G+FIXN+/=D");
        boolean bl = permissionResult = isPermission == 1;
        if (!permissionResult) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u201d\u7684\u201c\u590d\u5236\u5230\u76ee\u6807\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalOpinionListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return permissionResult;
    }

    private void showCopyOpinionForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("task_copyopinions");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().put("sscid", this.getPageCache().get(CK_SSCID));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CBK_AFTERCOPY);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object sscidTmp;
        Boolean isCertainCopy;
        Map keyInfo;
        Object certainCopy;
        Object rtnValue;
        super.closedCallBack(event);
        String backId = event.getActionId();
        if (StringUtils.equals((CharSequence)CBK_AFTERCOPY, (CharSequence)backId) && (rtnValue = event.getReturnData()) instanceof Map && (certainCopy = (keyInfo = (Map)rtnValue).get("certainCopy")) instanceof Boolean && (isCertainCopy = (Boolean)certainCopy).booleanValue() && (sscidTmp = keyInfo.get("sscid")) instanceof Long) {
            Long targetSscid = (Long)sscidTmp;
            Long sourSscid = Long.valueOf(this.getPageCache().get(CK_SSCID));
            this.copyOpinionFromSourceToTarget(sourSscid, targetSscid);
        }
    }

    private void copyOpinionFromSourceToTarget(Long sourSscid, Long targetSscid) {
        try (TXHandle th = TX.requiresNew();){
            try {
                this.deleteTargetOpinions(targetSscid);
                this.saveCopyOpinions(sourSscid, targetSscid);
            }
            catch (Exception e) {
                th.markRollback();
                log.error("formplugin.ApprovalOpinionListPlugin.copyOpinionFromSourceToTarget\u540c\u6b65\u6570\u636e\u9519\u8bef", (Throwable)e);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1\u590d\u5236\u6210\u529f\u3002", (String)"ApprovalOpinionListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void saveCopyOpinions(Long sourSscid, Long targetSscid) {
        if (sourSscid == null || targetSscid == null) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("sscid", "=", (Object)sourSscid)};
        String selectField = this.getSelectField(ENTITYID);
        int level = this.getTreeLevel(sourSscid);
        if (level <= 0) {
            return;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SSC_ApprovalOpinions", (String)ENTITYID, (String)selectField, (QFilter[])qFilters, (String)ENTITY_NUMBER);
        HashMap<Integer, Map<Long, Long>> map = new HashMap<Integer, Map<Long, Long>>(2);
        HashMap<Long, DynamicObject> dstObjMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 1; i <= level; ++i) {
            DataSet dataSetCopy = dataSet.copy();
            this.saveEachLevelData(dataSetCopy, map, targetSscid, i, dstObjMap);
        }
        dataSet.close();
    }

    private int getTreeLevel(Long sscid) {
        String selectField = "level";
        QFilter[] qFilters = new QFilter[]{new QFilter("sscid", "=", (Object)sscid)};
        DynamicObjectCollection levelDyos = QueryServiceHelper.query((String)ENTITYID, (String)selectField, (QFilter[])qFilters, (String)"level desc", (int)1);
        if (levelDyos == null || levelDyos.isEmpty()) {
            return -1;
        }
        DynamicObject levelDyo = (DynamicObject)levelDyos.get(0);
        return levelDyo.getInt("level");
    }

    private void saveEachLevelData(DataSet dataSet, Map<Integer, Map<Long, Long>> map, Long targetSscid, int i, Map<Long, DynamicObject> dstObjMap) {
        DataSet levelData = dataSet.filter("level = " + i).orderBy(new String[]{ENTITY_NUMBER});
        DataSet levelDataCopy = levelData.copy();
        if (i == 1) {
            ArrayList<DynamicObject> copyData = new ArrayList<DynamicObject>(10);
            for (Row row : levelData) {
                DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)ENTITYID);
                this.copyDyoFromRow(row, newDyo);
                newDyo.set("sscid", (Object)targetSscid);
                String newNumber = this.getCodeRuleNumber(ENTITYID, newDyo, null);
                newDyo.set(ENTITY_NUMBER, (Object)newNumber);
                newDyo.set(ENTITY_LONGNUMBER, (Object)newNumber);
                copyData.add(newDyo);
            }
            DynamicObject[] newDyos = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])copyData.toArray(new DynamicObject[0]));
            this.rememberMapping(levelDataCopy, newDyos, map, i, dstObjMap);
        } else {
            Map<Long, Long> childMap = map.get(i - 1);
            ArrayList<DynamicObject> copyData = new ArrayList<DynamicObject>(10);
            for (Row row : levelData) {
                DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)ENTITYID);
                this.copyDyoFromRow(row, newDyo);
                newDyo.set("sscid", (Object)targetSscid);
                String newNumber = this.getCodeRuleNumber(ENTITYID, newDyo, null);
                newDyo.set(ENTITY_NUMBER, (Object)newNumber);
                Long parentId = childMap.get(row.getLong("parent"));
                if (parentId == null) continue;
                DynamicObject parent = dstObjMap.get(parentId);
                if (parent != null) {
                    StringBuilder longNumber = new StringBuilder(parent.getString(ENTITY_LONGNUMBER)).append(LONG_NUMBER_SEPARATOR).append(newNumber);
                    newDyo.set(ENTITY_LONGNUMBER, (Object)longNumber);
                }
                newDyo.set("parent", (Object)parentId);
                copyData.add(newDyo);
            }
            DynamicObject[] newDyos = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])copyData.toArray(new DynamicObject[0]));
            this.rememberMapping(levelDataCopy, newDyos, map, i, dstObjMap);
        }
    }

    private void rememberMapping(DataSet levelData, DynamicObject[] newDyos, Map<Integer, Map<Long, Long>> map, int i, Map<Long, DynamicObject> dstObjMap) {
        if (i > 2) {
            map.remove(i - 2);
        }
        int index = 0;
        HashMap<Long, Long> childMap = new HashMap<Long, Long>(10);
        for (Row row : levelData) {
            Long srcId = row.getLong("id");
            Long dstId = (Long)newDyos[index].getPkValue();
            childMap.put(srcId, dstId);
            dstObjMap.put(dstId, newDyos[index]);
            ++index;
        }
        map.put(i, childMap);
    }

    private void copyDyoFromRow(Row row, DynamicObject newDyo) {
        String selectField = this.getSelectField(ENTITYID);
        for (String name : selectField.split(",")) {
            if (StringUtils.equals((CharSequence)"id", (CharSequence)name) || StringUtils.equals((CharSequence)ENTITY_NUMBER, (CharSequence)name) || StringUtils.equals((CharSequence)ENTITY_LONGNUMBER, (CharSequence)name)) continue;
            newDyo.set(name, row.get(name));
        }
    }

    private String getCodeRuleNumber(String entityId, DynamicObject dataInfo, String orgID) {
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ENTITYID, (DynamicObject)dataInfo, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dataInfo);
        return number;
    }

    private String getSelectField(String entity) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        Map fields = entityType.getAllFields();
        return String.join((CharSequence)",", fields.keySet()) + ",id,masterid";
    }

    private void deleteTargetOpinions(Long targetSscid) {
        if (targetSscid == null) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("sscid", "=", (Object)targetSscid)};
        DeleteServiceHelper.delete((String)ENTITYID, (QFilter[])qFilters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String sscidStr = this.getPageCache().get(CK_SSCID);
        if (StringUtils.isNotBlank((CharSequence)sscidStr)) {
            this.setTreeFilter(sscidStr);
        }
    }

    private void setTreeFilter(String sscid) {
        ListView thisView = (ListView)this.getView();
        TreeListView treeView = (TreeListView)thisView.getTreeListView();
        TreeListModel treeModel = (TreeListModel)treeView.getTreeModel();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        QFilter qFilter = new QFilter("sscid", "=", (Object)Long.valueOf(sscid));
        qFilterList.add(qFilter);
        treeModel.setTreeFilter(qFilterList);
    }

    public void afterBindData(EventObject e) {
        String sscidStr;
        String rtnStr;
        String refreshTree;
        Boolean isRefresh;
        super.afterBindData(e);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isLookUp = parameter.isLookUp();
        if (isLookUp && !Boolean.parseBoolean(this.getPageCache().get(CK_AFTERF7REFRESH))) {
            Object sscid;
            this.getPageCache().put(CK_SSCID, (String)parameter.getCustomParam("sscId"));
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            if (filterParameter != null && (sscid = ((QFilter)filterParameter.getQFilters().get(0)).getValue()) != null) {
                this.refreshTreeListAfterF7Select(Long.parseLong(sscid + ""));
            }
        }
        if ((isRefresh = Boolean.valueOf(refreshTree = this.getPageCache().get(CK_REFRESHTREE))).booleanValue()) {
            return;
        }
        Object rtnValue = this.getView().getReturnData();
        if (rtnValue instanceof String && StringUtils.equals((CharSequence)(rtnStr = (String)rtnValue), (CharSequence)"beforeClose") && StringUtils.isNotBlank((CharSequence)(sscidStr = this.getPageCache().get(CK_SSCID)))) {
            this.refreshTreeListAfterSave(Long.parseLong(sscidStr));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.getPageCache().put(CK_REFRESHTREE, "false");
        this.getPageCache().put(CK_AFTERF7REFRESH, "false");
    }

    private void refreshTreeListAfterF7Select(long sscId) {
        this.getPageCache().put(CK_AFTERF7REFRESH, "true");
        this.refreshTreeListWithFilter(sscId);
    }

    private void refreshTreeListAfterSave(long sscId) {
        this.getPageCache().put(CK_REFRESHTREE, "true");
        this.refreshTreeListWithFilter(sscId);
    }

    private void refreshTreeListWithFilter(long sscId) {
        ListView thisView = (ListView)this.getView();
        TreeListView treeView = (TreeListView)thisView.getTreeListView();
        TreeListModel treeModel = (TreeListModel)treeView.getTreeModel();
        TreeNode root = treeModel.getRoot();
        treeModel.refreshNode((Object)root.getId());
        this.treeListView.refreshTreeNode(root.getId(), false);
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String sscIdString = this.getPageCache().get(CK_SSCID);
        TreeListModel treeModel = (TreeListModel)this.getTreeListView().getTreeModel();
        List treeFilter = treeModel.getTreeFilter();
        treeFilter.clear();
        if (StringUtils.isNotEmpty((CharSequence)sscIdString)) {
            Long sscId = Long.valueOf(sscIdString);
            QFilter qFilter = new QFilter("sscid", "=", (Object)sscId);
            treeModel.getTreeFilter().add(qFilter);
        }
    }
}

