/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AssignDecisionItemPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final String FIELD_DECISIONITEMRELATION = "id,number,name, ssccenter.id ssccenter,decisionitem.id decisionitem,billtypeid.id billtypeid,tasktypeid.id tasktypeid,approvaltype,status,enable,createtime";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        FormShowParameter param = this.getView().getFormShowParameter();
        List ids = (List)param.getCustomParam("decisionitemlist");
        if (ids != null && ids.size() > 0) {
            QFilter filter = new QFilter("decisionitem", "in", (Object)ids);
            DynamicObject[] relations = this.getDecisionItemCols(new QFilter[]{filter});
            if (relations == null || relations.length == 0) {
                return;
            }
            HashSet<String> approvaltypeSet = new HashSet<String>();
            for (DynamicObject item : relations) {
                String approvalType = item.getString("approvaltype");
                String[] typeArr = approvalType.split(",");
                approvaltypeSet.addAll(Arrays.asList(typeArr));
            }
            IDataModel model = this.getModel();
            for (String approvalType : approvaltypeSet) {
                if ("0".equals(approvalType)) {
                    model.setValue("approvalfail", (Object)Boolean.TRUE);
                    continue;
                }
                if ("1".equals(approvalType)) {
                    model.setValue("approvalpass", (Object)Boolean.TRUE);
                    continue;
                }
                if (!"2".equals(approvalType)) continue;
                model.setValue("approvalreback", (Object)Boolean.TRUE);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection effectiveBizBills = this.getTaskTypeData("1");
        if (effectiveBizBills != null) {
            int pos = 0;
            model.batchCreateNewEntryRow("entryentity", effectiveBizBills.size());
            for (DynamicObject bizBill : effectiveBizBills) {
                model.setValue("billtypeid", bizBill.get("billtypeid"), pos);
                model.setValue("billtypename", bizBill.get("billtypename"), pos);
                model.setValue("effective", bizBill.get("effective"), pos);
                model.setValue("tasktypeid", bizBill.get("tasktypeid"), pos);
                model.setValue("tasktype", bizBill.get("tasktype"), pos);
                ++pos;
            }
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        if ("includeonway".equals(propName)) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (((Boolean)propValue).booleanValue()) {
                DynamicObjectCollection onWayBizBills = this.getTaskTypeData("2");
                if (onWayBizBills == null) {
                    return;
                }
                for (DynamicObject bizBill : onWayBizBills) {
                    DynamicObject addNew = entryEntity.addNew();
                    addNew.set("billtypeid", bizBill.get("billtypeid"));
                    addNew.set("billtypename", bizBill.get("billtypename"));
                    addNew.set("effective", bizBill.get("effective"));
                    addNew.set("tasktypeid", bizBill.get("tasktypeid"));
                    addNew.set("tasktype", bizBill.get("tasktype"));
                }
            } else {
                entryEntity.removeIf(en -> "2".equals(en.getString("effective")));
            }
            model.getDataEntity(true).set("entryentity", (Object)entryEntity);
            this.getView().updateView("entryentity");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctrl.getKey())) {
            this.assignDecisionItem();
        }
    }

    private void assignDecisionItem() {
        FormShowParameter param = this.getView().getFormShowParameter();
        List decisionItemIds = (List)param.getCustomParam("decisionitemlist");
        String sscid = (String)param.getCustomParam("sscid");
        if (StringUtils.isEmpty((CharSequence)sscid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u8d85\u65f6\uff0c\u60a8\u9009\u62e9\u7684\u5171\u4eab\u4e2d\u5fc3\u6570\u636e\u5df2\u5931\u6548\u3002", (String)"AssignDecisionItemPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Map<String, Object>> taskBillMapList = new ArrayList<Map<String, Object>>(16);
        for (int rows : selectedRows) {
            HashMap<String, Object> taskBillMap = new HashMap<String, Object>(2);
            DynamicObject dyo = (DynamicObject)entryentity.get(rows);
            taskBillMap.put("billtypeid", dyo.get("billtypeid"));
            taskBillMap.put("tasktypeid", dyo.get("tasktypeid"));
            taskBillMapList.add(taskBillMap);
        }
        if (CollectionUtils.isEmpty(taskBillMapList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AssignDecisionItemPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isSuccess = this.saveDecisionItemRelation(sscid, decisionItemIds, taskBillMapList);
        if (isSuccess) {
            this.getView().returnDataToParent((Object)"assignok");
        } else {
            this.getView().returnDataToParent((Object)"assignfail");
        }
        this.getView().close();
    }

    private boolean saveDecisionItemRelation(String sscid, List<Long> decisionItemIds, List<Map<String, Object>> taskBillMap) {
        QFilter sscidFilter = new QFilter("ssccenter", "=", (Object)Long.parseLong(sscid));
        ArrayList<DynamicObject> newDecisionItemList = new ArrayList<DynamicObject>();
        for (int i = 0; i < decisionItemIds.size(); ++i) {
            QFilter decisionItemIdFilter = new QFilter("decisionitem", "=", (Object)decisionItemIds.get(i));
            for (int j = 0; j < taskBillMap.size(); ++j) {
                QFilter taskTypeIdFilter;
                QFilter billTypeIdFilter = new QFilter("billtypeid", "=", taskBillMap.get(j).get("billtypeid"));
                DynamicObject dyDecisionItemRel = this.getDecisionItem(new QFilter[]{sscidFilter, billTypeIdFilter, taskTypeIdFilter = new QFilter("tasktypeid", "=", taskBillMap.get(j).get("tasktypeid")), decisionItemIdFilter});
                if (dyDecisionItemRel != null) continue;
                dyDecisionItemRel = BusinessDataServiceHelper.newDynamicObject((String)"task_decisionitem_re");
                newDecisionItemList.add(dyDecisionItemRel);
                dyDecisionItemRel.set("ssccenter", (Object)sscid);
                dyDecisionItemRel.set("decisionitem", (Object)decisionItemIds.get(i));
                dyDecisionItemRel.set("billtypeid", taskBillMap.get(j).get("billtypeid"));
                dyDecisionItemRel.set("tasktypeid", taskBillMap.get(j).get("tasktypeid"));
                dyDecisionItemRel.set("status", (Object)"A");
                dyDecisionItemRel.set("enable", (Object)"1");
                dyDecisionItemRel.set("createtime", (Object)new Date());
                dyDecisionItemRel.set("number", (Object)decisionItemIds.get(i).toString());
                dyDecisionItemRel.set("name", (Object)decisionItemIds.get(i).toString());
            }
        }
        boolean isNewSuccess = false;
        if (newDecisionItemList.size() > 0) {
            DynamicObject[] newDecisionItemArr = new DynamicObject[newDecisionItemList.size()];
            newDecisionItemList.toArray(newDecisionItemArr);
            Object[] ret = SaveServiceHelper.save((DynamicObject[])newDecisionItemArr);
            if (ret != null && ret.length > 0) {
                isNewSuccess = true;
            }
        } else {
            isNewSuccess = true;
        }
        return isNewSuccess;
    }

    private DynamicObject getDecisionItem(QFilter[] filters) {
        return BusinessDataServiceHelper.loadSingle((String)"task_decisionitem_re", (String)FIELD_DECISIONITEMRELATION, (QFilter[])filters);
    }

    private DynamicObject[] getDecisionItemCols(QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)"task_decisionitem_re", (String)FIELD_DECISIONITEMRELATION, (QFilter[])filters);
    }

    private DynamicObjectCollection getTaskTypeData(String effectiveStatus) {
        String sscId = this.getPageCache().get("sscid");
        if (sscId == null) {
            FormShowParameter param = this.getView().getFormShowParameter();
            sscId = (String)param.getCustomParam("sscid");
            this.getPageCache().put("sscid", sscId);
        }
        if (StringUtils.isNotBlank((CharSequence)sscId)) {
            String selectFields = "id billtypeid,name billtypename,effective,entryentity.tasktype.id tasktypeid,entryentity.tasktype.name tasktype";
            QFilter qFilterOnWay = new QFilter("effective", "=", (Object)effectiveStatus);
            QFilter qFilterSsc = new QFilter("ssccenter", "=", (Object)Long.valueOf(sscId));
            return QueryServiceHelper.query((String)"task_taskbill", (String)selectFields, (QFilter[])new QFilter[]{qFilterOnWay, qFilterSsc});
        }
        return null;
    }
}

