/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.common.LogBuildUtil;

public class ChooseTargetSSCFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CBK_CONFIRM = "confirm";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit ssc = (BasedataEdit)this.getControl("sscid");
        ssc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String fieldName = edit.getKey();
        if (StringUtils.equals((CharSequence)"sscid", (CharSequence)fieldName)) {
            this.addSscOrgPermFilter(e);
        }
    }

    private void addSscOrgPermFilter(BeforeF7SelectEvent e) {
        Object sscidTmp;
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)currentUserId, (String)appId, (String)"task_appropinions", (String)"47150e89000000ac");
        List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
        boolean isAllPerssion = allPermOrgs.hasAllOrgPerm();
        if (!isAllPerssion) {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            QFilter qFilter = new QFilter("id", "in", (Object)hasPermOrgs);
            qFilters.add(qFilter);
        }
        if ((sscidTmp = this.getView().getFormShowParameter().getCustomParam("sscid")) != null) {
            QFilter nqFilter = new QFilter("id", "!=", (Object)Long.valueOf(sscidTmp + ""));
            qFilters.add(nqFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        if ("barcancel".equals(itemKey)) {
            view.close();
        } else if ("barcertain".equals(itemKey)) {
            this.addOperationLog();
            if (view.getModel().getValue("sscid") == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"ChooseTargetSSCFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String confirmTips = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u590d\u5236\u5f53\u524d\u5168\u90e8\u5e38\u7528\u5ba1\u6279\u610f\u89c1\uff0c\u5e76\u8986\u76d6\u81f3\u76ee\u6807\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"ChooseTargetSSCFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CBK_CONFIRM, (IFormPlugin)this);
            view.showConfirm(confirmTips, MessageBoxOptions.OKCancel, confirmCallBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if (StringUtils.equals((CharSequence)key, (CharSequence)CBK_CONFIRM)) {
            MessageBoxResult result = evt.getResult();
            if (MessageBoxResult.Yes == result) {
                HashMap<String, Object> rtnData = new HashMap<String, Object>(2);
                rtnData.put("certainCopy", Boolean.TRUE);
                Object sscidTmp = ((DynamicObject)this.getModel().getValue("sscid")).getPkValue();
                if (sscidTmp instanceof Long) {
                    rtnData.put("sscid", sscidTmp);
                    this.getView().returnDataToParent(rtnData);
                }
            }
            this.getView().close();
        }
    }

    private void addOperationLog() {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u590d\u5236\u5230\u76ee\u6807", "ChooseTargetSSCFormPlugin_4", "ssc-task-formplugin");
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u5e38\u89c1\u5ba1\u6279\u610f\u89c1\u590d\u5236\u5230\u76ee\u6807\u64cd\u4f5c\u3002", "ChooseTargetSSCFormPlugin_3", "ssc-task-formplugin");
        OpLogAppInfo opLogAppInfo = LogBuildUtil.buildLogInfo(this.getView(), null, "ssc_calendar_multiplex", "barcertain", opName, opDes, new String[0]);
        LogServiceHelper.addLog((AppLogInfo)opLogAppInfo);
    }
}

