/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.constant.EntityField;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.enums.DealTypeEnum;
import kd.ssc.exception.enums.NotCompensateEnum;
import kd.ssc.exception.util.ExceptionHelperUtil;
import kd.ssc.task.util.RecordExceptionUtil;

public class ExceptionRecordListPlugin
extends AbstractListPlugin {
    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"retryagain")) {
            if (this.isSelectRowsInvalid(selectedRows, true)) {
                return;
            }
            List<Long> selectRowPkId = this.getSelectRowsPkId(selectedRows);
            if (!this.validateDataForBatchProcessing(selectRowPkId)) {
                return;
            }
            int compensateSucessNumer = this.batchCompensate(selectRowPkId);
            this.showSucessTip(compensateSucessNumer, selectedRows.size() - compensateSucessNumer);
            this.getView().updateView();
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"viewstack")) {
            if (this.isSelectRowsInvalid(selectedRows, false)) {
                return;
            }
            Object key = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)key, (String)"task_exceptionrecord", (String)"failurereason_tag");
            String content = dyo.getString("failurereason_tag");
            if (StringUtils.isNotBlank((CharSequence)content)) {
                RecordExceptionUtil.openShowDetailDialog((IFormView)this.getView(), null, (String)content);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u65e0\u5f02\u5e38\u5806\u6808\u4fe1\u606f\u3002", (String)"ExceptionRecordListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"viewhistory")) {
            if (this.isSelectRowsInvalid(selectedRows, false)) {
                return;
            }
            long selectid = (Long)selectedRows.get(0).getPrimaryKeyValue();
            this.showHisRecord(selectid);
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"markpass")) {
            if (this.isSelectRowsInvalid(selectedRows, true)) {
                return;
            }
            List<Long> selectRowPkId = this.getSelectRowsPkId(selectedRows);
            if (!this.validateDataForBatchProcessing(selectRowPkId)) {
                return;
            }
            this.markPass(selectRowPkId);
            this.getView().updateView("billlistap");
        }
    }

    private void markPass(List<Long> selectRowPkId) {
        DynamicObject[] qryCollections;
        ArrayList<DynamicObject> hisNewDataList = new ArrayList<DynamicObject>(10);
        String selectField = EntityField.buildSelectField((String[])new String[]{"billid", "billno", "compensatestatus", "iscompensate", "failuretime", "exceptiontype"});
        for (DynamicObject dyo : qryCollections = BusinessDataServiceHelper.load((String)"task_exceptionrecord", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", selectRowPkId)})) {
            dyo.set("compensatestatus", (Object)CompensateStatusEnum.MARKPASS.getValue());
            dyo.set("iscompensate", (Object)NotCompensateEnum.N_COMPENSATE.getValue());
            DynamicObject hisNewData = BusinessDataServiceHelper.newDynamicObject((String)"task_exceptionhistory");
            hisNewData.set("billid", (Object)dyo.getString("billid"));
            hisNewData.set("billno", (Object)dyo.getString("billno"));
            hisNewData.set("dealtype", (Object)DealTypeEnum.MarkPass.getValue());
            hisNewData.set("retrytime", (Object)new Date());
            hisNewData.set("compensatestatus", (Object)CompensateStatusEnum.MARKPASS.getValue());
            hisNewData.set("failuretime", (Object)dyo.getDate("failuretime"));
            hisNewData.set("exceptiontype", (Object)dyo.getString("exceptiontype"));
            hisNewDataList.add(hisNewData);
        }
        SaveServiceHelper.save((DynamicObject[])qryCollections);
        SaveServiceHelper.save((DynamicObject[])hisNewDataList.toArray(new DynamicObject[0]));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fielldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)fielldName, (CharSequence)"billno")) {
            ListSelectedRow selectedRow = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
            long selectid = (Long)selectedRow.getPrimaryKeyValue();
            this.showBillForm(selectid);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterCol = args.getCommonFilterColumns();
        for (FilterColumn filter : commonFilterCol) {
            if (!filter.getFieldName().equals("compensatestatus")) continue;
            filter.setDefaultValue("0");
        }
    }

    private int batchCompensate(List<Long> keyIds) {
        DynamicObjectCollection qryCollections = QueryServiceHelper.query((String)"task_exceptionrecord", (String)this.getBatchSelectFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", keyIds)});
        return ExceptionHelperUtil.batchCompensate((DynamicObjectCollection)qryCollections, (boolean)false);
    }

    private List<Long> getSelectRowsPkId(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> keyIds = new ArrayList<Long>(20);
        for (ListSelectedRow row : selectedRows) {
            Long keyId = (Long)row.getPrimaryKeyValue();
            keyIds.add(keyId);
        }
        return keyIds;
    }

    private boolean isSelectRowsInvalid(ListSelectedRowCollection selectedRows, boolean canMultipleSelect) {
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExceptionRecordListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (selectedRows.size() > 1 && !canMultipleSelect) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ExceptionRecordListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateDataForBatchProcessing(List<Long> pkids) {
        Set<String> dataStatusSet = this.getOnePropSet(pkids, "compensatestatus");
        if (dataStatusSet.contains(CompensateStatusEnum.SUCCESS.getValue()) || dataStatusSet.contains(CompensateStatusEnum.STOP.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5b58\u5728\u72b6\u6001\u4e3a\u201c\u6210\u529f\u201d\u6216\u8005\u201c\u505c\u6b62\u201d\u7684\u5f02\u5e38\u8bb0\u5f55\uff0c\u65e0\u6cd5\u91cd\u590d\u6267\u884c\u3002", (String)"ExceptionRecordListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Set<String> getOnePropSet(List<Long> pkids, String propName) {
        HashSet<String> propValue = new HashSet<String>(10);
        DynamicObjectCollection qryObj = QueryServiceHelper.query((String)"task_exceptionrecord", (String)propName, (QFilter[])new QFilter[]{new QFilter("id", "in", pkids)});
        for (DynamicObject dyo : qryObj) {
            String value = dyo.getString(propName);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            propValue.add(dyo.getString(propName));
        }
        return propValue;
    }

    private void showSucessTip(int successCount, int failureCount) {
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u6267\u884c\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"ExceptionRecordListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), successCount, failureCount));
    }

    private void showHisRecord(Long selectDataId) {
        DynamicObject selectBillData = this.getSelectBillData(selectDataId);
        if (selectBillData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"ExceptionRecordListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("billid", selectBillData.get("billid"));
        params.put("exceptiontype", selectBillData.getString("exceptiontype"));
        parameter.setCustomParams(params);
        parameter.setBillFormId("task_exceptionhistory");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showBillForm(Long selectDataId) {
        DynamicObject selectBillData = this.getSelectBillData(selectDataId);
        if (selectBillData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"ExceptionRecordListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = selectBillData.getString("billtype");
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(formId);
            parameter.setPkId((Object)selectBillData.getString("billid"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private DynamicObject getSelectBillData(long selectDataId) {
        String selectField = EntityField.buildSelectField((String[])new String[]{"billid", "billtype", "exceptiontype"});
        return QueryServiceHelper.queryOne((String)"task_exceptionrecord", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectDataId)});
    }

    private String getBatchSelectFields() {
        return "*";
    }
}

