/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.image.pojo.ViewImageVo;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ImageMaintainListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ImageMaintainListPlugin.class);

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            if ("imagesync".equals(key)) {
                this.syncImageToEAS();
            } else if ("deleteimage".equals(key)) {
                this.deleteImage();
            } else if ("pingtest".equals(key)) {
                this.pingtest();
            } else if ("viewphoto".equals(key)) {
                this.viewPhoto();
            }
        }
    }

    private void viewPhoto() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrows = list.getSelectedRows();
        if (selectrows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ImageMaintainListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            Map<String, Object> map = this.buildMessageMap(selectrows.get(0).getPrimaryKeyValue());
            String billId = (String)map.get("billid");
            ViewImageVo viewImageVo = new ViewImageVo();
            viewImageVo.setBillId(billId);
            viewImageVo.setUserId(RequestContext.get().getUserId());
            viewImageVo.setUserName(RequestContext.get().getUserName());
            viewImageVo = ImageServiceHelper.viewPhoto((ViewImageVo)viewImageVo);
            if (StringUtils.isNotEmpty((String)viewImageVo.getUrl())) {
                this.getView().openUrl(viewImageVo.getUrl());
            } else {
                this.getView().showTipNotification(viewImageVo.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingtest() {
        DynamicObject imageconfig = QueryServiceHelper.queryOne((String)"bas_imageconfig", (String)"number,imagesystermip,imageport", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"A")});
        if (imageconfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u542f\u7528\u76f8\u5e94\u7684\u914d\u7f6e\u3002", (String)"ImageMaintainListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = imageconfig.getString("number");
        String imagesystermip = imageconfig.getString("imagesystermip");
        String imageport = imageconfig.getString("imageport");
        Socket socket = null;
        try {
            socket = SSLSocketFactory.getDefault().createSocket();
            socket.connect(new InetSocketAddress(imagesystermip, Integer.parseInt(imageport)));
        }
        catch (IOException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\u3002\u5f71\u50cf\u7cfb\u7edf\uff1a\u201c%1$s\u201d\uff0cIP\uff1a\u201c%2$s\u201d\uff0c\u7aef\u53e3\uff1a\u201c%3$s\u201d\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u201c%4$s\u201d\u3002", (String)"ImageMaintainListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), number, imagesystermip, imageport, e.getMessage()), Integer.valueOf(5000));
            return;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95edsocket\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f\u3002\u5f71\u50cf\u7cfb\u7edf\uff1a\u201c%1$s\u201d\uff0c\u5f71\u50cf\u7cfb\u7edfip\uff1a\u201c%2$s\u201d\uff0c\u5f71\u50cf\u7cfb\u7edf\u7aef\u53e3\uff1a\u201c%3$s\u201d\u3002", (String)"ImageMaintainListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), number, imagesystermip, imageport), Integer.valueOf(5000));
    }

    private void syncImageToEAS() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrows = list.getSelectedRows();
        Object primarykey = null;
        Map<String, Object> map = null;
        String imagemessage = null;
        String imagenumber = null;
        if (selectrows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ImageMaintainListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            int size = selectrows.size();
            int count = 0;
            for (ListSelectedRow listSelectedRow : selectrows) {
                primarykey = listSelectedRow.getPrimaryKeyValue();
                map = this.buildMessageMap(primarykey);
                imagenumber = (String)map.get("imagenumber");
                log.info(imagenumber + ":\u5f00\u59cb\u540c\u6b65EAS");
                try {
                    imagemessage = JSONUtils.toString(map);
                    ImageServiceHelper.SynEasImageMap((String)imagemessage, (String)imagenumber);
                    log.info(imagenumber + ":\u5df2\u7ecf\u540c\u6b65EAS");
                    if (++count != size) continue;
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"ImageMaintainListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
                catch (IOException e) {
                    log.error(imagenumber + ":\u540c\u6b65\u81f3EAS\u51fa\u9519:" + e.getMessage());
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u540c\u6b65\u81f3EAS\u51fa\u9519\uff1a\u201c%2$s\u201d\u3002", (String)"ImageMaintainListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), imagenumber, e.getMessage()));
                }
            }
        }
    }

    private void deleteImage() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrows = list.getSelectedRows();
        if (selectrows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ImageMaintainListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete_image", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u9009\u4e2d\u5f71\u50cf\uff1f", (String)"ImageMaintainListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && "delete_image".equals(messageBoxClosedEvent.getCallBackId())) {
            IListView list = (IListView)this.getView();
            ListSelectedRowCollection selectrows = list.getSelectedRows();
            for (ListSelectedRow listSelectedRow : selectrows) {
                Map<String, Object> map = this.buildMessageMap(listSelectedRow.getPrimaryKeyValue());
                String imagenumber = (String)map.get("imagenumber");
                ImageServiceHelper.deleteImage((String)imagenumber, (String)RequestContext.get().getUserName(), null);
            }
            list.clearSelection();
            this.getView().updateView();
        }
    }

    private Map<String, Object> buildMessageMap(Object primarykey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QFilter filter1 = new QFilter("id", "=", primarykey);
        String selectfields = "billtype,billid,billnumber,imagenumber,imagestate,creator,creatororgid,createtime,modifier,modifytime";
        DynamicObject imagerecord = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)selectfields, (QFilter[])new QFilter[]{filter1});
        if (imagerecord == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f71\u50cf\u8bb0\u5f55\u4e0d\u5b8c\u6574\u3002", (String)"ImageMaintainListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return map;
        }
        String billid = String.valueOf(imagerecord.get("billid"));
        map.put("SynEasImageMap", "SynEasImageMap");
        map.put("billid", billid);
        map.put("billnumber", imagerecord.get("billnumber"));
        map.put("imagenumber", imagerecord.get("imagenumber"));
        map.put("imagestate", imagerecord.get("imagestate"));
        map.put("creator", imagerecord.get("creator"));
        map.put("createtime", imagerecord.get("createtime"));
        map.put("modifier", imagerecord.get("modifier"));
        map.put("modifytime", imagerecord.get("modifytime"));
        map.put("billtype", imagerecord.get("billtype"));
        map.put("creatororgid", imagerecord.get("creatororgid"));
        return map;
    }
}

