/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.util.DateUtil;

public class IndexDataAutoCalculateTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(IndexDataAutoCalculateTask.class);
    private static final String sscId = "sscid";
    private static final String usergroup = "usergroup";
    private static final QFilter processingFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
    private static final QFilter completFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
    private static final QFilter normalStateFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()});
    private static final QFilter pauseStateFilter = new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue());
    private static final QFilter rescanStateFilter = new QFilter("state", "=", (Object)TaskStateEnum.RESCAN.getValue());
    private static final QFilter expirestateQFilter = new QFilter("expirestate", "=", (Object)"2");
    private static final QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
    private static final QFilter quaCheckTask = new QFilter("qualitysamplelibrary", ">", (Object)TaskFilterEnum.NOTQUACHECKTASK);
    private static final QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
    private static final QFilter overduequalityFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.CHECKING.getValue(), TaskStateEnum.RECTIFYING.getValue(), TaskStateEnum.REVIEW.getValue()});
    private static final QFilter pendinghandleFilter = new QFilter("state", "=", (Object)TaskStateEnum.CHECKING.getValue());
    private static final QFilter pendingFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue()});
    private static final QFilter pendingreformFilter = new QFilter("state", "=", (Object)TaskStateEnum.RECTIFYING.getValue());
    private static final QFilter pendingrecheckFilter = new QFilter("state", "=", (Object)TaskStateEnum.REVIEW.getValue());
    private static final QFilter completedqualityFilter = new QFilter("state", "=", (Object)TaskStateEnum.QUA_CHECK_COMPLETED.getValue());
    private DynamicObject paramObj = null;

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        Date nowDate = new Date();
        Date todayStart = null;
        Date todayEnd = null;
        Date monthStart = null;
        try {
            todayStart = DateUtil.getCurDateForm((Date)nowDate, (boolean)true);
            todayEnd = DateUtil.getCurDateForm((Date)nowDate, (boolean)false);
            Date firstDay = DateUtil.getFirstDayOfMonth((Date)nowDate);
            monthStart = DateUtil.getCurDateForm((Date)firstDay, (boolean)true);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        this.calTodayOrMonthTask(todayStart, todayEnd, true);
        this.calTodayOrMonthTask(monthStart, todayEnd, false);
        this.calHandleChart(todayEnd);
        this.calToDoTask();
        this.calTaskHandleCountAndEfficiency(DateUtil.addDay((Date)todayStart, (long)-6L), todayEnd);
        this.calMyToDoTask(todayStart, todayEnd, monthStart);
        this.calMonthlyRanking(monthStart, todayEnd);
        this.calAvgDaily(todayStart, todayEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calTodayOrMonthTask(Date startDate, Date endDate, boolean isToday) {
        String entityName = "task_task";
        String algoKey = "IndexDataAutoCalculateTask.calTodayOrMonthTask";
        String completentityName = "task_taskhistory";
        QFilter receivetimeFilter = QFilter.of((String)"receivetime >= ? and receivetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter processingFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter completetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        DataSet processDataSet = null;
        DataSet receiveCompleteDataSet = null;
        DataSet receiveCompleteDSCpoy = null;
        DataSet distributedDataSet = null;
        DataSet completetimeDataSet = null;
        try {
            processDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{receivetimeFilter, processingFilter, notQuaCheckTask}, null);
            processDataSet = processDataSet.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            receiveCompleteDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)completentityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{receivetimeFilter, completetimeFilter, notQuaCheckTask}, null);
            receiveCompleteDataSet = receiveCompleteDataSet.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            receiveCompleteDSCpoy = receiveCompleteDataSet.copy();
            distributedDataSet = processDataSet.union(receiveCompleteDSCpoy).groupBy(new String[]{sscId, usergroup}).sum("taskcount").finish();
            completetimeDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)completentityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{completetimeFilter, notQuaCheckTask}, null);
            completetimeDataSet = completetimeDataSet.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            if (isToday) {
                this.saveIndexData("today_receivecomplete", receiveCompleteDataSet, true);
                this.saveIndexData("today_distributed", distributedDataSet, true);
                this.saveIndexData("today_complete", completetimeDataSet, true);
            } else {
                this.saveIndexData("curmonth_receivecomplete", receiveCompleteDataSet, true);
                this.saveIndexData("curmonth_distributed", distributedDataSet, true);
                this.saveIndexData("curmonth_complete", completetimeDataSet, true);
            }
        }
        catch (Exception e1) {
            BizLog.log((String)("IndexDataAutoCalculateTask_calTodayandThismonthTask" + e1));
        }
        finally {
            if (processDataSet != null) {
                processDataSet.close();
            }
            if (receiveCompleteDataSet != null) {
                receiveCompleteDataSet.close();
            }
            if (receiveCompleteDSCpoy != null) {
                receiveCompleteDSCpoy.close();
            }
            if (distributedDataSet != null) {
                distributedDataSet.close();
            }
            if (completetimeDataSet != null) {
                completetimeDataSet.close();
            }
        }
    }

    private void saveIndexData(String propName, DataSet dSet, boolean isBusiness) {
        if (dSet == null) {
            return;
        }
        String entityName = isBusiness ? "task_indexdata_update" : "task_saleindexdata_update";
        QFilter propNameFil = new QFilter("propname", "=", (Object)propName);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{propNameFil});
        ArrayList<DynamicObject> dynObj = new ArrayList<DynamicObject>();
        for (Row row : dSet) {
            Integer taskcount = row.getInteger("taskcount");
            DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            newDynObj.set("propname", (Object)propName);
            newDynObj.set("propvalue", (Object)taskcount);
            newDynObj.set("updatetime", (Object)new Date());
            if (isBusiness) {
                Long sscid = row.getLong(sscId);
                newDynObj.set(sscId, (Object)sscid);
                String groupId = row.getString(usergroup);
                newDynObj.set(usergroup, (Object)groupId);
            } else {
                Long user = row.getLong("personid");
                newDynObj.set("user", (Object)user);
                Long sscid = row.getLong(sscId);
                newDynObj.set(sscId, (Object)sscid);
            }
            dynObj.add(newDynObj);
        }
        if (dynObj.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynObj.toArray(new DynamicObject[0]));
        }
        if (dSet != null) {
            dSet.close();
        }
    }

    private void saveIndexDataExt(DataSet dSet) {
        if (dSet == null) {
            return;
        }
        String entityName = "task_indexdata_update_ext";
        DeleteServiceHelper.delete((String)entityName, null);
        ArrayList<DynamicObject> dynObj = new ArrayList<DynamicObject>();
        for (Row row : dSet) {
            Long user = row.getLong("personid");
            Long sscid = row.getLong(sscId);
            String usergroupId = row.getString(usergroup);
            Integer taskcount = row.getInteger("taskcount");
            BigDecimal taskamount = row.getBigDecimal("taskamount").setScale(2, 4);
            BigDecimal costwaittime = row.getBigDecimal("costwaittime").setScale(2, 4);
            BigDecimal taskefficiency = row.getBigDecimal("taskefficiency").setScale(2, 4);
            DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            newDynObj.set("user", (Object)user);
            newDynObj.set(sscId, (Object)sscid);
            newDynObj.set("taskcount", (Object)taskcount);
            newDynObj.set("taskamount", (Object)taskamount);
            newDynObj.set("costwaittime", (Object)costwaittime);
            newDynObj.set("taskefficiency", (Object)taskefficiency);
            newDynObj.set("updatetime", (Object)new Date());
            newDynObj.set(usergroup, (Object)usergroupId);
            dynObj.add(newDynObj);
        }
        if (dynObj.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynObj.toArray(new DynamicObject[0]));
        }
        if (dSet != null) {
            dSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calHandleChart(Date date) {
        String entityName = "task_task";
        String algoKey = "IndexDataAutoCalculateTask.calHandleChart";
        QFilter processingFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter expirestateQFilter = new QFilter("expirestate", "=", (Object)"2");
        QFilter notexpireQFilter = new QFilter("expirestate", "!=", (Object)"2");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        Date threeDate = DateUtil.addDay((Date)date, (long)-3L);
        Date seventhDate = DateUtil.addDay((Date)date, (long)-7L);
        Date tenthDate = DateUtil.addDay((Date)date, (long)-10L);
        Date fifthDate = DateUtil.addDay((Date)date, (long)-15L);
        Date twentyDate = DateUtil.addDay((Date)date, (long)-20L);
        Date monthDate = DateUtil.addDay((Date)date, (long)-30L);
        QFilter threedayFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{threeDate, date});
        QFilter seventhdayFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{seventhDate, threeDate});
        QFilter tenthFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{tenthDate, seventhDate});
        QFilter fifthFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{fifthDate, tenthDate});
        QFilter twentFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{twentyDate, fifthDate});
        QFilter monthFilter = QFilter.of((String)"receivetime > ? and receivetime <= ?", (Object[])new Object[]{monthDate, twentyDate});
        QFilter gtmonthFilter = QFilter.of((String)"receivetime <= ? ", (Object[])new Object[]{monthDate});
        DataSet dataSet0_3 = null;
        DataSet oodDataSet0_3 = null;
        DataSet dataSet3_7 = null;
        DataSet oodDataSet3_7 = null;
        DataSet dataSet7_10 = null;
        DataSet oodDataSet7_10 = null;
        DataSet dataSet10_15 = null;
        DataSet oodDataSet10_15 = null;
        DataSet dataSet15_20 = null;
        DataSet oodDataSet15_20 = null;
        DataSet dataSet20_30 = null;
        DataSet oodDataSet20_30 = null;
        DataSet dataSet30_xx = null;
        DataSet oodDataSet30_xx = null;
        try {
            dataSet0_3 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{threedayFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet0_3 = dataSet0_3.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_threedays", dataSet0_3, true);
            oodDataSet0_3 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{threedayFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet0_3 = oodDataSet0_3.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_threedays_ood", oodDataSet0_3, true);
            dataSet3_7 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{seventhdayFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet3_7 = dataSet3_7.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_sevendays", dataSet3_7, true);
            oodDataSet3_7 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{seventhdayFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet3_7 = oodDataSet3_7.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_sevendays_ood", oodDataSet3_7, true);
            dataSet7_10 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{tenthFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet7_10 = dataSet7_10.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_tenthdays", dataSet7_10, true);
            oodDataSet7_10 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{tenthFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet7_10 = oodDataSet7_10.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_tenthdays_ood", oodDataSet7_10, true);
            dataSet10_15 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{fifthFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet10_15 = dataSet10_15.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_fifthdays", dataSet10_15, true);
            oodDataSet10_15 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{fifthFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet10_15 = oodDataSet10_15.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_fifthdays_ood", oodDataSet10_15, true);
            dataSet15_20 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{twentFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet15_20 = dataSet15_20.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_twentydays", dataSet15_20, true);
            oodDataSet15_20 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{twentFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet15_20 = oodDataSet15_20.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_twentydays_ood", oodDataSet15_20, true);
            dataSet20_30 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{monthFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet20_30 = dataSet20_30.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_monthdays", dataSet20_30, true);
            oodDataSet20_30 = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{monthFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet20_30 = oodDataSet20_30.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_monthdays_ood", oodDataSet20_30, true);
            dataSet30_xx = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{gtmonthFilter, processingFilter, notexpireQFilter, notQuaCheckTask}, null);
            dataSet30_xx = dataSet30_xx.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_monthdaysup", dataSet30_xx, true);
            oodDataSet30_xx = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{gtmonthFilter, processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            oodDataSet30_xx = oodDataSet30_xx.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("chart_monthdaysup_ood", oodDataSet30_xx, true);
        }
        catch (Exception e1) {
            BizLog.log((String)("IndexDataAutoCalculateTask_calHandleChart" + e1));
        }
        finally {
            if (dataSet0_3 != null) {
                dataSet0_3.close();
            }
            if (dataSet3_7 != null) {
                dataSet3_7.close();
            }
            if (dataSet7_10 != null) {
                dataSet7_10.close();
            }
            if (dataSet10_15 != null) {
                dataSet10_15.close();
            }
            if (dataSet15_20 != null) {
                dataSet15_20.close();
            }
            if (dataSet20_30 != null) {
                dataSet20_30.close();
            }
            if (dataSet30_xx != null) {
                dataSet30_xx.close();
            }
        }
    }

    private void calTaskHandleCountAndEfficiency(Date startDate, Date endDate) {
        QFilter receivetimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter pooltypeFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        QFilter ishandledFilter = new QFilter("ishandled", "=", (Object)"0");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(receivetimeFilter);
        qfList.add(pooltypeFilter);
        qfList.add(ishandledFilter);
        qfList.add(notQuaCheckTask);
        qfList.add(notAutoProcess);
        String entityName = "task_taskhistory";
        String algoKey = "IndexDataAutoCalculateTask.calTaskHandleCountAndEfficiency";
        String selectFields = "personid.id as personid, sscid.id as sscid, usergroup.id as usergroup, pooltype, coefficient, costwaittime";
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        ds = ds.select(new String[]{"personid", sscId, usergroup, "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "pooltype", "(case when costwaittime is null or costwaittime = 0 then 0.02 else costwaittime end) as costwaittime"}).groupBy(new String[]{"personid", sscId, usergroup}).count("taskcount").sum("coefficient", "taskamount").sum("costwaittime").finish();
        ds = ds.select(new String[]{"personid", sscId, usergroup, "taskcount", "taskamount", "costwaittime", "cast(case when taskcount=0 then 0 else taskamount/costwaittime end as decimal) as taskefficiency"});
        this.saveIndexDataExt(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calToDoTask() {
        String entityName = "task_task";
        QFilter processingFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter todoFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        QFilter touploadimageFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue());
        QFilter expirestateQFilter = new QFilter("expirestate", "=", (Object)"2");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        DataSet processingDataSet = null;
        DataSet expirestateDataSet = null;
        DataSet todoDataSet = null;
        DataSet touploadimageDataSet = null;
        try {
            processingDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calToDoTask", (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{processingFilter, notQuaCheckTask}, null);
            processingDataSet = processingDataSet.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("processing", processingDataSet, true);
            expirestateDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calToDoTask", (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            expirestateDataSet = expirestateDataSet.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("expire", expirestateDataSet, true);
            todoDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calToDoTask", (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{todoFilter, notQuaCheckTask}, null);
            todoDataSet = todoDataSet.select(new String[]{sscId, usergroup}).groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("tobeassigned", todoDataSet, true);
            touploadimageDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calToDoTask", (String)entityName, (String)"id,sscid,usergroup", (QFilter[])new QFilter[]{touploadimageFilter, notQuaCheckTask}, null);
            touploadimageDataSet = touploadimageDataSet.groupBy(new String[]{sscId, usergroup}).count("taskcount").finish();
            this.saveIndexData("touploadimage", touploadimageDataSet, true);
        }
        catch (Exception e1) {
            BizLog.log((String)("IndexDataAutoCalculateTask_calToDoTask" + e1));
        }
        finally {
            if (processingDataSet != null) {
                processingDataSet.close();
            }
            if (expirestateDataSet != null) {
                expirestateDataSet.close();
            }
            if (todoDataSet != null) {
                todoDataSet.close();
            }
            if (touploadimageDataSet != null) {
                touploadimageDataSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calMyToDoTask(Date startDate, Date endDate, Date monthStart) {
        QFilter daytimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter monthFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{monthStart, endDate});
        DataSet myProcessDataSet = null;
        DataSet normalDataSet = null;
        DataSet pauseDataSet = null;
        DataSet rescanDataSet = null;
        DataSet expirestateDataSet = null;
        DataSet completeDataSet = null;
        DataSet quamyProcessDataSet = null;
        DataSet pendinghandleDataSet = null;
        DataSet pendingreformDataSet = null;
        DataSet pendingrecheckDataSet = null;
        DataSet overduequalityDataSet = null;
        DataSet completedqualityDataSet = null;
        DataSet pendingDataSet = null;
        try {
            myProcessDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{processingFilter, notQuaCheckTask}, null);
            myProcessDataSet = myProcessDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_myprocess", myProcessDataSet, false);
            completeDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_taskhistory", (String)"id,personid,sscid", (QFilter[])new QFilter[]{completFilter, daytimeFilter, notQuaCheckTask}, null);
            completeDataSet = completeDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_complet", completeDataSet, false);
            normalDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{processingFilter, normalStateFilter, notQuaCheckTask}, null);
            normalDataSet = normalDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_normal", normalDataSet, false);
            pauseDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{processingFilter, pauseStateFilter, notQuaCheckTask}, null);
            pauseDataSet = pauseDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_pause", pauseDataSet, false);
            rescanDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{processingFilter, rescanStateFilter, notQuaCheckTask}, null);
            rescanDataSet = rescanDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_rescan", rescanDataSet, false);
            expirestateDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{processingFilter, expirestateQFilter, notQuaCheckTask}, null);
            expirestateDataSet = expirestateDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_expirestate", expirestateDataSet, false);
            quamyProcessDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{processingFilter, quaCheckTask}, null);
            quamyProcessDataSet = quamyProcessDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_quamyprocess", quamyProcessDataSet, false);
            pendinghandleDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{quaCheckTask, pendinghandleFilter}, null);
            pendinghandleDataSet = pendinghandleDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_pendinghandle", pendinghandleDataSet, false);
            pendingDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{quaCheckTask, pendingFilter}, null);
            pendingDataSet = pendingDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_pending", pendingDataSet, false);
            pendingreformDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{quaCheckTask, pendingreformFilter}, null);
            pendingreformDataSet = pendingreformDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_pendingreform", pendingreformDataSet, false);
            pendingrecheckDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{quaCheckTask, pendingrecheckFilter}, null);
            pendingrecheckDataSet = pendingrecheckDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_pendingrecheck", pendingrecheckDataSet, false);
            completedqualityDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMyToDoTask", (String)"task_taskhistory", (String)"id,personid,sscid", (QFilter[])new QFilter[]{quaCheckTask, completedqualityFilter, monthFilter}, null);
            completedqualityDataSet = completedqualityDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_completedquality", completedqualityDataSet, false);
            overduequalityDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calToDoTask", (String)"task_task", (String)"id,personid,sscid", (QFilter[])new QFilter[]{overduequalityFilter, expirestateQFilter, quaCheckTask}, null);
            overduequalityDataSet = overduequalityDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish();
            this.saveIndexData("sale_overduequality", overduequalityDataSet, false);
        }
        catch (Exception e1) {
            BizLog.log((String)("IndexDataAutoCalculateTask_calMyToDoTask" + e1));
        }
        finally {
            if (normalDataSet != null) {
                normalDataSet.close();
            }
            if (pauseDataSet != null) {
                pauseDataSet.close();
            }
            if (rescanDataSet != null) {
                rescanDataSet.close();
            }
            if (expirestateDataSet != null) {
                expirestateDataSet.close();
            }
            if (completeDataSet != null) {
                completeDataSet.close();
            }
            if (pendinghandleDataSet != null) {
                pendinghandleDataSet.close();
            }
            if (pendingreformDataSet != null) {
                pendingreformDataSet.close();
            }
            if (pendingrecheckDataSet != null) {
                pendingrecheckDataSet.close();
            }
            if (overduequalityDataSet != null) {
                overduequalityDataSet.close();
            }
            if (completedqualityDataSet != null) {
                completedqualityDataSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calMonthlyRanking(Date startDate, Date endDate) {
        QFilter monthtimeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
        DataSet dataSet = null;
        DataSet quaDataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMonthlyRanking", (String)"task_taskhistory", (String)"id,personid,sscid", (QFilter[])new QFilter[]{completFilter, monthtimeFilter, notAutoProcess, notQuaCheckTask}, null);
            dataSet = dataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish().orderBy(new String[]{"taskcount desc"});
            this.saveIndexData("sale_ranking", dataSet, false);
            quaDataSet = QueryServiceHelper.queryDataSet((String)"IndexDataAutoCalculateTask.calMonthlyRanking", (String)"task_taskhistory", (String)"id,personid,sscid", (QFilter[])new QFilter[]{quaCheckTask, completedqualityFilter, monthtimeFilter}, null);
            quaDataSet = quaDataSet.select("personid,sscid").groupBy(new String[]{"personid", sscId}).count("taskcount").finish().orderBy(new String[]{"taskcount desc"});
            this.saveIndexData("sale_ranking_quality", quaDataSet, false);
        }
        catch (Exception e1) {
            BizLog.log((String)("IndexDataAutoCalculateTask_calMonthlyRanking" + e1));
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (quaDataSet != null) {
                quaDataSet.close();
            }
        }
    }

    private boolean checkInitCompleted() {
        boolean isInitCompleted = true;
        String entityName = "task_paramcontrol";
        String selectProp = "paramname,paramvalue";
        QFilter nameFilter = new QFilter("paramname", "=", (Object)"isCalAvgPerDay");
        this.paramObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProp, (QFilter[])new QFilter[]{nameFilter});
        if (this.paramObj == null) {
            log.error("\u5171\u4eab\u7cfb\u7edf\u63a7\u5236\u53c2\u6570isCalAvgPerDay\u4e22\u5931\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002");
            return isInitCompleted;
        }
        String isInitDisRule = this.paramObj.getString("paramvalue");
        if (StringUtils.isNotEmpty((String)isInitDisRule) && "0".equals(isInitDisRule)) {
            isInitCompleted = false;
        }
        return isInitCompleted;
    }

    private void calAvgDaily(Date startDate, Date endDate) {
        boolean isCompleted = this.checkInitCompleted();
        String algoKey = "IndexDataAutoCalculateTask.calAvgPerDay";
        DataSet todayTaskSet = null;
        DataSet allTaskSet = null;
        DataSet resultSet = null;
        ArrayList<DynamicObject> dynObjs = new ArrayList<DynamicObject>();
        if (isCompleted) {
            QFilter completeFilter = QFilter.of((String)"completetime >= ? and completetime <= ?", (Object[])new Object[]{startDate, endDate});
            todayTaskSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskhistory", (String)"id,personid,qualitysamplelibrary,expirestate,sscid", (QFilter[])new QFilter[]{completeFilter}, null);
            todayTaskSet = todayTaskSet.select(new String[]{"id", "personid", sscId, "cast(case when qualitysamplelibrary>0 then 1 else 0 end as integer) as isquality", "cast(case when expirestate='2' then '1' else '0' end as String) as expire"});
            todayTaskSet = todayTaskSet.groupBy(new String[]{"personid", sscId, "isquality", "expire"}).count("tasknum").finish();
            todayTaskSet = todayTaskSet.select(new String[]{"personid", sscId, "isquality", "cast(case when expire='0' then tasknum else 0 end as integer) as normalnum", "cast(case when expire='1' then tasknum else 0 end as integer) as expirenum"});
            resultSet = todayTaskSet.groupBy(new String[]{"personid", sscId, "isquality"}).sum("normalnum").sum("expirenum").finish();
            DeleteServiceHelper.delete((String)"task_saleindex_avgdaily", (QFilter[])new QFilter[]{new QFilter("date", "=", (Object)startDate)});
        } else {
            allTaskSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskhistory", (String)"id,personid,qualitysamplelibrary,expirestate,completetime as ct, sscid", null, (String)"completetime asc");
            allTaskSet = allTaskSet.select(new String[]{"id", "personid", sscId, "cast(case when qualitysamplelibrary>0 then 1 else 0 end as integer) as isquality", "cast(case when expirestate='2' then '1' else '0' end as String) as expire", "date(year(ct),month(ct),day(ct))"});
            allTaskSet = allTaskSet.groupBy(new String[]{"date", "personid", sscId, "isquality", "expire"}).count("tasknum").finish();
            allTaskSet = allTaskSet.select(new String[]{"date", "personid", sscId, "isquality", "cast(case when expire='0' then tasknum else 0 end as integer) as normalnum", "cast(case when expire='1' then tasknum else 0 end as integer) as expirenum"});
            resultSet = allTaskSet.groupBy(new String[]{"date", "personid", sscId, "isquality"}).sum("normalnum").sum("expirenum").finish();
            DeleteServiceHelper.delete((String)"task_saleindex_avgdaily", null);
        }
        if (todayTaskSet != null) {
            todayTaskSet.close();
        }
        if (allTaskSet != null) {
            allTaskSet.close();
        }
        if (resultSet == null) {
            return;
        }
        for (Row row : resultSet) {
            Date completeDate = isCompleted ? startDate : row.getDate("date");
            Long personid = row.getLong("personid");
            int isquality = row.getInteger("isquality");
            int normalnum = row.getInteger("normalnum");
            int expirenum = row.getInteger("expirenum");
            Long sscid = row.getLong(sscId);
            DynamicObject avgperday = BusinessDataServiceHelper.newDynamicObject((String)"task_saleindex_avgdaily");
            avgperday.set("user", (Object)personid);
            avgperday.set(sscId, (Object)sscid);
            avgperday.set("isquality", (Object)String.valueOf(isquality));
            avgperday.set("normalnum", (Object)normalnum);
            avgperday.set("expirenum", (Object)expirenum);
            avgperday.set("date", (Object)completeDate);
            dynObjs.add(avgperday);
            if (dynObjs.size() % 1000 != 0) continue;
            SaveServiceHelper.save((DynamicObject[])dynObjs.toArray(new DynamicObject[dynObjs.size()]));
            dynObjs.clear();
        }
        if (dynObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynObjs.toArray(new DynamicObject[dynObjs.size()]));
        }
        if (!isCompleted && this.paramObj != null) {
            this.paramObj.set("paramvalue", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.paramObj});
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }
}

