/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.util.InvoiceMaintainUtil;

public class InvoiceMaintainListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(InvoiceMaintainListPlugin.class);

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("modifytime desc,createtime desc");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            if ("tblimage".equalsIgnoreCase(key)) {
                this.viewImage();
            } else if ("tblrecheck".equalsIgnoreCase(key)) {
                this.recheckRecognized();
                this.refreshList();
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs contInitEvent) {
        super.filterContainerInit(contInitEvent);
        List commonFilters = contInitEvent.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("modifytime".equalsIgnoreCase(fieldName)) {
                filterColumn.setDefaultValue("63");
                continue;
            }
            if (!"taskbill.name".equalsIgnoreCase(fieldName)) continue;
            List<ComboItem> cbItemBillType = CommonFilterUtil.getComboItems("task_taskbill", null);
            if (cbItemBillType == null || cbItemBillType.size() == 0) {
                return;
            }
            List listComItemBilltype = commonFilterColumn.getComboItems();
            listComItemBilltype.clear();
            commonFilterColumn.setComboItems(cbItemBillType);
        }
    }

    private void viewImage() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceMaintainListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows != null && selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InvoiceMaintainListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        Object selectedRowId = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject invoiceMain = InvoiceMaintainUtil.queryInvoiceMaintain((Object)selectedRowId);
        if (invoiceMain == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"InvoiceMaintainListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String imageNumber = invoiceMain.getString("imagenumber");
        if (StringUtils.isEmpty((String)imageNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"InvoiceMaintainListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            String userId = RequestContext.get().getUserId();
            String userName = RequestContext.get().getUserName();
            String url = ImageServiceHelper.viewPhoto((String)imageNumber, (String)userId, (String)userName);
            if (url == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"InvoiceMaintainListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().openUrl(url);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u5f71\u50cf\u51fa\u9519\uff1a%s", (String)"InvoiceMaintainListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void recheckRecognized() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceMaintainListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        for (ListSelectedRow selectedRow : selectedRows) {
            idList.add(selectedRow.getPrimaryKeyValue());
        }
        Object[] pkArray = idList.toArray();
        try {
            DynamicObject[] invoiceMaintainArr = InvoiceMaintainUtil.queryInvoiceMaintainCol((Object[])pkArray);
            DynamicObject[] imageIds = InvoiceMaintainUtil.saveImageQueueBatch((DynamicObject[])invoiceMaintainArr);
            if (imageIds == null || imageIds.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u91cd\u65b0\u8bc6\u522b\u51fa\u9519\uff0c\u539f\u56e0\u4e3a\u4fdd\u5b58\u5f71\u50cf\u961f\u5217\u5931\u8d25\u3002", (String)"InvoiceMaintainListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.inMQQueue(imageIds);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u53d1\u7968\u8bb0\u5f55\u5df2\u7ecf\u8fdb\u5165\u53d1\u7968\u8bc6\u522b\u7cfb\u7edf\u5f71\u50cf\u961f\u5217\u8fdb\u884c\u91cd\u65b0\u8bc6\u522b\u3002", (String)"InvoiceMaintainListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("\u60a8\u9009\u62e9\u7684\u53d1\u7968\u91cd\u65b0\u8bc6\u522b\u51fa\u9519\uff1a", (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u53d1\u7968\u91cd\u65b0\u8bc6\u522b\u51fa\u9519\uff1a\u201c%s\u201d\u3002", (String)"InvoiceMaintainListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), e));
        }
    }

    private void inMQQueue(DynamicObject[] data) {
        log.info("\u5f00\u59cb\u5165\u961fMQ-kd.bos.invoice.service.invoice_queue");
        log.info("\u521b\u5efaMQ\u6210\u529f-kd.bos.invoice.service.invoice_queue");
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.invoice.service.invoice_queue");){
            for (DynamicObject item : data) {
                pub.publish(item.get("id"));
            }
        }
        log.info("\u5165\u961fMQ\u6210\u529f-kd.bos.invoice.service.invoice_queue");
    }

    private void refreshList() {
        ((IListView)this.getView()).refresh();
        BillList list = (BillList)this.getControl("billlistap");
        list.clearSelection();
    }
}

