/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PriorityrulePlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(PriorityrulePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.equals("save")) {
            FormShowParameter paramter = this.getView().getFormShowParameter();
            String taskBill = (String)paramter.getCustomParam("taskBill");
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)taskBill);
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
            filterBuilder.buildFilter(false);
            HashMap<String, String> map = new HashMap<String, String>();
            String filter = filterBuilder.getFilterObject().getFilter();
            map.put("filter", filter != null && filter.length() > 2000 ? filter.substring(0, 2000) : filter);
            map.put("filterCondition", SerializationUtils.toJsonString((Object)filterCondition));
            log.info("PriorityrulePlugin \u56de\u4f20\u7ed9\u4e1a\u52a1\u5355\u636emap:" + map);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.createFilterGrid(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String json = (String)paramter.getCustomParam("json");
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        if (StringUtils.isNotEmpty((CharSequence)json.trim())) {
            FilterCondition fc2 = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            filterGrid.SetValue(fc2);
        }
    }

    public void createFilterGrid(EventObject e) {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String taskBill = (String)paramter.getCustomParam("taskBill");
        log.info(String.format("\u4e1a\u52a1\u5355\u636e\u4f18\u5148\u7ea7\u8fc7\u6ee4\u6761\u4ef6\u4f20\u9012\u7684taskBill %s", taskBill));
        if (taskBill != null) {
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)taskBill);
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(filterColumns);
        }
    }
}

