/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.ssc.task.formplugin.nsynprocess.NsynTaskAuditProcess;

public class ProcessingProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private int batchCount;
    private String opkey;
    private List<Long> pkIds;
    private List<Long> taskIds;
    private List<Object> decisionItemIds;
    private String opinion;
    private String innerMsg;
    private Boolean isEmbed;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"TaskAuditPool", (int)2);
    private static final String OP_RESULT = "opResult";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.iniFormParameter(parameter);
        this.start();
    }

    private void iniFormParameter(FormShowParameter parameter) {
        this.batchCount = this.getBatchCount(parameter);
        this.pkIds = this.getPkIds(parameter);
        this.opkey = this.getOpKey(parameter);
        this.opinion = this.getOpinion(parameter);
        this.innerMsg = this.getInnerMsg(parameter);
        this.taskIds = this.getTaskIds(parameter);
        this.decisionItemIds = this.getDecisionItemIds(parameter);
        this.isEmbed = this.getIsEmbed(parameter);
    }

    public void onProgress(ProgressEvent arg0) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.iniFormParameter(parameter);
            IFormView parentView = this.getParentView(parameter.getParentPageId());
            NsynTaskAuditProcess executer = new NsynTaskAuditProcess(taskId, this.batchCount, this.opkey, this.pkIds, this.taskIds, this.decisionItemIds, this.opinion, this.innerMsg, this.isEmbed, parentView);
            threadPool.execute((Runnable)executer);
            this.setTaskId(taskId);
        } else {
            boolean completed = NsynTaskAuditProcess.isCompleted(taskId);
            boolean finished = NsynTaskAuditProcess.isFinished(taskId);
            boolean isInteruption = NsynTaskAuditProcess.isInteruption(taskId);
            HashMap<String, String> returnData = new HashMap<String, String>(1);
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            if (completed) {
                this.complete();
                bar.stop();
            } else if (isInteruption) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6279\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProcessingProgressFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                returnData.put(OP_RESULT, "interrupted");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                bar.stop();
            } else if (finished) {
                returnData.put(OP_RESULT, "finished");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                bar.stop();
            } else {
                int progress = NsynTaskAuditProcess.getProgress(taskId);
                String tip = NsynTaskAuditProcess.getProgressTip(taskId);
                arg0.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)tip)) {
                    this.setProgressTip(tip);
                }
            }
        }
    }

    private void complete() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6279\u5b8c\u6210", (String)"ProcessingProgressFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        HashMap<String, String> returnData = new HashMap<String, String>(1);
        returnData.put(OP_RESULT, "completed");
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private String getTaskId() {
        return this.getPageCache().get("taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("taskid", taskId);
    }

    private void start() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        this.setProgressTip(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u7684\u6570\u636e\u8f83\u591a\uff0c\u6b63\u5728\u5206\u6279\u5904\u7406\u3002", (String)"ProcessingProgressFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    private String getOpKey(FormShowParameter parameter) {
        return (String)parameter.getCustomParam("opkey");
    }

    private String getOpinion(FormShowParameter parameter) {
        return (String)parameter.getCustomParam("opinion");
    }

    private String getInnerMsg(FormShowParameter parameter) {
        return (String)parameter.getCustomParam("innerMsg");
    }

    private Boolean getIsEmbed(FormShowParameter parameter) {
        String isEmbed = (String)parameter.getCustomParam("isEmbed");
        if (StringUtils.isEmpty((CharSequence)isEmbed)) {
            return false;
        }
        return Boolean.parseBoolean(isEmbed);
    }

    private List<Long> getPkIds(FormShowParameter parameter) {
        String str = (String)parameter.getCustomParam("pkIds");
        List<Long> pkids = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            pkids = (List)SerializationUtils.fromJsonString((String)str, List.class);
        }
        return pkids;
    }

    private List<Long> getTaskIds(FormShowParameter parameter) {
        String str = (String)parameter.getCustomParam("taskIds");
        List<Long> taskids = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            taskids = (List)SerializationUtils.fromJsonString((String)str, List.class);
        }
        return taskids;
    }

    private List<Object> getDecisionItemIds(FormShowParameter parameter) {
        String str = (String)parameter.getCustomParam("decisionitemids");
        List<Object> decisionItemIds = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            decisionItemIds = (List)SerializationUtils.fromJsonString((String)str, List.class);
        }
        return decisionItemIds;
    }

    private int getBatchCount(FormShowParameter parameter) {
        return (Integer)parameter.getCustomParam("batchcount");
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl("lblprogress");
        lblTip.setText(tip);
    }

    private IFormView getParentView(String parentPageId) {
        return this.getView().getViewNoPlugin(parentPageId);
    }
}

