/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.quality.QcPendingRecordOperationEnum;
import kd.ssc.task.business.task.TaskQcPendingRecordHelper;
import kd.ssc.task.common.TaskApprevalPluginUtil;
import kd.ssc.task.formplugin.quality.QualityApprovalPendingHelper;

public class QcPendingReasonselPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QcPendingReasonselPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit pendingopinions = (BasedataEdit)this.getControl("pendingopinions");
        pendingopinions.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List taskIds = (List)showParameter.getCustomParam("taskIds");
        if (taskIds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u4efb\u52a1ID\u5165\u53c2\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QcPendingReasonselPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if ("btnok".equalsIgnoreCase(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(15);
            DynamicObjectCollection pendingopinions = (DynamicObjectCollection)this.getModel().getValue("pendingopinions");
            if (CollectionUtils.isEmpty((Collection)pendingopinions)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u68c0\u6682\u6302\u539f\u56e0\u3002", (String)"QualityApprovalPendingListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Integer totalTaskCount = taskIds.size();
            Integer totalSuccessCount = 0;
            StringBuilder errorMsg = new StringBuilder();
            QFilter idFilter = new QFilter("id", "in", (Object)taskIds);
            DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,billnumber,state,pendingopinion", (QFilter[])new QFilter[]{idFilter});
            if (taskDos != null && taskDos.length > 0) {
                ArrayList<DynamicObject> taskDyos_ = new ArrayList<DynamicObject>(taskDos.length);
                ArrayList<DynamicObject> pendingRecordDyos_ = new ArrayList<DynamicObject>(taskDos.length);
                long currUserId = RequestContext.get().getCurrUserId();
                for (DynamicObject task : taskDos) {
                    long taskId = task.getLong("id");
                    String state = task.getString("state");
                    String billNumber = task.getString("billnumber");
                    if (!QualityApprovalPendingHelper.isPause(state)) {
                        String result = String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u9009\u62e9\u5f85\u8d28\u68c0\u3001\u5f85\u6574\u6539\u6216\u5f85\u590d\u6838\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityApprovalPendingListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber);
                        errorMsg.append(result).append("\n");
                        continue;
                    }
                    QcPendingRecordOperationEnum operation = QcPendingRecordOperationEnum.PAUSE_CHECKING;
                    if (TaskStateEnum.CHECKING.getValue().equals(state)) {
                        operation = QcPendingRecordOperationEnum.PAUSE_CHECKING;
                        task.set("state", (Object)TaskStateEnum.PAUSE_CHECKING.getValue());
                    } else if (TaskStateEnum.RECTIFYING.getValue().equals(state)) {
                        operation = QcPendingRecordOperationEnum.PAUSE_RECTIFYING;
                        task.set("state", (Object)TaskStateEnum.PAUSE_RECTIFYING.getValue());
                    } else if (TaskStateEnum.REVIEW.getValue().equals(state)) {
                        operation = QcPendingRecordOperationEnum.PAUSE_REVIEW;
                        task.set("state", (Object)TaskStateEnum.PAUSE_REVIEW.getValue());
                    }
                    List pendingIdList = pendingopinions.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    String pendingopinion = (String)this.getModel().getValue("pendingopinion");
                    DynamicObject pendingRecordDyo = TaskQcPendingRecordHelper.buildPendingRecordDyo((Long)taskId, (Long)currUserId, (QcPendingRecordOperationEnum)operation, pendingIdList, (String)pendingopinion);
                    pendingRecordDyos_.add(pendingRecordDyo);
                    taskDyos_.add(task);
                }
                if (taskDyos_.size() > 0) {
                    try (TXHandle h = TX.requiresNew((String)(QcPendingReasonselPlugin.class + ".click()"));){
                        try {
                            SaveServiceHelper.save((DynamicObject[])pendingRecordDyos_.toArray(new DynamicObject[pendingRecordDyos_.size()]));
                            Object[] saveResult = SaveServiceHelper.save((DynamicObject[])taskDyos_.toArray(new DynamicObject[taskDyos_.size()]));
                            totalSuccessCount = saveResult != null ? saveResult.length : 0;
                        }
                        catch (Exception e) {
                            h.markRollback();
                            log.error("an error occurred: save 'taskDyos_' and 'pendingRecordDyos_'.", (Throwable)e);
                            throw e;
                        }
                    }
                }
            }
            returnData.put("totalTaskCount", totalTaskCount);
            returnData.put("totalSuccessCount", totalSuccessCount);
            returnData.put("digest", this.createTipDigest(totalTaskCount, totalSuccessCount));
            returnData.put("errorMsg", errorMsg.toString());
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u6682\u6302\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"QualityApprovalPendingListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List taskIds = (List)showParameter.getCustomParam("taskIds");
        if (taskIds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u4efb\u52a1ID\u5165\u53c2\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QcPendingReasonselPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_qcpendingreason", (Long)billInfo.get("sscid").get(0));
        beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
    }
}

