/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.task.business.quality.credit.CreditFilterCondition;
import kd.ssc.task.business.quality.credit.QualityCheckCreditHelper;
import kd.ssc.task.common.CommonFilterUtil;

public class QualityCheckSchemePlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
BeforeQuickAddNewListener,
RowClickEventListener,
ItemClickListener {
    private static final Log logger = LogFactory.getLog(QualityCheckSchemePlugin.class);
    private static final String CONFIRM_APP_OBJ_CHANGE = "confirmAppObjChange";
    private static final String CONFIRM_CREDIT_ARGS_CHANGE = "confirmCreditArgsChange";
    private IDataModel model;
    private IFormView view;

    public void initialize() {
        super.initialize();
        this.model = this.getModel();
        this.view = this.getView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.view.getControl("btnselect");
        btn.addClickListener((ClickListener)this);
        BasedataEdit qualitychecktasktype = (BasedataEdit)this.getControl("qualitychecktasktype");
        qualitychecktasktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tasktype = (BasedataEdit)this.getControl("tasktype");
        tasktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taskbill = (BasedataEdit)this.getControl("multaskbill");
        taskbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit selectedorg = (BasedataEdit)this.getControl("selectedorg");
        selectedorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cpname = (BasedataEdit)this.getControl("cpname");
        cpname.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        cpname.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        TextEdit condition = (TextEdit)this.getView().getControl("condition");
        condition.addClickListener((ClickListener)this);
        AbstractGrid taskBill = (AbstractGrid)this.getView().getControl("taskbillentry");
        taskBill.addRowClickListener((RowClickEventListener)this);
        Toolbar taskBillToorBar = (Toolbar)this.getView().getControl("taskbilltoolbar");
        taskBillToorBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        Long sscId = this.getSscId();
        this.checkTaskInfoExist(model, sscId);
        this.afterCreateNewData(e);
    }

    private void checkTaskInfoExist(IDataModel model, Long sscId) {
        QFilter taskTypeFilter = this.getTaskTypeFilter(sscId);
        long taskTypeId = ((DynamicObject)model.getValue("tasktype")).getLong("id");
        QFilter idFilter = new QFilter("id", "=", (Object)taskTypeId);
        QFilter statusFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        boolean exists = QueryServiceHelper.exists((String)"task_tasktype", (QFilter[])new QFilter[]{taskTypeFilter, idFilter, statusFilter});
        if (!exists) {
            model.setValue("tasktype", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String enable;
        super.afterCreateNewData(e);
        this.handleDisRule();
        OperationStatus opStatus = this.view.getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.view.setEnable(Boolean.FALSE, new String[]{"number", "ssccenter"});
            this.mulTaskBill();
        }
        if (opStatus.equals((Object)OperationStatus.ADDNEW) && Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("iscopy"))) {
            this.view.setEnable(Boolean.TRUE, new String[]{"number"});
            this.mulTaskBill();
        }
        String string = enable = this.model.getValue("enable") == null ? null : this.model.getValue("enable").toString();
        if (EnableStatusEnum.Diable.getValue().equals(enable)) {
            this.view.setVisible(Boolean.FALSE, new String[]{"bar_save", "saveandnew"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (iscopy != null && iscopy.booleanValue()) {
            DynamicObjectCollection cpentry = this.getModel().getEntryEntity("cpentry");
            Iterator iterator = cpentry.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                DynamicObject cpname = next.getDynamicObject("cpname");
                if (cpname == null || Boolean.TRUE.equals(cpname.getBoolean("enable"))) continue;
                iterator.remove();
            }
            DynamicObject qualityCheckTaskType = (DynamicObject)this.getModel().getValue("qualitychecktasktype");
            if (qualityCheckTaskType != null && !qualityCheckTaskType.getBoolean("enable")) {
                this.getModel().setValue("qualitychecktasktype", null);
            }
            this.getView().updateView("cpentry");
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        BasedataEdit baseData = (BasedataEdit)event.getSource();
        String key = baseData.getKey();
        FormShowParameter showParameter = event.getShowParameter();
        if ("cpname".equals(key)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("taskbillentry".equals(entryGrid.getEntryKey())) {
            this.getPageCache().put("taskbillentry#rowindex", evt.getRow() + "");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnselect".equals(key)) {
            this.showTaskFilterF7Form(this.model.getValue("taskbillcondiontionjson") + "");
        } else if ("condition".equals(key)) {
            int rowIndex = Integer.parseInt(this.getPageCache().get("taskbillentry#rowindex"));
            DynamicObject billType = (DynamicObject)this.model.getValue("multaskbill", rowIndex);
            boolean isValid = this.isValidTaskBill(billType);
            if (!isValid) {
                return;
            }
            String conditionjson = this.model.getValue("conditionjson", rowIndex) + "";
            String creditJson = this.model.getValue("creditjson_tag", rowIndex) + "";
            this.showBillFilterF7Form(conditionjson, creditJson);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Long sscId = this.getSscId();
        if ("tasktype".equals(key)) {
            QFilter taskTypeFilter = this.getTaskTypeFilter(sscId);
            showParameter.getListFilterParameter().setFilter(taskTypeFilter);
        } else if ("qualitychecktasktype".equals(key)) {
            QFilter sscFilter = new QFilter("orgfield", "=", (Object)sscId);
            QFilter qualityJudgeFilter = new QFilter("qualityjudge", "=", (Object)"1");
            QFilter filter = sscFilter.and(qualityJudgeFilter);
            showParameter.getListFilterParameter().setFilter(filter);
        } else if ("taskbill".equals(key)) {
            QFilter sscFilter = new QFilter("ssccenter", "=", (Object)sscId);
            showParameter.getListFilterParameter().setFilter(sscFilter);
        } else if ("selectedorg".equals(key)) {
            QFilter sscFilter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter2(this.getPageCache(), "qualityCheckScheme_selectOrg", sscId);
            showParameter.getListFilterParameter().setFilter(sscFilter);
            showParameter.setFormId("ssc_orgtreelistf7");
            showParameter.setCustomParam("ServiceAppId", (Object)"ssc");
            showParameter.setCustomParam("sscId", (Object)sscId.toString());
        } else if ("cpname".equals(key)) {
            DynamicObjectCollection cpEntry = this.model.getEntryEntity("cpentry");
            ArrayList<Long> cpList = new ArrayList<Long>();
            for (DynamicObject obj : cpEntry) {
                DynamicObject cp = obj.getDynamicObject("cpname");
                if (cp == null) continue;
                cpList.add((Long)cp.getPkValue());
            }
            QFilter filter = new QFilter("id", "not in", cpList);
            filter.and(new QFilter("ssccenter", "=", (Object)sscId));
            showParameter.getListFilterParameter().setFilter(filter);
        } else if ("multaskbill".equals(key)) {
            DynamicObjectCollection taskBillEntry = this.model.getEntryEntity("taskbillentry");
            ArrayList<Long> taskBillLiset = new ArrayList<Long>();
            for (DynamicObject obj : taskBillEntry) {
                DynamicObject taskBill = obj.getDynamicObject("multaskbill");
                if (taskBill == null) continue;
                taskBillLiset.add((Long)taskBill.getPkValue());
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
            if (!taskBillLiset.isEmpty()) {
                QFilter filter = new QFilter("id", "not in", taskBillLiset);
                filters.add(filter);
            }
            filters.add(new QFilter("ssccenter", "=", (Object)sscId));
            showParameter.getListFilterParameter().setQFilters(filters);
        }
    }

    private QFilter getTaskTypeFilter(Long sscId) {
        QFilter sscFilter = new QFilter("orgfield", "=", (Object)sscId);
        QFilter filterType1 = new QFilter("qualityjudge", "=", (Object)"0");
        QFilter filterType2 = new QFilter("qualityjudge", "is null", (Object)"");
        QFilter filterType = sscFilter.and(filterType1.or(filterType2));
        return filterType;
    }

    private Long getSscId() {
        Object ssccenter = this.model.getValue("ssccenter");
        Long sscId = 0L;
        if (ssccenter != null) {
            DynamicObject dySSCCenter = (DynamicObject)ssccenter;
            sscId = dySSCCenter.getLong("id");
        }
        return sscId;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        Object newValue = data[0].getNewValue();
        Object oldValue = data[0].getOldValue();
        int index = data[0].getRowIndex();
        if ("multaskbill".equalsIgnoreCase(name)) {
            this.model.setValue("condition", null, index);
            this.model.setValue("conditionjson", null, index);
            this.model.setValue("creditjson_tag", null, index);
        } else if ("cpname".equalsIgnoreCase(name) && newValue != null) {
            this.model.beginInit();
            DynamicObject checkingPoint = (DynamicObject)newValue;
            String cpnumber = checkingPoint.getString("number");
            this.model.setValue("cpnumber", (Object)cpnumber, index);
            this.model.endInit();
            this.view.updateView();
        } else if ("isautoprocess".equalsIgnoreCase(name)) {
            this.handleDisRule();
        } else if ("taskduration".equalsIgnoreCase(name)) {
            this.taskDurationChanged(newValue, oldValue);
        } else if ("warningtime".equalsIgnoreCase(name)) {
            this.warningTimeChanged(newValue, oldValue);
        } else if ("condition".equals(name) && (newValue == null || StringUtils.isEmpty((String)(newValue + "")))) {
            this.model.setValue("conditionjson", null, index);
            this.model.setValue("creditjson_tag", null, index);
        } else if ("startdate".equals(name) || "enddate".equals(name)) {
            this.restrictDate(name);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() != null) {
            if ("billSelect".equals(e.getActionId())) {
                int rowIndex = Integer.parseInt(this.getPageCache().get("taskbillentry#rowindex"));
                Map ret = (Map)e.getReturnData();
                if (ret.size() == 0) {
                    this.model.setValue("condition", null, rowIndex);
                    this.model.setValue("conditionjson", null, rowIndex);
                    this.model.setValue("creditjson_tag", null, rowIndex);
                    return;
                }
                String filter = (String)ret.get("filter");
                String filterJson = (String)ret.get("filterCondition");
                String creditFilter = (String)ret.get("creditFilter");
                String creditFilterCondition = (String)ret.get("creditFilterCondition");
                StringBuffer sbFilter = new StringBuffer();
                String operateLogic = "";
                if (StringUtils.isNotEmpty((String)filter)) {
                    sbFilter.append('(');
                    sbFilter.append(filter);
                    sbFilter.append(')');
                    operateLogic = ResManager.loadKDString((String)"\u5e76\u4e14", (String)"DisRuleFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    sbFilter.append(operateLogic);
                }
                if (StringUtils.isNotEmpty((String)creditFilter)) {
                    sbFilter.append('(');
                    sbFilter.append(creditFilter);
                    sbFilter.append(')');
                } else {
                    int startIndex = sbFilter.lastIndexOf(operateLogic);
                    if (startIndex > 0) {
                        sbFilter = sbFilter.delete(startIndex, sbFilter.length());
                    }
                }
                this.model.setValue("condition", (Object)sbFilter.toString(), rowIndex);
                this.model.setValue("conditionjson", (Object)filterJson, rowIndex);
                this.model.setValue("creditjson_tag", (Object)creditFilterCondition, rowIndex);
            } else if ("taskSelect".equals(e.getActionId())) {
                Map ret = (Map)e.getReturnData();
                if (ret.size() == 0) {
                    this.model.setValue("taskbillcondiontion", null);
                    this.model.setValue("taskbillcondiontionjson", null);
                    return;
                }
                String filter = (String)ret.get("filter");
                String filterJson = (String)ret.get("filterCondition");
                this.model.setValue("taskbillcondiontion", (Object)filter);
                this.model.setValue("taskbillcondiontionjson", (Object)filterJson);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (evt.getItemKey().equals("newbillrow") && this.model.getEntryEntity("taskbillentry").size() > 99) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5355\u4e2a\u8d28\u68c0\u65b9\u6848\u62bd\u68c0\u4e1a\u52a1\u5355\u636e\u6570\u91cf\u4e0a\u9650\u4e3a100\u3002", (String)"QualityCheckSchemePlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void mulTaskBill() {
        if (this.model.getEntryEntity("taskbillentry").size() > 0) {
            return;
        }
        logger.info("\u591a\u9009\u4e1a\u52a1\u5355\u636e\uff0c\u7f16\u8f91\u8be5\u8d28\u68c0\u65b9\u6848\u65f6\u5148\u4fdd\u5b58\uff0c\u517c\u5bb9\u65e7\u6570\u636e" + this.model.getDataEntity().getPkValue());
        DynamicObject taskBill = (DynamicObject)this.model.getValue("taskbill");
        if (taskBill == null) {
            logger.info("\u8be5\u8d28\u68c0\u65b9\u6848\u5f15\u7528\u7684\u4e1a\u52a1\u5355\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c" + this.model.getDataEntity().getPkValue());
            return;
        }
        String condition = this.model.getValue("taskbillcondiontion") + "";
        String conditionJson = this.model.getValue("taskbillcondiontionjson") + "";
        this.model.batchCreateNewEntryRow("taskbillentry", 1);
        this.model.setValue("multaskbill", taskBill.getPkValue(), 0);
        this.model.setValue("scale", this.model.getValue("percentage"), 0);
        this.model.setValue("samplesize", this.model.getValue("samplenum"), 0);
        if (StringUtils.isNotEmpty((String)condition) && StringUtils.isNotEmpty((String)conditionJson)) {
            Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionJson, Map.class);
            String taskFilterJson = (String)filterConditionMap.get("taskparamfiler");
            String billFilterJson = (String)filterConditionMap.get("billparamfiler");
            if (StringUtils.isEmpty((String)billFilterJson) && StringUtils.isEmpty((String)taskFilterJson)) {
                this.model.setValue("conditionjson", (Object)billFilterJson, 0);
                this.model.setValue("condition", (Object)condition, 0);
                this.model.setValue("taskbillcondiontion", null);
                this.model.setValue("taskbillcondiontionjson", null);
            }
            if (StringUtils.isNotEmpty((String)billFilterJson) && StringUtils.isBlank((String)taskFilterJson)) {
                this.model.setValue("conditionjson", (Object)billFilterJson, 0);
                this.model.setValue("condition", (Object)condition.replaceAll("\\(", "").replaceAll("\\)", ""), 0);
                this.model.setValue("taskbillcondiontionjson", null);
                this.model.setValue("taskbillcondiontion", null);
            }
            if (StringUtils.isEmpty((String)billFilterJson) && StringUtils.isNotEmpty((String)taskFilterJson)) {
                this.model.setValue("conditionjson", null, 0);
                this.model.setValue("condition", null, 0);
                this.model.setValue("taskbillcondiontionjson", (Object)taskFilterJson);
                this.model.setValue("taskbillcondiontion", (Object)condition.replaceAll("\\(", "").replaceAll("\\)", ""));
            }
            if (StringUtils.isNotEmpty((String)billFilterJson) && StringUtils.isNotEmpty((String)taskFilterJson)) {
                this.model.setValue("conditionjson", (Object)billFilterJson, 0);
                this.model.setValue("taskbillcondiontionjson", (Object)taskFilterJson);
                String and = ResManager.loadKDString((String)"\u5e76\u4e14", (String)"QualityCheckSchemePlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                String or = ResManager.loadKDString((String)"\u6216\u8005", (String)"QualityCheckSchemePlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                String splitTextAnd = ")" + and + "(";
                String splitTextOr = ")" + or + "(";
                String splitTextAnd2 = "\\)" + and + "\\(";
                String splitTextOr2 = "\\)" + or + "\\(";
                if (condition.contains(splitTextAnd)) {
                    String billCondition = condition.split(splitTextAnd2)[0];
                    String taskCondition = condition.split(splitTextAnd2)[1];
                    this.model.setValue("condition", (Object)billCondition.replaceAll("\\(", ""), 0);
                    this.model.setValue("taskbillcondiontion", (Object)taskCondition.replaceAll("\\)", ""));
                } else if (condition.contains(splitTextOr)) {
                    String billCondition = condition.split(splitTextOr2)[0];
                    String taskCondition = condition.split(splitTextOr2)[1];
                    this.model.setValue("condition", (Object)billCondition.replaceAll("\\(", ""), 0);
                    this.model.setValue("taskbillcondiontion", (Object)taskCondition.replaceAll("\\)", ""));
                }
            }
        }
        this.getView().updateView("taskbillentry");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.model.getDataEntity()});
    }

    private void handleDisRule() {
        String isautoprocess = (String)this.model.getValue("isautoprocess");
        if ("1".equalsIgnoreCase(isautoprocess)) {
            this.model.setValue("disrule", (Object)"1");
            this.view.setEnable(Boolean.TRUE, new String[]{"disrule"});
        } else if ("0".equalsIgnoreCase(isautoprocess)) {
            this.model.setValue("disrule", (Object)"0");
            this.view.setEnable(Boolean.FALSE, new String[]{"disrule"});
        } else {
            this.model.setValue("disrule", (Object)"0");
            this.view.setEnable(Boolean.TRUE, new String[]{"disrule"});
        }
    }

    private void showBillFilterF7Form(String conditionjson, String creditJson) {
        IPageCache pageCache = this.getView().getPageCache();
        String taskBillNum = pageCache.get("taskBillNum");
        String taskBillName = pageCache.get("taskBillName");
        String appObj = QualityCheckCreditHelper.queryAppObjNum((String)taskBillNum);
        if (StringUtils.isEmpty((String)appObj)) {
            if (StringUtils.isNotEmpty((String)creditJson)) {
                this.showCreditArgsChangeForm(taskBillName);
                return;
            }
        } else {
            boolean isChange = this.checkAppObjChange(appObj, creditJson);
            if (isChange) {
                this.showAppObjChangeForm(appObj, taskBillNum, taskBillName);
                return;
            }
        }
        this.openBillFilterF7Form(conditionjson, creditJson, taskBillNum, appObj);
    }

    private void showCreditArgsChangeForm(String taskBillName) {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_CREDIT_ARGS_CHANGE, (IFormPlugin)this);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u672a\u914d\u7f6e\u53ef\u7528\u7684\u4fe1\u7528\u53c2\u6570\uff0c\u6253\u5f00\u62bd\u68c0\u53c2\u6570\u6761\u4ef6\u9875\u9762\u5c06\u81ea\u52a8\u5220\u9664\u62a5\u8d26\u4fe1\u7528\u6761\u4ef6\uff0c\u8bf7\u95ee\u7ee7\u7eed\u6253\u5f00\u5417?", (String)"QualityCheckSchemePlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskBillName), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private void openBillFilterF7Form(String json, String creditJson, String taskBillNum, String appObj) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_qualitycheckscalef7");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCustomParam("isBill", (Object)true);
        showParameter.setCustomParam("taskBill", (Object)taskBillNum);
        Object ssc = this.getModel().getValue("ssccenter");
        if (ssc != null) {
            showParameter.setCustomParam("ssc", (Object)((DynamicObject)ssc).getLong("id"));
        }
        showParameter.setCustomParam("json", (Object)json);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "billSelect");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam("appObj", (Object)appObj);
        showParameter.setCustomParam("creditJson", (Object)creditJson);
        showParameter.setCaption(ResManager.loadKDString((String)"\u62bd\u68c0\u53c2\u6570\u6761\u4ef6", (String)"QualityCheckSchemePlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.view.showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_APP_OBJ_CHANGE.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                IPageCache pageCache = this.getView().getPageCache();
                String taskBillNum = pageCache.get("taskBillNum");
                String appObj = pageCache.get("appObj");
                int rowIndex = Integer.parseInt(this.getPageCache().get("taskbillentry#rowindex"));
                String json = this.model.getValue("conditionjson", rowIndex) + "";
                this.openBillFilterF7Form(json, "", taskBillNum, appObj);
            }
        } else if (CONFIRM_CREDIT_ARGS_CHANGE.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            IPageCache pageCache = this.getView().getPageCache();
            String taskBillNum = pageCache.get("taskBillNum");
            String appObj = "";
            int rowIndex = Integer.parseInt(this.getPageCache().get("taskbillentry#rowindex"));
            String json = this.model.getValue("conditionjson", rowIndex) + "";
            this.openBillFilterF7Form(json, "", taskBillNum, appObj);
        }
    }

    private void showTaskFilterF7Form(String json) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_qualitycheckscalef7");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCustomParam("isBill", (Object)false);
        Object ssc = this.getModel().getValue("ssccenter");
        if (ssc != null) {
            showParameter.setCustomParam("ssc", (Object)((DynamicObject)ssc).getLong("id"));
        }
        showParameter.setCustomParam("json", (Object)json);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskSelect");
        showParameter.setCloseCallBack(closeCallBack);
        this.view.showForm(showParameter);
    }

    private boolean checkAppObjChange(String appObj, String creditJson) {
        if (StringUtils.isEmpty((String)creditJson)) {
            return Boolean.FALSE;
        }
        CreditFilterCondition condition = (CreditFilterCondition)SerializationUtils.fromJsonString((String)creditJson, CreditFilterCondition.class);
        String conditionAppObj = condition.getAppObj();
        if (appObj.equals(conditionAppObj)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void showAppObjChangeForm(String appObj, String taskBillNum, String taskBillName) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("appObj", appObj);
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_APP_OBJ_CHANGE, (IFormPlugin)this);
        String appObjName = QualityCheckCreditHelper.queryAppObjName((String)taskBillNum, (String)appObj);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u7684\u4fe1\u7528\u53c2\u6570\u7684\u5e94\u7528\u5bf9\u8c61\u662f%2$s\uff0c\u4e0e\u914d\u7f6e\u7684\u62a5\u8d26\u4fe1\u7528\u6761\u4ef6\u4e0d\u540c\uff0c\u6253\u5f00\u62bd\u68c0\u53c2\u6570\u6761\u4ef6\u9875\u9762\u5c06\u81ea\u52a8\u5220\u9664\u62a5\u8d26\u4fe1\u7528\u6761\u4ef6\uff0c\u8bf7\u95ee\u7ee7\u7eed\u6253\u5f00\u5417?", (String)"QualityCheckSchemePlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskBillName, appObjName), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private boolean isValidTaskBill(DynamicObject billType) {
        if (billType == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u60a8\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"QualityCheckSchemePlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObject billTypeFull = BusinessDataServiceHelper.loadSingle((Object)billType.getPkValue(), (String)"task_taskbill");
        DynamicObject bindBill = (DynamicObject)billTypeFull.get("bindbill");
        if (bindBill == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u4e1a\u52a1\u5355\u636e\u7ed1\u5b9a\u7684\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u4e1a\u52a1\u5355\u636e\u7ed1\u5b9a\u7684\u5355\u636e\u662f\u5426\u5b58\u5728\u3002", (String)"QualityCheckSchemePlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("taskBillNum", bindBill.getString("number"));
        pageCache.put("taskBillName", bindBill.getString("name"));
        return Boolean.TRUE;
    }

    private void taskDurationChanged(Object newValue, Object oldValue) {
        if (newValue == null) {
            return;
        }
        Integer newVal = (Integer)newValue;
        Integer warnTime = (Integer)this.model.getValue("warningtime");
        String tipInfo = null;
        if (newVal <= 0) {
            tipInfo = ResManager.loadKDString((String)"\u4efb\u52a1\u671f\u9650\uff08\u5c0f\u65f6\uff09\u5e94\u5927\u4e8e0\u3002", (String)"QualityCheckSchemePlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        } else if (0 < newVal && newVal < warnTime) {
            tipInfo = ResManager.loadKDString((String)"\u4efb\u52a1\u671f\u9650\uff08\u5c0f\u65f6\uff09\u5e94\u5927\u4e8e\u9884\u8b66\u65f6\u95f4\u3002", (String)"QualityCheckSchemePlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty(tipInfo)) {
            this.model.beginInit();
            this.model.setValue("taskduration", oldValue);
            this.model.endInit();
            this.view.showTipNotification(tipInfo);
        }
    }

    private void warningTimeChanged(Object newValue, Object oldValue) {
        if (newValue == null) {
            return;
        }
        Integer newVal = (Integer)newValue;
        Integer taskDuration = (Integer)this.model.getValue("taskduration");
        String tipInfo = null;
        if (taskDuration == null || taskDuration == 0) {
            tipInfo = ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4efb\u52a1\u671f\u9650\uff08\u5c0f\u65f6\uff09\u3002", (String)"QualityCheckSchemePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        } else if (newVal < 0) {
            tipInfo = ResManager.loadKDString((String)"\u9884\u8b66\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QualityCheckSchemePlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        } else if (0 < newVal && newVal > taskDuration) {
            tipInfo = ResManager.loadKDString((String)"\u9884\u8b66\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\u4e0d\u80fd\u5927\u4e8e\u4efb\u52a1\u671f\u9650\u65f6\u957f\u3002", (String)"QualityCheckSchemePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)tipInfo)) {
            this.model.beginInit();
            this.model.setValue("warningtime", oldValue);
            this.model.endInit();
            this.view.showTipNotification(tipInfo);
        }
    }

    private void restrictDate(String changedDateTag) {
        if ("startdate".equals(changedDateTag)) {
            Date minDate = (Date)this.getModel().getValue("startdate");
            if (minDate == null) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(minDate);
            cal.add(1, 1);
            Date maxDate = cal.getTime();
            DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
            endDateEdit.setMinDate(minDate);
            endDateEdit.setMaxDate(maxDate);
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (endDate != null && endDate.after(maxDate)) {
                this.getModel().setValue("enddate", (Object)maxDate);
            }
        } else {
            Date maxDate = (Date)this.getModel().getValue("enddate");
            if (maxDate == null) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(maxDate);
            cal.add(1, -1);
            Date minDate = cal.getTime();
            DateEdit startDateEdit = (DateEdit)this.getView().getControl("startdate");
            startDateEdit.setMinDate(minDate);
            startDateEdit.setMaxDate(maxDate);
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (startDate != null && startDate.before(minDate)) {
                this.getModel().setValue("startdate", (Object)minDate);
            }
        }
    }
}

