/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.quality.QualityTaskHelper;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.face.TaskFacade;
import kd.ssc.task.formplugin.util.BillAttributeControlUtil;
import kd.ssc.task.formplugin.util.TaskApproveUtil;
import kd.ssc.task.formplugin.util.ViewFlowchartUtil;
import kd.ssc.task.helper.TaskQueryServiceHelper;
import kd.ssc.task.image.SscImageServiceHelper;
import kd.ssc.task.image.SscImageServiceUtil;
import kd.ssc.task.userworkload.TaskUserWorkLoadHelper;

public class QualityCheckTaskParentPlugin
extends AbstractFormPlugin
implements ItemClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(QualityCheckTaskParentPlugin.class);
    private static final String selectAttachmentFields = "id,taskid,pointid,entryentity.attachmentid,entryentity.taskformid, entryentity.userid,entryentity.createtime,entryentity.modifytime, entryentity.remark";
    private static final String FIELD_QUALITYMESSAGERECORD = "point,qualitycheck,ischeckok,rebackcount,handlemethod,reviewmethod, entryentity.message,entryentity.datetime,entryentity.messagetype,entryentity.usercheck, entryentity.isnewmessage";
    private static final String selectPauseRecord = "qctaskid,pauseuser,orgtype,pausecreatetime,pausecanceltime,pausereasen";
    private static String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";

    public void initialize() {
        ControlTypes.register(ApprovalRecord.class);
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billID = (String)formShowParameter.getCustomParam("billid");
        if (StringUtils.isBlank((CharSequence)billID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u76f8\u5e94\u5355\u636e\uff0c\u5355\u636e\u4e1a\u52a1\u65e0\u6cd5\u52a0\u8f7d\u3002", (String)"QualityCheckTaskParentPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String metadatatType = (String)formShowParameter.getCustomParam("billnumber");
        String bindform = (String)formShowParameter.getCustomParam("bindform");
        boolean disableBillType = false;
        if (StringUtils.isNotEmpty((CharSequence)bindform)) {
            disableBillType = true;
        } else {
            bindform = metadatatType;
        }
        Long taskid = (Long)formShowParameter.getCustomParam("taskid");
        Long sourcetaskid = (Long)formShowParameter.getCustomParam("sourcetaskid");
        String bizdata = (String)formShowParameter.getCustomParam("bizdata");
        Long billTypeId = (Long)formShowParameter.getCustomParam("billtypeid");
        String opType = (String)formShowParameter.getCustomParam("operationnumber");
        String personid = (String)formShowParameter.getCustomParam("personid");
        String reformperson = (String)formShowParameter.getCustomParam("reformperson");
        String sampraryLibId = (String)formShowParameter.getCustomParam("sampraryLibId");
        String state = (String)formShowParameter.getCustomParam("state");
        String ismanagepage = (String)formShowParameter.getCustomParam("ismanagepage");
        String ismytask = (String)formShowParameter.getCustomParam("ismytask");
        boolean isembed = formShowParameter.getCustomParam("isembed") != null && (Boolean)formShowParameter.getCustomParam("isembed") != false;
        String tagPageFrom = null;
        if (StringUtils.isNotEmpty((CharSequence)ismanagepage)) {
            tagPageFrom = ismanagepage;
        } else if (StringUtils.isNotEmpty((CharSequence)ismytask)) {
            tagPageFrom = ismytask;
        }
        this.getPageCache().put("billID", billID);
        this.getPageCache().put("metadatatType", metadatatType);
        this.getPageCache().put("bindform", metadatatType);
        this.getPageCache().put("opType", opType);
        this.getPageCache().put("taskid", taskid.toString());
        this.getPageCache().put("sourcetaskid", sourcetaskid.toString());
        this.getPageCache().put("billtypeid", billTypeId.toString());
        this.getPageCache().put("personid", personid);
        this.getPageCache().put("reformperson", reformperson);
        this.getPageCache().put("sampraryLibId", sampraryLibId);
        this.getPageCache().put("state", state);
        this.setEmbedViewVisible();
        this.setBillToolbar();
        this.openBillView(billID, bindform, taskid, bizdata, isembed, disableBillType);
        boolean samePerson = this.isSamePerson(personid);
        this.initControlsState(tagPageFrom, state, samePerson);
        this.initReformPerson(taskid, reformperson, state);
        this.initCheckPoints(taskid, sampraryLibId, state);
        this.initAttachments(state);
        this.initApprovalHandleMsg(formShowParameter);
        this.initAuditRecord(sourcetaskid, billTypeId);
        this.autoOpenImage();
    }

    private void setBillToolbar() {
        long taskTypeId;
        String sourceTaskId = this.getPageCache().get("sourcetaskid");
        DynamicObject sourceAuditTaskInfo = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"tasktypeid,billtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceTaskId))});
        if (sourceAuditTaskInfo == null) {
            log.info("\u672a\u627e\u5230\u8be5\u8d28\u68c0\u4efb\u52a1\u5bf9\u5e94\u539f\u5ba1\u5355\u4efb\u52a1\u4fe1\u606f\uff0c\u4e0d\u8bbe\u7f6e\u539f\u5355\u6309\u94ae");
            for (int i = 1; i <= 10; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + i});
            }
            return;
        }
        long billTypeId = sourceAuditTaskInfo.getLong("billtype");
        String billAttributeConfig = BillAttributeControlUtil.getBillAttributeConfig(billTypeId, taskTypeId = sourceAuditTaskInfo.getLong("tasktypeid"));
        if (StringUtils.isEmpty((CharSequence)billAttributeConfig)) {
            for (int i = 1; i <= 10; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + i});
            }
            return;
        }
        this.getPageCache().put("billAttributeConfig", billAttributeConfig);
        Map<String, Map<String, Object>> needShowButtonAps = BillAttributeControlUtil.parseBillShowButtonConfig(billAttributeConfig, true);
        for (int i = needShowButtonAps.size() + 1; i <= 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + i});
        }
        Map<String, Object> btnInfoMap = BillAttributeControlUtil.getBtnInfoMap(this.getPageCache().get("metadatatType"));
        int index = 1;
        for (Map.Entry<String, Map<String, Object>> entry : needShowButtonAps.entrySet()) {
            Map<String, Object> configInfo = entry.getValue();
            String ctrlApNumber = (String)configInfo.get("ctrlapnumber");
            String ctrlApName = "";
            Map infoMap = (Map)btnInfoMap.get(ctrlApNumber);
            if (!CollectionUtils.isEmpty((Map)infoMap)) {
                ctrlApName = (String)infoMap.get("ctrlapname");
            }
            if (StringUtils.isBlank((CharSequence)ctrlApName)) {
                ctrlApName = (String)configInfo.get("ctrlapname");
            }
            String[] ctrlApNames = ctrlApName.split("\\.");
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(ctrlApNames[ctrlApNames.length - 1]);
            map.put("text", localeString);
            this.getView().updateControlMetadata("billbar" + index, map);
            String[] ctrlApNumbers = ctrlApNumber.split("\\.");
            IPageCache pageCache = this.getPageCache();
            pageCache.put("billbar" + index + "_key", entry.getKey());
            pageCache.put("billbar" + index + "_number", configInfo.get("opkey") == null ? "" : configInfo.get("opkey").toString());
            pageCache.put("billbar" + index + "_toolbar", ctrlApNumbers[0]);
            if (++index <= 10) continue;
            return;
        }
    }

    private void autoOpenImage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isMyTask = (String)formShowParameter.getCustomParam("ismytask");
        if (!"mytask".equals(isMyTask)) {
            return;
        }
        long sscId = Long.parseLong((String)formShowParameter.getCustomParam("sscid"));
        boolean autoOpenImageSwitch = TeamLeaderApi.getBooleanParam("qualitytask_autoopenimage", sscId, false);
        if (!autoOpenImageSwitch) {
            return;
        }
        Long billTypeId = (Long)formShowParameter.getCustomParam("billtypeid");
        boolean taskBillOpenImage = false;
        DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"isuseimage", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billTypeId)});
        if (taskBill != null) {
            taskBillOpenImage = taskBill.getBoolean("isuseimage");
        }
        if (taskBillOpenImage) {
            String billType = (String)formShowParameter.getCustomParam("billtype");
            String billId = (String)formShowParameter.getCustomParam("billid");
            try {
                SscImageServiceHelper.autoOpenImage((String)billId, (IFormView)this.getView(), (String)billType);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("close".equalsIgnoreCase(key)) {
            return;
        }
        String isload = this.getPageCache().get("SSC_FORM_ISLOAD");
        if (StringUtils.isBlank((CharSequence)isload) || "true".equals(isload)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u672a\u5b8c\u5168\u52a0\u8f7d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"QualityCheckTaskParentPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String billId = this.getPageCache().get("billID");
        String entityNumber = this.getPageCache().get("metadatatType");
        if ("viewflowchart".equalsIgnoreCase(key)) {
            if (this.isEmbedBill()) {
                this.openEmbBillFlowChart();
            } else {
                this.openNoEmbBillFlowChart();
            }
        } else if ("bar_image".equalsIgnoreCase(key)) {
            this.viewphoto();
        } else if ("uplook".equalsIgnoreCase(key)) {
            if (this.isEmbedBill()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5d4c\u5165\u5f0f\u5355\u636e\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd\u3002", (String)"QualityCheckTaskParentPlugin_33", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.executeOperate(entityNumber, "trackup");
        } else if ("downlook".equalsIgnoreCase(key)) {
            if (this.isEmbedBill()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5d4c\u5165\u5f0f\u5355\u636e\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd\u3002", (String)"QualityCheckTaskParentPlugin_33", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.executeOperate(entityNumber, "trackdown");
        } else if ("viewvoucher".equalsIgnoreCase(key)) {
            if (this.isEmbedBill()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5d4c\u5165\u5f0f\u5355\u636e\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd\u3002", (String)"QualityCheckTaskParentPlugin_33", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.executeOperate(entityNumber, "tracevoucher");
        } else if (key.contains("billbar")) {
            this.doBillOperator(key);
        }
    }

    private void doBillOperator(String key) {
        try {
            String billKey = this.getPageCache().get(key + "_key");
            String billOpetator = this.getPageCache().get(key + "_number");
            String billToolbar = this.getPageCache().get(key + "_toolbar");
            String subViewPageID = this.getPageCache().get("sompageid");
            FormView view = (FormView)this.getView();
            String subAppID = view.getServiceAppId(subViewPageID);
            String requestParams = String.format("[{\"key\":\"%s\",\"methodName\":\"itemClick\",\"args\":[\"%s\",\"%s\"],\"postData\":[{},[]]}]", billToolbar, billKey, billOpetator);
            log.info("requestParams:" + requestParams);
            Object resultObject = DispatchServiceHelper.invokeBOSService((String)subAppID, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{subViewPageID, requestParams});
            if (resultObject == null) {
                log.error("kd.ssc.task.formplugin.QualityCheckTaskParentPlugin#doBillOpetator: result is blank, key=" + key);
                return;
            }
            String result = resultObject.toString();
            log.info("result:" + result);
            List list = (List)SerializationUtils.fromJsonString((String)result, List.class);
            HashMap<String, Object> arg = new HashMap<String, Object>(2);
            arg.put("pageId", subViewPageID);
            arg.put("actions", list);
            view.getClientProxy().addAction("sendDynamicFormAction", arg);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskApproveFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void openEmbBillFlowChart() {
        String url = this.getEmbWFCharUrl();
        if (kd.bos.util.StringUtils.isEmpty((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5d4c\u5165\u5355\u636e\u7684\u6d41\u7a0b\u56feurl\u4e3a\u7a7a\u3002", (String)"QualityCheckTaskParentPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().openUrl(url);
    }

    private String getEmbWFCharUrl() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        String pooltype = (String)this.getView().getFormShowParameter().getCustomParam("pooltype");
        if (pooltype == null) {
            pooltype = (String)this.getView().getFormShowParameter().getCustomParam("pooltype-mytask");
        }
        boolean isHis = false;
        if (TaskPoolTypeEnum.COMPLETE.getValue().equalsIgnoreCase(pooltype)) {
            isHis = true;
        }
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)this.getErpNumberAndCacheBindNum());
        log.info("kd.ssc.task.formplugin.QualityCheckTaskParentPlugin.getEmbWFCharUrl taskID:" + taskId + ";isHis:" + isHis);
        String url = taskFacade.getEmbedWFUrl(taskId, isHis);
        log.info("kd.ssc.task.formplugin.QualityCheckTaskParentPlugin.getEmbWFCharUrl end");
        return url;
    }

    private void openNoEmbBillFlowChart() {
        IFormView subView = this.getView().getViewNoPlugin(this.getPageCache().get("sompageid"));
        DynamicObject billData = subView.getModel().getDataEntity(true);
        if (this.getErpNumber(null).equalsIgnoreCase("EAS")) {
            ViewFlowchartUtil.viewFlowchart(log, subView, this.getPageCache().get("billID"), this.getView());
        } else {
            WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)billData.get("id"));
        }
    }

    private void initControlsState(String pageTag, String state, boolean samePerson) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("ismanagepage".equalsIgnoreCase(pageTag) || !samePerson) {
            view.setVisible(Boolean.FALSE, new String[]{"save", "checksubmit", "bar_pending", "subandnext", "bar_nexttask"});
            model.setValue("qcpend", (Object)1);
        } else if ("mytask".equalsIgnoreCase(pageTag)) {
            List<String> pauseState = Arrays.asList(TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue());
            if (pauseState.contains(state)) {
                view.setVisible(Boolean.FALSE, new String[]{"save", "checksubmit", "subandnext", "nexttask"});
                model.setValue("qcpend", (Object)1);
            } else {
                model.setValue("qcpend", (Object)0);
            }
            if (StringUtils.equals((CharSequence)TaskStateEnum.QUA_CHECK_COMPLETED.getValue(), (CharSequence)state)) {
                view.setVisible(Boolean.FALSE, new String[]{"save", "checksubmit", "bar_pending"});
            }
        }
        String billTypeId = view.getPageCache().get("billtypeid");
        boolean displayImage = SscImageServiceUtil.imageDisplayCtrlById((Long)Long.valueOf(billTypeId));
        if (!displayImage) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_image"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"opinion", "innermsg", "selectbreakrule", "selectsubscorerule"});
    }

    protected String getErpNumber(Long billtypeid) {
        if (billtypeid == null) {
            String billTypeIdStr = this.getPageCache().get("billtypeid");
            billtypeid = billTypeIdStr == null ? null : Long.valueOf(billTypeIdStr);
        }
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        String erpNumber = (String)billType.get("externalerp.number");
        return erpNumber.toLowerCase();
    }

    private void initReformPerson(Long taskid, String reformperson, String state) {
        String entityName = "task_task";
        if (TaskStateEnum.QUA_CHECK_COMPLETED.getValue().equals(state)) {
            this.getModel().setValue("reformperson", (Object)reformperson);
            return;
        }
        QFilter filterTaskId = new QFilter("id", "=", (Object)taskid);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,personid,reformperson,autoprocess,autoprocessforcheck,sourcetaskid,qualitysamplelibrary.id", (QFilter[])new QFilter[]{filterTaskId});
        if (task != null) {
            boolean autoprocess = task.getBoolean("autoprocess");
            String oriReformperson = task.getString("reformperson.id");
            Long libId = task.getLong("qualitysamplelibrary.id");
            DynamicObject qcScheme = QualityCheckSchemeUtil.getQualityCheckScheme(libId);
            String disrule = qcScheme.getString("disrule");
            if (autoprocess && "1".equals(disrule) && (StringUtils.isBlank((CharSequence)oriReformperson) || "0".equals(oriReformperson))) {
                reformperson = task.getString("personid.id");
            } else if (autoprocess && "0".equals(disrule) && (StringUtils.isBlank((CharSequence)oriReformperson) || "0".equals(oriReformperson))) {
                String selectFields = "id,tasktypeid,billtype,state,orgid,sscid";
                Long sourcetaskid = task.getLong("sourcetaskid");
                ArrayList<String> tTypeBTypeList = new ArrayList<String>();
                ArrayList<String> orgIDList = new ArrayList<String>();
                ArrayList<String> sscList = new ArrayList<String>();
                ORM orm = ORM.create();
                QFilter filterHistoryTaskId = new QFilter("id", "=", (Object)sourcetaskid);
                DynamicObject taskHistory = orm.queryOne("task_taskhistory", selectFields, new QFilter[]{filterHistoryTaskId});
                String tTypeBType = taskHistory.getString("tasktypeid") + "," + taskHistory.getString("billtype");
                tTypeBTypeList.add(tTypeBType);
                orgIDList.add(taskHistory.getString("orgid"));
                sscList.add(taskHistory.getString("sscid"));
                WorkerStatusPojo workerStatusPojo = TaskUserWorkLoadHelper.queryReformerMinWorkload(orgIDList, sscList, Collections.singletonList(taskid), tTypeBTypeList, true, true);
                reformperson = null;
                if (workerStatusPojo != null) {
                    reformperson = workerStatusPojo.getUserId().toString();
                }
            }
        }
        this.getModel().setValue("reformperson", (Object)reformperson);
    }

    private void initCheckPoints(Long taskid, String sampleLibId, String state) {
        TaskStateEnum taskState = TaskStateEnum.getTaskState((String)state);
        if (taskState == null) {
            return;
        }
        switch (taskState) {
            case TO_BE_DIS: 
            case TO_BE_MANUAL_DIS: 
            case DIS_EXCEPTION: 
            case PAUSE_CHECKING: 
            case CHECKING: {
                this.getCheckPoints(taskid, sampleLibId);
                break;
            }
            case PAUSE_RECTIFYING: 
            case RECTIFYING: {
                this.initRectifyCheckPoints(taskid, sampleLibId);
                break;
            }
            case PAUSE_REVIEW: 
            case REVIEW: 
            case QUA_CHECK_COMPLETED: {
                this.initRecviewCheckPoints(taskid, sampleLibId);
                break;
            }
        }
    }

    private void initAttachments(String state) {
        IDataModel model = this.getModel();
        String taskId = this.getPageCache().get("taskid");
        long taskIdInt = Long.parseLong(taskId);
        Object[] attachmentIds = this.getAttachmentId(taskIdInt, null, Collections.singletonList(0L));
        model.setValue("qcattachment", (Object)attachmentIds);
        List<String> rectifyStateList = Arrays.asList(TaskStateEnum.RECTIFYING.getValue(), TaskStateEnum.REVIEW.getValue(), TaskStateEnum.QUA_CHECK_COMPLETED.getValue());
        if (rectifyStateList.contains(state)) {
            Object[] rectifyattachmentIds = this.getAttachmentId(taskIdInt, null, Collections.singletonList(1L));
            model.setValue("rectifyattachment", (Object)rectifyattachmentIds);
        }
    }

    public void fireSaveAttachments(String attachmentKey, long taskId, long pointId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection attachemnts = (DynamicObjectCollection)model.getValue(attachmentKey);
        String formID = this.getView().getEntityId();
        if (attachemnts.size() > 0) {
            this.saveAttachmentsExt(attachemnts, taskId, formID, pointId);
        }
    }

    public boolean isQualityTaskSuccess(Long taskid, String sampleLibId) {
        long pointId;
        if (StringUtils.isBlank((CharSequence)sampleLibId)) {
            return false;
        }
        Long libId = Long.valueOf(sampleLibId);
        DynamicObject checkscheme = QualityCheckSchemeUtil.getQualityCheckScheme(libId);
        DynamicObjectCollection points = checkscheme.getDynamicObjectCollection("cpentry");
        if (points == null || points.size() == 0) {
            return false;
        }
        HashSet<Long> pointIds = new HashSet<Long>();
        for (DynamicObject item : points) {
            pointId = (Long)item.get("cpname.id");
            pointIds.add(pointId);
        }
        Map<Long, DynamicObject> dyMessageRecordCol = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, Collections.singletonList("0"));
        for (DynamicObject item : points) {
            pointId = (Long)item.get("cpname.id");
            boolean isSuccessPoint = QualityCheckSchemeUtil.isCheckSuccessPoints(dyMessageRecordCol.get(pointId));
            if (isSuccessPoint) continue;
            return false;
        }
        return true;
    }

    private void initRecviewCheckPoints(Long taskid, String sampleLibId) {
        long pointId;
        if (StringUtils.isBlank((CharSequence)sampleLibId)) {
            return;
        }
        Long libId = Long.valueOf(sampleLibId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IFormView view = this.getView();
        DynamicObject checkscheme = QualityCheckSchemeUtil.getQualityCheckScheme(libId);
        DynamicObjectCollection points = checkscheme.getDynamicObjectCollection("cpentry");
        if (points == null || points.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> successPoints = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> rectifyPassPoints = new ArrayList<DynamicObject>();
        ArrayList<Object> rectifyRebackPoints = new ArrayList<Object>();
        HashSet<Long> pointIds = new HashSet<Long>();
        for (Object item : points) {
            pointId = (Long)item.get("cpname.id");
            pointIds.add(pointId);
        }
        Map<Long, DynamicObject> dyRecordMessageCol = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, Collections.singletonList("0"));
        for (Object item : points) {
            pointId = (Long)item.get("cpname.id");
            boolean bl = QualityCheckSchemeUtil.isCheckSuccessPoints(dyRecordMessageCol.get(pointId));
            if (bl) {
                successPoints.add((DynamicObject)item);
                continue;
            }
            if (QualityCheckSchemeUtil.isRectifyPassPoints(dyRecordMessageCol.get(pointId))) {
                rectifyPassPoints.add((DynamicObject)item);
                continue;
            }
            rectifyRebackPoints.add(item);
        }
        if (rectifyRebackPoints.size() > 0) {
            view.setVisible(Boolean.TRUE, new String[]{"qcfailtab"});
            HashSet<Long> rectfiPointIds = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : rectifyRebackPoints) {
                rectfiPointIds.add(dynamicObject.getLong("cpname.id"));
            }
            Map<Long, DynamicObject> dyMessageRecordCol = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(rectfiPointIds, taskid, Collections.singletonList("0"), new QFilter("rebackcount", "=", (Object)0));
            Map<Long, DynamicObject> map = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(rectfiPointIds, taskid, Collections.singletonList("1"), new QFilter("rebackcount", "=", (Object)1));
            Map<Long, DynamicObject> ckPointMap = QualityCheckSchemeUtil.getCheckPointMap(pointIds);
            String ckName = null;
            String ckDescription = null;
            long checkPoint = 0L;
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (int i = 0; i < rectifyRebackPoints.size(); ++i) {
                DynamicObject checkRecordInfo;
                checkPoint = (Long)((DynamicObject)rectifyRebackPoints.get(i)).get("cpname.id");
                vs.set("pointid", (Object)checkPoint, i);
                DynamicObject dyCheckPoint = ckPointMap.get(checkPoint);
                ckName = dyCheckPoint.getString("name");
                ckDescription = dyCheckPoint.getString("description");
                vs.set("description", (Object)String.format("- %s", ckDescription), i);
                vs.set("name", (Object)String.format("%d. %s", i + 1, ckName), i);
                DynamicObject checkRecordRectify = map.get(checkPoint);
                if (checkRecordRectify != null) {
                    String checkinfo;
                    String handlemethod = checkRecordRectify.getString("handlemethod");
                    vs.set("handlemethod", (Object)handlemethod, i);
                    if ("2".equals(handlemethod)) {
                        vs.set("handlemethodname", (Object)ResManager.loadKDString((String)"\u3010\u7533\u8bc9\u3011", (String)"QualityCheckTaskParentPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]), i);
                        checkinfo = ResManager.loadKDString((String)"\u7533\u8bc9\u901a\u8fc7", (String)"QualityCheckTaskReviewPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                        vs.set("checkinfo", (Object)checkinfo, i);
                    } else {
                        vs.set("handlemethodname", (Object)ResManager.loadKDString((String)"\u3010\u6574\u6539\u5b8c\u6210\u3011", (String)"QualityCheckTaskParentPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]), i);
                        checkinfo = ResManager.loadKDString((String)"\u6574\u6539\u901a\u8fc7", (String)"QualityCheckTaskReviewPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                        vs.set("checkinfo", (Object)checkinfo, i);
                    }
                    DynamicObjectCollection entities = checkRecordRectify.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy : entities) {
                        String declare = dy.getString("message");
                        vs.set("checkdeclare", (Object)declare, i);
                    }
                }
                if ((checkRecordInfo = dyMessageRecordCol.get(checkPoint)) != null) {
                    String reviewmethod = checkRecordInfo.getString("reviewmethod");
                    if ("3".equals(reviewmethod)) {
                        vs.set("checkreback", (Object)Boolean.TRUE, i);
                    } else {
                        vs.set("checkpass", (Object)Boolean.TRUE, i);
                    }
                    DynamicObjectCollection entities = checkRecordInfo.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy : entities) {
                        String declare = dy.getString("message");
                        vs.set("checkinfo", (Object)declare, i);
                    }
                    continue;
                }
                vs.set("checkpass", (Object)Boolean.TRUE, i);
            }
            model.batchCreateNewEntryRow("entryentityfail", vs);
            model.endInit();
            view.updateView("entryentityfail");
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"qcfailtab"});
        }
        this.initTabCheckPoints(model, view, taskid, rectifyPassPoints, "qcreformpasstab", "entryentityreform", 2);
        this.initTabCheckPoints(model, view, taskid, successPoints, "qcsuccesstab", "entryentitysuccess", 1);
    }

    private void initRectifyCheckPoints(Long taskid, String sampleLibId) {
        long pointId;
        if (StringUtils.isBlank((CharSequence)sampleLibId)) {
            return;
        }
        Long libId = Long.valueOf(sampleLibId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IFormView view = this.getView();
        DynamicObject checkscheme = QualityCheckSchemeUtil.getQualityCheckScheme(libId);
        DynamicObjectCollection points = checkscheme.getDynamicObjectCollection("cpentry");
        if (points == null || points.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> successPoints = new ArrayList<DynamicObject>();
        ArrayList<Object> failPoints = new ArrayList<Object>();
        ArrayList<DynamicObject> reformPassPoints = new ArrayList<DynamicObject>();
        HashSet<Long> pointIds = new HashSet<Long>();
        for (Object item : points) {
            pointId = (Long)item.get("cpname.id");
            pointIds.add(pointId);
        }
        Map<Long, DynamicObject> dyRecordMessageCol = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, Collections.singletonList("0"));
        for (Object item : points) {
            pointId = (Long)item.get("cpname.id");
            boolean bl = QualityCheckSchemeUtil.isCheckSuccessPoints(dyRecordMessageCol.get(pointId));
            if (bl) {
                successPoints.add((DynamicObject)item);
                continue;
            }
            if (QualityCheckSchemeUtil.isRectifyPassPoints(dyRecordMessageCol.get(pointId))) {
                reformPassPoints.add((DynamicObject)item);
                continue;
            }
            failPoints.add(item);
        }
        if (failPoints.size() > 0) {
            view.setVisible(Boolean.TRUE, new String[]{"qcfailtab"});
            HashSet<Long> failPointIds = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : failPoints) {
                failPointIds.add(dynamicObject.getLong("cpname.id"));
            }
            Map<Long, DynamicObject> dyoldMessageRecordCol = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(failPointIds, taskid, Collections.singletonList("0"));
            Map<Long, DynamicObject> map = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(failPointIds, taskid, Collections.singletonList("1"));
            Map<Long, DynamicObject> ckPointMap = QualityCheckSchemeUtil.getCheckPointMap(pointIds);
            String ckName = null;
            String ckDescription = null;
            long checkPoint = 0L;
            model.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            for (int i = 0; i < failPoints.size(); ++i) {
                DynamicObject checkRecordRectify;
                checkPoint = (Long)((DynamicObject)failPoints.get(i)).get("cpname.id");
                tvs.set("pointid", (Object)checkPoint, i);
                DynamicObject dyCheckPoint = ckPointMap.get(checkPoint);
                ckName = dyCheckPoint.getString("name");
                ckDescription = dyCheckPoint.getString("description");
                tvs.set("description", (Object)String.format("- %s", ckDescription), i);
                tvs.set("name", (Object)String.format("%d. %s", i + 1, ckName), i);
                DynamicObject checkRecordInfo = dyoldMessageRecordCol.get(checkPoint);
                if (checkRecordInfo != null) {
                    DynamicObjectCollection entities = checkRecordInfo.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy : entities) {
                        String declare = dy.getString("message");
                        tvs.set("checkdeclare", (Object)declare, i);
                    }
                }
                if ((checkRecordRectify = map.get(checkPoint)) != null) {
                    String handlemethod = checkRecordRectify.getString("handlemethod");
                    if ("2".equals(handlemethod)) {
                        tvs.set("checkappeal", (Object)Boolean.TRUE, i);
                    } else {
                        tvs.set("checkdone", (Object)Boolean.TRUE, i);
                    }
                    DynamicObjectCollection entities = checkRecordRectify.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy : entities) {
                        String declare = dy.getString("message");
                        tvs.set("checkinfo", (Object)declare, i);
                    }
                    continue;
                }
                tvs.set("checkdone", (Object)Boolean.TRUE, i);
            }
            model.batchCreateNewEntryRow("entryentityfail", tvs);
            model.endInit();
            this.getView().updateView("entryentityfail");
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"qcfailtab"});
        }
        this.initTabCheckPoints(model, view, taskid, reformPassPoints, "qcreformpasstab", "entryentityreform", 2);
        this.initTabCheckPoints(model, view, taskid, successPoints, "qcsuccesstab", "entryentitysuccess", 1);
    }

    private void initTabCheckPoints(AbstractFormDataModel model, IFormView view, Long taskid, List<DynamicObject> pointsList, String tabPage, String entityEntityTag, int index) {
        if (pointsList.size() > 0) {
            view.setVisible(Boolean.TRUE, new String[]{tabPage});
            HashSet<Long> pointIds = new HashSet<Long>(10);
            for (DynamicObject item : pointsList) {
                pointIds.add(item.getLong("cpname.id"));
            }
            Map<Long, DynamicObject> submitMessageRecordDoMap = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, Collections.singletonList("0"), new QFilter("rebackcount", "=", (Object)1));
            Map<Long, DynamicObject> saveMessageRecordDoMap = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, Collections.singletonList("0"), new QFilter("rebackcount", "=", (Object)0));
            Map<Long, DynamicObject> ckPointMap = QualityCheckSchemeUtil.getCheckPointMap(pointIds);
            String ckName = null;
            String ckDescription = null;
            long checkPoint = 0L;
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (int i = 0; i < pointsList.size(); ++i) {
                DynamicObject saveMessageRecordDo;
                checkPoint = (Long)pointsList.get(i).get("cpname.id");
                vs.set(String.format("pointid%d", index), (Object)checkPoint, i);
                DynamicObject dycheckPoint = ckPointMap.get(checkPoint);
                ckName = dycheckPoint.getString("name");
                ckDescription = dycheckPoint.getString("description");
                vs.set(String.format("description%d", index), (Object)String.format("- %s", ckDescription), i);
                vs.set(String.format("name%d", index), (Object)String.format("%d. %s", i + 1, ckName), i);
                DynamicObject submitMessageRecordDo = submitMessageRecordDoMap.get(checkPoint);
                if (submitMessageRecordDo != null) {
                    DynamicObjectCollection entities = submitMessageRecordDo.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy : entities) {
                        String declare = dy.getString("message");
                        vs.set(String.format("checkinfo%d", index), (Object)declare, i);
                    }
                }
                if ((saveMessageRecordDo = saveMessageRecordDoMap.get(checkPoint)) == null) continue;
                DynamicObjectCollection entities = saveMessageRecordDo.getDynamicObjectCollection("entryentity");
                if (!"entryentitysuccess".equals(entityEntityTag) || saveMessageRecordDo.getLong("rebackcount") != 0L) continue;
                boolean isCheckOk = saveMessageRecordDo.getBoolean("ischeckok");
                for (DynamicObject dy : entities) {
                    String declare = dy.getString("message");
                    vs.set("checknopass", (Object)(!isCheckOk ? 1 : 0), i);
                    vs.set("checkinfo3", (Object)declare, i);
                }
            }
            model.batchCreateNewEntryRow(entityEntityTag, vs);
            model.endInit();
            view.updateView(entityEntityTag);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{tabPage});
        }
    }

    public void getCheckPoints(Long taskid, String sampleLibId) {
        if (StringUtils.isBlank((CharSequence)sampleLibId)) {
            return;
        }
        Long libId = Long.valueOf(sampleLibId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject checkscheme = QualityCheckSchemeUtil.getQualityCheckScheme(libId);
        DynamicObjectCollection col = checkscheme.getDynamicObjectCollection("cpentry");
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        HashSet<Long> pointIds = new HashSet<Long>();
        for (DynamicObject item : col) {
            pointIds.add(item.getLong("cpname.id"));
        }
        Map<Long, DynamicObject> dyMessageCol = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, Collections.singletonList("0"));
        Map<Long, DynamicObject> ckPointMap = QualityCheckSchemeUtil.getCheckPointMap(pointIds);
        HashSet<Long> noPassPoint = new HashSet<Long>();
        long checkPoint = 0L;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < col.size(); ++i) {
            checkPoint = (Long)((DynamicObject)col.get(i)).get("cpname.id");
            vs.set("point", (Object)checkPoint, i);
            vs.set("pointid", (Object)checkPoint, i);
            Boolean ckDefcorrect = ckPointMap.get(checkPoint).getBoolean("defcorrect");
            if (ckDefcorrect.booleanValue()) {
                vs.set("checksuccess", (Object)Boolean.TRUE, i);
                vs.set("checkinfo", (Object)ResManager.loadKDString((String)"\u8d28\u68c0\u5408\u683c", (String)"QualityCheckTaskParentPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]), i);
                noPassPoint.remove(checkPoint);
            } else {
                noPassPoint.add(checkPoint);
            }
            DynamicObject checkRecordInfo = dyMessageCol.get(checkPoint);
            if (checkRecordInfo == null) continue;
            if (checkRecordInfo.getBoolean("ischeckok")) {
                vs.set("checksuccess", (Object)Boolean.TRUE, i);
                noPassPoint.remove(checkPoint);
            } else {
                vs.set("checksuccess", (Object)Boolean.FALSE, i);
                noPassPoint.add(checkPoint);
            }
            DynamicObjectCollection entities = checkRecordInfo.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entities)) continue;
            vs.set("checkinfo", (Object)((DynamicObject)entities.get(0)).getString("message"), i);
        }
        model.batchCreateNewEntryRow("entryentitycheck", vs);
        model.endInit();
        this.getView().updateView("entryentitycheck");
        if (noPassPoint.size() > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nopasslabel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"allpasslabel"});
            model.setValue("allpass", (Object)Boolean.FALSE);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nopasslabel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"allpasslabel"});
            model.setValue("allpass", (Object)Boolean.TRUE);
        }
        this.getPageCache().put("nopassnum", noPassPoint.size() + "");
    }

    public DynamicObject[] getCheckPointCols(long pointid, long taskid, List messageTypes) {
        QFilter filterPoint = new QFilter("point", "=", (Object)pointid);
        QFilter filterCheck = new QFilter("qualitycheck", "=", (Object)taskid);
        QFilter filterSubmit = new QFilter("rebackcount", "=", (Object)1);
        QFilter filterMessageType = new QFilter("entryentity.messagetype", "in", (Object)messageTypes);
        DynamicObject[] checkRecords = BusinessDataServiceHelper.load((String)"task_qualitymessagerecord", (String)FIELD_QUALITYMESSAGERECORD, (QFilter[])new QFilter[]{filterPoint, filterCheck, filterMessageType, filterSubmit}, (String)"entryentity.datetime asc");
        return checkRecords;
    }

    public void initCheckRecord(long pointid, long taskid, List messageTypes) {
        DynamicObject[] checks = this.getCheckPointCols(pointid, taskid, messageTypes);
        if (checks == null || checks.length == 0) {
            return;
        }
        ArrayList approvalRecordItems = new ArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < checks.length; ++i) {
            DynamicObject record = checks[i];
            String handlemethod = record.getString("handlemethod");
            String reviewmethod = record.getString("reviewmethod");
            DynamicObjectCollection cols = record.getDynamicObjectCollection("entryentity");
            if (cols == null || cols.size() == 0) {
                return;
            }
            for (DynamicObject row : cols) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("group", "approved");
                item.put("groupDecisionType", "approve");
                ArrayList childrenItems = new ArrayList();
                HashMap<String, Object> childrenItem = new HashMap<String, Object>();
                childrenItem.put("openId", row.get("usercheck.useropenid"));
                Long checkId = row.getLong("usercheck.id");
                if (checkId != null) {
                    Map userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(Long.parseLong(checkId.toString())), (boolean)true);
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)userAvatarPath.get(checkId)))) {
                        childrenItem.put("avatar", userAvatarPath.get(checkId));
                    } else {
                        childrenItem.put("avatar", COMMON_URL);
                    }
                }
                childrenItem.put("userName", row.get("usercheck.name"));
                String messageType = row.getString("messagetype");
                String operation = this.getOperation(messageType, handlemethod, reviewmethod);
                String decisionType = this.getDecisionType(messageType, reviewmethod);
                Date currentTime = row.getDate("datetime");
                String timeStr = null;
                if (null != currentTime) {
                    timeStr = dateFormat.format(currentTime);
                }
                childrenItem.put("decisionType", decisionType);
                childrenItem.put("resultName", operation);
                childrenItem.put("time", timeStr);
                childrenItem.put("message", row.get("message"));
                childrenItems.add(childrenItem);
                item.put("children", childrenItems);
                approvalRecordItems.add(item);
            }
        }
        if (!approvalRecordItems.isEmpty()) {
            ApprovalRecord approvalRecord = (ApprovalRecord)this.getControl("approvalrecordap");
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put("hideMoreChat", true);
            parameters.put("isPC", "true");
            approvalRecord.setParameters(parameters);
            approvalRecord.setData(approvalRecordItems);
        }
    }

    private String getOperation(String messageType, String handlemethod, String reviewmethod) {
        StringBuilder sbOperation = new StringBuilder();
        if ("1".equals(messageType)) {
            sbOperation.append(String.format(ResManager.loadKDString((String)"%s\u6574\u6539", (String)"QualityCheckTaskParentPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\uff1a"));
            if ("2".equals(handlemethod)) {
                sbOperation.append(ResManager.loadKDString((String)"\u3010\u7533\u8bc9\u3011", (String)"QualityCheckTaskParentPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                sbOperation.append(ResManager.loadKDString((String)"\u3010\u6574\u6539\u5b8c\u6210\u3011", (String)"QualityCheckTaskParentPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("1".equals(reviewmethod)) {
            sbOperation.append(String.format(ResManager.loadKDString((String)"%s\u590d\u6838\u3010\u6574\u6539\u901a\u8fc7\u3011", (String)"QualityCheckTaskParentPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\uff1a"));
        } else if ("2".equals(reviewmethod)) {
            sbOperation.append(String.format(ResManager.loadKDString((String)"%s\u590d\u6838\u3010\u7533\u8bc9\u901a\u8fc7\u3011", (String)"QualityCheckTaskParentPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\uff1a"));
        } else if ("3".equals(reviewmethod)) {
            sbOperation.append(String.format(ResManager.loadKDString((String)"%s\u590d\u6838\u3010\u9000\u56de\u6574\u6539\u3011", (String)"QualityCheckTaskParentPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\uff1a"));
        } else if ("4".equals(reviewmethod)) {
            sbOperation.append(String.format(ResManager.loadKDString((String)"%s\u590d\u6838\u3010\u8d28\u68c0\u4e0d\u5408\u683c\u3011", (String)"QualityCheckTaskParentPlugin_32", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\uff1a"));
        } else {
            sbOperation.append(String.format(ResManager.loadKDString((String)"%s\u8d28\u68c0", (String)"QualityCheckTaskParentPlugin_23", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\uff1a"));
        }
        return sbOperation.toString();
    }

    private String getDecisionType(String messageType, String reviewmethod) {
        String decisionType = "approve";
        if ("0".equals(messageType) && "3".equals(reviewmethod)) {
            decisionType = "reject";
        }
        return decisionType;
    }

    public boolean saveMessage(DynamicObjectCollection checks, boolean isSubmit, long taskid, String messagetype, String state) {
        return this.saveMessage(checks, isSubmit, taskid, messagetype, state, null);
    }

    public boolean saveMessage(DynamicObjectCollection checks, boolean isSubmit, long taskid, String messagetype, String state, String otherParam) {
        QFilter filterIsOldNewMessage;
        DynamicObject[] dyOldMessageRecordCol;
        if (checks == null || checks.size() == 0) {
            return false;
        }
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        ArrayList<DynamicObject> newCheckRecords = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> existedCheckRecords = new ArrayList<DynamicObject>();
        Integer rebackcount = isSubmit ? 1 : 0;
        HashSet<Long> pointIds = new HashSet<Long>();
        for (DynamicObject dy : checks) {
            if (StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam)) {
                pointIds.add(dy.getLong("pointid1"));
                continue;
            }
            pointIds.add(dy.getLong("pointid"));
        }
        QFilter filterPoint = new QFilter("point", "in", pointIds);
        QFilter filterCheck = new QFilter("qualitycheck", "=", (Object)taskid);
        QFilter filterMessageType = new QFilter("entryentity.messagetype", "in", Collections.singletonList(messagetype));
        QFilter filterIsNewMessage = new QFilter("entryentity.isnewmessage", "=", (Object)1);
        if (StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam)) {
            QFilter filterReviewMethod = new QFilter("reviewmethod", "=", (Object)"4");
            filterPoint.and(filterReviewMethod);
        }
        HashMap<Long, DynamicObject> messageRecordMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> oldMessageRecordMap = new HashMap<Long, DynamicObject>();
        DynamicObject[] dyMessageRecordCol = BusinessDataServiceHelper.load((String)"task_qualitymessagerecord", (String)FIELD_QUALITYMESSAGERECORD, (QFilter[])new QFilter[]{filterPoint, filterCheck, filterMessageType, filterIsNewMessage});
        if (dyMessageRecordCol != null && dyMessageRecordCol.length > 0) {
            for (DynamicObject item : dyMessageRecordCol) {
                messageRecordMap.put(item.getLong("point"), item);
            }
        }
        if (TaskStateEnum.REVIEW.getValue().equals(state) && (dyOldMessageRecordCol = BusinessDataServiceHelper.load((String)"task_qualitymessagerecord", (String)FIELD_QUALITYMESSAGERECORD, (QFilter[])new QFilter[]{filterPoint, filterCheck, filterMessageType, filterIsOldNewMessage = new QFilter("entryentity.isnewmessage", "=", (Object)0)})) != null && dyOldMessageRecordCol.length > 0) {
            for (DynamicObject item : dyOldMessageRecordCol) {
                oldMessageRecordMap.put(item.getLong("point"), item);
            }
        }
        String message = "";
        for (DynamicObject dy : checks) {
            boolean isNew;
            long pointid = StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam) ? dy.getLong("pointid1") : dy.getLong("pointid");
            if (pointid == 0L) continue;
            DynamicObject checkRecord = (DynamicObject)messageRecordMap.get(pointid);
            if (checkRecord == null) {
                checkRecord = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitymessagerecord");
                checkRecord.set("point", (Object)pointid);
                checkRecord.set("qualitycheck", (Object)taskid);
                newCheckRecords.add(checkRecord);
            } else {
                existedCheckRecords.add(checkRecord);
            }
            message = StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam) ? dy.getString("checkinfo3").trim() : dy.getString("checkinfo").trim();
            TaskStateEnum taskState = TaskStateEnum.getTaskState((String)state);
            switch (taskState) {
                case CHECKING: {
                    boolean ischeckok = false;
                    boolean ispass = dy.getBoolean("checksuccess");
                    if (ispass) {
                        ischeckok = true;
                    }
                    checkRecord.set("ischeckok", (Object)ischeckok);
                    checkRecord.set("rebackcount", (Object)rebackcount);
                    if (!ischeckok || !StringUtils.isBlank((CharSequence)message)) break;
                    message = ResManager.loadKDString((String)"\u8d28\u68c0\u5408\u683c", (String)"QualityCheckTaskParentPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                case RECTIFYING: {
                    String handleMethod = "1";
                    boolean isappeal = dy.getBoolean("checkappeal");
                    boolean ischeckdone = dy.getBoolean("checkdone");
                    if (isappeal) {
                        handleMethod = "2";
                    }
                    if (ischeckdone) {
                        handleMethod = "1";
                    }
                    checkRecord.set("handlemethod", (Object)handleMethod);
                    checkRecord.set("rebackcount", (Object)rebackcount);
                    break;
                }
                case REVIEW: {
                    checkRecord.set("rebackcount", (Object)rebackcount);
                    if (StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam)) {
                        checkRecord.set("ischeckok", (Object)(!dy.getBoolean("checknopass") ? 1 : 0));
                        message = this.setQcSuccessTabCheckRecord(message, dy, checkRecord);
                        break;
                    }
                    DynamicObject oldCheckRecord = (DynamicObject)oldMessageRecordMap.get(pointid);
                    boolean ischeckok = oldCheckRecord.getBoolean("ischeckok");
                    checkRecord.set("ischeckok", (Object)ischeckok);
                    message = this.setQcFailTabCheckRecord(message, dy, checkRecord);
                    break;
                }
            }
            DynamicObjectCollection objEntrys = (DynamicObjectCollection)checkRecord.get("entryentity");
            DynamicObject objentry = null;
            if (objEntrys == null) {
                isNew = true;
            } else if (objEntrys.size() == 0) {
                objentry = new DynamicObject(objEntrys.getDynamicObjectType());
                isNew = true;
            } else {
                objentry = (DynamicObject)objEntrys.get(0);
                isNew = false;
            }
            if (objentry == null) continue;
            objentry.set("message", (Object)message);
            objentry.set("datetime", (Object)new Date());
            objentry.set("messagetype", (Object)messagetype);
            objentry.set("usercheck", (Object)currentUserId);
            objentry.set("isnewmessage", (Object)1);
            if (!isNew) continue;
            objEntrys.add((Object)objentry);
        }
        if (newCheckRecords.size() > 0) {
            DynamicObject[] newCheckRecordsArray = new DynamicObject[newCheckRecords.size()];
            SaveServiceHelper.save((DynamicObject[])newCheckRecords.toArray(newCheckRecordsArray));
        }
        if (existedCheckRecords.size() > 0) {
            DynamicObject[] existedCheckRecordsArray = new DynamicObject[existedCheckRecords.size()];
            SaveServiceHelper.save((DynamicObject[])existedCheckRecords.toArray(existedCheckRecordsArray));
        }
        return true;
    }

    private String setQcSuccessTabCheckRecord(String message, DynamicObject dy, DynamicObject checkRecord) {
        boolean checknopass = dy.getBoolean("checknopass");
        if (checknopass) {
            if (StringUtils.isBlank((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u3002", (String)"QualityCheckTaskParentPlugin_31", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            }
            checkRecord.set("reviewmethod", (Object)"4");
        }
        return message;
    }

    private String setQcFailTabCheckRecord(String message, DynamicObject dy, DynamicObject checkRecord) {
        String reviewmethod = "3";
        boolean ispass = dy.getBoolean("checkpass");
        boolean isreback = dy.getBoolean("checkreback");
        String handlemethod = dy.getString("handlemethod");
        if (ispass) {
            if ("2".equals(handlemethod)) {
                reviewmethod = "2";
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = ResManager.loadKDString((String)"\u7533\u8bc9\u901a\u8fc7\u3002", (String)"QualityCheckTaskParentPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                }
            } else {
                reviewmethod = "1";
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = ResManager.loadKDString((String)"\u6574\u6539\u901a\u8fc7\u3002", (String)"QualityCheckTaskParentPlugin_25", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                }
            }
        }
        if (isreback) {
            reviewmethod = "3";
        }
        checkRecord.set("reviewmethod", (Object)reviewmethod);
        return message;
    }

    public boolean updateMessageState(DynamicObjectCollection checks, long taskid, String messagetype, String state, Map<String, Object> changeData) {
        return this.updateMessageState(checks, taskid, messagetype, state, changeData, null);
    }

    public boolean updateMessageState(DynamicObjectCollection checks, long taskid, String messagetype, String state, Map<String, Object> changeData, String otherParam) {
        if (checks == null || checks.size() == 0 || changeData == null) {
            return false;
        }
        ArrayList<DynamicObject> updateMessageList = new ArrayList<DynamicObject>();
        for (DynamicObject dy : checks) {
            DynamicObjectCollection objEntrys;
            DynamicObject checkRecord;
            long pointid = StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam) ? dy.getLong("pointid1") : dy.getLong("pointid");
            if (pointid == 0L) continue;
            QFilter filterPoint = new QFilter("point", "=", (Object)pointid);
            QFilter filterCheck = new QFilter("qualitycheck", "=", (Object)taskid);
            QFilter filterMessageType = new QFilter("entryentity.messagetype", "in", Collections.singletonList(messagetype));
            QFilter filterIsNewMessage = new QFilter("entryentity.isnewmessage", "=", (Object)1);
            if (changeData.get("otherFilter") != null) {
                QFilter otherFilter = (QFilter)changeData.get("otherFilter");
                filterPoint.and(otherFilter);
            }
            if ((checkRecord = BusinessDataServiceHelper.loadSingle((String)"task_qualitymessagerecord", (String)FIELD_QUALITYMESSAGERECORD, (QFilter[])new QFilter[]{filterPoint, filterCheck, filterMessageType, filterIsNewMessage})) == null) continue;
            Object updateCheckResult = changeData.get("updateCheckResult");
            if (updateCheckResult != null && ((Boolean)updateCheckResult).booleanValue()) {
                if (StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam)) {
                    boolean checknopass = dy.getBoolean("checknopass");
                    checkRecord.set("ischeckok", (Object)(!checknopass ? 1 : 0));
                } else {
                    boolean isPass = dy.getBoolean("checkpass");
                    if (isPass) {
                        boolean hasRectifyCompleted = QualityCheckSchemeUtil.hasRectifyCompleted(taskid, pointid);
                        if (hasRectifyCompleted) {
                            checkRecord.set("ischeckok", (Object)Boolean.FALSE);
                        } else {
                            checkRecord.set("ischeckok", (Object)Boolean.TRUE);
                        }
                    } else {
                        checkRecord.set("ischeckok", (Object)Boolean.FALSE);
                    }
                }
            }
            if ((objEntrys = (DynamicObjectCollection)checkRecord.get("entryentity")) == null || objEntrys.size() == 0) continue;
            DynamicObject objentry = (DynamicObject)objEntrys.get(0);
            Object isnewmessage = changeData.get("isnewmessage");
            if (isnewmessage != null) {
                objentry.set("isnewmessage", isnewmessage);
            }
            updateMessageList.add(checkRecord);
        }
        if (updateMessageList.size() > 0) {
            DynamicObject[] needUpdateArray = new DynamicObject[updateMessageList.size()];
            updateMessageList.toArray(needUpdateArray);
            SaveServiceHelper.save((DynamicObject[])needUpdateArray);
            return true;
        }
        return false;
    }

    public void saveTask(long taskId, long personid, String pooltype, String state, String orignalperson, String reformperson) {
        QFilter filterId = new QFilter("id", "=", (Object)taskId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,personid,pooltype,state,qualitystate,orignalperson,reformperson,qualitychecktime,qualityresult", (QFilter[])new QFilter[]{filterId});
        if (task == null) {
            return;
        }
        task.set("personid", (Object)personid);
        task.set("pooltype", (Object)pooltype);
        task.set("state", (Object)state);
        task.set("qualitychecktime", (Object)new Date());
        if (StringUtils.isNotBlank((CharSequence)orignalperson)) {
            task.set("orignalperson", (Object)Long.valueOf(orignalperson));
        }
        if (StringUtils.isNotBlank((CharSequence)reformperson)) {
            task.set("reformperson", (Object)Long.valueOf(reformperson));
        }
        String sampraryLibId = this.getPageCache().get("sampraryLibId");
        if (this.isQualityTaskSuccess(taskId, sampraryLibId)) {
            task.set("qualityresult", (Object)1);
        } else {
            task.set("qualityresult", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }

    public DynamicObject getTask(long taskId, long qualitysamplelibraryId) {
        QFilter filterId = new QFilter("id", "=", (Object)taskId);
        QFilter filterqualitysamplelibrary = new QFilter("qualitysamplelibrary", "=", (Object)qualitysamplelibraryId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,personid,pooltype,qualitystate,orignalperson,reformperson", (QFilter[])new QFilter[]{filterId, filterqualitysamplelibrary});
        return task;
    }

    public Object saveQualityHistoryTask(long taskId) {
        return QualityTaskHelper.saveQualityHistoryTask(taskId);
    }

    public boolean updateMessageRecord(long taskId, Map<String, Object> changeData) {
        return QualityTaskHelper.updateMessageRecord(taskId, changeData);
    }

    public boolean updateAttachmentsRecord(long taskId, Map<String, Object> changeData) {
        return QualityTaskHelper.updateAttachmentsRecord(taskId, changeData);
    }

    public boolean deleteCompleteTask(long taskId) {
        return QualityTaskHelper.deleteCompleteTask(taskId);
    }

    public Object insertQualityTaskHistory(long taskId) {
        QFilter fiterTaskId = new QFilter("id", "=", (Object)taskId);
        QFilter fiterPoolType = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        String selectFields = "id,billno,resttime,billnumber,orgid,usergroup,costwaittime,billtype,tasktypeid,sscid,creator,subject,state,innermsg,apprevalmessage,taskcreatetime,imageuploadtime,receivetime,completetime,personid,tasklevelid,imageok,flagmsg,autoprocess,pooltype,expirestate,bizdata_tag,billid,billlongid,procinstid,coefficient,unpassreasondesc,qualitysamplelibrary,qualitystate,orignalperson,reformperson,qualityresult,qualitychecktime,sysbillid,multistate,level,extenderp,source,auditor,assignid,oldtaskstate,recyclestate,unpassreasonid,info,consignerid,flowbackstgid,waittime,pausewaittime,rescanwaittime,allocatecount,islastaudit,hasallocated,createruleid,imagenumber,reverseoprt,oprt,orglongnumber,sourcetaskid,autoprocessforcheck,matchrule,firstreceivetime,firstcostwaittime,pausewaittime";
        DynamicObject taskData = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{fiterTaskId, fiterPoolType});
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"task_taskhistory");
        historyTask.set("sourcetaskid", taskData.get("sourcetaskid"));
        historyTask.set("subject", taskData.get("subject"));
        historyTask.set("billno", taskData.get("billno"));
        historyTask.set("state", taskData.get("state"));
        historyTask.set("innermsg", taskData.get("innermsg"));
        historyTask.set("billnumber", taskData.get("billnumber"));
        historyTask.set("apprevalmessage", taskData.get("apprevalmessage"));
        historyTask.set("completetime", (Object)new Date());
        historyTask.set("receivetime", taskData.get("receivetime"));
        historyTask.set("firstreceivetime", taskData.get("firstreceivetime"));
        historyTask.set("personid", taskData.get("personid"));
        historyTask.set("usergroup", taskData.get("usergroup"));
        historyTask.set("tasklevelid", taskData.get("tasklevelid"));
        historyTask.set("imageok", taskData.get("imageok"));
        historyTask.set("flagmsg", taskData.get("flagmsg"));
        historyTask.set("autoprocess", taskData.get("autoprocess"));
        historyTask.set("pooltype", taskData.get("pooltype"));
        historyTask.set("expirestate", taskData.get("expirestate"));
        historyTask.set("creator", taskData.get("creator"));
        historyTask.set("sscid", taskData.get("sscid"));
        historyTask.set("tasktypeid", taskData.get("tasktypeid"));
        historyTask.set("billtype", taskData.get("billtype"));
        historyTask.set("orgid", taskData.get("orgid"));
        historyTask.set("createtime", taskData.get("taskcreatetime"));
        historyTask.set("taskcreatetime", taskData.get("taskcreatetime"));
        historyTask.set("imageuploadtime", taskData.get("imageuploadtime"));
        historyTask.set("costwaittime", taskData.get("costwaittime"));
        historyTask.set("firstcostwaittime", taskData.get("firstcostwaittime"));
        historyTask.set("pausewaittime", taskData.get("pausewaittime"));
        historyTask.set("resttime", taskData.get("resttime"));
        historyTask.set("bizdata_tag", taskData.get("bizdata_tag"));
        historyTask.set("billid", taskData.get("billid"));
        historyTask.set("billlongid", taskData.get("billlongid"));
        historyTask.set("procinstid", taskData.get("procinstid"));
        historyTask.set("coefficient", taskData.get("coefficient"));
        historyTask.set("unpassreasondesc", taskData.get("unpassreasondesc"));
        historyTask.set("qualitystate", taskData.get("qualitystate"));
        historyTask.set("qualitysamplelibrary", taskData.get("qualitysamplelibrary.id"));
        historyTask.set("orignalperson", taskData.get("orignalperson.id"));
        historyTask.set("reformperson", taskData.get("reformperson.id"));
        historyTask.set("qualityresult", taskData.get("qualityresult"));
        historyTask.set("qualitychecktime", taskData.get("qualitychecktime"));
        historyTask.set("sysbillid", taskData.get("sysbillid"));
        historyTask.set("multistate", taskData.get("multistate"));
        historyTask.set("level", taskData.get("level"));
        historyTask.set("extenderp", taskData.get("extenderp"));
        historyTask.set("source", taskData.get("source"));
        historyTask.set("auditor", taskData.get("auditor"));
        historyTask.set("assignid", taskData.get("assignid"));
        historyTask.set("oldtaskstate", taskData.get("oldtaskstate"));
        historyTask.set("recyclestate", taskData.get("recyclestate"));
        historyTask.set("unpassreasonid", taskData.get("unpassreasonid"));
        historyTask.set("info", taskData.get("info"));
        historyTask.set("consignerid", taskData.get("consignerid"));
        historyTask.set("flowbackstgid", taskData.get("flowbackstgid"));
        historyTask.set("waittime", taskData.get("waittime"));
        historyTask.set("pausewaittime", (Object)taskData.getDate("pausewaittime"));
        historyTask.set("rescanwaittime", (Object)taskData.getDate("rescanwaittime"));
        historyTask.set("allocatecount", taskData.get("allocatecount"));
        historyTask.set("islastaudit", taskData.get("islastaudit"));
        historyTask.set("hasallocated", taskData.get("hasallocated"));
        historyTask.set("createruleid", taskData.get("createruleid"));
        historyTask.set("imagenumber", taskData.get("imagenumber"));
        historyTask.set("reverseoprt", taskData.get("reverseoprt"));
        historyTask.set("oprt", taskData.get("oprt"));
        historyTask.set("orglongnumber", taskData.get("orglongnumber"));
        historyTask.set("autoprocessforcheck", taskData.get("autoprocessforcheck"));
        historyTask.set("matchrule", taskData.get("matchrule"));
        Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyTask});
        if (ret != null && ret.length > 0) {
            DynamicObject newTask = (DynamicObject)ret[0];
            return newTask.getPkValue();
        }
        return null;
    }

    private void viewphoto() {
        String billID = this.getPageCache().get("billID");
        String billtype = this.getPageCache().get("metadatatType");
        String taskid = this.getPageCache().get("taskid");
        String state = this.getPageCache().get("state");
        boolean isHistory = TaskStateEnum.QUA_CHECK_COMPLETED.getValue().equals(state);
        DynamicObject dataTask = TaskQueryServiceHelper.getDataTask(taskid, isHistory);
        String imageNumber = dataTask.getString("imagenumber");
        String isEdit = "0";
        SscImageServiceHelper.viewphoto((String)imageNumber, (String)billID, (String)billtype, (IFormView)this.getView(), (String)isEdit);
    }

    public boolean changeQualitySampleLib(long sampleLibId, Map<String, Object> changeData) {
        return QualityCheckSchemeUtil.changeQualitySampleLib(sampleLibId, changeData);
    }

    public boolean isCompleteQualityCheckLibrary(long sampleLibId) {
        return QualityCheckSchemeUtil.isCompleteQualityCheckLibrary(sampleLibId);
    }

    public boolean isExistToDoQualityCheckTask(long sampleLibId) {
        return QualityCheckSchemeUtil.isExistToDoQualityCheckTask(sampleLibId);
    }

    public void initPointName() {
        IDataModel model = this.getModel();
        DynamicObjectCollection failChecks = model.getEntryEntity("entryentityfail");
        if (failChecks != null && failChecks.size() > 0) {
            int index = model.getEntryCurrentRowIndex("entryentityfail");
            Object cpName = model.getValue("name", index);
            if (null != cpName) {
                model.setValue("cpname", (Object)String.format(ResManager.loadKDString((String)"%s\u8d28\u68c0\u8bb0\u5f55\u8be6\u60c5\uff1a", (String)"QualityCheckTaskParentPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]), cpName));
            }
            return;
        }
        DynamicObjectCollection reformChecks = model.getEntryEntity("entryentityreform");
        if (reformChecks != null && reformChecks.size() > 0) {
            int index = model.getEntryCurrentRowIndex("entryentityreform");
            Object cpName = model.getValue("name2", index);
            if (null != cpName) {
                model.setValue("cpname", (Object)String.format(ResManager.loadKDString((String)"%s\u8d28\u68c0\u8bb0\u5f55\u8be6\u60c5\uff1a", (String)"QualityCheckTaskParentPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]), cpName));
            }
            return;
        }
        DynamicObjectCollection successChecks = model.getEntryEntity("entryentitysuccess");
        if (successChecks != null && successChecks.size() > 0) {
            int index = model.getEntryCurrentRowIndex("entryentitysuccess");
            Object cpName = model.getValue("name1", index);
            if (null != cpName) {
                model.setValue("cpname", (Object)String.format(ResManager.loadKDString((String)"%s\u8d28\u68c0\u8bb0\u5f55\u8be6\u60c5\uff1a", (String)"QualityCheckTaskParentPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]), cpName));
            }
            return;
        }
    }

    public void initFirstQualityAdvice() {
        IDataModel model = this.getModel();
        String index = "";
        DynamicObjectCollection checks = model.getEntryEntity("entryentityfail");
        if (checks == null || checks.size() == 0) {
            checks = model.getEntryEntity("entryentityreform");
            index = "2";
        }
        if (checks == null || checks.size() == 0) {
            checks = model.getEntryEntity("entryentitysuccess");
            index = "1";
        }
        if (checks == null || checks.size() == 0) {
            return;
        }
        String taskId = this.getPageCache().get("taskid");
        DynamicObject check = (DynamicObject)checks.get(0);
        String pointName = String.format("pointid%s", index);
        long point = check.getLong(pointName);
        this.initCheckRecord(point, Long.parseLong(taskId), Arrays.asList("0", "1", "2"));
    }

    public void initSelectTab() {
        IDataModel model = this.getModel();
        Tab tabap = (Tab)this.getControl("tabap");
        String selectTabPage = "";
        DynamicObjectCollection checks = model.getEntryEntity("entryentityfail");
        if (checks == null || checks.size() == 0) {
            checks = model.getEntryEntity("entryentityreform");
        } else {
            selectTabPage = "qcfailtab";
        }
        if (StringUtils.isNotBlank((CharSequence)selectTabPage)) {
            tabap.activeTab(selectTabPage);
            return;
        }
        if (checks == null || checks.size() == 0) {
            checks = model.getEntryEntity("entryentitysuccess");
        } else {
            selectTabPage = "qcreformpasstab";
        }
        if (StringUtils.isNotBlank((CharSequence)selectTabPage)) {
            tabap.activeTab(selectTabPage);
            return;
        }
        if (checks != null) {
            selectTabPage = "qcsuccesstab";
        }
        if (StringUtils.isNotBlank((CharSequence)selectTabPage)) {
            tabap.activeTab(selectTabPage);
            return;
        }
    }

    public boolean saveAttachmentsExt(DynamicObjectCollection attachemnts, long taskId, String formId, long pointId) {
        if (attachemnts == null || attachemnts.size() == 0) {
            return false;
        }
        AttachmentFieldServiceHelper.saveTempAttachments((String)this.getView().getPageId());
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        QFilter filterTaskId = new QFilter("taskid", "=", (Object)taskId);
        QFilter filterPointId = new QFilter("pointid", "=", (Object)pointId);
        filterTaskId.and(filterPointId);
        DynamicObject dyAttachment = BusinessDataServiceHelper.loadSingle((String)"task_qcattachment", (String)selectAttachmentFields, (QFilter[])filterTaskId.toArray());
        if (dyAttachment == null) {
            dyAttachment = BusinessDataServiceHelper.newDynamicObject((String)"task_qcattachment");
            dyAttachment.set("taskid", (Object)taskId);
            dyAttachment.set("pointid", (Object)pointId);
        }
        DynamicObjectCollection objEntrys = (DynamicObjectCollection)dyAttachment.get("entryentity");
        HashSet<Long> allNewEntryIds = new HashSet<Long>();
        for (DynamicObject item : attachemnts) {
            long attachmentid = item.getLong("fbasedataid_id");
            boolean isNew = true;
            if (objEntrys != null && objEntrys.size() > 0) {
                for (DynamicObject entry : objEntrys) {
                    long attachmentid2 = entry.getLong("attachmentid");
                    if (attachmentid2 != attachmentid) continue;
                    entry.set("modifytime", (Object)new Date());
                    isNew = false;
                    break;
                }
            }
            if (isNew) {
                DynamicObject objentry = new DynamicObject(objEntrys.getDynamicObjectType());
                objentry.set("taskformid", (Object)formId);
                objentry.set("createtime", (Object)new Date());
                objentry.set("attachmentid", (Object)attachmentid);
                objentry.set("userid", (Object)currentUserId);
                objEntrys.add((Object)objentry);
            }
            allNewEntryIds.add(attachmentid);
        }
        if (objEntrys != null && objEntrys.size() > 0) {
            objEntrys.iterator();
            Iterator it = objEntrys.iterator();
            while (it.hasNext()) {
                long id = ((DynamicObject)it.next()).getLong("attachmentid");
                if (allNewEntryIds.contains(id)) continue;
                it.remove();
            }
        }
        dyAttachment.set("entryentity", (Object)objEntrys);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyAttachment});
        return true;
    }

    public Object[] getAttachmentId(long taskId, List<String> formIds, List<Long> pointIds) {
        DynamicObject dyAttachment;
        QFilter filterId = new QFilter("taskid", "=", (Object)taskId);
        if (pointIds != null && pointIds.size() > 0) {
            QFilter filterPointId = new QFilter("pointid", "in", pointIds);
            filterId.and(filterPointId);
        }
        if ((dyAttachment = BusinessDataServiceHelper.loadSingle((String)"task_qcattachment", (String)"entryentity.attachmentid", (QFilter[])filterId.toArray())) == null) {
            return null;
        }
        DynamicObjectCollection cols = dyAttachment.getDynamicObjectCollection("entryentity");
        if (cols == null || cols.size() == 0) {
            return null;
        }
        Object[] ret = new Object[cols.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((DynamicObject)cols.get(i)).get("attachmentid");
        }
        return ret;
    }

    public void setPageControlState(boolean flag, String type) {
        IFormView view = this.getView();
        if (TaskStateEnum.CHECKING.getValue().equals(type)) {
            view.setEnable(Boolean.valueOf(flag), new String[]{"reformperson", "qcattachment"});
        } else if (TaskStateEnum.RECTIFYING.getValue().equals(type)) {
            view.setEnable(Boolean.valueOf(flag), new String[]{"rectifyattachment"});
        } else if (TaskStateEnum.REVIEW.getValue().equals(type)) {
            view.setEnable(Boolean.valueOf(flag), new String[]{"qcattachment", "rectifyattachment"});
        }
        view.setVisible(Boolean.valueOf(flag), new String[]{"save", "checksubmit"});
    }

    public boolean isPendingState(Long taskId) {
        QFilter filterId = new QFilter("id", "=", (Object)taskId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"state", (QFilter[])new QFilter[]{filterId});
        if (task == null) {
            return false;
        }
        String state = task.getString("state");
        List<String> pauseStateList = Arrays.asList(TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue());
        return pauseStateList.contains(state);
    }

    private void openBillView(String billID, String bindform, Long taskid, String bizdata, boolean isembed, boolean disableBillType) {
        if (isembed) {
            this.openEmbedView(billID);
        } else {
            this.openNextBillView(billID, bindform, taskid, bizdata, disableBillType);
        }
    }

    private void openNextBillView(String billID, String bindform, Long taskid, String bizdata, boolean disableBillType) {
        BillShowParameter parameter = new BillShowParameter();
        if (bizdata != null) {
            parameter.getCustomParams().put("bizdata", bizdata);
        }
        parameter.setPkId((Object)billID);
        parameter.setFormId(bindform);
        parameter.getOpenStyle().setTargetKey("billcontainer");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("taskID", (Object)taskid);
        parameter.setCustomParam("billID", (Object)billID);
        parameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        parameter.setCustomParam("disableBillType", (Object)disableBillType);
        parameter.setCustomParam("isQualityTask", (Object)true);
        parameter.setCustomParam("billAttributeConfig", (Object)this.getPageCache().get("billAttributeConfig"));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setHasRight(true);
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.BillFormShowCustomerPlugin");
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.QualityCheckHideToolBarPlugin");
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.BillAttributeControlV2FormPlugin");
        this.getPageCache().put("SSC_FORM_ISLOAD", "true");
        this.getPageCache().put("sompageid", parameter.getPageId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setEmbedViewVisible() {
        if (!this.isEmbedBill()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"iframeap"});
        }
    }

    private boolean isEmbedBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isembed = formShowParameter.getCustomParam("isembed") == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam("isembed");
        return isembed;
    }

    private void openEmbedView(String billID) {
        this.getPageCache().put("SSC_FORM_ISLOAD", "false");
        String taskID = this.getPageCache().get("taskid");
        String state = this.getPageCache().get("state");
        TaskStateEnum taskState = TaskStateEnum.getTaskState((String)state);
        boolean isHis = false;
        if (TaskStateEnum.QUA_CHECK_COMPLETED == taskState) {
            isHis = true;
        }
        String extUrl = this.getExtUrl(billID, taskID, isHis);
        IFrame frame = (IFrame)this.getControl("iframeap");
        frame.setSrc(extUrl);
    }

    private String getExtUrl(String billID, String taskID, boolean isHis) {
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)this.getErpNumberAndCacheBindNum());
        log.info("kd.ssc.task.formplugin.QualityCheckTaskParentPlugin.getExtUrl getEmbedViewUrl billID : " + billID + "; taskID: " + taskID + "; isHis:" + isHis);
        String extUrl = taskFacade.getEmbedViewUrl(billID, taskID, isHis);
        log.info("kd.ssc.task.formplugin.QualityCheckTaskParentPlugin.getExtUrl getEmbedViewUrl end");
        return extUrl;
    }

    private String getErpNumberAndCacheBindNum() {
        String erpNumber = this.getPageCache().get("erpNumber");
        if (this.getPageCache().get("erpNumber") != null) {
            return erpNumber;
        }
        String billtypeidStr = this.getPageCache().get("billtypeid");
        long billtypeid = Long.parseLong(billtypeidStr);
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number,bindbill.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        erpNumber = (String)billType.get("externalerp.number");
        String bindbillNumber = (String)billType.get("bindbill.number");
        this.getPageCache().put("erpNumber", erpNumber.toLowerCase());
        this.getPageCache().put("bindbillNumber", bindbillNumber);
        return erpNumber.toLowerCase();
    }

    private boolean isHisTask() {
        Object sourcetaskid = this.getView().getFormShowParameter().getCustomParam("sourcetaskid");
        return sourcetaskid != null && Long.parseLong(sourcetaskid.toString()) > 0L;
    }

    private void initApprovalHandleMsg(FormShowParameter formShowParameter) {
        String apprevalmessage = (String)formShowParameter.getCustomParam("apprevalmessage");
        String innermsg = (String)formShowParameter.getCustomParam("innermsg");
        IDataModel dataModel = this.getModel();
        dataModel.setValue("opinion", (Object)apprevalmessage);
        dataModel.setValue("innermsg", (Object)innermsg);
    }

    private void initAuditRecord(Long taskId, Long billTypeId) {
        boolean isHist = this.isHisTask();
        FormShowParameter paramEdit = TaskApproveUtil.setAuditRecord(taskId, billTypeId, isHist);
        this.getView().showForm(paramEdit);
        List<IApprovalRecordGroup> approvalRecordGroups = TaskApproveUtil.setPauseRecord(taskId, isHist);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("isPC", "true");
        ((ApprovalRecord)this.getControl("pauserecordap")).setParameters(params);
        ((ApprovalRecord)this.getControl("pauserecordap")).setArData(approvalRecordGroups);
    }

    private boolean isSamePerson(String personid) {
        String userId = RequestContext.get().getUserId();
        log.info(String.format("isFromWaiteTrackedState(), userId = %s, personid = %s", userId, personid));
        return StringUtils.isNotEmpty((CharSequence)userId) && userId.equals(personid);
    }

    public void openQualityPendingDialog(Long taskId) {
        if (taskId != null) {
            ArrayList<Long> taskIds = new ArrayList<Long>(8);
            taskIds.add(taskId);
            IFormView view = this.getView();
            FormShowParameter para = new FormShowParameter();
            para.setFormId("task_qcpendingreasonsel");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.getOpenStyle().setTargetKey("tabap");
            para.setHasRight(true);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "action_quality_pause"));
            para.setCustomParam("taskIds", taskIds);
            view.showForm(para);
        }
    }

    private void executeOperate(String entityName, String operateType) {
        IFormView subView = this.getView().getViewNoPlugin(this.getPageCache().get("sompageid"));
        String operateKey = this.findOperate(entityName, operateType);
        if (operateKey == null) {
            subView.invokeOperation(operateType);
            this.getView().sendFormAction(subView);
        } else {
            subView.getFormShowParameter().setPermissionItemId(entityName);
            subView.invokeOperation(operateKey);
            this.getView().sendFormAction(subView);
        }
    }

    private String findOperate(String entityName, String operateType) {
        Map operateMetaMap;
        try {
            operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)operateType);
        }
        catch (Exception ex) {
            return null;
        }
        String operateType_ = (String)operateMetaMap.get("type");
        if (operateType.equalsIgnoreCase(operateType_)) {
            return operateType;
        }
        for (Map operateMap : EntityMetadataCache.getDataEntityOperate((String)entityName)) {
            String type = (String)operateMap.get("type");
            if (!operateType.equalsIgnoreCase(type)) continue;
            return (String)operateMap.get("key");
        }
        return null;
    }

    public boolean deleteMessage(DynamicObjectCollection checks, long taskid, String messagetype, String otherParam) {
        if (checks == null || checks.size() == 0) {
            return false;
        }
        HashSet<Long> pointIds = new HashSet<Long>();
        for (DynamicObject dy : checks) {
            if (StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam)) {
                pointIds.add(dy.getLong("pointid1"));
                continue;
            }
            pointIds.add(dy.getLong("pointid"));
        }
        QFilter filterPoint = new QFilter("point", "in", pointIds);
        QFilter filterCheck = new QFilter("qualitycheck", "=", (Object)taskid);
        QFilter filterSave = new QFilter("rebackcount", "=", (Object)0);
        QFilter filterMessageType = new QFilter("entryentity.messagetype", "in", Collections.singletonList(messagetype));
        QFilter filterIsNewMessage = new QFilter("entryentity.isnewmessage", "=", (Object)1);
        if (StringUtils.isNotEmpty((CharSequence)otherParam) && "qcsuccesstab".equals(otherParam)) {
            QFilter filterReviewMethod = new QFilter("reviewmethod", "=", (Object)"4");
            filterPoint.and(filterReviewMethod);
        }
        int deleteCount = DeleteServiceHelper.delete((String)"task_qualitymessagerecord", (QFilter[])new QFilter[]{filterPoint, filterCheck, filterSave, filterMessageType, filterIsNewMessage});
        log.info("\u5220\u9664\u8d28\u68c0\u4fe1\u606f\u8bb0\u5f55\u5b8c\u6210\uff0cdeleteCount size\uff1a" + deleteCount);
        return deleteCount > 0;
    }
}

