/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.ssc.task.formplugin.nsynprocess.NsynTaskAllocationProcess;

public class TaskAllocationProcessFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private Long userId;
    private Long userGroup;
    private List<Long> taskIds;
    private int batchCounts;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"TaskAllocationPool", (int)2);
    private static final Log log = LogFactory.getLog(TaskAllocationProcessFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.userId = this.getUserId(parameter);
        this.taskIds = this.getTaskIds(parameter);
        this.batchCounts = this.getBatchCounts(parameter);
        this.userGroup = this.getUserGroup(parameter);
        this.start();
    }

    public void onProgress(ProgressEvent arg0) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            this.setTaskId(taskId);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.userId = this.getUserId(parameter);
            this.taskIds = this.getTaskIds(parameter);
            this.batchCounts = this.getBatchCounts(parameter);
            this.userGroup = this.getUserGroup(parameter);
            IFormView parentView = this.getParentView();
            NsynTaskAllocationProcess executer = new NsynTaskAllocationProcess(taskId, this.userId, this.taskIds, this.batchCounts, parentView, this.userGroup);
            threadPool.execute((Runnable)executer);
        } else {
            boolean completed = NsynTaskAllocationProcess.isCompleted(taskId);
            boolean finished = NsynTaskAllocationProcess.isFinished(taskId);
            boolean isInteruption = NsynTaskAllocationProcess.isInteruption(taskId);
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            if (completed) {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                this.taskIds = this.getTaskIds(parameter);
                this.complete(taskId);
                bar.stop();
            } else if (isInteruption) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"TaskAllocationProcessFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().close();
                bar.stop();
            } else if (finished) {
                this.getView().close();
                bar.stop();
            } else {
                int progress = NsynTaskAllocationProcess.getProgress(taskId);
                String tip = NsynTaskAllocationProcess.getProgressTip(taskId);
                arg0.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)tip)) {
                    this.setProgressTip(tip);
                }
            }
        }
    }

    private void start() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        this.setProgressTip(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6570\u636e\u8f83\u591a\uff0c\u6b63\u5728\u5206\u6279...", (String)"TaskAllocationProcessFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    private void complete(String taskId) {
        String errorMsgStr = NsynTaskAllocationProcess.getErrorMsg(taskId);
        StringBuilder errorMsg = new StringBuilder(errorMsgStr);
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        int totalTaskCount = this.taskIds.size();
        int totalSuccessCount = NsynTaskAllocationProcess.getSuccessCount(taskId);
        returnDataMap.put("totalTaskCount", totalTaskCount);
        returnDataMap.put("totalSuccessCount", totalSuccessCount);
        String digest = this.createTipDigest(totalTaskCount, totalSuccessCount);
        returnDataMap.put("digest", digest);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            errorMsg.deleteCharAt(errorMsg.length() - 1);
            returnDataMap.put("errorMsg", errorMsg.toString());
        }
        String jsonString = JSON.toJSONString(returnDataMap);
        log.info(jsonString);
        this.getView().returnDataToParent((Object)jsonString);
        this.getView().close();
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl("lblprogress");
        lblTip.setText(tip);
    }

    private Long getUserId(FormShowParameter parameter) {
        return Long.valueOf("" + parameter.getCustomParam("userid"));
    }

    private Long getUserGroup(FormShowParameter parameter) {
        return Long.valueOf("" + parameter.getCustomParam("usergroup"));
    }

    private List<Long> getTaskIds(FormShowParameter parameter) {
        String taskIdJason = (String)parameter.getCustomParam("taskids");
        List<Long> taskIds = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)taskIdJason)) {
            taskIds = (List)SerializationUtils.fromJsonString((String)taskIdJason, List.class);
        }
        return taskIds;
    }

    private int getBatchCounts(FormShowParameter parameter) {
        return (Integer)parameter.getCustomParam("batchcount");
    }

    private IFormView getParentView() {
        return this.getView().getParentView();
    }

    private String getTaskId() {
        return this.getPageCache().get("taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("taskid", taskId);
    }

    public String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u5206\u914d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"UserWorkLoadFormPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }
}

