/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import org.apache.commons.lang3.StringUtils;

public class TaskQuerylistpoolEditPlugin
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "bill_new", "querylist", "querylisth"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String mainEntityFormId;
        String number;
        DynamicObject dy;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("querylist".equals(name)) {
            dy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            number = dy.getString("number");
            mainEntityFormId = this.getMainEntityFormId(number);
            this.getModel().beginInit();
            this.getModel().setValue("mainquery", (Object)mainEntityFormId);
            this.getModel().endInit();
            this.getView().updateView("mainquery");
        }
        if ("querylisth".equals(name)) {
            dy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            number = dy.getString("number");
            mainEntityFormId = this.getMainEntityFormId(number);
            this.getModel().beginInit();
            this.getModel().setValue("mainqueryh", (Object)mainEntityFormId);
            this.getModel().endInit();
            this.getView().updateView("mainqueryh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public QueryEntity getQueryEntity(String entityName) {
        String queryEntityName = null;
        Map meta = FormMetadataCache.getListMeta((String)entityName);
        if (meta != null && meta.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)meta.get(BillList.class.getSimpleName());
            BillList list = (BillList)ControlTypes.fromJsonString((String)strBillList);
            queryEntityName = list.getEntityId();
        }
        if (StringUtils.isEmpty(queryEntityName)) {
            return null;
        }
        String queryFormId = MetadataDao.getIdByNumber(queryEntityName, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)queryFormId)) {
            return null;
        }
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
        if (entityMeta == null) {
            return null;
        }
        return (QueryEntity)entityMeta.getRootEntity();
    }

    public String getMainEntityFormId(String entityName) {
        QueryEntity queryEntity = this.getQueryEntity(entityName);
        if (queryEntity == null) {
            return null;
        }
        return queryEntity.getEntityName();
    }
}

