/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.enums.OpreationRuleEnum;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.TaskFieldConfigEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.business.helper.TaskBillClassifyHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;
import kd.ssc.task.formplugin.util.MetadataUtil;
import kd.ssc.task.partask.analyzation.ParTaskFlowAnaFromBill;
import kd.ssc.task.partask.meta.ParTaskFlowNodeMeta;
import kd.ssc.task.partask.service.impl.ParTaskFlowServiceImpl;
import kd.ssc.task.partask.util.ParTaskFlowVerifyUtil;

public class TaskRuleEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
ItemClickListener,
BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final Log log = LogFactory.getLog(TaskRuleEditPlugin.class);
    private static final String ORGTYPE = "10";
    private static final String CALLBACKID_SOURCE_CHANGED = "sourceChanged";
    private static final String CALLBACKID_FORM_CHANGED = "formChanged";
    private static final String CALLBACKID_REPETITION_TASKLEVEL = "repetitionTaskLevel";
    private static final String CACHE_CONFIRM_SAME_TASKLEVEL = "confirmSameTaskLevel";
    private static final Long EXTENERAL_ERP_KDCC = 427215148743160832L;
    private static final boolean IS_EMBED_DEFAULT_VALUE = false;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap1"});
        Image image = (Image)this.getControl("imagedelete");
        image.addClickListener((ClickListener)this);
        AbstractGrid entryentity = (AbstractGrid)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
        BasedataEdit sscbillorgpar = (BasedataEdit)this.getControl("sscbillorgpar");
        sscbillorgpar.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bindbill = (BasedataEdit)this.getControl("bindbill");
        bindbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bindBill_new = (BasedataEdit)this.getControl("bindbill_new");
        bindBill_new.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit source = (TextEdit)this.getControl("sourcefieldname");
        source.addButtonClickListener((ClickListener)this);
        BasedataEdit externalerp = (BasedataEdit)this.getControl("externalerp");
        externalerp.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        this.addClickListeners(new String[]{"tipsclose"});
        BasedataEdit group = (BasedataEdit)this.getControl("group");
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taskpool = (BasedataEdit)this.getControl("taskpool");
        taskpool.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"changelabel"});
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        OperationStatus opStatus = view.getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            view.setEnable(Boolean.FALSE, new String[]{"number", "ssccenter"});
        }
        if (opStatus.equals((Object)OperationStatus.ADDNEW)) {
            view.setVisible(Boolean.TRUE, new String[]{"noticetipsflex"});
            model.setValue("createtaskmodel", (Object)"1");
            model.setValue("externalerp", (Object)EXTENERAL_ERP_KDCC);
            model.setValue("isembed", (Object)false);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"noticetipsflex"});
        }
        DynamicObject dyn = (DynamicObject)this.getModel().getValue("bindbill");
        if (dyn != null) {
            this.getPageCache().put("oldbindbill", dyn.getString("number"));
        }
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.selectRows(0);
        model.setDataChanged(false);
        Long sscid = (Long)model.getValue("ssccenter_id");
        if (sscid == null || sscid == 0L) {
            log.info("setFieldConfiguration() warning. sscid = {}", (Object)sscid);
            return;
        }
        String sscType = DutyManageDataHelper.getSSCType((long)sscid);
        this.setFieldConfiguration(sscid, sscType);
        if (SSCTypeEnum.HR.getValue().equals(sscType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"isneedimage", "isneedvoucher", "noticetipsflex"});
        }
    }

    private void setFieldConfiguration(Long sscid, String sscType) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentityfield");
        ComboEdit comboEdit = (ComboEdit)this.getControl("fieldconfiguration");
        for (int i = 0; i < rowCount; ++i) {
            String fieldConfig = (String)model.getValue("fieldconfiguration", i);
            if (!fieldConfig.equals(TaskFieldConfigEnum.ORG.getFieldKey()) && !fieldConfig.equals(TaskFieldConfigEnum.APPLIER.getFieldKey())) continue;
            comboEdit.setEnable(null, false, i);
        }
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("fieldconfiguration");
        List vmItems = comboProp.getComboItems();
        ArrayList<ComboItem> cbItems = new ArrayList<ComboItem>(vmItems.size());
        for (ValueMapItem vmItem : vmItems) {
            if (SSCTypeEnum.HR.getValue().equals(sscType) && !TaskFieldConfigEnum.baseFieldsSet.contains(vmItem.getValue())) continue;
            ComboItem cbItem = new ComboItem();
            cbItem.setValue(vmItem.getValue());
            cbItem.setCaption(vmItem.getName());
            cbItems.add(cbItem);
        }
        comboEdit.setComboItems(cbItems);
    }

    public void entryRowClick(RowClickEvent e) {
        String key = ((Control)e.getSource()).getKey();
        String currentIndex = this.getPageCache().get("currentIndex");
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (index < 0) {
            return;
        }
        if ("entryentity".equals(key) && !currentIndex.equals(index + "")) {
            Boolean needCtrl = Boolean.FALSE;
            if (this.getPageCache().get("isExistParTaskOnProcessing") != null) {
                needCtrl = Boolean.TRUE;
            }
            if (this.isSavePre(false)) {
                this.closePage();
                this.openShowTaskCreateRule(index, null, needCtrl);
            } else {
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
                cardEntry.selectRows(Integer.parseInt(currentIndex));
            }
        }
    }

    private boolean isSavePre(boolean unEdit) {
        if (!this.savedAsPartask(unEdit)) {
            return false;
        }
        int i = 0;
        DynamicObjectCollection entryCount = this.getModel().getEntryEntity("entryentity");
        if (i < entryCount.size()) {
            String childpkid;
            String string = childpkid = this.getModel().getValue("childpkid", i) == null ? null : this.getModel().getValue("childpkid", i).toString();
            if (StringUtils.isEmpty(childpkid)) {
                OperationResult isSuccess = this.invokeBillOperation();
                if (isSuccess.isSuccess()) {
                    Long childPkId = (Long)isSuccess.getSuccessPkIds().get(0);
                    this.getModel().setValue("childpkid", (Object)childPkId, i);
                    return true;
                }
                this.validateErrorInFo(isSuccess);
                return false;
            }
            OperationResult isSuccess = this.invokeBillOperation();
            if (isSuccess.isSuccess()) {
                Long childPkId = (Long)isSuccess.getSuccessPkIds().get(0);
                int currentIndex = Integer.parseInt(this.getPageCache().get("currentIndex"));
                this.getModel().setValue("childpkid", (Object)childPkId, currentIndex);
                return true;
            }
            this.validateErrorInFo(isSuccess);
            return false;
        }
        return true;
    }

    private boolean savedAsPartask(boolean unEdit) {
        boolean canBeSaved = false;
        try {
            canBeSaved = this.canBeSaveAsPartask(unEdit);
        }
        catch (Throwable e) {
            KDException kdException;
            if (e instanceof KDException && "taskType".equals((kdException = (KDException)e).getErrorCode().getCode())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u5f55\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u4efb\u52a1\u7c7b\u578b\u3002", (String)"TaskRuleEditPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            log.warn("\u591a\u7ea7\u4efb\u52a1\u6821\u9a8c", e);
        }
        return canBeSaved;
    }

    private boolean canBeSaveAsPartask(boolean unEdit) throws Exception {
        ArrayList<String> visited;
        DynamicObject[] needChangeDatas;
        DynamicObject addnew;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryInfo = model.getEntryEntity("entryentity");
        int index = Integer.parseInt(this.getPageCache().get("currentIndex"));
        Long currentChildPkId = (Long)model.getValue("childpkid", index);
        List<DynamicObject> taskInfos = null;
        taskInfos = this.getTaskFromBillChild(entryInfo, currentChildPkId, unEdit);
        boolean isNeedVoucher = (Boolean)model.getValue("isneedvoucher");
        if (isNeedVoucher && (addnew = this.getAlterTaskInfo()).getBoolean("isvoucherhandler") && (needChangeDatas = this.getOtherChildEntries()).length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u4e1a\u52a1\u5355\u636e\u53ea\u80fd\u5f00\u542f\u4e00\u4e2a\u201c\u5171\u4eab\u5904\u7406\u4eba\u4e3a\u51ed\u8bc1\u5236\u8bc1\u4eba\u201d\u53c2\u6570\u3002", (String)"TaskRuleEditPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.isParTask(taskInfos)) {
            this.getPageCache().put("isParTask", "false");
            return true;
        }
        this.getPageCache().put("isParTask", "true");
        HashMap<String, ParTaskFlowNodeMeta> defMap = new HashMap<String, ParTaskFlowNodeMeta>(4);
        this.getParTaskFlowByEntryInfo(defMap, taskInfos);
        List startNodeList = new ParTaskFlowServiceImpl().getStartNodeFromDefMap(defMap);
        if (startNodeList == null || startNodeList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u4e0d\u5b58\u5728\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskRuleEditPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        List<DynamicObject> parTaskList = this.getParTaskFormBillChild(taskInfos);
        List<String> parTaskNameList = this.getTaskName(parTaskList);
        if (!parTaskNameList.isEmpty()) {
            for (String startNode : startNodeList) {
                if (!parTaskNameList.contains(startNode)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4efb\u52a1\u201c%s\u201d\u7684\u201c\u4efb\u52a1\u6765\u6e90\u201d\u662f\u201c\u591a\u7ea7\u4efb\u52a1\u201d\uff0c\u9700\u8bbe\u7f6e\u524d\u7f6e\u4efb\u52a1\u3002", (String)"TaskRuleEditPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]), startNode));
                return false;
            }
        }
        if (ParTaskFlowVerifyUtil.closedLoopCheck(defMap, (String)"", visited = new ArrayList<String>(4))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u5b58\u5728\u95ed\u73af\uff0c\u8bf7\u68c0\u67e5\u95ed\u73af\u3002", (String)"TaskRuleEditPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]) + "\t" + this.getLoop(visited));
            return false;
        }
        return true;
    }

    private String getLoop(List<String> visited) {
        String flag = visited.get(visited.size() - 1);
        StringBuilder path = new StringBuilder();
        int from = visited.indexOf(flag);
        int to = visited.lastIndexOf(flag);
        for (int i = from; i < to; ++i) {
            path.append(visited.get(i)).append(" -> ");
        }
        path.append(visited.get(to));
        return path.toString();
    }

    private void getParTaskFlowByEntryInfo(Map<String, ParTaskFlowNodeMeta> defMap, List<DynamicObject> taskInfo) {
        String sourceTypeName = "";
        String targetTypeName = "";
        ParTaskFlowServiceImpl flowService = new ParTaskFlowServiceImpl();
        for (DynamicObject entry : taskInfo) {
            DynamicObject taskType = (DynamicObject)entry.get("tasktype");
            DynamicObjectCollection preTasks = entry.getDynamicObjectCollection("pretasks");
            if (preTasks == null || preTasks.isEmpty()) {
                sourceTypeName = taskType.getLocaleString("name").getLocaleValue();
                flowService.saveEntry2DefMap(defMap, sourceTypeName, targetTypeName);
                continue;
            }
            for (DynamicObject preTaskTmp : preTasks) {
                DynamicObject preTask = (DynamicObject)preTaskTmp.get("fbasedataid");
                sourceTypeName = preTask.getLocaleString("name").getLocaleValue();
                targetTypeName = taskType.getLocaleString("name").getLocaleValue();
                flowService.saveEntry2DefMap(defMap, sourceTypeName, targetTypeName);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        IDataModel model = this.getModel();
        if ("sourcefieldname".equals(key)) {
            String entityNumber = this.getEntityNumberOfSourceBill();
            if (entityNumber == null) {
                return;
            }
            String entityName = model.getValue("name") + "";
            if (StringUtils.isEmpty((String)entityName) || "null".equals(entityName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u540d\u79f0\u672a\u5f55\u5165\u3002", (String)"TaskRuleChildEditPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            int selectedrow = model.getEntryCurrentRowIndex("entryentityfield");
            String fieldconfiguration = (String)model.getValue("fieldconfiguration", selectedrow);
            if (StringUtils.isEmpty((String)fieldconfiguration)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u5b57\u6bb5\u540d\u79f0\u3002", (String)"TaskRuleEditPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            MetadataUtil.getBillRule(entityNumber, entityName, key, (IFormPlugin)this, this.getView(), fieldconfiguration);
        } else if ("changelabel".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"noticetipsflex"});
            model.setValue("createtaskmodel", (Object)"0");
        } else if ("tipsclose".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"noticetipsflex"});
        }
    }

    private String getEntityNumberOfSourceBill() {
        IDataModel model = this.getModel();
        DynamicObject bindBill = (DynamicObject)model.getValue("bindbill");
        if (bindBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"TaskRuleChildEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        return bindBill.getString("number");
    }

    private boolean canBeDeleted() {
        String currentIndex;
        int index;
        IDataModel dataModel = this.getModel();
        DynamicObject deleteRow = dataModel.getEntryRowEntity("entryentity", index = Integer.parseInt(currentIndex = this.getPageCache().get("currentIndex")));
        long deleteChildPkId = deleteRow.getLong("childpkid");
        if (deleteChildPkId == 0L) {
            return true;
        }
        Long deleteTaskTypeId = deleteRow.getLong("tasktype.id");
        DynamicObjectCollection entrys = dataModel.getEntryEntity("entryentity");
        for (DynamicObject entry : entrys) {
            DynamicObject taskInfo;
            DynamicObjectCollection preTask;
            long childPkId = entry.getLong("childpkid");
            if (childPkId == 0L || (preTask = (taskInfo = BusinessDataServiceHelper.loadSingle((Object)childPkId, (String)"task_taskbill_child", (String)"id,pretasks")).getDynamicObjectCollection("pretasks")) == null || preTask.isEmpty()) continue;
            for (DynamicObject task : preTask) {
                Long taskTypeId = (Long)task.get("fbasedataid_id");
                if (!taskTypeId.equals(deleteTaskTypeId)) continue;
                return false;
            }
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("sourcefieldnametree".equalsIgnoreCase(e.getActionId()) && (ret = (Map)returnData).size() > 0) {
            IDataModel model = this.getModel();
            int currentRowfield = this.getModel().getEntryCurrentRowIndex("entryentityfield");
            model.setValue("sourcefieldname", ret.get("alias"), currentRowfield);
            model.setValue("sourcefieldnumber", ret.get("key"), currentRowfield);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IPageCache pageCache = this.getPageCache();
        if ("bar_save".equals(key)) {
            DynamicObject dyn = (DynamicObject)this.getModel().getValue("bindbill");
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconbaritemap"});
            if (dyn == null) {
                return;
            }
            String oldBindBill = pageCache.get("oldbindbill");
            String newBindBill = dyn.getString("number");
            String oldTaskoprt = pageCache.get("oldTaskoprt");
            String newTaskoprt = null;
            if (pageCache.get("newTaskoprtnumber") == null) {
                newTaskoprt = oldTaskoprt;
            } else if (!pageCache.get("newTaskoprtnumber").equals("1")) {
                newTaskoprt = pageCache.get("newTaskoprtnumber");
            }
            if ("true".equals(this.getPageCache().get("isParTask"))) {
                this.saveOpBizRule(oldBindBill, newBindBill, oldTaskoprt, newTaskoprt, OpreationRuleEnum.ParTask.getValue());
            } else {
                this.saveOpBizRule(oldBindBill, newBindBill, oldTaskoprt, newTaskoprt, OpreationRuleEnum.Task.getValue());
            }
            if (StringUtils.isBlank((String)newTaskoprt)) {
                pageCache.put("oldTaskoprt", newTaskoprt);
            }
            pageCache.put("oldbindbill", newBindBill);
        }
    }

    public void saveOpBizRule(String oldBindBill, String newBindBill, String oldTaskoprt, String newTaskoprt, String opBizRuleId) {
        if (StringUtils.isEmpty((String)oldBindBill) && !StringUtils.isEmpty((String)newTaskoprt)) {
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)newBindBill, (String)opBizRuleId, Collections.singletonList(newTaskoprt));
        } else if (!StringUtils.isEmpty((String)oldBindBill) && !StringUtils.isEmpty((String)newTaskoprt)) {
            this.deleteOprationRuleRecords(oldBindBill);
            OpBizRuleSetServiceHelper.clearCache();
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)newBindBill, (String)opBizRuleId, Collections.singletonList(newTaskoprt));
        } else if (!StringUtils.isEmpty((String)oldBindBill) && StringUtils.isEmpty((String)newTaskoprt) && !StringUtils.isEmpty((String)oldTaskoprt)) {
            this.deleteOprationRuleRecords(oldBindBill);
            OpBizRuleSetServiceHelper.clearCache();
        }
    }

    private void isExistSubject() {
        IDataModel childModel = this.getView().getView(this.getPageCache().get("childrenPageId")).getModel();
        if (!" ".equals(childModel.getValue("tasksubjectid"))) {
            Long tasksubjectid = Long.valueOf(childModel.getValue("tasksubjectid") + "");
            QFilter filter = new QFilter("id", "=", (Object)tasksubjectid);
            DeleteServiceHelper.delete((String)"task_tasksubject", (QFilter[])filter.toArray());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BaseView view = (BaseView)e.getSource();
        String save = this.getPageCache().get("save");
        if (!(view.getStatus() != OperationStatus.EDIT && view.getStatus() != OperationStatus.VIEW || null != save && !"unloadChildModel".equals(save))) {
            if (view.getFormShowParameter().getCustomParam("isExistParTaskOnProcessing") != null) {
                this.openShowTaskCreateRule(0, null, Boolean.TRUE);
                this.viewControl((IFormView)view);
                this.getPageCache().put("isExistParTaskOnProcessing", "true");
                if (null == save) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u5b58\u5728\u6b63\u5728\u6d41\u8f6c\u7684\u591a\u7ea7\u4efb\u52a1\uff0c\u4efb\u52a1\u76f8\u5173\u5c5e\u6027\u4e0d\u80fd\u4fee\u6539\uff0c\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u5148\u5c06\u5728\u6d41\u8f6c\u7684\u4efb\u52a1\u5ba1\u6279\u5b8c\u6210\u3002", (String)"TaskRuleEditPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.openShowTaskCreateRule(0, null, Boolean.FALSE);
                this.viewNotControl((IFormView)view);
                this.getPageCache().remove("isExistParTaskOnProcessing");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject ssccenter;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Object useorg = this.getView().getFormShowParameter().getCustomParam("useorg");
        if (useorg != null && StringUtils.isNotEmpty((String)(useorg + ""))) {
            model.setValue("ssccenter", useorg);
        }
        if ((ssccenter = (DynamicObject)model.getValue("ssccenter")) != null) {
            long ssccenterId = ssccenter.getLong("id");
            List orgIds = OrgRelationQueryHelper.getFromOrgListFilterDutyScope((long)ssccenterId, (boolean)true);
            model.setValue("sscbillorgpar", (Object)orgIds.toArray());
            String sscType = DutyManageDataHelper.getSSCType((long)ssccenterId);
            if (SSCTypeEnum.HR.getValue().equals(sscType)) {
                model.setValue("isuseimage", (Object)false);
                model.setValue("isneedimage", (Object)false);
                model.setValue("isneedvoucher", (Object)false);
            } else {
                model.setValue("isuseimage", (Object)true);
            }
        } else {
            log.info(TaskRuleEditPlugin.class + "\u5f02\u5e38\uff1a\u4e1a\u52a1\u5355\u636e\u65b0\u589e\u5171\u4eab\u4e2d\u5fc3\u6ca1\u6709\u9ed8\u8ba4\u503c");
        }
        String userLang = ResManager.getLanguage();
        this.getModel().setValue("uselang", (Object)userLang);
        this.openShowTaskCreateRule(0, null, Boolean.FALSE);
        this.iniChildModel();
        model.batchCreateNewEntryRow("entryentityfield", 2);
        int currentIndex = 0;
        model.setValue("fieldconfiguration", (Object)TaskFieldConfigEnum.ORG.getFieldKey(), currentIndex);
        model.setValue("fieldconfiguration", (Object)TaskFieldConfigEnum.APPLIER.getFieldKey(), ++currentIndex);
        this.getPageCache().put("sourceBillIsChanged", "false");
        Label msgLabel = (Label)this.getView().getControl("msglabel");
        String tipsContent = ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u591a\u7ea7\u4efb\u52a1\u7684\u9ed8\u8ba4\u521b\u5efa\u6a21\u5f0f\u4e3a\u5de5\u4f5c\u6d41\uff08\u5373\u5728\u5de5\u4f5c\u6d41\u4e2d\u914d\u7f6e\u591a\u4e2a\u5171\u4eab\u5ba1\u6838\u8282\u70b9\uff0c\u4e1a\u52a1\u5355\u636e\u4e2d\u4e0d\u80fd\u8bbe\u7f6e\u591a\u7ea7\u4efb\u52a1\uff09\uff0c\u5982\u9700\u5728\u4e1a\u52a1\u5355\u636e\u4e2d\u8bbe\u7f6e\u591a\u7ea7\u4efb\u52a1\uff08\u5373\u5728\u5de5\u4f5c\u6d41\u4e2d\u4ec5\u914d\u7f6e1\u4e2a\u5171\u4eab\u5ba1\u6838\u8282\u70b9\uff0c\u4e1a\u52a1\u5355\u636e\u4e2d\u914d\u7f6e\u591a\u7ea7\u4efb\u52a1\uff09\uff0c\u8bf7", (String)"TaskRuleEditPlugin_23", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        msgLabel.setText(tipsContent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("bindbill".equals(propName)) {
            Boolean cancelPropertyChanged = Boolean.FALSE;
            String cancelProStr = pageCache.get("cancelChanged");
            if (StringUtils.isNotEmpty((String)cancelProStr)) {
                cancelPropertyChanged = Boolean.valueOf(cancelProStr);
            }
            if (newValue == null) {
                log.info(((Object)((Object)this)).getClass() + ".propertyChanged: newValue\u4e3anull");
                return;
            }
            String bindbill = ((DynamicObject)newValue).getString("number");
            BillEntityType dataEntityType = this.getDataEntityType(bindbill);
            if (dataEntityType == null) {
                pageCache.put("cancelChanged", "true");
                return;
            }
            MainOrgProp mainOrg = dataEntityType.getMainOrgProperty();
            this.setFiledMapEntry(model, mainOrg);
            Boolean soureBillIsChanged = Boolean.TRUE;
            String srceBillChangedStr = pageCache.get("sourceBillIsChanged");
            if (StringUtils.isNotEmpty((String)srceBillChangedStr)) {
                soureBillIsChanged = Boolean.valueOf(srceBillChangedStr);
            }
            if (!soureBillIsChanged.booleanValue()) {
                pageCache.put("sourceBillIsChanged", "true");
                return;
            }
            if (cancelPropertyChanged.booleanValue()) {
                pageCache.put("cancelChanged", "false");
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACKID_SOURCE_CHANGED, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u6765\u6e90\u5355\u636e\u5c06\u6e05\u9664\u6240\u6709\u4efb\u52a1\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"TaskRuleEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            String customValue = "";
            if (oldValue instanceof DynamicObject) {
                customValue = ((DynamicObject)oldValue).getPkValue() + "";
            }
            this.getView().showConfirm(confirmTip, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, customValue);
        } else if ("isneedvoucher".equals(propName)) {
            this.linkageChangeIsVoucherHandler(newValue);
            IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
            String createTaskModel = (String)model.getValue("createtaskmodel");
            childView.setVisible((Boolean)newValue, new String[]{"flexpanelap7"});
            childView.setVisible(Boolean.valueOf((Boolean)newValue != false && Objects.equals(createTaskModel, "1")), new String[]{"isdelvoucher"});
            childView.setVisible((Boolean)newValue, new String[]{"isvoucherhandler"});
            this.getView().sendFormAction(childView);
        } else if ("createtaskmodel".equals(propName)) {
            this.createTaskModelChanged(newValue);
        }
    }

    private void openShowTaskCreateRule(int parentEntryIndex, OperationStatus state, Boolean control) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("task_taskbill_child");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap");
        long childpkid = Long.parseLong(this.getModel().getValue("childpkid", parentEntryIndex) + "");
        if (childpkid != 0L) {
            parameter.setPkId((Object)childpkid);
            if (state != null) {
                parameter.setStatus(state);
            } else {
                parameter.setStatus(OperationStatus.EDIT);
            }
        } else {
            parameter.setStatus(OperationStatus.ADDNEW);
        }
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
            parameter.setStatus(OperationStatus.VIEW);
        }
        parameter.setCustomParam("parentEntryIndex", (Object)parentEntryIndex);
        parameter.setCustomParam("itemControl", (Object)control);
        this.getPageCache().put("currentIndex", parentEntryIndex + "");
        this.getPageCache().put("childrenPageId", parameter.getPageId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void validateErrorInFo(OperationResult isSuccess) {
        StringBuilder sb = new StringBuilder();
        List errorListValidate = isSuccess.getValidateResult().getValidateErrors();
        for (int i = 0; i < errorListValidate.size(); ++i) {
            ValidateResult validateResult = (ValidateResult)errorListValidate.get(i);
            List errorInfoList = validateResult.getAllErrorInfo();
            for (int j = 0; j < errorInfoList.size(); ++j) {
                sb.append(((OperateErrorInfo)errorInfoList.get(j)).getMessage()).append('\n');
            }
        }
        this.getView().showTipNotification(sb.toString().trim(), Integer.valueOf(3000));
    }

    private void closePage() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageId", this.getPageCache().get("childrenPageId"));
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", paramMap);
    }

    private OperationResult invokeBillOperation() {
        log.info("this.getPageCache().get(\"childrenPageId\")  :" + this.getPageCache().get("childrenPageId"));
        IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("isshowmessage", "false");
        OperationResult operationResult = childView.invokeOperation("save", option);
        if (operationResult.isSuccess()) {
            childView.getModel().updateCache();
            this.getView().sendFormAction(childView);
        }
        return operationResult;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "newentry".equals(((AbstractOperate)args.getSource()).getOperateKey())) {
            BaseView view = (BaseView)this.getView();
            if (view.getStatus().equals((Object)OperationStatus.VIEW)) {
                args.cancel = true;
            } else {
                if (!this.savedAsPartask(true) || !this.checkEntryentitylevel()) {
                    args.cancel = true;
                    return;
                }
                this.saveAndValidate(args);
            }
        } else if (args.getSource().getClass().getTypeName().equals("kd.bos.entity.operate.Save")) {
            IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
            IDataModel childModel = childView.getModel();
            if (!childModel.isDataLoaded()) {
                this.getPageCache().put("save", "unloadChildModel");
                return;
            }
            boolean canBeSaved = false;
            try {
                canBeSaved = this.canBeSaveAsPartask(false);
            }
            catch (Throwable e) {
                KDException kdException;
                if (e instanceof KDException && "taskType".equals((kdException = (KDException)e).getErrorCode().getCode())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u5f55\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u4efb\u52a1\u7c7b\u578b\u3002", (String)"TaskRuleEditPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
                log.warn("\u591a\u7ea7\u4efb\u52a1\u6821\u9a8c", e);
            }
            if (!canBeSaved) {
                args.setCancel(true);
                return;
            }
            OperationResult isSuccess = this.invokeBillOperation();
            if (!isSuccess.isSuccess()) {
                this.validateErrorInFo(isSuccess);
                args.cancel = true;
                return;
            }
            Long childPkId = (Long)isSuccess.getSuccessPkIds().get(0);
            int entryIndex = Integer.parseInt(this.getPageCache().get("currentIndex"));
            this.getModel().setValue("childpkid", (Object)childPkId, entryIndex);
            HashMap<String, String> repTaskTypes = this.checkRepeatabilityOfEntryProp("entryentity", "tasktype.id");
            if (repTaskTypes.size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4efb\u52a1\u5206\u5f55\uff1a%s\u884c\u7684\u4efb\u52a1\u7c7b\u578b\u76f8\u540c\u3002", (String)"TaskRuleEditPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", repTaskTypes.values())));
                args.cancel = true;
                return;
            }
            String createTaskModel = (String)this.getView().getModel().getValue("createtaskmodel");
            if ("1".equals(createTaskModel)) {
                boolean confirmedTaskLevel = "true".equals(this.getPageCache().get(CACHE_CONFIRM_SAME_TASKLEVEL));
                if (confirmedTaskLevel) {
                    this.getPageCache().remove(CACHE_CONFIRM_SAME_TASKLEVEL);
                } else {
                    HashMap<String, String> repTaskLevels = this.checkRepeatabilityOfEntryProp("entryentity", "tasktype.tasklevel");
                    if (repTaskLevels.size() > 0) {
                        String confirmMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u914d\u7f6e\u4e86\u591a\u4e2a\u76f8\u540c\u4efb\u52a1\u7ea7\u6b21\uff08\u4efb\u52a1\u7ea7\u6b21\u4e3a%s\uff09\u7684\u4efb\u52a1\u7c7b\u578b\uff0c\u5982\u679c\u5de5\u4f5c\u6d41\u4e2d\u6709\u591a\u4e2a\u8be5\u4efb\u52a1\u7ea7\u6b21\u7684\u5171\u4eab\u5ba1\u6838\u8282\u70b9\uff0c\u4f1a\u91cd\u590d\u521b\u5efa\u5171\u4eab\u4efb\u52a1\uff0c\u662f\u5426\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"TaskRuleEditPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), repTaskLevels.keySet());
                        this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_REPETITION_TASKLEVEL, (IFormPlugin)this));
                        args.cancel = true;
                        return;
                    }
                }
            }
            this.getPageCache().put("save", "save");
        }
    }

    private boolean saveAndValidate(BeforeDoOperationEventArgs args) {
        OperationResult isSuccess = this.invokeBillOperation();
        if (!isSuccess.isSuccess()) {
            this.validateErrorInFo(isSuccess);
            args.cancel = true;
            return false;
        }
        Long childPkId = (Long)isSuccess.getSuccessPkIds().get(0);
        this.setChildPkId(childPkId);
        this.closePage();
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof AbstractOperate && "newentry".equals(((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
            DynamicObjectCollection entryCount = this.getModel().getEntryEntity("entryentity");
            int parentEntryIndex = entryCount.size() - 1;
            this.openShowTaskCreateRule(parentEntryIndex, null, Boolean.FALSE);
        } else if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entryInfos = (DynamicObjectCollection)model.getValue("entryentity");
            ArrayList<Long> childPkIds = new ArrayList<Long>(2);
            for (DynamicObject entry : entryInfos) {
                childPkIds.add(entry.getLong("childpkid"));
            }
            Object billTypeId = model.getValue("id");
            Object sscId = ((DynamicObject)model.getValue("ssccenter")).get("id");
            if (this.isParTaskAfterSave()) {
                ParTaskFlowAnaFromBill.saveParTaskFlowDef((Object)sscId, (Object)billTypeId, childPkIds);
                this.autoSetNextTaskType(childPkIds);
            } else {
                this.clearNextTaskField(childPkIds);
                this.deleteParTaskDef(sscId, billTypeId);
            }
            Long pkId = (Long)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0);
            this.billUpdateAndLockField(pkId);
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("task_del".equals(operateKey)) {
            this.deleteTask();
        }
    }

    private void deleteTask() {
        BaseView view = (BaseView)this.getView();
        if (!this.canBeDeleted()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5b58\u5728\u540e\u7f6e\u4efb\u52a1,\u8bf7\u5148\u5220\u9664\u3002", (String)"TaskRuleEditPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        if (!view.getStatus().equals((Object)OperationStatus.VIEW)) {
            Long childpkid;
            String currentIndex = pageCache.get("currentIndex");
            int index = Integer.parseInt(currentIndex);
            int count = model.getEntryRowCount("entryentity");
            this.closePage();
            if (model.getValue("childpkid", index) != null && (childpkid = Long.valueOf(model.getValue("childpkid", index) + "")) == 0L) {
                this.isExistSubject();
            }
            model.deleteEntryRow("entryentity", index);
            if (count != 1) {
                this.openShowTaskCreateRule(0, null, Boolean.FALSE);
            } else {
                model.createNewEntryRow("entryentity");
                this.openShowTaskCreateRule(0, null, Boolean.FALSE);
            }
        }
    }

    private void billUpdateAndLockField(Long pkId) {
        this.billStatusUpdate(pkId);
        this.lockSourceBillField();
    }

    private void billStatusUpdate(Long pkId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"task_taskbill", (String)"id,status");
        bill.set("status", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private void lockSourceBillField() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"bindbill"});
    }

    private void deleteParTaskDef(Object sscId, Object billTypeId) {
        new ParTaskFlowServiceImpl().deleteAllDef(sscId, billTypeId);
    }

    private void clearNextTaskField(List<Long> childPkIds) {
        DynamicObject[] qryResult;
        String selectField = "nexttasks";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", childPkIds)};
        for (DynamicObject dyo : qryResult = BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)selectField, (QFilter[])qFilters)) {
            dyo.set("nexttasks", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])qryResult);
        this.getView().updateView();
        this.openShowTaskCreateRule(0, null, Boolean.FALSE);
    }

    private void setChildPkId(Long childPkId) {
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("childpkid", (Object)childPkId, index);
        this.getModel().updateCache();
    }

    public DynamicObject queryCoefficients(Object billtypeId) {
        QFilter h = new QFilter("basetype", "=", billtypeId);
        DynamicObjectCollection resultcollection = QueryServiceHelper.query((String)"task_taskquantcoefficient", (String)"id", (QFilter[])new QFilter[]{h});
        if (resultcollection == null || resultcollection.size() == 0) {
            return null;
        }
        DynamicObject opinionDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)resultcollection.get(0)).getLong("id"), (String)"task_taskquantcoefficient");
        return opinionDy;
    }

    public DynamicObject queryTaskOpinion(Object billtypeId, Object tasktypeId) {
        ORM orm = ORM.create();
        QFilter h = new QFilter("basetype", "=", billtypeId);
        QFilter j = new QFilter("opiniontypeentry.tasktype", "=", tasktypeId);
        DynamicObject opinionDy = orm.queryOne("task_dealopinionsopen", new QFilter[]{h, j});
        return opinionDy;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        Object sscObj = this.getModel().getValue("ssccenter_id");
        if ("sscbillorgpar".equals(key)) {
            OrgF7ViewShowHelper.beforeF7Select((BeforeF7SelectEvent)e, (Long)((Long)sscObj));
        } else if ("bindbill".equals(key)) {
            QFilter typeFilter = new QFilter("modeltype", "in", Arrays.asList("BillFormModel", "BaseFormModel"));
            qFilters.add(typeFilter);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5217\u8868", (String)"TaskRuleEditPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if ("group".equals(key)) {
            QFilter sscFilter = new QFilter("ssccenter", "=", sscObj);
            showParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(sscFilter));
            qFilters.add(sscFilter);
        } else if ("taskpool".equals(key)) {
            DynamicObject bindbill = (DynamicObject)this.getModel().getValue("bindbill_new");
            if (bindbill != null) {
                Object id = bindbill.getPkValue();
                qFilters.add(new QFilter("bill_new.FBasedataId", "=", id));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6765\u6e90\u5355\u636e\u3002", (String)"TaskRuleEditPlugin_25", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("bindbill_new".equals(key)) {
            String longNumber;
            Long sscId;
            List bindBillList;
            QFilter typeFilter = new QFilter("modeltype", "in", Arrays.asList("BillFormModel", "BaseFormModel"));
            qFilters.add(typeFilter);
            DynamicObject groupDo = (DynamicObject)this.getModel().getValue("group");
            if (groupDo != null && CollectionUtils.isNotEmpty((Collection)(bindBillList = TaskBillClassifyHelper.getAllUpBindBillByClassify((Long)(sscId = Long.valueOf(((DynamicObject)this.getModel().getValue("ssccenter")).getLong("id"))), (String)(longNumber = groupDo.getString("longnumber")))))) {
                QFilter idFilter = new QFilter("id", "in", (Object)bindBillList);
                qFilters.add(idFilter);
            }
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        BasedataEdit baseData = (BasedataEdit)event.getSource();
        String key = baseData.getKey();
        FormShowParameter showParameter = event.getShowParameter();
        if ("externalerp".equals(key)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
    }

    private boolean isParTask(List<DynamicObject> taskInfo) {
        return !this.getParTaskFormBillChild(taskInfo).isEmpty();
    }

    private boolean isParTaskAfterSave() {
        IDataModel model = this.getModel();
        DynamicObjectCollection taskInfo = model.getEntryEntity("entryentity");
        ArrayList<Long> childPkIds = new ArrayList<Long>(taskInfo.size());
        for (DynamicObject dyo : taskInfo) {
            childPkIds.add(dyo.getLong("childpkid"));
        }
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "in", childPkIds)};
        DynamicObjectCollection qryResult = QueryServiceHelper.query((String)"task_taskbill_child", (String)"taskoriginal", (QFilter[])qfilters);
        for (DynamicObject dyo : qryResult) {
            if (!"2".equals(dyo.getString("taskoriginal"))) continue;
            return true;
        }
        return false;
    }

    private List<DynamicObject> getParTaskFormBillChild(List<DynamicObject> taskInfo) {
        ArrayList<DynamicObject> parTaskList = new ArrayList<DynamicObject>(4);
        for (DynamicObject taskInfoDyn : taskInfo) {
            String taskSource = taskInfoDyn.getString("taskoriginal");
            if (!"2".equals(taskSource)) continue;
            parTaskList.add(taskInfoDyn.getDynamicObject("tasktype"));
        }
        return parTaskList;
    }

    private List<DynamicObject> getTaskFromBillChild(DynamicObjectCollection entryInfo, Long removeChildPkId, boolean unEdit) throws Exception {
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(4);
        ArrayList<Long> childPkIds = new ArrayList<Long>(entryInfo.size());
        for (DynamicObject dyo : entryInfo) {
            Long childPkId = dyo.getLong("childpkid");
            if (childPkId.equals(0L) && !unEdit) {
                DynamicObject addnew = this.getAlterTaskInfo();
                taskList.add(addnew);
                continue;
            }
            childPkIds.add(childPkId);
        }
        if (childPkIds.contains(removeChildPkId)) {
            childPkIds.remove(removeChildPkId);
            DynamicObject addnew = this.getAlterTaskInfo();
            taskList.add(addnew);
        }
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "in", childPkIds)};
        DynamicObject[] qryResult = BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)"tasktype,taskoriginal,pretasks", (QFilter[])qfilters);
        taskList.addAll(Arrays.asList(qryResult));
        return taskList;
    }

    private DynamicObject getAlterTaskInfo() {
        IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
        IDataModel childModel = childView.getModel();
        Object taskType = childModel.getValue("tasktype");
        Object taskSource = childModel.getValue("taskoriginal");
        Object preTasks = childModel.getValue("pretasks");
        Object isVoucherHandler = childModel.getValue("isvoucherhandler");
        if (taskType == null) {
            throw new KDException(new ErrorCode("taskType", "exception"), new Object[0]);
        }
        DynamicObject addnew = BusinessDataServiceHelper.newDynamicObject((String)"task_taskbill_child");
        addnew.set("tasktype", taskType);
        addnew.set("taskoriginal", taskSource);
        addnew.set("pretasks", preTasks);
        addnew.set("isvoucherhandler", isVoucherHandler);
        return addnew;
    }

    private boolean checkEntryentitylevel() {
        IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
        IDataModel childModel = childView.getModel();
        DynamicObjectCollection objects = childModel.getEntryEntity("entryentitylevel");
        if (null == objects || objects.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9ed8\u8ba4\u4f18\u5148\u7ea7\u3002", (String)"TaskRuleChildSaveValidatorPlugin_18", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return false;
        }
        int defaultNum = 0;
        for (DynamicObject obj : objects) {
            boolean isdefault = obj.getBoolean("isdefault");
            if (!isdefault) continue;
            ++defaultNum;
        }
        if (defaultNum == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9ed8\u8ba4\u4f18\u5148\u7ea7\u3002", (String)"TaskRuleChildSaveValidatorPlugin_18", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (defaultNum > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8bbe\u7f6e\u4e00\u6761\u9ed8\u8ba4\u4f18\u5148\u7ea7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskRuleChildSaveValidatorPlugin_19", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void deleteOprationRuleRecords(String billnumber) {
        for (OpreationRuleEnum ruleEnum : OpreationRuleEnum.values()) {
            String opBizRule = ruleEnum.getValue();
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)billnumber, (String)opBizRule);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CALLBACKID_SOURCE_CHANGED.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.clearEntrys();
                this.getModel().setValue("taskpool", null);
                this.getModel().setValue("applycond", null);
            } else {
                this.getPageCache().put("cancelChanged", "true");
                String customValue = event.getCustomVaule();
                if (StringUtils.isNotEmpty((String)customValue) && !"null".equals(customValue)) {
                    this.getModel().setValue("bindbill", (Object)customValue);
                } else {
                    this.getModel().setValue("bindbill", null);
                }
            }
        } else if (CALLBACKID_FORM_CHANGED.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.clearEntrys();
            }
        } else if (CALLBACKID_REPETITION_TASKLEVEL.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(CACHE_CONFIRM_SAME_TASKLEVEL, "true");
            OperationResult result = this.getView().invokeOperation("save");
            if (!result.isSuccess() && StringUtils.isNotEmpty((String)result.getMessage())) {
                this.getView().showErrorNotification(result.getMessage());
            }
        }
    }

    private void clearEntrys() {
        IDataModel dataModel = this.getModel();
        int entryCount = dataModel.getEntryRowCount("entryentity");
        int[] rowIndex = new int[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            rowIndex[i] = i;
        }
        dataModel.deleteEntryRows("entryentity", rowIndex);
        dataModel.createNewEntryRow("entryentity");
        this.openShowTaskCreateRule(0, null, Boolean.FALSE);
        this.iniChildModel();
    }

    private void autoSetNextTaskType(List<Long> childPkIds) {
        String selectField = "tasktype,pretasks,nexttasks";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", childPkIds), new QFilter("taskoriginal", "<=", (Object)"2")};
        DynamicObject[] qryResult = BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)selectField, (QFilter[])qFilters);
        HashMap<String, ParTaskFlowNodeMeta> defMap = new HashMap<String, ParTaskFlowNodeMeta>(4);
        this.getParTaskFlowByEntryInfo(defMap, Arrays.asList(qryResult));
        for (DynamicObject dyo : qryResult) {
            String taskTypeName = dyo.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue();
            ParTaskFlowNodeMeta mapValue = (ParTaskFlowNodeMeta)defMap.get(taskTypeName);
            if (mapValue == null) {
                dyo.set("nexttasks", (Object)"");
                continue;
            }
            List nextTaskList = mapValue.getChildNodeIdList();
            if (nextTaskList == null || nextTaskList.isEmpty()) {
                dyo.set("nexttasks", (Object)"");
                continue;
            }
            String nextTasks = this.getNextTasks(nextTaskList);
            dyo.set("nexttasks", (Object)nextTasks);
        }
        SaveServiceHelper.save((DynamicObject[])qryResult);
        this.getView().updateView();
        this.openShowTaskCreateRule(0, null, Boolean.FALSE);
    }

    private String getNextTasks(List<String> nextTaskList) {
        StringBuilder strBuilder = new StringBuilder();
        int i = 0;
        for (String nextTask : nextTaskList) {
            if (i > 0) {
                strBuilder.append(',');
            }
            strBuilder.append(nextTask);
            ++i;
        }
        return strBuilder.toString();
    }

    private void iniChildModel() {
        String pageId = this.getPageCache().get("childrenPageId");
        if (StringUtils.isNotEmpty((String)pageId)) {
            IFormView childView = this.getView().getView(pageId);
            IDataModel childModel = childView.getModel();
            childModel.beginInit();
            childModel.createNewData();
            childModel.endInit();
            childModel.updateCache();
        }
    }

    private List<String> getTaskName(List<DynamicObject> parTaskList) {
        ArrayList<String> parTaskNaemList = new ArrayList<String>(4);
        for (DynamicObject parTask : parTaskList) {
            String parTaskName = parTask.getLocaleString("name").getLocaleValue();
            parTaskNaemList.add(parTaskName);
        }
        return parTaskNaemList;
    }

    private BillEntityType getDataEntityType(String entityNumber) {
        BillEntityType entityType = null;
        try {
            entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception e) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%s\u3002", (String)"TaskRuleEditPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage());
            this.getView().showErrorNotification(errorInfo);
            log.error(((Object)((Object)this)).getClass() + ".getDataEntityType: " + e);
        }
        return entityType;
    }

    private void setFiledMapEntry(IDataModel model, MainOrgProp mainOrg) {
        int rowCount = model.getEntryRowCount("entryentityfield");
        if (mainOrg == null) {
            log.info(((Object)((Object)this)).getClass() + ".setFiledMapEntry\uff0c\u83b7\u53d6\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3anull");
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            String fieldConfig = (String)model.getValue("fieldconfiguration", i);
            if (TaskFieldConfigEnum.ORG.getFieldKey().equals(fieldConfig)) {
                model.setValue("sourcefieldname", (Object)mainOrg.getDisplayName(), i);
                model.setValue("sourcefieldnumber", (Object)mainOrg.getName(), i);
                continue;
            }
            model.setValue("sourcefieldname", null, i);
        }
    }

    private void viewControl(IFormView view) {
        this.itemControl(Boolean.FALSE, view);
    }

    private void viewNotControl(IFormView view) {
        this.itemControl(Boolean.TRUE, view);
    }

    private void itemControl(Boolean enable, IFormView view) {
        view.setEnable(enable, new String[]{"externalerp"});
        view.setEnable(enable, new String[]{"cardentryfixrowap"});
    }

    private void linkageChangeIsVoucherHandler(Object changeData) {
        if (!Boolean.parseBoolean(changeData.toString())) {
            DynamicObject[] needChangeDatas;
            IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
            IDataModel childModel = childView.getModel();
            if (!childModel.isDataLoaded()) {
                return;
            }
            childModel.setValue("isvoucherhandler", (Object)Boolean.FALSE);
            for (DynamicObject item : needChangeDatas = this.getOtherChildEntries()) {
                item.set("isvoucherhandler", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.update((DynamicObject[])needChangeDatas);
        }
    }

    private DynamicObject[] getOtherChildEntries() {
        int currentIndex = Integer.parseInt(this.getPageCache().get("currentIndex"));
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> otherChildPkIds = new ArrayList<Long>();
        for (int i = 0; i < entries.size(); ++i) {
            if (i == currentIndex) continue;
            otherChildPkIds.add(((DynamicObject)entries.get(i)).getLong("childpkid"));
        }
        QFilter filter1 = new QFilter("id", "in", otherChildPkIds);
        QFilter filter2 = new QFilter("isvoucherhandler", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)"id,isvoucherhandler", (QFilter[])new QFilter[]{filter1, filter2});
    }

    private HashMap<String, String> checkRepeatabilityOfEntryProp(String entryKey, String propKey) {
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(entryKey);
        HashMap<String, String> firstTouchPropValues = new HashMap<String, String>();
        HashMap<String, String> repPropValues = new HashMap<String, String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject row = (DynamicObject)entryCol.get(i);
            String propValue = row.getString(propKey);
            if (firstTouchPropValues.containsKey(propValue)) {
                String cellIndexStr = ", " + i + "]";
                String indexStr = repPropValues.containsKey(propValue) ? repPropValues.get(propValue).replace("]", cellIndexStr) : "[" + (String)firstTouchPropValues.get(propValue) + cellIndexStr;
                repPropValues.put(propValue, indexStr);
                continue;
            }
            firstTouchPropValues.put(propValue, String.valueOf(i));
        }
        return repPropValues;
    }

    private void createTaskModelChanged(Object newValue) {
        if (newValue == null) {
            return;
        }
        boolean sscCreateTaskModel = "0".equals(newValue.toString());
        IFormView childView = this.getView().getView(this.getPageCache().get("childrenPageId"));
        IDataModel childModel = childView.getModel();
        ComboEdit taskoriComboEdit = (ComboEdit)childView.getControl("taskoriginal");
        ComboProp taskOriComboProp = (ComboProp)childModel.getProperty("taskoriginal");
        childModel.setValue("parentcreatetaskmodel", newValue);
        List vmItems = taskOriComboProp.getComboItems();
        ArrayList<ComboItem> cbItems = new ArrayList<ComboItem>(vmItems.size());
        for (ValueMapItem vmItem : vmItems) {
            if (sscCreateTaskModel && "3".contains(vmItem.getValue())) continue;
            ComboItem cbItem = new ComboItem();
            cbItem.setValue(vmItem.getValue());
            cbItem.setCaption(vmItem.getName());
            cbItem.setItemVisible(vmItem.isItemVisible());
            cbItems.add(cbItem);
        }
        taskoriComboEdit.setComboItems(cbItems);
        childView.setVisible(Boolean.valueOf(sscCreateTaskModel), new String[]{"nexttasks"});
        if (sscCreateTaskModel) {
            childView.setVisible(Boolean.FALSE, new String[]{"isdelvoucher"});
        }
        this.getView().sendFormAction(childView);
    }
}

