/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.SerializeUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaskTreeListPlugin
extends AbstractTreeListPlugin
implements TabSelectListener,
TreeNodeClickListener {
    private static final Log LOG = LogFactory.getLog(TaskTreeListPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.extracted(tabKey);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.getItems().forEach(p -> this.getPageCache().remove(p.getKey()));
        String currentTab = tabap.getCurrentTab();
        this.showTabNameWithTaskCount();
        this.extracted(currentTab);
    }

    private void extracted(String tabKey) {
        Task action = this.getTask();
        if (this.checkWhetherLoadData()) {
            switch (tabKey) {
                case "wait": {
                    this.loadListData(tabKey, action::process);
                    break;
                }
                case "done": {
                    this.loadListData(tabKey, action::done);
                    break;
                }
                default: {
                    throw new KDBizException("choose a error tab ");
                }
            }
        }
    }

    private Task getTask() {
        Task action;
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode == null || "0".equals(focusNode.get("id"))) {
            action = new Task();
        } else if ("zjrw".equals(focusNode.get("id"))) {
            action = new ZJTask();
        } else if ("gxrw".equals(focusNode.get("id"))) {
            action = new SDTask(null, null);
        } else if (((Boolean)focusNode.get("isParent")).booleanValue()) {
            String id = (String)focusNode.get("id");
            action = new SDTask(null, Long.parseLong(id));
        } else {
            String id = (String)focusNode.get("id");
            action = new SDTask(Long.parseLong(id), null);
        }
        return action;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setSSCid();
        this.addTreeList();
        this.showDefaultTableList();
    }

    private void setSSCid() {
        this.getModel().setValue("sscid", (Object)100000L);
    }

    private void showDefaultTableList() {
        Task action = new Task();
        this.showTabNameWithTaskCount();
        this.loadListData("wait", action::process);
    }

    private void showTabNameWithTaskCount() {
        Long sscid;
        Tab tabap = (Tab)this.getControl("tabap");
        Task task = this.getTask();
        int doneTaskCount = task.getDoneTaskCount(new QFilter("sscid", "=", (Object)(sscid = (Long)this.getModel().getValue("sscid_id"))));
        if (doneTaskCount > 0) {
            tabap.updateTabName("done", String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"TaskTreeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), doneTaskCount));
        }
        String treeNodeSerializeCache = this.getPageCache().get("treeNodeSerializeCache");
        TreeNode treeNode = (TreeNode)SerializeUtil.deserialize((String)treeNodeSerializeCache, TreeNode.class);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Map focusNode = treeView.getTreeState().getFocusNode();
        String label = null;
        TreeNode treeNode1 = focusNode == null ? treeNode : treeNode.getTreeNode((String)focusNode.get("id"));
        List labelPara = treeNode1.getLabelPara();
        if (labelPara != null && !labelPara.isEmpty()) {
            label = (String)((Map)labelPara.get(0)).get("label");
        }
        if (label != null) {
            tabap.updateTabName("wait", String.format(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\uff08%s\uff09", (String)"TaskTreeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), label));
        }
    }

    private void loadListData(String tabkey, Consumer<ListShowParameter> consumer) {
        String tabkeyList = tabkey + "list";
        Long sscid = (Long)this.getModel().getValue("sscid_id");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setTargetKey(tabkeyList);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getListFilterParameter().setFilter(new QFilter("sscid", "=", (Object)sscid));
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("100%");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setShowTitle(false);
        consumer.accept(listShowParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
        this.getPageCache().put(tabkey, "1");
    }

    private boolean checkWhetherLoadData() {
        Tab tabap = (Tab)this.getControl("tabap");
        String currentTab = tabap.getCurrentTab();
        String tabapCache = this.getPageCache().get(currentTab);
        return tabapCache == null;
    }

    private void addTreeList() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaskTreeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), (Object)"allData");
        TreeNode zjnode = new TreeNode("0", "zjrw", ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1", (String)"TaskTreeListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), (Object)"allData");
        TreeNode gxnode = new TreeNode("0", "gxrw", ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1", (String)"TaskTreeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), (Object)"allData");
        Long sscid = (Long)this.getModel().getValue("sscid_id");
        List<TreeNode> zjtreeNodes = this.getZjTreeNode(sscid);
        List<TreeNode> gxtreeNodes = this.getGxTreeNode(sscid);
        gxnode.addChildren(gxtreeNodes);
        root.addChild(gxnode);
        TreeNodeLabel label = new TreeNodeLabel();
        label.setLabel(String.valueOf(gxtreeNodes.size()));
        ArrayList<TreeNodeLabel> labels = new ArrayList<TreeNodeLabel>();
        labels.add(label);
        root.setLabelPara(labels);
        root.setLabelShowType(1);
        String treeNodeSerialize = SerializeUtil.serialize((Object)root);
        this.getPageCache().put("treeNodeSerializeCache", treeNodeSerialize);
        treeView.addNode(root);
        treeView.setRootVisible(true);
    }

    private List<TreeNode> getZjTreeNode(Long sscid) {
        return null;
    }

    private List<TreeNode> getGxTreeNode(long sscid) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter sscidQfilter = new QFilter("createorg", "=", (Object)sscid);
        QFilter userQfilter = new QFilter("entryentity.userfield", "=", (Object)currUserId);
        QFilter ssccenterQfilter = new QFilter("ssccenter", "=", (Object)sscid);
        try (DataSet usergroupDataSet = QueryServiceHelper.queryDataSet((String)"query_task_usergroup", (String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{sscidQfilter, userQfilter}, null);
             DataSet taskDisruleDataSet = QueryServiceHelper.queryDataSet((String)"query_task_disrule", (String)"task_disrule", (String)"entryentity1.usergroup as usergroup,entryentity.billtype.id as billtypeid,entryentity.billtype.name as billtypename", (QFilter[])new QFilter[]{ssccenterQfilter}, null);
             DataSet billtypeDataSet = taskDisruleDataSet.join(usergroupDataSet).on("usergroup", "id").select(new String[]{"billtypeid", "billtypename"}).finish().distinct();){
            while (billtypeDataSet.hasNext()) {
                Row next = billtypeDataSet.next();
                Long billtypeid = next.getLong("billtypeid");
                String billtypename = next.getString("billtypename");
                list.add(new TreeNode("gxrw", billtypeid.toString(), billtypename));
            }
        }
        return list;
    }

    private static class SDTask
    extends Task
    implements Action {
        Long billType;
        Long group;

        public SDTask(Long billType, Long group) {
            this.billType = billType;
            this.group = group;
        }

        @Override
        QFilter setFilter(QFilter extraFilter) {
            if (this.billType != null) {
                extraFilter.and(new QFilter("billtype", "=", (Object)this.billType));
            }
            if (this.group != null) {
                extraFilter.and(new QFilter("billtype", "=", (Object)this.group));
            }
            extraFilter.and(new QFilter("tasktypeid.qualityjudge", "in", (Object)new String[]{"0", "3"}));
            return extraFilter;
        }
    }

    private static class ZJTask
    extends Task {
        private ZJTask() {
        }

        @Override
        QFilter setFilter(QFilter extraFilter) {
            return extraFilter.and(new QFilter("tasktypeid.qualityjudge", "=", (Object)"1"));
        }
    }

    private static class Task
    implements Action {
        QFilter processStateFilter = new QFilter("pooltype", "in", (Object)new String[]{"0", "1", "3"});
        QFilter doneStateFilter = new QFilter("pooltype", "=", (Object)"2");

        private Task() {
        }

        QFilter setFilter(QFilter extraFilter) {
            return extraFilter;
        }

        int getDoneTaskCount(QFilter sscIdFilter) {
            QFilter qFilter = this.setFilter(this.doneStateFilter.and(sscIdFilter));
            try (DataSet distinct = QueryServiceHelper.queryDataSet((String)"getDoneTaskCount", (String)"task_taskhistory", (String)"count(1) as donecount", (QFilter[])new QFilter[]{qFilter}, null).distinct();){
                if (distinct.hasNext()) {
                    Row next = distinct.next();
                    int n = next.getInteger("donecount");
                    return n;
                }
            }
            return 0;
        }

        @Override
        public void process(ListShowParameter listShowParameter) {
            listShowParameter.setBillFormId("task_task_query");
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(this.setFilter(this.processStateFilter));
        }

        @Override
        public void done(ListShowParameter listShowParameter) {
            listShowParameter.setBillFormId("task_history_query");
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(this.setFilter(this.doneStateFilter));
        }
    }

    private static interface Action {
        public void process(ListShowParameter var1);

        public void done(ListShowParameter var1);
    }
}

