/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.formplugin.imports.TaskAbstractListPlugin;

public class TaskTypeListPlugin
extends TaskAbstractListPlugin
implements ClickListener {
    private static final String BTN_DEL = "imageap";
    private List<FilterColumn> listFilter = new ArrayList<FilterColumn>();

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_DEL});
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("number");
    }

    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        if (key.equalsIgnoreCase(BTN_DEL)) {
            this.deleteRightSingeleCrad();
        }
    }

    private void deleteRightSingeleCrad() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"TaskTypeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.listFilter = args.getFilterContainerInitEvent().getCommonFilterColumns();
        String ssc = this.getPageCache().get("sscid");
        if (ssc == null) {
            for (FilterColumn filCol : args.getCommonFilterColumns()) {
                if (!"orgfield.name".equals(filCol.getFieldName())) continue;
                List ssccenters = filCol.getDefaultValues();
                if (ssccenters.size() == 0) {
                    return;
                }
                this.getPageCache().put("sscid", (String)ssccenters.get(0));
                this.rebuildCommonFilter();
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            if ("orgfield.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                this.getPageCache().put("sscid", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
                List<String> nullFieldValues = Collections.singletonList("qualityjudge");
                CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, "orgfield.id", nullFieldValues);
            }
            this.rebuildCommonFilter();
        }
    }

    private void rebuildCommonFilter() {
        for (FilterColumn filterColumn : this.listFilter) {
            String itemValue;
            ComboItem comboItem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"qualityjudge".equals(fieldName)) continue;
            String sscId = this.getPageCache().get("sscid");
            String sscType = DutyManageDataHelper.getSSCType((long)Long.parseLong(sscId));
            List comboItemList = commonFilterColumn.getComboItems();
            Iterator iterator = comboItemList.iterator();
            if (SSCTypeEnum.HR.getValue().equals(sscType)) {
                while (iterator.hasNext()) {
                    comboItem = (ComboItem)iterator.next();
                    itemValue = comboItem.getValue();
                    if (!TaskPropertyEnum.QUACHECKTASK.getValue().equals(itemValue)) continue;
                    iterator.remove();
                }
                continue;
            }
            while (iterator.hasNext()) {
                comboItem = (ComboItem)iterator.next();
                itemValue = comboItem.getValue();
                if (!TaskPropertyEnum.HANDLE_TASK.getValue().equals(itemValue)) continue;
                iterator.remove();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String sscId = this.getPageCache().get("sscid");
        if (StringUtils.isNotEmpty((String)sscId)) {
            String sscType = DutyManageDataHelper.getSSCType((long)Long.parseLong(sscId));
            List qFilters = e.getQFilters();
            QFilter propertyFilter = null;
            propertyFilter = SSCTypeEnum.HR.getValue().equals(sscType) ? new QFilter("qualityjudge", "!=", (Object)TaskPropertyEnum.QUACHECKTASK.getValue()) : new QFilter("qualityjudge", "!=", (Object)TaskPropertyEnum.HANDLE_TASK.getValue());
            qFilters.add(propertyFilter);
        }
    }
}

