/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserGroupCardListPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
SetFilterListener {
    private static final String CACHE_USERGROUP_ID = "groupId";

    public void initialize() {
        super.initialize();
        ((BillList)this.getControl("billlistap1")).addSetFilterListener((SetFilterListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList groupList = (BillList)this.getControl("billlistap");
        groupList.clearSelection();
        groupList.selectRows(0);
        if (e.getSource() instanceof BillList) {
            BillList listView = (BillList)e.getSource();
            ListSelectedRowCollection rowColl = listView.getCurrentListAllRowCollection();
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            if (rowColl.size() <= 0) {
                splitContainer.setCollapse("splitpanelap1", true);
            } else {
                splitContainer.setCollapse("splitpanelap1", false);
            }
        }
    }

    public void listRowClick(ListRowClickEvent e) {
        super.listRowClick(e);
        String key = ((Control)e.getSource()).getKey();
        if ("billlistap".equals(key)) {
            ListSelectedRow selectedRow = e.getCurrentListSelectedRow();
            if (selectedRow == null) {
                return;
            }
            Long pkId = (Long)selectedRow.getPrimaryKeyValue();
            this.getPageCache().put(CACHE_USERGROUP_ID, String.valueOf(pkId));
            this.switchForm(this.isRobots(pkId));
            ((BillList)this.getControl("billlistap1")).refresh();
        }
    }

    private boolean isRobots(Long id) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("isrobots", "=", (Object)Character.valueOf('1'))};
        return QueryServiceHelper.exists((String)"task_usergroup", (QFilter[])qFilters);
    }

    public void setFilter(SetFilterEvent e) {
        String entityId = ((BillList)e.getSource()).getEntityId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"task_user")) {
            String id = this.getPageCache().get(CACHE_USERGROUP_ID);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                Long groupId = Long.valueOf(id);
                QFilter filter = new QFilter("groupid", "=", (Object)groupId);
                e.getQFilters().add(filter);
            } else {
                e.getQFilters().add(new QFilter("groupid", "=", (Object)0L));
            }
        }
    }

    private void switchForm(boolean robots) {
        BillList list = (BillList)this.getControl("billlistap1");
        if (robots) {
            list.changeBillFormId("task_intlgrouop_user");
        } else {
            list.changeBillFormId("task_user");
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        ((BillList)this.getControl("billlistap")).getEntryState().setSelectAllRows(true);
    }
}

