/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.userworkload.DisTaskWithUserIdHelper;
import kd.ssc.task.userworkload.TaskUserWorkLoadHelper;

public class UserWorkLoadFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(UserWorkLoadFormPlugin.class);
    private static final String INCLUDENOPERM = "includenoperm";
    private static final int BATCH_COUNT = 20;
    private Set<String> qualityPages = new HashSet<String>(Arrays.asList("task_doqualitymanagement", "task_quality_docheck"));
    private static final String MINE_GROUP_LEADER = "minegroupleader";

    public void initialize() {
        this.addClickListeners(new String[]{INCLUDENOPERM, "btok"});
        this.addItemClickListeners(new String[]{INCLUDENOPERM});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String entryfieldchange = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        Object newValue = data[0].getNewValue();
        if (entryfieldchange.equals(INCLUDENOPERM)) {
            Boolean isOpen = (Boolean)newValue;
            if (isOpen.booleanValue()) {
                this.getModel().setValue(MINE_GROUP_LEADER, (Object)Boolean.FALSE);
            }
            this.queryData(Boolean.parseBoolean(this.getView().getModel().getValue(INCLUDENOPERM).toString()), false, true);
        } else if (entryfieldchange.equals(MINE_GROUP_LEADER)) {
            Boolean isOpen = (Boolean)newValue;
            if (isOpen.booleanValue()) {
                this.getModel().setValue(INCLUDENOPERM, (Object)Boolean.FALSE);
                this.queryMineGroupLeaderData(isOpen);
            } else {
                boolean isSysAdmin = true;
                String identity = (String)this.getView().getFormShowParameter().getCustomParam("identity");
                if (!"sysadmin".equals(identity)) {
                    isSysAdmin = false;
                }
                this.queryData(false, true, isSysAdmin);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btok")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u5206\u914d\u4eba\u5458\u3002", (String)"UserWorkLoadFormPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.disToUser(selectRows);
        }
    }

    private void disToUser(int[] selectRows) {
        boolean success;
        Long userID = ((DynamicObject)this.getModel().getValue("usernum", selectRows[0])).getLong("id");
        Long userGroup = ((DynamicObject)this.getModel().getValue("usergroup", selectRows[0])).getLong("id");
        if (userID <= 0L || userGroup <= 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237ID\u4e0d\u5b58\u5728\u3002", (String)"UserWorkLoadFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (this.qualityPages.contains(parentFormId)) {
            if ("task_quality_docheck".equals(parentFormId)) {
                this.getView().returnDataToParent((Object)userID);
            } else {
                this.getView().returnDataToParent((Object)(userID + "_" + userGroup));
            }
            this.getView().close();
            return;
        }
        List taskIDs = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        if (taskIDs.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1ID\u3002", (String)"UserWorkLoadFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        int taskSize = taskIDs.size();
        Boolean includeNoPermOpen = (Boolean)this.getModel().getValue(INCLUDENOPERM);
        Boolean mineGroupLeaderOpen = (Boolean)this.getModel().getValue(MINE_GROUP_LEADER);
        if (!(taskSize != 1 || includeNoPermOpen.booleanValue() || mineGroupLeaderOpen.booleanValue() || (success = this.checkApplier((Long)taskIDs.get(0), userID)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u63d0\u81ea\u5ba1\u3002", (String)"UserWorkLoadFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taskSize < 20) {
            this.disTaskWithUserId(userID, taskIDs, this.getView(), false, userGroup);
        } else {
            this.batchProcessing(userID, taskIDs, userGroup);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("taskdis")) {
            this.queryData(false, false, true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        boolean isSysAdmin = true;
        String identity = (String)this.getView().getFormShowParameter().getCustomParam("identity");
        if (!"sysadmin".equals(identity)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INCLUDENOPERM});
            isSysAdmin = false;
        }
        this.showMineGroupLeader();
        this.queryData(false, true, isSysAdmin);
    }

    private void showMineGroupLeader() {
        HashSet<Long> manageGroupSet;
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscId = (String)taskSscList.get(0);
        Long currUserId = RequestContext.get().getCurrUserId();
        this.getModel().setValue(MINE_GROUP_LEADER, (Object)Boolean.FALSE);
        if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId)) && CollectionUtils.isNotEmpty(manageGroupSet = UserGroupUtil.getManageGroup(sscId, String.valueOf(currUserId)))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MINE_GROUP_LEADER});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{MINE_GROUP_LEADER});
    }

    private void queryData(boolean includenoperm, boolean isFromButton, boolean isSysAdmin) {
        List taskSscList;
        log.info("UserWorkLoadFormPlugin.queryData() begin\uff1a includenoperm = {}, isFromButton = {}, isSysAdmin = {}", new Object[]{includenoperm, isFromButton, isSysAdmin});
        long begin = System.currentTimeMillis();
        ArrayList<Long> errRuleDyns = new ArrayList<Long>(4);
        List<WorkerStatusPojo> gridList = this.queryGridDataByAssign(includenoperm, errRuleDyns);
        if (isFromButton && !isSysAdmin && (taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs")) != null && taskSscList.size() > 0 && gridList != null && gridList.size() > 0) {
            HashSet<Long> manageGroup = UserGroupUtil.getManageGroup((String)taskSscList.get(0), RequestContext.get().getUserId());
            Iterator<WorkerStatusPojo> iterator = gridList.iterator();
            while (iterator.hasNext()) {
                if (manageGroup.contains(iterator.next().getUserGroupId())) continue;
                iterator.remove();
            }
        }
        log.info("UserWorkLoadFormPlugin.batchCreateNewEntryRow begin");
        long begin1 = System.currentTimeMillis();
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("usernum", new Object[0]);
        vs.addField("workload", new Object[0]);
        vs.addField("usergroup", new Object[0]);
        vs.addField("workstatus", new Object[0]);
        vs.addField("ability", new Object[0]);
        if (gridList != null) {
            for (int i = gridList.size() - 1; i >= 0; --i) {
                WorkerStatusPojo girdData = gridList.get(i);
                vs.addRow(new Object[]{girdData.getUserId(), girdData.getTaskTotal(), girdData.getUserGroupId(), girdData.isPresent(), girdData.getAbilityValue()});
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        long end1 = System.currentTimeMillis();
        log.info("UserWorkLoadFormPlugin.batchCreateNewEntryRow end :{}ms", (Object)(end1 - begin1));
        this.getView().updateView("entryentity");
        if (!errRuleDyns.isEmpty()) {
            this.showWarningMsg(errRuleDyns);
        }
        long end = System.currentTimeMillis();
        log.info("UserWorkLoadFormPlugin.queryData() end :{}ms", (Object)(end - begin));
    }

    private void showWarningMsg(List<Long> errRuleDyns) {
        log.info("UserWorkLoadFormPlugin.showWarningMsg begin");
        long begin = System.currentTimeMillis();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", errRuleDyns)};
        String selectFields = "number";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"task_disrule", (String)selectFields, (QFilter[])qFilters);
        StringBuilder warningMsg = new StringBuilder();
        warningMsg.append(ResManager.loadKDString((String)"\u83b7\u53d6\u53ef\u5206\u914d\u4eba\u5458\u65f6\uff0c\u90e8\u5206\u4efb\u52a1\u5206\u914d\u89c4\u5219\u6267\u884c\u51fa\u9519\uff0c\u89c4\u5219\u7f16\u7801\u4e3a\uff1a", (String)"UserWorkLoadFormPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        for (DynamicObject dyo : dyns) {
            warningMsg.append(dyo.get("number"));
            warningMsg.append("\uff0c");
        }
        warningMsg.append(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"UserWorkLoadFormPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showTipNotification(warningMsg.toString());
        long end = System.currentTimeMillis();
        log.info("UserWorkLoadFormPlugin.showWarningMsg() end :{}ms", (Object)(end - begin));
    }

    private List<WorkerStatusPojo> queryGridDataByAssign(boolean includenoperm, List<Long> errRuleDyns) {
        List<Object> userIDList = new ArrayList(8);
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        List taskIdList = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        if (!includenoperm && taskIdList.size() == 1) {
            userIDList = this.getDisUserAndUserGroupIDSByAssign(errRuleDyns, taskSscList, taskIdList);
        } else if (includenoperm) {
            userIDList = TaskUserWorkLoadHelper.getAllUserInGroup(taskSscList);
        } else {
            return null;
        }
        TaskUserWorkLoadHelper.addUserWorklingJobLoad(userIDList);
        return userIDList;
    }

    public List<WorkerStatusPojo> getDisUserAndUserGroupIDSByAssign(List<Long> errRuleDyns, List<String> taskSscList, List<Long> taskIdList) {
        Map<Object, Object> groupId2Priority = new HashMap();
        List tIDTTypeBTypeList = (List)this.getView().getFormShowParameter().getCustomParam("taskdisParameters");
        boolean isRectification = false;
        Object rectify = this.getView().getFormShowParameter().getCustomParam("isRectification");
        if (rectify != null) {
            isRectification = (Boolean)rectify;
        }
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            groupId2Priority = TaskUserWorkLoadHelper.buildHandleGroupMapByAssignNew(errRuleDyns, taskSscList, taskIdList, tIDTTypeBTypeList, isRectification);
        } else {
            List orgIdList = (List)this.getView().getFormShowParameter().getCustomParam("orgIDList");
            groupId2Priority = TaskUserWorkLoadHelper.buildHandleGroupMapByAssign(errRuleDyns, orgIdList, taskSscList, taskIdList, tIDTTypeBTypeList);
        }
        Object isexceptrebots = this.getView().getFormShowParameter().getCustomParam("isexceptrebots");
        boolean isExceptRebots = isexceptrebots == null ? false : (Boolean)isexceptrebots;
        return TaskUserWorkLoadHelper.addUserGoupMembers(new ArrayList<Object>(groupId2Priority.keySet()), isExceptRebots);
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        this.disToUser(selectRows);
    }

    private void batchProcessing(Long userId, List<Long> taskIds, Long userGroup) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("task_allocation_progress");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customPara = parameter.getCustomParams();
        customPara.put("userid", userId);
        customPara.put("taskids", SerializationUtils.toJsonString(taskIds));
        customPara.put("batchcount", 20);
        customPara.put("usergroup", userGroup);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batchAllocation");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("batchAllocation".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void disTaskWithUserId(Long userId, List<Long> taskIds, IFormView view, boolean isBatchProcessing, Long userGroup) {
        StringBuilder errorMsg = new StringBuilder();
        boolean isRedistribute = "admin_redistribution".equals(view.getFormShowParameter().getCustomParam("operation"));
        Map task2Index = (Map)view.getFormShowParameter().getCustomParam("task2Index");
        List<Long> successIds = DisTaskWithUserIdHelper.disTaskNew(userId, taskIds, errorMsg, userGroup, isRedistribute, task2Index);
        if (!isBatchProcessing) {
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(8);
            int totalTaskCount = taskIds.size();
            int totalSuccessCount = successIds.size();
            returnDataMap.put("totalTaskCount", totalTaskCount);
            returnDataMap.put("totalSuccessCount", totalSuccessCount);
            String digest = this.createTipDigest(totalTaskCount, totalSuccessCount);
            returnDataMap.put("digest", digest);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                errorMsg.deleteCharAt(errorMsg.length() - 1);
                returnDataMap.put("errorMsg", errorMsg.toString());
            }
            String jsonString = JSON.toJSONString(returnDataMap);
            log.info(jsonString);
            this.getView().returnDataToParent((Object)jsonString);
            this.getView().close();
        }
    }

    public String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u5206\u914d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"UserWorkLoadFormPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }

    private boolean checkApplier(Long taskId, Long userId) {
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"creator.id,billtype.id,qualitysamplelibrary.id", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (task == null || task.getLong("qualitysamplelibrary.id") > 0L) {
            return true;
        }
        DynamicObject billType = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"allowanyapplier", (QFilter[])new QFilter("id", "=", (Object)task.getLong("billtype.id")).toArray());
        return billType.getBoolean("allowanyapplier") || !userId.equals(task.getLong("creator.id"));
    }

    private void queryMineGroupLeaderData(boolean mineGroupLeader) {
        IDataModel dataModel = this.getModel();
        List<WorkerStatusPojo> gridList = this.queryGridDataByGroupLeader(mineGroupLeader);
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        if (gridList != null && gridList.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("usernum", new Object[0]);
            vs.addField("workload", new Object[0]);
            vs.addField("usergroup", new Object[0]);
            vs.addField("workstatus", new Object[0]);
            vs.addField("ability", new Object[0]);
            for (int i = gridList.size() - 1; i >= 0; --i) {
                WorkerStatusPojo girdData = gridList.get(i);
                vs.addRow(new Object[]{girdData.getUserId(), girdData.getTaskTotal(), girdData.getUserGroupId(), girdData.isPresent(), girdData.getAbilityValue()});
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        this.getView().updateView("entryentity");
    }

    private List<WorkerStatusPojo> queryGridDataByGroupLeader(boolean mineGroupLeader) {
        if (mineGroupLeader) {
            List<WorkerStatusPojo> userIDList = this.getAllUserByGroupLeader();
            TaskUserWorkLoadHelper.addUserWorklingJobLoad(userIDList);
            return userIDList;
        }
        return null;
    }

    private List<WorkerStatusPojo> getAllUserByGroupLeader() {
        ArrayList<WorkerStatusPojo> userIDList = new ArrayList<WorkerStatusPojo>(8);
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscId = (String)taskSscList.get(0);
        Long currUserId = RequestContext.get().getCurrUserId();
        QFilter sscQFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscId));
        QFilter enableUserQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter enableUserGroupQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(sscId, String.valueOf(currUserId));
        QFilter manageGroupQF = new QFilter("id", "in", manageGroupSet);
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name,createorg,entryentity.userfield,entryentity.ability,entryentity.usestatus", (QFilter[])new QFilter[]{sscQFilter, enableUserQF, enableUserGroupQF, manageGroupQF});
        TaskUserWorkLoadHelper.initEnableAndWorkUserList(userIDList, userGroups);
        return userIDList;
    }
}

