/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.formplugin.imports.TaskAbstractListPlugin;
import kd.ssc.task.formplugin.util.MetadataUtil;

public class WithdrawalListPlugin
extends TaskAbstractListPlugin
implements ClickListener,
IConfirmCallBack,
ItemClickListener {
    private static final String KEY_WITHDRAWAL_OPENDDIALOG = "openWithDrawalDialog";
    private static final String TBLDEAL = "distribute";
    private static final String TBLSELECT = "disquery";
    private static final String TBLENABLE = "enable";
    private static final String TBLDISABLE = "disable";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        boolean exists = MetadataUtil.existEntity("fircm_subscorerule");
        if (!exists) {
            listShowParameter.setBillFormId("task_withdrawal_ge");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("number");
        this.addClickListeners(new String[]{"btnmodify"});
        this.addClickListeners(new String[]{"btn_del"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String sscid = (String)this.getView().getFormShowParameter().getCustomParam("sscid");
        if (sscid != null) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter filter = new QFilter("sscid", "=", (Object)Long.valueOf(sscid));
            qFilters.add(filter);
            e.setQFilters(qFilters);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String ssc = this.getPageCache().get("sscid");
        if (ssc == null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!commonFilterColumn.getFieldName().contains("useorg")) continue;
                List list = commonFilterColumn.getDefaultValues();
                if (list.size() > 0) {
                    String sscId = (String)list.get(0);
                    this.getPageCache().put("sscid", sscId);
                    break;
                }
                String sscidCus = (String)this.getView().getFormShowParameter().getCustomParam("sscid");
                if (sscidCus != null) break;
                List comboItems = commonFilterColumn.getComboItems();
                ComboItem comboItem = (ComboItem)comboItems.get(0);
                String sscId = comboItem.getValue();
                this.getPageCache().put("sscid", sscId);
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "useorg.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            String sscId = String.valueOf(((List)currentCommonFilter.get("Value")).get(0));
            this.getPageCache().put("sscid", sscId);
            AbstractListView listView = (AbstractListView)this.getView();
            String billFormId = listView.getBillFormId();
            if (!"task_withdrawal_ge".equals(billFormId)) {
                String sscType = DutyManageDataHelper.getSSCType((long)Long.parseLong(sscId));
                if (SSCTypeEnum.HR.getValue().equals(sscType)) {
                    listView.changeListView("task_withdrawal_pc");
                } else {
                    listView.changeListView("task_withdrawal");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (afterDoOperationEventArgs.getOperateKey()) {
                case "distribute": {
                    this.setShowForm();
                    break;
                }
                case "disquery": {
                    boolean hasPermission = this.checkDisqueryPermission();
                    if (!hasPermission) {
                        return;
                    }
                    this.setSelsctForm();
                    break;
                }
                case "enable": {
                    this.syncState4DistributedWithdrawal(true);
                    break;
                }
                case "disable": {
                    this.syncState4DistributedWithdrawal(false);
                    break;
                }
            }
        }
    }

    private void syncState4DistributedWithdrawal(boolean isEnable) {
        String val = isEnable ? "1" : "0";
        IListView list = (IListView)this.getView();
        StringBuilder sb = new StringBuilder(128);
        sb.append("update t_tk_withdrawal_deal set fenable = ");
        sb.append(val);
        sb.append(" where fwithdrawalid in (");
        for (ListSelectedRow selectedRow : list.getSelectedRows()) {
            sb.append(selectedRow.getPrimaryKeyValue()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1).append(')');
        DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sb.toString());
    }

    private void setSelsctForm() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrow = list.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : selectrow) {
            ids.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        if (ids.size() > 0 && this.checkStateIsEnable(ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u7981\u7528\u72b6\u6001\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u64cd\u4f5c\uff0c\u8bf7\u5148\u542f\u7528\u6570\u636e\u3002", (String)"WithdrawalListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String sscid = this.getPageCache().get("sscid");
        this.getModel();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("task_withdrawal_re");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("tabap");
        para.setCustomParam("sscid", (Object)sscid);
        if (!CollectionUtils.isEmpty(ids)) {
            ListFilterParameter filter = new ListFilterParameter();
            filter.setFilter(new QFilter("withdrawalid", "in", ids).and(new QFilter("useorg.id", "=", (Object)Long.valueOf(sscid))));
            para.setListFilterParameter(filter);
        }
        this.getView().showForm((FormShowParameter)para);
    }

    private boolean checkDisqueryPermission() {
        boolean permissionResult;
        String appId;
        IListView listView = (IListView)this.getView();
        List sscIds = listView.getSelectedMainOrgIds();
        Long sscId = (Long)sscIds.get(0);
        Long userId = RequestContext.get().getCurrUserId();
        int isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)(appId = AppMetadataCache.getAppInfo((String)"ssc").getId()), (String)"task_withdrawal", (String)"16G+KEKP9Z59");
        boolean bl = permissionResult = isPermission == 1;
        if (!permissionResult) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6279\u9000\u539f\u56e0\u201d\u7684\u201c\u5206\u914d\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WithdrawalListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return permissionResult;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int result;
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (("callBackIdOne".equals(callBackId) || "callBackId".equals(callBackId)) && (result = e.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.delWithrawal(callBackId);
            this.getView().updateView();
        }
    }

    private void delWithrawal(String callBackId) {
        boolean exists = this.checkRelWithrawal(callBackId);
        if (exists) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u6279\u9000\u539f\u56e0\u5b58\u5728\u5f15\u7528\u5173\u7cfb\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WithdrawalListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        } else {
            OperationServiceHelper opService = new OperationServiceHelper();
            List<Long> keys = this.getSelectedRowWithdrawal(callBackId);
            OperationResult operationResult = new OperationResult();
            OperationServiceHelper.executeOperate((String)"delete", (String)"task_withdrawal", (Object[])keys.toArray());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WithdrawalListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
            }
        }
    }

    private List<Long> getSelectedRowWithdrawal(String callBackId) {
        BillList billList = (BillList)this.getControl("BillListAp");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        ArrayList<Long> keys = new ArrayList<Long>();
        if ("callBackIdOne".equals(callBackId)) {
            int focusRow = billList.getEntryState().getFocusRow();
            for (int i = 0; i < listSelectedRows.size(); ++i) {
                if (focusRow != listSelectedRows.get(i).getRowKey()) continue;
                keys.add((Long)listSelectedRows.get(i).getPrimaryKeyValue());
                return keys;
            }
        } else {
            for (int i = 0; i < listSelectedRows.size(); ++i) {
                keys.add((Long)listSelectedRows.get(i).getPrimaryKeyValue());
            }
        }
        return keys;
    }

    private boolean checkRelWithrawal(String callBackId) {
        List<Long> keys = this.getSelectedRowWithdrawal(callBackId);
        QFilter df = new QFilter("withdrawalid", "in", keys);
        QFilter[] filters = new QFilter[]{df};
        return QueryServiceHelper.exists((String)"task_withdrawal_re", (QFilter[])filters);
    }

    private void setShowForm() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectrow = list.getSelectedRows();
        if (selectrow.size() < 1) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : selectrow) {
            ids.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        if (this.checkStateIsEnable(ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u7981\u7528\u72b6\u6001\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u64cd\u4f5c\uff0c\u8bf7\u5148\u542f\u7528\u6570\u636e\u3002", (String)"WithdrawalListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getShowFormByIds(ids);
    }

    private boolean checkStateIsEnable(List<Long> ids) {
        String selectField = TBLENABLE;
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".checkStateIsEnable()"), (String)"task_withdrawal", (String)selectField, (QFilter[])new QFilter[]{idFilter}, null);
        if (collection.size() == 0) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519", (String)"WithdrawalListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u6570\u636e\u65e0\u6cd5\u67e5\u8be2\u3002", (String)"WithdrawalListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject obj : collection) {
            String isenable = obj.getString(TBLENABLE);
            if (!"0".equals(isenable)) continue;
            return true;
        }
        return false;
    }

    private void getShowFormByIds(List<Long> ids) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_withdrawal_deal");
        showParameter.setCustomParam("sscid", (Object)this.getPageCache().get("sscid"));
        if (ids.size() > 0) {
            showParameter.setCustomParam("busUnpassReaList", ids);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_WITHDRAWAL_OPENDDIALOG);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String retData;
        super.closedCallBack(e);
        if (KEY_WITHDRAWAL_OPENDDIALOG.equalsIgnoreCase(e.getActionId()) && "assignok".equalsIgnoreCase(retData = (String)e.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"WithdrawalListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
    }
}

