/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.field.FieldEdit;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModel;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetail;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetailFieldInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class AchieveReportStylePlugin
extends AbstractBillPlugIn {
    private static final String DYNAMIC_ENTRY_COUNT_KEY = "dynamicEntryCount";
    private static final List<String> NEED_CONFIG_BY_WF_FIELDS = new ArrayList<String>(2);

    public void afterBindData(EventObject e) {
        String dynamicEntryCount = this.getPageCache().get(DYNAMIC_ENTRY_COUNT_KEY);
        if (StringUtils.isEmpty((String)dynamicEntryCount)) {
            return;
        }
        int dynEntryCount = Integer.parseInt(dynamicEntryCount);
        Object processDefinitionId = this.getView().getFormShowParameter().getCustomParam("processDefinitionId");
        if (processDefinitionId != null) {
            this.setStyleByWfPageSetting(dynEntryCount);
        }
        boolean billInWorkflow = this.inWorkflow();
        for (int i = 1; i < dynEntryCount + 1; ++i) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity_po_" + i);
            for (int j = 0; j < entryRowCount; ++j) {
                if (billInWorkflow && processDefinitionId == null) {
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"poapproved_" + i});
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"podescription_" + i});
                } else {
                    this.getView().setEnable(Boolean.TRUE, j, new String[]{"poapproved_" + i});
                    this.getView().setEnable(Boolean.TRUE, j, new String[]{"podescription_" + i});
                }
                DynamicObject achieveTarget = (DynamicObject)this.getModel().getValue("poachieveid_" + i, j);
                if (!"0".equals(achieveTarget.getString("targettype"))) continue;
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"poactual_" + i});
            }
        }
    }

    private Boolean inWorkflow() {
        String status = (String)this.getModel().getValue("status");
        boolean inSubmitStatus = "B".equals(status);
        if (!inSubmitStatus) {
            return false;
        }
        return WorkflowServiceHelper.inProcess((String)String.valueOf(this.getModel().getValue("id")));
    }

    private void setStyleByWfPageSetting(int dynamicEntryCount) {
        Map<String, String> wfPageSetting = this.wfPageSetting();
        if (!wfPageSetting.isEmpty()) {
            for (Map.Entry<String, String> entry : wfPageSetting.entrySet()) {
                String key = entry.getKey();
                String[] fieldNumbers = entry.getValue().split(",");
                ArrayList<String> needAdjustKey = new ArrayList<String>(fieldNumbers.length);
                for (String field : fieldNumbers) {
                    String detailKey;
                    if (!field.contains("entryentity_po.") || !NEED_CONFIG_BY_WF_FIELDS.contains(detailKey = field.replace("entryentity_po.", ""))) continue;
                    needAdjustKey.add(detailKey);
                }
                if (needAdjustKey.size() <= 0) continue;
                for (int i = 1; i < dynamicEntryCount + 1; ++i) {
                    int entryRow = this.getModel().getEntryRowCount("entryentity_po_" + i);
                    for (String adjustkey : needAdjustKey) {
                        String realKey = adjustkey + "_" + i;
                        if ("modify".equals(key)) {
                            this.unlockField(realKey, i);
                            for (int j = 0; j < entryRow; ++j) {
                                this.getView().setEnable(Boolean.TRUE, j, new String[]{realKey});
                            }
                            continue;
                        }
                        if ("hide".equals(key)) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{realKey});
                            continue;
                        }
                        if ("display".equals(key)) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{realKey});
                            continue;
                        }
                        if (!"mustInput".equals(key)) continue;
                        ((FieldEdit)this.getControl(realKey)).setMustInput(Boolean.TRUE.booleanValue());
                    }
                }
            }
        }
    }

    private Map<String, String> wfPageSetting() {
        HashMap<String, String> fieldControl = new HashMap<String, String>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Object attributeConfigsObj = wfService.getRepositoryService().getPageAttrCfg((String)formShowParameter.getCustomParam("businessKey"), (Long)formShowParameter.getCustomParam("processDefinitionId"), (Long)formShowParameter.getCustomParam("processInstanceId"), (String)formShowParameter.getCustomParam("taskDefinitionKey"), (String)formShowParameter.getCustomParam("formkey"), (Boolean)formShowParameter.getCustomParam("pcShow"));
        if (attributeConfigsObj != null) {
            if (!(attributeConfigsObj instanceof BillPageAttributeConfigModel)) {
                return fieldControl;
            }
            BillPageAttributeConfigModel attributeConfigsModel = (BillPageAttributeConfigModel)attributeConfigsObj;
            BillPageAttributeConfigModelDetail configModelDetail = attributeConfigsModel.getField();
            if (configModelDetail != null) {
                BillPageAttributeConfigModelDetailFieldInfo mustInput;
                BillPageAttributeConfigModelDetailFieldInfo display;
                BillPageAttributeConfigModelDetailFieldInfo hide;
                BillPageAttributeConfigModelDetailFieldInfo modify = configModelDetail.getModify();
                if (modify != null && StringUtils.isNotEmpty((String)modify.getFieldnumber())) {
                    fieldControl.put("modify", modify.getFieldnumber());
                }
                if ((hide = configModelDetail.getHide()) != null && StringUtils.isNotEmpty((String)hide.getFieldnumber())) {
                    fieldControl.put("hide", hide.getFieldnumber());
                }
                if ((display = configModelDetail.getDisplay()) != null && StringUtils.isNotEmpty((String)display.getFieldnumber())) {
                    fieldControl.put("display", display.getFieldnumber());
                }
                if ((mustInput = configModelDetail.getMustinput()) != null && StringUtils.isNotEmpty((String)mustInput.getFieldnumber())) {
                    fieldControl.put("mustInput", mustInput.getFieldnumber());
                }
            }
        }
        return fieldControl;
    }

    private void unlockField(String fieldNumber, int entryIndex) {
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        service.invokeControlMethod("entryentity_po_" + entryIndex, "setColProp", new Object[]{fieldNumber, "l", 0});
    }

    static {
        NEED_CONFIG_BY_WF_FIELDS.add("poapproved");
        NEED_CONFIG_BY_WF_FIELDS.add("podescription");
    }
}

