/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.ssc.enums.achieve.AssessTypeEnum;
import kd.ssc.enums.achieve.ScoreComputeTypeEnum;
import kd.ssc.enums.achieve.TargetRule;

public class AchieveTargetFormPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private static final String KEY_TARGETTYPE = "targettype";
    private static final String KEY_RULEEXP = "ruleexpression";
    private static final String KEY_RULEEXPJSON_TAG = "ruleexpjson_tag";
    private static final String KEY_NAME = "name";
    private static final String KEY_UNITID = "unitid";
    private static final String KEY_ISPRESET = "ispreset";
    private static final String KEY_ACHIEVEDESC = "achievedesc";
    private static final String KEY_SCORINGMETHOD = "scoringmethod";
    private static final String KEY_MINSCORE = "minscore";
    private static final String KEY_MAXSOCRE = "maxscore";
    private static final String KEY_SETUP = "setup";
    private static final String KEY_SETDOWN = "setdown";
    private static final String BTN_TRIAL = "btn_trial";
    private static final BigDecimal MAX_DEFAULT = new BigDecimal(100);
    private static final BigDecimal MIN_DEFAULT = new BigDecimal(0);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_RULEEXP});
        BasedataEdit serviceCla = (BasedataEdit)this.getControl("group");
        serviceCla.addBeforeF7ViewDetailListener(f7ViewDetailEvent -> {
            BasedataEdit serviceClassify = (BasedataEdit)f7ViewDetailEvent.getSource();
            serviceClassify.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
        });
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel dataModel = this.getModel();
        boolean isPresent = (Boolean)dataModel.getValue(KEY_ISPRESET);
        if (isPresent) {
            String billNo;
            switch (billNo = (String)dataModel.getValue("number")) {
                case "JXZB-2AB591CA": {
                    dataModel.setValue(KEY_RULEEXP, (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6807\u51c6\u5de5\u4f5c\u91cf", (String)"AchieveTargetFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "JXZB-321CF377": {
                    dataModel.setValue(KEY_RULEEXP, (Object)ResManager.loadKDString((String)"( \u4efb\u52a1\u5904\u7406\u6570 - \u8d85\u671f\u4efb\u52a1\u6570 ) / \u4efb\u52a1\u5904\u7406\u6570", (String)"AchieveTargetFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "JXZB-5F7B0BC7": {
                    dataModel.setValue(KEY_RULEEXP, (Object)ResManager.loadKDString((String)"\u5728\u5c97\u65f6\u957f / \u4efb\u52a1\u6807\u51c6\u5de5\u4f5c\u91cf", (String)"AchieveTargetFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "JXZB-8AF19F1E": {
                    dataModel.setValue(KEY_RULEEXP, (Object)ResManager.loadKDString((String)"( \u8d28\u68c0\u6b21\u6570 - \u8d28\u68c0\u4e0d\u5408\u683c\u6b21\u6570 ) / \u8d28\u68c0\u6b21\u6570", (String)"AchieveTargetFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (BTN_TRIAL.equals(itemKey) && model.getDataChanged()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6307\u6807\u540e\u518d\u8fdb\u884c\u8bd5\u7b97\u3002", (String)"AchieveTargetFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_TRIAL.equals(itemKey)) {
            this.showTrialForm();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("save".equals(keyName) && args.getOperationResult().isSuccess()) {
            boolean setDown;
            boolean setUp = (Boolean)this.getModel().getValue(KEY_SETUP);
            if (!setUp) {
                this.getModel().setValue(KEY_MAXSOCRE, null);
            }
            if (!(setDown = ((Boolean)this.getModel().getValue(KEY_SETDOWN)).booleanValue())) {
                this.getModel().setValue(KEY_MINSCORE, null);
            }
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String ruleExpression;
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("save".equals(keyName) && StringUtils.isEmpty((CharSequence)(ruleExpression = (String)this.getModel().getValue(KEY_RULEEXP)))) {
            this.getModel().setValue(KEY_RULEEXPJSON_TAG, null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String scoringMethod = (String)this.getModel().getValue(KEY_SCORINGMETHOD);
        String targetType = (String)this.getModel().getValue(KEY_TARGETTYPE);
        this.unitEnable(scoringMethod, targetType);
        this.adjustScoreEnable();
        if (status.equals((Object)OperationStatus.EDIT)) {
            IDataModel dataModel = this.getModel();
            Boolean isPreset = (Boolean)dataModel.getValue(KEY_ISPRESET);
            boolean isRefrenced = BaseDataRefrenceHelper.isRefrenced((String)"ssc_achievetarget", (Object)dataModel.getDataEntity().getPkValue());
            if (isPreset.booleanValue() || isRefrenced) {
                IFormView formView = this.getView();
                formView.setEnable(Boolean.FALSE, new String[]{KEY_NAME, KEY_TARGETTYPE, KEY_UNITID, KEY_RULEEXP, KEY_SCORINGMETHOD, "assessobject"});
            } else {
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_SCORINGMETHOD);
                FieldEdit ruleExp = (FieldEdit)this.getControl(KEY_RULEEXP);
                if ("0".equals(targetType)) {
                    ruleExp.setMustInput(Boolean.TRUE.booleanValue());
                    comboEdit.setMustInput(Boolean.TRUE.booleanValue());
                    this.setScoringMethodCombo(comboEdit, Boolean.TRUE);
                } else if ("1".equals(targetType)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{KEY_RULEEXP});
                    comboEdit.setMustInput(Boolean.TRUE.booleanValue());
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SCORINGMETHOD, KEY_RULEEXP});
                    this.getModel().setValue(KEY_SCORINGMETHOD, null);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)KEY_TARGETTYPE)) {
            FieldEdit ruleExp;
            IFormView formView = this.getView();
            IDataModel dataModel = this.getModel();
            if ("0".equals(newValue)) {
                ruleExp = (FieldEdit)formView.getControl(KEY_RULEEXP);
                ruleExp.setMustInput(Boolean.TRUE.booleanValue());
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_SCORINGMETHOD);
                comboEdit.setMustInput(Boolean.TRUE.booleanValue());
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_SCORINGMETHOD, KEY_RULEEXP});
                this.getModel().setValue(KEY_SCORINGMETHOD, (Object)ScoreComputeTypeEnum.RATIO.getValue());
                this.setScoringMethodCombo(comboEdit, Boolean.TRUE);
            } else if ("1".equals(newValue)) {
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_SCORINGMETHOD);
                comboEdit.setMustInput(Boolean.TRUE.booleanValue());
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_SCORINGMETHOD});
                this.setScoringMethodCombo(comboEdit, Boolean.FALSE);
                this.getModel().setValue(KEY_SCORINGMETHOD, (Object)ScoreComputeTypeEnum.DIRECT.getValue());
                FieldEdit ruleExp2 = (FieldEdit)formView.getControl(KEY_RULEEXP);
                ruleExp2.setMustInput(Boolean.FALSE.booleanValue());
            } else {
                ruleExp = (FieldEdit)formView.getControl(KEY_RULEEXP);
                ruleExp.setMustInput(Boolean.FALSE.booleanValue());
                dataModel.setValue(KEY_RULEEXPJSON_TAG, null);
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_SCORINGMETHOD);
                comboEdit.setMustInput(Boolean.FALSE.booleanValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SCORINGMETHOD});
                this.getModel().setValue(KEY_SCORINGMETHOD, null);
            }
            String scoringMethod = (String)this.getModel().getValue(KEY_SCORINGMETHOD);
            this.unitEnable(scoringMethod, (String)newValue);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)KEY_SCORINGMETHOD)) {
            String targetType = (String)this.getModel().getValue(KEY_TARGETTYPE);
            this.unitEnable((String)newValue, targetType);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)KEY_SETUP) || StringUtils.equals((CharSequence)propName, (CharSequence)KEY_SETDOWN)) {
            String scoreKey;
            String string = scoreKey = propName.equals(KEY_SETUP) ? KEY_MAXSOCRE : KEY_MINSCORE;
            if (((Boolean)newValue).booleanValue()) {
                if (scoreKey.equals(KEY_MAXSOCRE)) {
                    BigDecimal minScore = (BigDecimal)this.getModel().getValue(KEY_MINSCORE);
                    if (minScore == null || minScore.compareTo(MAX_DEFAULT) < 0) {
                        this.getModel().setValue(scoreKey, (Object)MAX_DEFAULT);
                    }
                } else {
                    BigDecimal maxScore = (BigDecimal)this.getModel().getValue(KEY_MAXSOCRE);
                    if (maxScore == null || maxScore.compareTo(MIN_DEFAULT) < 0) {
                        this.getModel().setValue(scoreKey, (Object)MIN_DEFAULT);
                    }
                    this.getModel().setValue(scoreKey, (Object)new BigDecimal("0.00"));
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{scoreKey});
                ((FieldEdit)this.getControl(scoreKey)).setMustInput(Boolean.TRUE.booleanValue());
            } else {
                this.getModel().setValue(scoreKey, null);
                this.getView().setEnable(Boolean.FALSE, new String[]{scoreKey});
                ((FieldEdit)this.getControl(scoreKey)).setMustInput(Boolean.FALSE.booleanValue());
            }
        }
    }

    private void unitEnable(String scoringMethod, String targetType) {
        if (ScoreComputeTypeEnum.DIRECT.getValue().equals(scoringMethod) && "1".equals(targetType) || "2".equals(targetType)) {
            this.getModel().setValue(KEY_UNITID, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_UNITID});
            ((FieldEdit)this.getControl(KEY_UNITID)).setMustInput(Boolean.FALSE.booleanValue());
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_UNITID});
            ((FieldEdit)this.getControl(KEY_UNITID)).setMustInput(Boolean.TRUE.booleanValue());
        }
    }

    private void adjustScoreEnable() {
        Boolean setUp = (Boolean)this.getModel().getValue(KEY_SETUP);
        Boolean setDown = (Boolean)this.getModel().getValue(KEY_SETDOWN);
        if (!setUp.booleanValue()) {
            this.getModel().setValue(KEY_MAXSOCRE, null);
        }
        if (!setDown.booleanValue()) {
            this.getModel().setValue(KEY_MINSCORE, null);
        }
        this.getView().setEnable(setUp, new String[]{KEY_MAXSOCRE});
        this.getView().setEnable(setDown, new String[]{KEY_MINSCORE});
        ((FieldEdit)this.getControl(KEY_MAXSOCRE)).setMustInput(setUp.booleanValue());
        ((FieldEdit)this.getControl(KEY_MINSCORE)).setMustInput(setDown.booleanValue());
    }

    private void setScoringMethodCombo(ComboEdit comboEdit, boolean hideDirecteScore) {
        List comboItems = ((ComboProp)comboEdit.getProperty()).getComboItems();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(4);
        for (ValueMapItem valueMapItem : comboItems) {
            String value = valueMapItem.getValue();
            ComboItem newcomboItem = new ComboItem();
            newcomboItem.setCaption(valueMapItem.getName());
            newcomboItem.setValue(value);
            if (hideDirecteScore && ScoreComputeTypeEnum.DIRECT.getValue().equals(value)) {
                newcomboItem.setItemVisible(false);
            } else {
                newcomboItem.setItemVisible(true);
            }
            comboItemList.add(newcomboItem);
        }
        comboEdit.setComboItems(comboItemList);
    }

    private void validateScoreZone(String porp) {
        BigDecimal maxScore = (BigDecimal)this.getModel().getValue(KEY_MAXSOCRE);
        BigDecimal minScore = (BigDecimal)this.getModel().getValue(KEY_MINSCORE);
        boolean setUp = (Boolean)this.getModel().getValue(KEY_SETUP);
        boolean setDown = (Boolean)this.getModel().getValue(KEY_SETDOWN);
        if (setUp && setDown && maxScore != null && minScore != null && maxScore.compareTo(minScore) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u201d\u5e94\u5927\u4e8e\u7b49\u4e8e\u201c\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u201d\u3002", (String)"AchieveTargetFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(porp, null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_RULEEXP.equals(key)) {
            HashMap<String, String> customParams = new HashMap<String, String>(4);
            String ruleExpression = (String)this.getModel().getValue(KEY_RULEEXP);
            if (StringUtils.isEmpty((CharSequence)ruleExpression)) {
                this.getModel().setValue(KEY_RULEEXPJSON_TAG, null);
            }
            String ruleJson = (String)this.getModel().getValue(KEY_RULEEXPJSON_TAG);
            customParams.put("ruleJson", ruleJson);
            Long sscId = (Long)this.getModel().getValue("createorg_id");
            customParams.put("sscid", String.valueOf(sscId));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ssc_calculateformula");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(customParams);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_RULEEXP));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (KEY_RULEEXP.equals(actionId)) {
            this.receiveCondition((String)returnData, KEY_RULEEXP, KEY_RULEEXPJSON_TAG);
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObject unitDy;
        long id;
        DynamicObject dynamicObject;
        String enable;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object unit = model.getValue(KEY_UNITID);
        if (!Objects.isNull(unit) && "0".equals(enable = (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)(id = (unitDy = (DynamicObject)unit).getLong("id")), (String)"bd_measureunits")).getString("enable"))) {
            model.setValue(KEY_UNITID, null);
        }
    }

    private void receiveCondition(String ruleJson, String ruleKey, String ruleJsonKey) {
        TargetRule rule;
        if (StringUtils.isNotEmpty((CharSequence)ruleJson) && (rule = (TargetRule)SerializationUtils.fromJsonString((String)ruleJson, TargetRule.class)) != null) {
            String ruleExp = this.getRuleExpre(rule);
            this.getModel().setValue(ruleJsonKey, (Object)ruleJson);
            this.getModel().setValue(ruleKey, (Object)ruleExp);
        }
    }

    private String getRuleExpre(TargetRule rule) {
        if (rule == null) {
            return "";
        }
        String handDesc = rule.getDescription().toString();
        if (StringUtils.isNotEmpty((CharSequence)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((CharSequence)rule.getExprTran()) ? rule.getExprTran() : rule.getExpression();
    }

    private void showTrialForm() {
        IDataModel model = this.getModel();
        String assessObj = (String)model.getValue("assessobject");
        if (StringUtils.isBlank((CharSequence)assessObj)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        block5: for (String s : assessObj.split(",")) {
            AssessTypeEnum assessType;
            if (StringUtils.isBlank((CharSequence)s) || (assessType = AssessTypeEnum.getAssessTypeByValue((String)s)) == null) continue;
            switch (assessType) {
                case USER: {
                    sb.append("bos_user,");
                    continue block5;
                }
                case WORK_GROUP: {
                    sb.append("task_workgroup,");
                    continue block5;
                }
                case SSC_ORG: {
                    sb.append("bos_org,");
                }
            }
        }
        String mainOrg = ((DynamicObject)model.getValue("createorg")).getString("id");
        Object pkValue = model.getDataEntity().getPkValue();
        if (pkValue == null || StringUtils.isBlank((CharSequence)pkValue.toString())) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ssc_achieve_trial");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("baseData_item", (Object)sb.toString());
        formShowParameter.setCustomParam("mainOrg", (Object)mainOrg);
        formShowParameter.setCustomParam("indicator", (Object)pkValue.toString());
        this.getView().showForm(formShowParameter);
    }
}

