/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.New;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.formplugin.util.AchieveUtil;

public class AchieveTargetTreeListPlugin
extends AbstractTreeListPlugin {
    private static final String OP_TBLDEL = "tbldelete";
    private static final String CUR_SSC = "currSSCId";
    private static final String TREE_ROOT = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnnew"});
        this.addClickListeners(new String[]{"btndel"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String currentSSCId = this.getPageCache().get(CUR_SSC);
        if (currentSSCId == null) {
            for (FilterColumn filCol : args.getCommonFilterColumns()) {
                if (!"useorg.id".equals(filCol.getFieldName())) continue;
                List ssccenters = filCol.getDefaultValues();
                if (ssccenters.size() == 0) {
                    return;
                }
                this.getPageCache().put(CUR_SSC, (String)ssccenters.get(0));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "useorg.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put(CUR_SSC, String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
            this.getTreeListView().focusRootNode();
        }
    }

    public void beforeBindData(EventObject e) {
        String sscId = this.getPageCache().get(CUR_SSC);
        if (StringUtils.isEmpty((CharSequence)sscId)) {
            return;
        }
        if (this.getTreeModel().getTreeFilter().size() == 2) {
            return;
        }
        this.refreshTreeNode();
    }

    private QFilter buildFilter() {
        String currentSSC = this.getPageCache().get(CUR_SSC);
        if (StringUtils.isBlank((CharSequence)currentSSC)) {
            return null;
        }
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter useOrgFilter = baseDataService.getBaseDataFilter("ssc_achieveclassify", Long.valueOf(currentSSC));
        QFilter groupFilter = null;
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter achieveUseOrgFilter = baseDataService.getBaseDataFilter("ssc_achievetarget", Long.valueOf(currentSSC));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"ssc_achievetarget", (String)"group", (QFilter[])new QFilter[]{enableFilter, achieveUseOrgFilter});
        if (collection != null && collection.size() > 0) {
            Set group = collection.stream().map(dynamicObject -> dynamicObject.getLong("group")).collect(Collectors.toSet());
            groupFilter = new QFilter("id", "in", group);
        }
        if (groupFilter != null) {
            useOrgFilter.or(groupFilter);
        }
        return useOrgFilter;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)OP_TBLDEL, (CharSequence)evt.getItemKey())) {
            boolean isPresent;
            Object selectedTarget;
            DynamicObject target;
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AchieveTargetTreeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (listSelectedRowCollection.size() == 1 && (target = BusinessDataServiceHelper.loadSingle((Object)(selectedTarget = listSelectedRowCollection.get(0).getPrimaryKeyValue()), (String)"ssc_achievetarget")) != null && target.get("ispreset") instanceof Boolean && (isPresent = target.getBoolean("ispreset"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u7ee9\u6548\u6307\u6807\u4e0d\u53ef\u5220\u9664\uff0c\u4ec5\u53ef\u7981\u7528\u3002", (String)"AchieveTargetTreeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        Object operation = args.getSource();
        boolean hasRule = AchieveUtil.codeRule("ssc_achievetarget");
        if (operation instanceof New) {
            if (!hasRule) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"AchieveTargetTreeListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                TreeView treeView = (TreeView)this.getView().getControl("treeview");
                if (treeView != null) {
                    List serClassifyId = treeView.getTreeState().getSelectedNodes();
                    if (serClassifyId == null || serClassifyId.size() == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ee9\u6548\u6307\u6807\u5206\u7c7b\u3002", (String)"AchieveTargetTreeListPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    Map serClassifyMap = (Map)serClassifyId.get(0);
                    String nodeId = (String)serClassifyMap.get("id");
                    if (TREE_ROOT.equals(nodeId)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u7ee9\u6548\u6307\u6807\u65f6\uff0c\u4e0d\u652f\u6301\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"AchieveTargetTreeListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
            }
        } else if (operation instanceof Copy) {
            if (!hasRule) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"AchieveTargetTreeListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
                if (listSelectedRowCollection.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AchieveTargetTreeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Vector)evt.getSource()).getKey();
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        if (treeview != null) {
            List serClassifyId = treeview.getTreeState().getSelectedNodes();
            if (serClassifyId == null || serClassifyId.size() == 0) {
                return;
            }
            Map serClassifyMap = (Map)serClassifyId.get(0);
            String nodeId = (String)serClassifyMap.get("id");
            if ("btndel".equalsIgnoreCase(key) && !TREE_ROOT.equals(nodeId)) {
                Long id = Long.parseLong(nodeId);
                DynamicObject kind = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ssc_achieveclassify");
                String ispreset = kind.getString("ispreset");
                if ("true".equals(ispreset)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7ee9\u6548\u6307\u6807\u5206\u7c7b\u4e0d\u80fd\u5220\u9664\u3002", (String)"AchieveTargetTreeListPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String currSSC = this.getPageCache().get(CUR_SSC);
                String dataCreateSSC = kind.getDynamicObject("createorg").getString("id");
                if (!dataCreateSSC.equals(currSSC)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u7ee9\u6548\u6307\u6807\u5206\u7c7b\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AchieveTargetTreeListPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                boolean hasData = QueryServiceHelper.exists((String)"ssc_achievetarget", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)id)});
                if (hasData) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u5b58\u5728\u7ee9\u6548\u6307\u6807\u7684\u5206\u7c7b\u3002", (String)"AchieveTargetTreeListPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    private void refreshTreeNode() {
        TreeNode root = this.getTreeModel().getRoot();
        this.getTreeModel().refreshNode((Object)root.getId());
        this.treeListView.refreshTreeNode(root.getId(), false);
    }

    public void refreshNode(RefreshNodeEvent e) {
        QFilter qfilter = this.buildFilter();
        if (qfilter == null) {
            return;
        }
        List treeFilter = this.getTreeModel().getTreeFilter();
        treeFilter.clear();
        treeFilter.add(qfilter);
        treeFilter.add(new QFilter("enable", "=", (Object)"1"));
    }
}

