/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.task.business.achieve.report.AchieveSchemeConverter;
import kd.ssc.task.common.LogBuildUtil;

public class ChoosePlanPeriodPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ChoosePlanPeriodPlugin.class);
    private static final String BASEINFO = ChoosePlanPeriodPlugin.class + ".execute():";
    private static final String ASSESS_PLAN = "assess_plan";
    private static final String ASSESS_YEAR = "assess_year";
    private static final String ASSESS_HALFYEAR = "assess_halfyear";
    private static final String LAB_HALFYEAR = "labhalfyear";
    private static final String ASSESS_MONTH = "assess_month";
    private static final String LAB_MONTH = "labmonth";
    private static final String ASSESS_QUARTER = "assess_quarter";
    private static final String LAB_QUARTER = "labquarter";
    private static final String OP_GENERATEDATA = "generatedatas";
    private static final String KEY_SSCID = "sscid";
    private static final String KEY_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit plane = (BasedataEdit)this.getControl(ASSESS_PLAN);
        plane.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Calendar c = Calendar.getInstance();
        int currentYear = c.get(1);
        int currentMonth = c.get(2);
        this.setYearComboItems(currentYear);
        this.getModel().setValue(ASSESS_YEAR, (Object)currentYear);
        this.getModel().setValue(ASSESS_MONTH, (Object)(currentMonth + 1));
        String sscid = (String)this.getView().getFormShowParameter().getCustomParam(KEY_SSCID);
        this.getModel().setValue(KEY_SSCID, (Object)sscid);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{ASSESS_HALFYEAR});
        formView.setVisible(Boolean.FALSE, new String[]{LAB_HALFYEAR});
        formView.setVisible(Boolean.FALSE, new String[]{ASSESS_MONTH});
        formView.setVisible(Boolean.FALSE, new String[]{LAB_MONTH});
        formView.setVisible(Boolean.FALSE, new String[]{ASSESS_QUARTER});
        formView.setVisible(Boolean.FALSE, new String[]{LAB_QUARTER});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        if (newValue == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)propName, (CharSequence)ASSESS_PLAN)) {
            Long planeId = ((DynamicObject)newValue).getLong("id");
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)planeId, (String)"ssc_achievescheme");
            String period = scheme.getString("assessperiod");
            IFormView formView = this.getView();
            switch (period) {
                case "1": {
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_HALFYEAR});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_HALFYEAR});
                    formView.setVisible(Boolean.TRUE, new String[]{ASSESS_MONTH});
                    formView.setVisible(Boolean.TRUE, new String[]{LAB_MONTH});
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_QUARTER});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_QUARTER});
                    break;
                }
                case "2": {
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_HALFYEAR});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_HALFYEAR});
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_MONTH});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_MONTH});
                    formView.setVisible(Boolean.TRUE, new String[]{ASSESS_QUARTER});
                    formView.setVisible(Boolean.TRUE, new String[]{LAB_QUARTER});
                    break;
                }
                case "3": {
                    formView.setVisible(Boolean.TRUE, new String[]{ASSESS_HALFYEAR});
                    formView.setVisible(Boolean.TRUE, new String[]{LAB_HALFYEAR});
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_MONTH});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_MONTH});
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_QUARTER});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_QUARTER});
                    break;
                }
                case "4": {
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_HALFYEAR});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_HALFYEAR});
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_MONTH});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_MONTH});
                    formView.setVisible(Boolean.FALSE, new String[]{ASSESS_QUARTER});
                    formView.setVisible(Boolean.FALSE, new String[]{LAB_QUARTER});
                    break;
                }
                default: {
                    log.error(planeId + "\u7ee9\u6548\u65b9\u6848\u5b58\u5728\u4e0d\u5408\u7406\u8003\u6838\u5468\u671f\u5b57\u6bb5\u503c");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OP_GENERATEDATA.equals(operateKey) && operationResult.isSuccess()) {
            IDataModel model = this.getModel();
            Long planeId = ((DynamicObject)model.getValue(ASSESS_PLAN)).getLong("id");
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)planeId, (String)"ssc_achievescheme");
            if (StringUtils.equals((CharSequence)this.getPageCache().get("needConfirm"), (CharSequence)"true")) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("coverEvaluate", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ee9\u6548\u65b9\u6848\u5df2\u751f\u6210\u7ee9\u6548\u62a5\u544a\uff0c\u662f\u5426\u9700\u8981\u8986\u76d6\uff1f", (String)"ChoosePlanPeriodPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBack);
            } else {
                String period = scheme.getString("assessperiod");
                Map<String, Date> date = this.getAssessPeriodDate(period);
                boolean saveSuccess = this.saveEvaluate(date.get("start"), date.get("end"), scheme);
                if (saveSuccess) {
                    this.addLog4SaveEvaluate(scheme, date.get("start"), date.get("end"));
                }
                this.getView().close();
            }
        }
    }

    private void addLog4SaveEvaluate(DynamicObject scheme, Date startDate, Date endDate) {
        String number = scheme.getString("number");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String start = sdf.format(startDate);
        String end = sdf.format(endDate);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u751f\u6210\u7ee9\u6548\u62a5\u544a", "AssessPeriodSelectPlugin_0", "ssc-task-formplugin");
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u7ee9\u6548\u8003\u6838\u65b9\u6848[%1$s]\uff0c\u8003\u6838\u533a\u95f4%2$s~%3$s\u751f\u6210\u7ee9\u6548\u62a5\u544a\u6210\u529f", "AssessPeriodSelectPlugin_1", "ssc-task-formplugin");
        OpLogAppInfo opLogAppInfo = LogBuildUtil.buildLogInfo(this.getView(), null, "ssc_achievescheme", "generateAchieveReport", opName, opDes, number, start, end);
        LogServiceHelper.addLog((AppLogInfo)opLogAppInfo);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit edit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String fieldName = edit.getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)ASSESS_PLAN)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String sscid = (String)fsp.getCustomParam(KEY_SSCID);
            Long sscidL = null;
            try {
                sscidL = Long.valueOf(sscid);
            }
            catch (Exception e) {
                log.error("\u5171\u4eab\u4e2d\u5fc3\u7f16\u7801\u5b57\u7b26\u4e32\u8f6c\u5316\u6570\u5b57\u51fa\u9519\uff1a" + Arrays.toString(e.getStackTrace()));
            }
            QFilter addFiler = new QFilter(KEY_SSCID, "in", (Object)sscidL);
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(addFiler);
            String reportTypeKey = (String)fsp.getCustomParam("reportTypeKey");
            if (reportTypeKey != null) {
                QFilter dimFilter = new QFilter("assessobject", "=", (Object)reportTypeKey);
                qFilters.add(dimFilter);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_BTNOK)) {
            this.getPageCache().put("needConfirm", "false");
            Long planeId = ((DynamicObject)this.getModel().getValue(ASSESS_PLAN)).getLong("id");
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)planeId, (String)"ssc_achievescheme");
            String period = scheme.getString("assessperiod");
            Map<String, Date> date = this.getAssessPeriodDate(period);
            Date startDate = date.get("start");
            Date endDate = date.get("end");
            QFilter dateFiler = new QFilter("periodstart", "=", (Object)startDate);
            dateFiler.and(new QFilter("periodend", "=", (Object)endDate));
            QFilter schemeFilter = new QFilter("assessplanid", "=", (Object)planeId);
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"ssc_achieveevalute", (String)"id,status", (QFilter[])new QFilter[]{dateFiler, schemeFilter});
            if (datas.size() == 0) {
                return;
            }
            this.getPageCache().put("needConfirm", "true");
            if (!this.canGenerate(datas)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ee9\u6548\u65b9\u6848\u751f\u6210\u7684\u7ee9\u6548\u62a5\u544a\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u65e0\u6cd5\u751f\u6210\u3002", (String)"ChoosePlanPeriodPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg) {
        super.confirmCallBack(arg);
        if ("coverEvaluate".equalsIgnoreCase(arg.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg.getResult())) {
            Long planeId = ((DynamicObject)this.getModel().getValue(ASSESS_PLAN)).getLong("id");
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)planeId, (String)"ssc_achievescheme");
            String period = scheme.getString("assessperiod");
            Map<String, Date> date = this.getAssessPeriodDate(period);
            this.deleteEvaluate(date.get("start"), date.get("end"), planeId);
            if (this.saveEvaluate(date.get("start"), date.get("end"), scheme)) {
                this.addLog4SaveEvaluate(scheme, date.get("start"), date.get("end"));
                this.getView().close();
            }
        }
    }

    private void setYearComboItems(int currentYear) {
        ComboEdit comboYear = (ComboEdit)this.getControl(ASSESS_YEAR);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        for (int i = currentYear - 10; i < currentYear + 10; ++i) {
            String year = String.valueOf(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        comboYear.setComboItems(propertyItems);
    }

    private Map<String, Date> getQuarterDate(int year, int quarter) {
        HashMap<String, Date> dateMap = new HashMap<String, Date>(2);
        switch (quarter) {
            case 1: {
                Date startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)1, (boolean)true);
                Date endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)3, (boolean)false);
                dateMap.put("start", startDate);
                dateMap.put("end", endDate);
                break;
            }
            case 2: {
                Date startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)4, (boolean)true);
                Date endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)6, (boolean)false);
                dateMap.put("start", startDate);
                dateMap.put("end", endDate);
                break;
            }
            case 3: {
                Date startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)7, (boolean)true);
                Date endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)9, (boolean)false);
                dateMap.put("start", startDate);
                dateMap.put("end", endDate);
                break;
            }
            case 4: {
                Date startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)10, (boolean)true);
                Date endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)12, (boolean)false);
                dateMap.put("start", startDate);
                dateMap.put("end", endDate);
                break;
            }
            default: {
                log.info("setQuarterDate\u65b9\u6cd5\u4f20\u5165\u4e0d\u5408\u7406\u7684\u5b63\u5ea6\u503c");
            }
        }
        return dateMap;
    }

    private int tranStringToInt(String name, String value) {
        int a;
        try {
            a = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.error(BASEINFO + " exception is parameter " + name + "to parse integer", (Throwable)e);
            return -1;
        }
        return a;
    }

    private Map<String, Date> getAssessPeriodDate(String assessPeriod) {
        HashMap<String, Date> dateMap = new HashMap<String, Date>(2);
        IDataModel model = this.getModel();
        int year = this.tranStringToInt(ASSESS_YEAR, (String)model.getValue(ASSESS_YEAR));
        Date startDate = new Date();
        Date endDate = new Date();
        switch (assessPeriod) {
            case "1": {
                int month = this.tranStringToInt(ASSESS_MONTH, (String)model.getValue(ASSESS_MONTH));
                startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)month, (boolean)true);
                endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)month, (boolean)false);
                break;
            }
            case "2": {
                int quarter = this.tranStringToInt(ASSESS_QUARTER, (String)model.getValue(ASSESS_QUARTER));
                Map<String, Date> date = this.getQuarterDate(year, quarter);
                startDate = date.get("start");
                endDate = date.get("end");
                break;
            }
            case "3": {
                int halfYear = this.tranStringToInt(ASSESS_HALFYEAR, (String)model.getValue(ASSESS_HALFYEAR));
                if (halfYear == 1) {
                    startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)1, (boolean)true);
                    endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)6, (boolean)false);
                    break;
                }
                if (halfYear == 2) {
                    startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)7, (boolean)true);
                    endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)12, (boolean)false);
                    break;
                }
                log.info("\u754c\u9762\u83b7\u53d6\u5230\u7684\u5e74\u5ea6\u503c\u57281\u548c2\u4e4b\u5916\uff0c1-\u4e0a\u534a\u5e74\u30012-\u4e0b\u534a\u5e74");
                break;
            }
            case "4": {
                startDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)1, (boolean)true);
                endDate = AchieveDateUtil.getDateByYearMonth((int)year, (int)12, (boolean)false);
                break;
            }
            default: {
                log.info("\u9009\u62e9\u7684\u7ee9\u6548\u65b9\u6848\u5b58\u5728\u4e0d\u5408\u7406\u8003\u6838\u5468\u671f\u5b57\u6bb5\u503c");
            }
        }
        dateMap.put("start", startDate);
        dateMap.put("end", endDate);
        return dateMap;
    }

    private boolean saveEvaluate(Date startDate, Date endDate, DynamicObject scheme) {
        List dynamicObjects;
        boolean success = true;
        try {
            AchieveSchemeConverter achieveSchemeConverter = new AchieveSchemeConverter(scheme, startDate, endDate);
            dynamicObjects = achieveSchemeConverter.buildEvaluationData();
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return false;
        }
        try {
            DynamicObject[] achieveEvaluateArray = new DynamicObject[dynamicObjects.size()];
            dynamicObjects.toArray(achieveEvaluateArray);
            DynamicObject[] achEvaIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])achieveEvaluateArray);
            if (achEvaIds == null || achEvaIds.length == 0) {
                log.info("\u65b0\u589e\u7efc\u5408\u7ee9\u6548\u8bc4\u4ef7\u5355\u6570\u91cf\u4e3a0\uff0c\u6784\u5efa\u7684\u8bc4\u4ef7\u5355\u6570\u91cf\u4e3a" + dynamicObjects.size());
            } else {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"ChoosePlanPeriodPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7efc\u5408\u7ee9\u6548\u8bc4\u4ef7\u5355\u51fa\u9519\uff1a", (Throwable)e);
            return false;
        }
        return success;
    }

    private void deleteEvaluate(Date startDate, Date endDate, Long planId) {
        try {
            QFilter dateFiler = new QFilter("periodstart", "=", (Object)startDate);
            dateFiler.and(new QFilter("periodend", "=", (Object)endDate));
            QFilter schemeFilter = new QFilter("assessplanid", "=", (Object)planId);
            DeleteServiceHelper.delete((String)"ssc_achieveevalute", (QFilter[])new QFilter[]{dateFiler, schemeFilter});
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8981\u8986\u76d6\u7684\u7efc\u5408\u7ee9\u6548\u8bc4\u4ef7\u5355\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    private boolean canGenerate(DynamicObjectCollection datas) {
        boolean isCan = true;
        for (DynamicObject data : datas) {
            String status = data.getString("status");
            if (StringUtils.equals((CharSequence)status, (CharSequence)"A")) continue;
            isCan = false;
            break;
        }
        return isCan;
    }
}

