/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ExtraPointsFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_TARGET = "target";
    private static final String KEY_PROJECT = "project";
    private static final String KEY_USER = "userid";
    private static final String KEY_DEPT = "dept";
    private static final String DISABLE = "0";
    private static final BigDecimal ZERO = new BigDecimal(new BigInteger("0"), 2);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl(KEY_TARGET);
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UserEdit user = (UserEdit)this.getControl(KEY_USER);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit dept = (OrgEdit)this.getControl(KEY_DEPT);
        dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (KEY_TARGET.equals(propertyName)) {
            if (newValue != null) {
                DynamicObject achieveTarget = (DynamicObject)newValue;
                this.getModel().setValue(KEY_PROJECT, (Object)achieveTarget.getDynamicObject("group"));
                BigDecimal score = (BigDecimal)this.getModel().getValue("score");
                if (score != null && !ZERO.equals(score)) {
                    this.checkScoreZone(achieveTarget, score);
                }
            } else {
                this.getModel().setValue(KEY_PROJECT, null);
            }
        } else if ("score".equals(propertyName)) {
            DynamicObject achieveTarget;
            BigDecimal score = (BigDecimal)newValue;
            if (score != null && !ZERO.equals(score) && (achieveTarget = (DynamicObject)this.getModel().getValue(KEY_TARGET)) != null) {
                this.checkScoreZone(achieveTarget, score);
            }
        } else if (KEY_USER.equals(propertyName)) {
            DynamicObject newUser = (DynamicObject)newValue;
            if (newUser == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)newUser.getLong("id"));
            QFilter[] qFilters = new QFilter[]{qFilter};
            String selectFields = "id,name,number,email,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
            DynamicObject selectedOrg = (DynamicObject)this.getModel().getValue(KEY_DEPT);
            if (selectedOrg != null) {
                Long userOrgId = selectedOrg.getLong("id");
                DynamicObject userOrg = user.getDynamicObjectCollection("entryentity").stream().filter(deptE -> Objects.equals(userOrgId, deptE.getDynamicObject("dpt").getLong("id"))).findAny().orElse(null);
                if (userOrg == null) {
                    this.getModel().setValue(KEY_DEPT, null);
                }
            }
        }
    }

    private void checkScoreZone(DynamicObject achieveTarget, BigDecimal score) {
        boolean hasSetUp = achieveTarget.getBoolean("setup");
        boolean hasSetDown = achieveTarget.getBoolean("setdown");
        BigDecimal maxScore = achieveTarget.getBigDecimal("maxscore");
        BigDecimal minScore = achieveTarget.getBigDecimal("minscore");
        if (hasSetUp && maxScore != null && maxScore.compareTo(score) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u52a0\u51cf\u5206\u503c\u201d\u5e94\u5c0f\u4e8e\u201c\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u201d\u3002", (String)"ExtraPointsListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (hasSetDown && minScore != null && minScore.compareTo(score) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u52a0\u51cf\u5206\u503c\u201d\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u201c\u6307\u6807\u5206\u503c\u6700\u5c0f\u503c\u201d\u3002", (String)"ExtraPointsListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT)) {
            int hasPermission;
            String billStatus = (String)this.getModel().getValue("billstatus");
            if ("B".equals(billStatus) || "C".equals(billStatus) || "D".equals(billStatus) || "E".equals(billStatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"org", KEY_USER, "date", KEY_PROJECT, "score", "reason", KEY_DEPT, KEY_TARGET});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
            }
            Long userId = RequestContext.get().getCurrUserId();
            DynamicObject ssc = (DynamicObject)this.getModel().getValue("org");
            String appId = this.getView().getFormShowParameter().getAppId();
            if (ssc != null && (hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)ssc.getLong("id"), (String)"12", (String)appId, (String)"ssc_extrapoints", (String)"0AQ3YJ2LET+U")) != 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"org", KEY_USER, "date", KEY_PROJECT, "score", "reason"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (KEY_TARGET.equals(name)) {
            ListShowParameter showParam = (ListShowParameter)event.getFormShowParameter();
            List qFilters = showParam.getListFilterParameter().getQFilters();
            QFilter extraPointTypeFilter = new QFilter("targettype", "=", (Object)"2");
            qFilters.add(extraPointTypeFilter);
        } else if (KEY_USER.equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.setCustomParam("ismergerows", (Object)Boolean.FALSE);
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterSelectUser"));
        } else if (KEY_DEPT.equals(name)) {
            DynamicObjectCollection deptEntrys;
            DynamicObject user = (DynamicObject)this.getModel().getValue(KEY_USER);
            if (user == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u5458\u201d\u3002", (String)"ExtraPointsFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                event.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            String selectFields = "id,name,number,email,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
            long userId = user.getLong("id");
            DynamicObject selectedUser = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
            if (selectedUser != null && (deptEntrys = selectedUser.getDynamicObjectCollection("entryentity")) != null && deptEntrys.size() > 0) {
                ArrayList<Long> orgIdList = new ArrayList<Long>(deptEntrys.size());
                for (DynamicObject dynamicObject : deptEntrys) {
                    Long deptId = dynamicObject.getDynamicObject("dpt").getLong("id");
                    orgIdList.add(deptId);
                }
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("id", "in", orgIdList));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData;
        String actionId = e.getActionId();
        if ("afterSelectUser".equals(actionId) && (returnData = (ListSelectedRowCollection)e.getReturnData()) != null && returnData.size() > 0) {
            ListSelectedRow selectedRow = returnData.get(0);
            Long entryPkValue = (Long)selectedRow.getEntryPrimaryKeyValue();
            String selectFields = "id,name,number,email,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
            Long userId = (Long)selectedRow.getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", (Object)userId);
            QFilter[] qFilters = new QFilter[]{qFilter};
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
            if (user != null) {
                this.getModel().setValue(KEY_USER, (Object)userId);
                DynamicObjectCollection deptEntrys = user.getDynamicObjectCollection("entryentity");
                DynamicObject userOrg = deptEntrys.stream().filter(deptE -> Objects.equals(entryPkValue, deptE.getPkValue())).findAny().orElse(null);
                if (userOrg != null) {
                    this.getModel().setValue(KEY_DEPT, userOrg.getDynamicObject("dpt").getPkValue());
                } else {
                    this.getModel().setValue(KEY_DEPT, null);
                }
            }
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObject target;
        long id;
        DynamicObject achieveTarget;
        String enable;
        IDataModel model = this.getModel();
        Object targetObj = model.getValue(KEY_TARGET);
        if (Objects.nonNull(targetObj) && DISABLE.equals(enable = (achieveTarget = BusinessDataServiceHelper.loadSingle((Object)(id = (target = (DynamicObject)targetObj).getLong("id")), (String)"ssc_achievetarget", (String)"enable")).getString("enable"))) {
            model.setValue(KEY_TARGET, null);
        }
    }
}

