/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.task.formplugin.util.AchieveUtil;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;

public class UserTimeSelectPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(UserTimeSelectPlugin.class);
    private static final String DATERANGEFIELD = "daterangefield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl(DATERANGEFIELD);
        headFieldEdit.setMaxDate(new Date());
    }

    public void click(EventObject evt) {
        String parentPage;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean result = false;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && "ssc_taskeffectquality".equals(parentPage = (String)customParams.get("parentPage"))) {
            result = true;
        }
        if ("btnok".equals(key)) {
            Date startday = (Date)model.getValue("startday");
            Date endday = (Date)model.getValue("endday");
            if (startday == null || endday == null) {
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdfShort = new SimpleDateFormat("yyyy-MM-dd");
            long between = AchieveDateUtil.between((Date)startday, (Date)endday);
            List<Date> dates = SscWorkCalendarUtil.findDates(startday, endday);
            if (dates.isEmpty()) {
                return;
            }
            try {
                endday = sdf.parse(sdfShort.format(endday) + " 23:59:59");
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
            if (result) {
                if (between > 125L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u6700\u591a\u4e3a4\u4e2a\u6708\u3002", (String)"UserTimeSelectPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().returnDataToParent((Object)"true");
            } else if (endday != null) {
                if (between > 31L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u671f\u8303\u56f4\u6700\u591a\u4e3a31\u5929\u3002", (String)"UserTimeSelectPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    AchieveUtil.deleteDate(dates, null);
                    for (Date date : dates) {
                        AchieveUtil.saveUserTime(date, null);
                    }
                }
                catch (Exception e) {
                    log.error("\u91cd\u7b97\u5931\u8d25\uff1a" + e);
                }
            }
            this.getView().close();
        }
    }
}

