/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.ssc.task.business.condition.ConFieldTypeEnum;

public class BillField2ConFieldEditPlugin
extends AbstractFormPlugin {
    private static final String OP_CHECK_SAVE = "checksave";
    private static final String CK_OLD_VALUE = "conFieldOldValue";
    private static final String CB_CONFIRM_CHANGE = "callback_confirmChange";
    private static final String CB_SELECT_PROP = "callback_selectProp";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"billfield", "btncancel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if ("dimsourcebill".equals(propName)) {
            DynamicObjectCollection entry = dataModel.getEntryEntity("entryentity");
            if (dataModel.getDataChanged() && oldValue != null && entry.stream().anyMatch(c -> c.getDataEntityState().isBizChanged())) {
                view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u5207\u6362\u6765\u6e90\u5355\u636e\u5c06\u6e05\u9664\u6240\u6709\u6620\u5c04\u4fe1\u606f\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"BillField2ConFieldEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CB_CONFIRM_CHANGE, (IFormPlugin)this));
                String oldDataId = ((DynamicObject)oldValue).getString("id");
                this.getPageCache().put(CK_OLD_VALUE, oldDataId);
            } else {
                this.switchEntry((DynamicObject)newValue);
            }
        } else if ("billfield".equals(propName) && StringUtils.isEmpty((CharSequence)((String)newValue))) {
            dataModel.setValue("billfieldnumber", null, rowIndex);
        }
    }

    private void buildEntryData(String entityNumber) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("entryentity");
        QFilter joinFilter = QFilter.join((String)"id", (String)"ssc_confield_mapping.confield", (QFilter)new QFilter("ssc_confield_mapping.sourcebill", "=", (Object)entityNumber), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)true);
        QFilter ableFilter = new QFilter("enable", "=", (Object)"1");
        String selectField = "id confield,R.id mId,R.billfield billfield,R.billfieldnumber billfieldnumber";
        selectField = selectField.replaceAll("R", "ssc_confield_mapping");
        DynamicObjectCollection mappingCol = QueryServiceHelper.query((String)"ssc_condition_field", (String)selectField, (QFilter[])new QFilter[]{joinFilter, ableFilter});
        if (mappingCol == null || mappingCol.size() == 0) {
            return;
        }
        mappingCol.sort((m1, m2) -> {
            String s1 = m1.getString("billfield");
            String s2 = m2.getString("billfield");
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        });
        for (int index : model.batchCreateNewEntryRow("entryentity", mappingCol.size())) {
            DynamicObject mapping = (DynamicObject)mappingCol.get(index);
            model.setValue("id", (Object)mapping.getLong("mId"), index);
            model.setValue("confield", (Object)mapping.getLong("confield"), index);
            model.setValue("billfield", (Object)mapping.getString("billfield"), index);
            model.setValue("billfieldnumber", (Object)mapping.getString("billfieldnumber"), index);
        }
        view.updateView("entryentity");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        IDataModel model = this.getModel();
        String callBackId = event.getCallBackId();
        if (CB_CONFIRM_CHANGE.equals(callBackId)) {
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.switchEntry((DynamicObject)model.getValue("dimsourcebill"));
            } else {
                String oldValue = this.getPageCache().get(CK_OLD_VALUE);
                model.beginInit();
                model.setValue("dimsourcebill", (Object)oldValue);
                model.endInit();
                this.getView().updateView("dimsourcebill");
            }
        } else if ("continue_close".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }

    private void switchEntry(DynamicObject newSourceBill) {
        IDataModel model = this.getModel();
        if (newSourceBill != null) {
            String entityNumber = newSourceBill.getString("number");
            this.buildEntryData(entityNumber);
        } else {
            model.deleteEntryData("entryentity");
        }
        model.setDataChanged(false);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(key) && this.getModel().getDataChanged()) {
            evt.setCancel(true);
            this.showClose();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("billfield".equals(key)) {
            this.showPropSelectForm();
        }
    }

    private void showPropSelectForm() {
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        String entityNumber = ((DynamicObject)model.getValue("dimsourcebill")).getString("number");
        DynamicObject conField = (DynamicObject)model.getValue("confield", currentRowIndex);
        String fieldType = conField.getString("fieldtype");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ssc_entitytree");
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        showParameter.setCustomParam("conFieldType", (Object)fieldType);
        if (ConFieldTypeEnum.BASE_DATA.getValue().equals(fieldType)) {
            showParameter.setCustomParam("baseDataType", (Object)conField.getString("basedatatype.number"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CB_SELECT_PROP));
        this.getView().showForm(showParameter);
    }

    private void showClose() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillField2ConFieldEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillField2ConFieldEditPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"BillField2ConFieldEditPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillField2ConFieldEditPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        if (CB_SELECT_PROP.equals(actionId)) {
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("billfield", (Object)name, currentRowIndex);
            model.setValue("billfieldnumber", (Object)number, currentRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String operateKey = eventArgs.getOperateKey();
        if (OP_CHECK_SAVE.equals(operateKey) && eventArgs.getOperationResult().isSuccess()) {
            DynamicObjectCollection mappingCol;
            List changedRows;
            if (model.getDataChanged() && (changedRows = (mappingCol = model.getEntryEntity("entryentity")).stream().filter(c -> c.getDataEntityState().isBizChanged()).collect(Collectors.toList())).size() > 0) {
                String entityNumber = ((DynamicObject)model.getValue("dimsourcebill")).getString("number");
                HashSet<Long> deleteMappingIds = new HashSet<Long>(4);
                ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(changedRows.size());
                HashMap<Long, DynamicObject> updateTempData = new HashMap<Long, DynamicObject>(changedRows.size());
                boolean needReload = false;
                for (DynamicObject changedRow : changedRows) {
                    long mappingId = changedRow.getLong("id");
                    String billField = changedRow.getString("billfield");
                    String billFieldNumber = changedRow.getString("billfieldnumber");
                    if (mappingId > 0L && StringUtils.isNotEmpty((CharSequence)billFieldNumber)) {
                        updateTempData.put(mappingId, changedRow);
                        continue;
                    }
                    if (mappingId > 0L && StringUtils.isEmpty((CharSequence)billFieldNumber)) {
                        deleteMappingIds.add(mappingId);
                        continue;
                    }
                    if (mappingId != 0L || !StringUtils.isNotEmpty((CharSequence)billFieldNumber)) continue;
                    DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"ssc_confield_mapping");
                    newData.set("confield", changedRow.get("confield"));
                    newData.set("sourcebill", (Object)entityNumber);
                    newData.set("billfield", (Object)billField);
                    newData.set("billfieldnumber", (Object)billFieldNumber);
                    saveData.add(newData);
                    needReload = true;
                }
                if (updateTempData.size() > 0) {
                    DynamicObject[] load;
                    for (DynamicObject row : load = BusinessDataServiceHelper.load((Object[])updateTempData.keySet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_confield_mapping"))) {
                        Long id = row.getLong("id");
                        DynamicObject temp = (DynamicObject)updateTempData.get(id);
                        if (temp == null) continue;
                        row.set("billfield", temp.get("billfield"));
                        row.set("billfieldnumber", temp.get("billfieldnumber"));
                        saveData.add(row);
                    }
                }
                if (deleteMappingIds.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ssc_confield_mapping"), (Object[])deleteMappingIds.toArray());
                    if (saveData.size() == 0) {
                        model.setDataChanged(false);
                    }
                }
                if (saveData.size() > 0) {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ssc_confield_mapping", (DynamicObject[])saveData.toArray(new DynamicObject[0]), null);
                    if (!operationResult.isSuccess()) {
                        this.getView().showTipNotification(operationResult.getMessage());
                        return;
                    }
                    if (needReload) {
                        this.buildEntryData(entityNumber);
                    }
                    model.setDataChanged(false);
                }
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConField2BillFieldEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

