/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.condition.ConditionDataQueryHelper;
import kd.ssc.task.business.condition.ConditionFilterHelper;

public class ConditionEditFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_FILTER_AP = "filtergridap";
    private static final String KEY_BTN_OK = "btnok";
    private static final String CB_EDIT_MAPPING = "editConFieldMapping";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void initialize() {
        this.initFilterApEntityType();
    }

    private MainEntityType initFilterApEntityType() {
        FilterGrid fg = (FilterGrid)this.getControl(KEY_FILTER_AP);
        MainEntityType mainEntityType = this.getEntityType();
        fg.setEntityNumber(mainEntityType.getName());
        fg.setMainEntityType(mainEntityType);
        return mainEntityType;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTN_OK.equals(key)) {
            Set entityNumbers;
            MainEntityType entityType = this.getEntityType();
            FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_AP);
            FilterCondition currentCondition = filterGrid.getFilterGridState().getFilterCondition();
            FilterBuilder currentFilterBuilder = new FilterBuilder(entityType, currentCondition, false);
            currentFilterBuilder.buildFilter(false);
            String conditionId = this.getParam("conditionId");
            if (StringUtils.isNotEmpty((String)conditionId) && (entityNumbers = ConditionDataQueryHelper.queryBindBillNumByApplyCondId((Long)Long.parseLong(conditionId))) != null && !entityNumbers.isEmpty()) {
                FilterCondition oldFilterCondition = this.getViewParamFilterCondition();
                FilterBuilder oldFilterBuilder = new FilterBuilder(entityType, oldFilterCondition, false);
                oldFilterBuilder.buildFilter(false);
                Set oldFilterFields = oldFilterBuilder.getFilterObject().getAllFilterFields().keySet();
                Set<String> currentFilterFields = currentFilterBuilder.getFilterObject().getAllFilterFields().keySet();
                if (!currentFilterFields.isEmpty() && !oldFilterFields.containsAll(currentFilterFields)) {
                    this.showEditMappingForm(entityNumbers, currentFilterFields);
                    return;
                }
            }
            String filterDes = currentFilterBuilder.getFilterObject().getFilter();
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            returnData.put("desc", filterDes);
            returnData.put("conditionJson", SerializationUtils.toJsonString((Object)currentCondition));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void showEditMappingForm(Set<String> entityNumbers, Set<String> conditionFields) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("ssc_edit_confield_mapping");
        formShowParameter.setCustomParam("entityNumbers", (Object)SerializationUtils.toJsonString(entityNumbers));
        formShowParameter.setCustomParam("conditionFields", (Object)SerializationUtils.toJsonString(conditionFields));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CB_EDIT_MAPPING);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (CB_EDIT_MAPPING.equals(actionId) && returnData != null && "ok".equals(returnData.toString())) {
            this.closeViewAndReturnData();
        }
    }

    private void closeViewAndReturnData() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_AP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        MainEntityType entityType = this.getEntityType();
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition, false);
        filterBuilder.buildFilter(false);
        String filterDes = filterBuilder.getFilterObject().getFilter();
        HashMap<String, String> returnData = new HashMap<String, String>(2);
        returnData.put("desc", filterDes);
        returnData.put("conditionJson", SerializationUtils.toJsonString((Object)filterCondition));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void afterBindData(EventObject e) {
        this.buildFilterAp();
        this.initFilterApValue();
    }

    private void buildFilterAp() {
        MainEntityType mainEntityType = this.initFilterApEntityType();
        EntityTypeUtil etu = new EntityTypeUtil();
        List filterColumns = etu.getFilterColumns((IDataEntityType)mainEntityType);
        FilterGrid fg = (FilterGrid)this.getControl(KEY_FILTER_AP);
        fg.setFieldColumns(filterColumns);
    }

    private void initFilterApValue() {
        FilterCondition filterCondition = this.getViewParamFilterCondition();
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_AP);
            filterGrid.SetValue(filterCondition);
        }
    }

    private FilterCondition getViewParamFilterCondition() {
        String conditionJson = this.getParam("conditionJson");
        FilterCondition filterCondition = null;
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        }
        return filterCondition;
    }

    private String getParam(String paramKey) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        return fsp.getCustomParam(paramKey) == null ? null : fsp.getCustomParam(paramKey).toString();
    }

    private MainEntityType getEntityType() {
        return ConditionFilterHelper.buildConFieldEntityType();
    }
}

