/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.credit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.helper.CreditServiceHelper;
import kd.ssc.task.formplugin.credit.CreditAbstractFormPlugin;

public class CreditAppWaittimeFormPlugin
extends CreditAbstractFormPlugin
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit creditLevel = (BasedataEdit)this.getControl("creditlevel");
        creditLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billType = (BasedataEdit)this.getControl("billtype");
        billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        billType.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("useorg", (Object)this.sscid);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFormData();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if ("billtype".equals(key)) {
            Set creditArgs = CreditServiceHelper.queryEnableFircmCreditArg();
            QFilter sscidFil = new QFilter("ssccenter", "=", (Object)Long.valueOf(this.sscid));
            QFilter enableFil = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            QFilter numFil = new QFilter("bindbill.number", "in", (Object)creditArgs);
            qFilters.add(sscidFil);
            qFilters.add(enableFil);
            qFilters.add(numFil);
        }
        if (qFilters.size() > 0) {
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            showParam.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("donothing_save".equals(key)) {
            boolean checkResult = this.checkData(this.getView().getParentView());
            if (checkResult) {
                this.saveData(this.getView().getParentView());
            }
        } else if ("donothing_disable".equals(key)) {
            this.updateStatus("0");
        } else if ("donothing_enable".equals(key)) {
            this.updateStatus("1");
        }
    }

    private void initFormData() {
        QFilter sscFilter = new QFilter("createorg", "=", (Object)Long.valueOf(this.sscid));
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"task_creditappwaittime", (String)"id,creditlevel,billtype,waittime,timeunit,enable", (QFilter[])new QFilter[]{sscFilter}, (String)"creditlevel.maxvalue,waittime asc");
        if (dynObjs == null || dynObjs.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", dynObjs.length);
        for (int i = 0; i < dynObjs.length; ++i) {
            DynamicObject dynObj = dynObjs[i];
            model.setValue("id", dynObj.get("id"), i);
            model.setValue("creditlevel", dynObj.get("creditlevel"), i);
            DynamicObjectCollection billTypes = (DynamicObjectCollection)dynObj.get("billtype");
            ArrayList<Long> billTypeIds = new ArrayList<Long>(8);
            for (DynamicObject billType : billTypes) {
                billTypeIds.add(billType.getLong("fbasedataid_id"));
            }
            model.setValue("billtype", (Object)billTypeIds.toArray(), i);
            model.setValue("waittime", dynObj.get("waittime"), i);
            model.setValue("timeunit", dynObj.get("timeunit"), i);
            model.setValue("enable", dynObj.get("enable"), i);
        }
        this.getView().updateView("entryentity");
    }

    private boolean checkData(IFormView parentView) {
        DynamicObjectCollection dynObjs = this.getModel().getEntryEntity("entryentity");
        StringBuilder info = new StringBuilder();
        HashMap<Long, Map<String, Set<Long>>> rowDataMap = new HashMap<Long, Map<String, Set<Long>>>(dynObjs.size());
        for (int i = 0; i < dynObjs.size(); ++i) {
            BigDecimal waitTime;
            DynamicObjectCollection billTypes;
            DynamicObject dynObj = (DynamicObject)dynObjs.get(i);
            DynamicObject creditLevel = dynObj.getDynamicObject("creditlevel");
            if (creditLevel == null) {
                String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4fe1\u7528\u7b49\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff1b", (String)"CreditAppWaittimeFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), i + 1);
                info.append(tempStr);
            }
            if ((billTypes = dynObj.getDynamicObjectCollection("billtype")).size() == 0) {
                String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e1a\u52a1\u5355\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff1b", (String)"CreditAppWaittimeFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), i + 1);
                info.append(tempStr);
            }
            if (creditLevel != null && billTypes.size() > 0) {
                this.checkBillTypeRepeat(rowDataMap, dynObjs, creditLevel, billTypes, i);
            }
            if ((waitTime = dynObj.getBigDecimal("waittime")).compareTo(BigDecimal.ZERO) != 0) continue;
            String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f85\u5206\u914d\u72b6\u6001\u505c\u7559\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff1b", (String)"CreditAppWaittimeFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), i + 1);
            info.append(tempStr);
        }
        for (Map.Entry entry : rowDataMap.entrySet()) {
            Map map = (Map)entry.getValue();
            Set keySet = map.keySet();
            for (String key : keySet) {
                if (key.indexOf(44) <= -1) continue;
                String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\uff1b", (String)"CreditAppWaittimeFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), key);
                info.append(tempStr);
            }
        }
        if (info.length() > 0) {
            parentView.showTipNotification(info.substring(0, info.length() - 1));
            return false;
        }
        return true;
    }

    private void checkBillTypeRepeat(Map<Long, Map<String, Set<Long>>> rowDataMap, DynamicObjectCollection dynObjs, DynamicObject creditLevel, DynamicObjectCollection billTypes, int i) {
        Long levelId = creditLevel.getLong("id");
        Map<String, Set<Long>> billTypeMap = rowDataMap.get(levelId);
        HashSet<Long> billTypeIds = new HashSet<Long>();
        if (billTypeMap == null) {
            billTypeMap = new HashMap<String, Set<Long>>(8);
            for (DynamicObject billType : billTypes) {
                billTypeIds.add(billType.getLong("fbasedataid_id"));
            }
            billTypeMap.put(String.valueOf(i + 1), billTypeIds);
        } else {
            for (DynamicObject billType : billTypes) {
                billTypeIds.add(billType.getLong("fbasedataid_id"));
            }
            boolean isRepeat = false;
            block2: for (Long id : billTypeIds) {
                for (Map.Entry<String, Set<Long>> entry : billTypeMap.entrySet()) {
                    if (!entry.getValue().contains(id)) continue;
                    HashSet<Long> temp = new HashSet<Long>();
                    temp.addAll(billTypeIds);
                    temp.addAll((Collection)entry.getValue());
                    String key = entry.getKey();
                    billTypeMap.remove(key);
                    billTypeMap.put(key + ',' + (i + 1), temp);
                    isRepeat = true;
                    break block2;
                }
            }
            if (!isRepeat) {
                billTypeMap.put(String.valueOf(i + 1), billTypeIds);
            }
        }
        rowDataMap.put(levelId, billTypeMap);
    }

    private void saveData(IFormView parentView) {
        DynamicObjectCollection dynObjs = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> appwaitTimes = new ArrayList<DynamicObject>(8);
        String userId = RequestContext.get().getUserId();
        for (DynamicObject dynObj : dynObjs) {
            DynamicObjectCollection billTypes;
            DynamicObject appwaitTime = BusinessDataServiceHelper.newDynamicObject((String)"task_creditappwaittime");
            Date date = new Date();
            Long id = dynObj.getLong("id");
            if (id > 0L) {
                appwaitTime.set("id", (Object)id);
            }
            appwaitTime.set("createtime", (Object)date);
            appwaitTime.set("modifytime", (Object)date);
            appwaitTime.set("creator_id", (Object)Long.valueOf(userId));
            appwaitTime.set("modifier_id", (Object)Long.valueOf(userId));
            appwaitTime.set("createorg_id", (Object)Long.valueOf(this.sscid));
            appwaitTime.set("status", (Object)"C");
            appwaitTime.set("enable", dynObj.get("enable"));
            appwaitTime.set("waittime", dynObj.get("waittime"));
            appwaitTime.set("timeunit", dynObj.get("timeunit"));
            DynamicObject creditLevel = dynObj.getDynamicObject("creditlevel");
            if (creditLevel != null) {
                appwaitTime.set("creditlevel_id", (Object)creditLevel.getLong("id"));
            }
            if ((billTypes = dynObj.getDynamicObjectCollection("billtype")).size() > 0) {
                DynamicObjectCollection newBillTypes = appwaitTime.getDynamicObjectCollection("billtype");
                for (DynamicObject billType : billTypes) {
                    DynamicObject newBillType = newBillTypes.addNew();
                    newBillType.set("fbasedataid_id", (Object)billType.getLong("fbasedataid_id"));
                }
                appwaitTime.set("billtype", (Object)newBillTypes);
            }
            appwaitTimes.add(appwaitTime);
        }
        QFilter sscFilter = new QFilter("createorg", "=", (Object)Long.valueOf(this.sscid));
        DeleteServiceHelper.delete((String)"task_creditappwaittime", (QFilter[])new QFilter[]{sscFilter});
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_creditappwaittime", (DynamicObject[])appwaitTimes.toArray(new DynamicObject[0]), null);
        super.afterSaveOperation(opResult, "task_creditappwaittime_l", parentView);
    }

    private void updateStatus(String opVal) {
        boolean isSuccess = this.updateStatus(this.getView(), this.getModel(), "task_creditappwaittime", "entryentity", opVal);
        if (isSuccess) {
            super.afterUpdateStatus(opVal, "task_creditappwaittime_l", this.getView().getParentView());
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        BasedataEdit baseData = (BasedataEdit)event.getSource();
        String key = baseData.getKey();
        FormShowParameter showParameter = event.getShowParameter();
        if ("billtype".equals(key)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("useorg", (Object)this.sscid);
        }
    }

    private boolean updateStatus(IFormView view, IDataModel model, String entityName, String entryName, String opVal) {
        boolean isSuccess = false;
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
        ArrayList<DynamicObject> newDynObjs = new ArrayList<DynamicObject>(8);
        EntryGrid entry = (EntryGrid)view.getControl(entryName);
        int[] selectRows = entry.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CreditfilesListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return isSuccess;
        }
        boolean flag = false;
        int length = selectRows.length;
        for (int i = 0; i < length; ++i) {
            DynamicObject entity = (DynamicObject)entryEntity.get(selectRows[i]);
            if (opVal.equals(entity.getString("enable"))) continue;
            model.setValue("enable", (Object)opVal, selectRows[i]);
            flag = true;
            DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            Long id = entity.getLong("id");
            entity.getString("enable");
            if (id <= 0L) continue;
            newDynObj.set("id", (Object)id);
            newDynObj.set("enable", (Object)opVal);
            newDynObjs.add(newDynObj);
        }
        if (!flag) {
            String info = "0".equals(opVal) ? ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\u3002", (String)"CreditCommonRuleFormPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\u3002", (String)"CreditCommonRuleFormPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            view.showTipNotification(info);
            return isSuccess;
        }
        view.updateView(entryName);
        isSuccess = true;
        if (newDynObjs.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])newDynObjs.toArray(new DynamicObject[0]));
        }
        return isSuccess;
    }
}

