/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.duty;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.SSCTypeEnum;

public class DutyManageTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
SearchEnterListener {
    private static final String KEY_TREE_VIEW = "treeviewap";
    private static final String CK_TREE_NODE = "treeCache";
    private static final String CK_CONFIG_PAGE_ID = "configFormPageIdCache";
    private static final String CK_CAN_SAVE = "canSaveCache";
    private static final String CK_CURRENT_NODE_ID = "currentTreeNodeId";
    private static final String IS_CONFIRM_CHANGE = "isConfirmChange";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkUserPermission();
        this.initTreeNode();
    }

    public void itemClick(ItemClickEvent evt) {
        IFormView dutyConfigForm;
        String itemKey = evt.getItemKey();
        if ("btnrefresh".equals(itemKey) && (dutyConfigForm = this.getCurrentCofFormView()) != null) {
            dutyConfigForm.invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView dutyConfigView;
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) && (dutyConfigView = this.getCurrentCofFormView()) != null) {
            IDataModel dutyConfigModel = dutyConfigView.getModel();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ssc_dutymanage", (DynamicObject[])new DynamicObject[]{dutyConfigModel.getDataEntity(true)}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showOperationResult(operationResult);
            } else {
                dutyConfigModel.setDataChanged(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DutyManageTreePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                String sscType = (String)dutyConfigModel.getValue("sscbusinesstype");
                if (SSCTypeEnum.HR.getValue().equals(sscType)) {
                    dutyConfigView.setEnable(Boolean.FALSE, new String[]{"sscbusinesstype"});
                    this.getView().sendFormAction(dutyConfigView);
                }
            }
            dutyConfigModel.updateCache();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if (nodeId.equals(this.getPageCache().get(CK_CURRENT_NODE_ID))) {
            return;
        }
        this.queryTreeNodeChildren(evt);
        if (this.closeConfigForm()) {
            this.openConfigForm(Long.parseLong(nodeId));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        OrgTreeParam param = this.getOrgTreeParam(Long.parseLong(nodeId));
        List treeChildren = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (treeChildren.size() > 0) {
            TreeNode treeNodeRoot = this.getTreeNodeRoot();
            if (treeNodeRoot == null) {
                return;
            }
            TreeNode node = treeNodeRoot.getTreeNode(nodeId);
            node.setChildren(treeChildren);
            TreeView tree = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
            tree.updateNode(node);
            tree.expand(nodeId);
            this.getPageCache().put(CK_TREE_NODE, SerializationUtils.toJsonString((Object)treeNodeRoot));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        IFormView view = this.getView();
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("close".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getPageCache().put(IS_CONFIRM_CHANGE, "");
                view.close();
            }
        } else if ("data_change_confirm".equals(callBackId)) {
            TreeView tree = (TreeView)view.getControl(KEY_TREE_VIEW);
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getPageCache().put(IS_CONFIRM_CHANGE, "");
                String focusNodeId = tree.getTreeState().getFocusNodeId();
                this.closeConfigForm();
                this.openConfigForm(Long.parseLong(focusNodeId));
            } else {
                String currentNodeId = this.getPageCache().get(CK_CURRENT_NODE_ID);
                TreeNode rootNode = this.getTreeNodeRoot();
                if (rootNode != null) {
                    TreeNode curNode = rootNode.getTreeNode(currentNodeId);
                    tree.focusNode(curNode);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean dataChanged;
        if (this.getPageCache().get(IS_CONFIRM_CHANGE) != null) {
            return;
        }
        IFormView dutyConfigForm = this.getCurrentCofFormView();
        if (dutyConfigForm != null && (dataChanged = dutyConfigForm.getModel().getDataChanged())) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"DutyManageTreePlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"DutyManageTreePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DutyManageTreePlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        IFormView view = this.getView();
        TreeView treeView = (TreeView)this.getControl(KEY_TREE_VIEW);
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(searchText, view, treeView, CK_TREE_NODE, "12");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    private void initTreeNode() {
        OrgTreeParam rootOrgParam = this.getOrgTreeParam(0L);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)rootOrgParam);
        if (root == null) {
            rootOrgParam.setBuildRootNodeInRange(false);
            root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)rootOrgParam);
            if (root == null) {
                root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"DutyManageTreePlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
        TreeNode focusNode = this.findInitFocusNode(root);
        this.getPageCache().put(CK_TREE_NODE, SerializationUtils.toJsonString((Object)root));
        TreeView treeView = (TreeView)this.getControl(KEY_TREE_VIEW);
        treeView.addNode(root);
        treeView.focusNode(focusNode);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.treeNodeClick("", focusNode.getId());
    }

    private TreeNode findInitFocusNode(TreeNode node) {
        String nodeId = node.getId();
        if (this.hasOrgPermission(Long.parseLong(nodeId))) {
            return node;
        }
        OrgTreeParam param = this.getOrgTreeParam(Long.parseLong(nodeId));
        List treeChildren = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (treeChildren.size() > 0) {
            node.setChildren(treeChildren);
            return this.findInitFocusNode((TreeNode)treeChildren.get(0));
        }
        return node;
    }

    private void checkUserPermission() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (kd.bos.util.StringUtils.isBlank((String)appId)) {
            appId = "ssc";
        }
        appId = AppMetadataCache.getAppInfo((String)appId).getId();
        String entityName = "ssc_dutymanageview";
        boolean savePer = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)"0=KX5+QVF5+R");
        if (savePer) {
            this.getPageCache().put(CK_CAN_SAVE, "true");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
        }
    }

    private boolean closeConfigForm() {
        IPageCache pageCache = this.getPageCache();
        String pageId = pageCache.get(CK_CONFIG_PAGE_ID);
        if (pageId != null) {
            if (this.getPageCache().get(IS_CONFIRM_CHANGE) != null) {
                this.sendCloseForm(pageId);
                pageCache.remove(IS_CONFIRM_CHANGE);
            } else {
                IFormView dutyConfigForm = this.getView().getView(pageId);
                if (dutyConfigForm == null) {
                    return true;
                }
                boolean dataChanged = dutyConfigForm.getModel().getDataChanged();
                if (!dataChanged) {
                    this.sendCloseForm(pageId);
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("data_change_confirm", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"DutyManageTreePlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"DutyManageTreePlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u5185\u5bb9\u66f4\u6539\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5207\u6362\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u7684\u4fe1\u606f\u3002", (String)"DutyManageTreePlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                    return false;
                }
            }
        }
        return true;
    }

    private void sendCloseForm(String pageId) {
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", pageId);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        this.getPageCache().remove(CK_CONFIG_PAGE_ID);
    }

    private void openConfigForm(long sscId) {
        TreeNode treeNode;
        String parentId;
        TreeNode rootNode;
        if (sscId < 1L) {
            return;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("ssc_dutymanage");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("settingspanel");
        formShowParameter.setCustomParam("sscId", (Object)sscId);
        formShowParameter.setCustomParam("canEdit", (Object)this.getPageCache().get(CK_CAN_SAVE));
        Long pkId = this.getDutyConfigIdBySSCId(sscId);
        if (pkId != null) {
            formShowParameter.setPkId((Object)pkId);
        }
        if ((rootNode = this.getTreeNodeRoot()) != null && StringUtils.isNotEmpty((CharSequence)(parentId = (treeNode = rootNode.getTreeNode(String.valueOf(sscId))).getParentid()))) {
            formShowParameter.setCustomParam("parentId", (Object)parentId);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
        this.getPageCache().put(CK_CONFIG_PAGE_ID, formShowParameter.getPageId());
        this.getPageCache().put(CK_CURRENT_NODE_ID, String.valueOf(sscId));
    }

    private IFormView getCurrentCofFormView() {
        IPageCache pageCache = this.getPageCache();
        String pageId = pageCache.get(CK_CONFIG_PAGE_ID);
        if (pageId != null) {
            return this.getView().getView(pageId);
        }
        return null;
    }

    private OrgTreeParam getOrgTreeParam(long orgId) {
        OrgTreeParam param = new OrgTreeParam();
        param.setId(orgId);
        param.setOrgViewNumber("12");
        param.setBuildRootNodeInRange(true);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)false);
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            QFilter idFilter = new QFilter("id", "in", (Object)userHasPermOrgs.getHasPermOrgs());
            param.setCustomFilterList(Arrays.asList(idFilter.toArray()));
        }
        return param;
    }

    private TreeNode getTreeNodeRoot() {
        String cache = this.getPageCache().get(CK_TREE_NODE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
    }

    private Long getDutyConfigIdBySSCId(long sscId) {
        QFilter sscFilter = new QFilter("sscorg", "=", (Object)sscId);
        DynamicObject dutyConfig = QueryServiceHelper.queryOne((String)"ssc_dutymanage", (String)"id", (QFilter[])sscFilter.toArray());
        if (dutyConfig != null) {
            return dutyConfig.getLong("id");
        }
        return null;
    }

    private boolean hasOrgPermission(Long orgId) {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)false);
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            return userHasPermOrgs.getHasPermOrgs().contains(orgId);
        }
        return true;
    }
}

