/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.duty;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.business.helper.DutyManageDataHelper;

public class OrgF7ExtPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        Object orgFunScope;
        FormShowParameter fsp = e.getFormShowParameter();
        String sscId = (String)fsp.getCustomParam("sscId");
        if (sscId == null) {
            return;
        }
        List dutyScopeList = DutyManageDataHelper.querySSCDutyScope((long)Long.parseLong(sscId));
        if (dutyScopeList == null) {
            return;
        }
        if (dutyScopeList.size() == 1) {
            Object orgFuncId = fsp.getCustomParam("orgFuncId");
            if (orgFuncId == null) {
                fsp.setCustomParam("orgFuncId", dutyScopeList.get(0));
            }
        } else if (dutyScopeList.size() > 1 && (orgFunScope = fsp.getCustomParam("orgFunScope")) == null) {
            if (fsp.getCustomParam("rejectInitFun") == null) {
                fsp.setCustomParam("initOrgFuncId", dutyScopeList.get(0));
            }
            fsp.setCustomParam("orgFunScope", (Object)SerializationUtils.toJsonString((Object)dutyScopeList));
        }
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        String orgFunScope = (String)fsp.getCustomParam("orgFunScope");
        ComboEdit comboEdit = (ComboEdit)view.getControl("cmborgtypelst");
        comboEdit.setComboItems(this.buildOrgDutyComboItem(orgFunScope));
        if (orgFunScope != null) {
            comboEdit.setMustInput(true);
        }
    }

    private List<ComboItem> buildOrgDutyComboItem(String dutyScope) {
        Map bizMap;
        if (dutyScope == null) {
            QFilter baseFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter visibleFilter = new QFilter("visiable", "=", (Object)Boolean.TRUE);
            QFilter baseMainFilter = new QFilter("basemaintain", "=", (Object)Boolean.TRUE);
            QFilter categoryFilter = new QFilter("category", "=", (Object)"1").or(new QFilter("id", "=", (Object)1L));
            QFilter[] filters = new QFilter[]{baseFilter, enableFilter, visibleFilter, categoryFilter, baseMainFilter};
            bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"id,fnumber,fname", (QFilter[])filters, (String)"fnumber");
        } else {
            List dutyScopeNumbers = SerializationUtils.fromJsonStringToList((String)dutyScope, String.class);
            QFilter numberFilter = new QFilter("fnumber", "in", (Object)dutyScopeNumbers);
            bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"id,fnumber,fname", (QFilter[])numberFilter.toArray(), (String)"fnumber");
        }
        if (bizMap.isEmpty()) {
            return new ArrayList<ComboItem>(0);
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(bizMap.size());
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject bizObj = (DynamicObject)entry.getValue();
            ComboItem item = new ComboItem();
            item.setValue(bizObj.getString("fnumber"));
            item.setCaption(new LocaleString(bizObj.getString("fname")));
            comboItems.add(item);
        }
        return comboItems;
    }
}

