/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.common.DisRuleDataSyncHelper;
import kd.ssc.task.formplugin.TaskRule4ImptEditPlugin;
import kd.ssc.task.formplugin.imports.TaskImportHelper;
import kd.ssc.task.partask.analyzation.ParTaskFlowAnaFromBill;

public class TaskBatchImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(TaskRule4ImptEditPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        String sscNumber = SscDistributeCache.get((String)"sscNumber");
        TaskImportHelper.invalidSsc4PerBill(billdatas, logger, sscNumber);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult = super.save(rowdatas, logger);
        if ("task_disrule".equals(this.ctx.getBillFormId()) && apiResult.getData() != null) {
            List ids = ((ArrayList)apiResult.getData()).stream().map(e -> (Long)e.get("id")).collect(Collectors.toList());
            DisRuleDataSyncHelper disRuleDataSyncHelper = new DisRuleDataSyncHelper();
            disRuleDataSyncHelper.keepDataSync(new QFilter("id", "in", ids));
        }
        if ("task_taskbill4impt".equals(this.ctx.getBillFormId()) && apiResult.getData() != null) {
            ArrayList data = (ArrayList)apiResult.getData();
            HashSet<String> successNums = new HashSet<String>(data.size());
            ArrayList bill4ImportIds = new ArrayList(data.size());
            for (Map map : data) {
                if (!((Boolean)map.get("success")).booleanValue()) continue;
                if (map.get("id") != null) {
                    bill4ImportIds.add(map.get("id"));
                }
                if (map.get("number") == null) continue;
                successNums.add(map.get("number").toString());
            }
            if (successNums.isEmpty()) {
                return apiResult;
            }
            DeleteServiceHelper.delete((String)"task_taskbill4impt", (QFilter[])new QFilter("id", "in", bill4ImportIds).toArray());
            Map<String, JSONObject> importDataMap = rowdatas.stream().collect(Collectors.toMap(k -> k.getData().getString("number"), ImportBillData::getData));
            long[] taskBillIds = DBServiceHelper.genLongIds((String)"t_tk_mainbill", (int)successNums.size());
            int i = 0;
            for (String num : successNums) {
                JSONObject dataJson = importDataMap.get(num);
                this.saveTaskBill(dataJson, taskBillIds[i]);
                ++i;
            }
        }
        return apiResult;
    }

    private void saveTaskBill(JSONObject dataJson, Long taskBillId) {
        boolean isParTask = false;
        if (dataJson.get((Object)"isParTaskBill") != null) {
            isParTask = true;
        }
        AbstractMap.SimpleEntry<DynamicObject, List<DynamicObject>> resultEntry = this.buildTaskBillDyo(dataJson, taskBillId);
        DynamicObject taskBill = (DynamicObject)resultEntry.getKey();
        List taskBillChildList = (List)resultEntry.getValue();
        try (TXHandle h = TX.requiresNew((String)(((Object)((Object)this)).getClass() + ".saveTaskBill()"));){
            try {
                OperationResult childOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_taskbill_child", (DynamicObject[])taskBillChildList.toArray(new DynamicObject[0]), null);
                if (childOpResult.isSuccess()) {
                    OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_taskbill", (DynamicObject[])new DynamicObject[]{taskBill}, null);
                    if (opResult.isSuccess()) {
                        if (isParTask) {
                            Long sscId = taskBill.getLong("ssccenter.id");
                            List taskChildIds = taskBillChildList.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
                            ParTaskFlowAnaFromBill.saveParTaskFlowDef((Object)sscId, (Object)taskBillId, taskChildIds);
                        }
                    } else {
                        this.opFailedHandling(opResult);
                    }
                } else {
                    this.opFailedHandling(childOpResult);
                }
            }
            catch (Exception e) {
                h.markRollback();
                log.info("taskbill save failed.", (Object)e);
                throw e;
            }
        }
    }

    private AbstractMap.SimpleEntry<DynamicObject, List<DynamicObject>> buildTaskBillDyo(JSONObject dataJson, Long taskBillId) {
        DynamicObject curEntry;
        JSONObject entry;
        DynamicObject taskBill = BusinessDataServiceHelper.newDynamicObject((String)"task_taskbill");
        taskBill.set("id", (Object)taskBillId);
        taskBill.set("masterid", (Object)taskBill.getLong("id"));
        taskBill.set("number", (Object)dataJson.getString("number"));
        taskBill.set("name", dataJson.get((Object)"name"));
        taskBill.set("status", (Object)"C");
        DynamicObject creatorDyo = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        creatorDyo.set("id", (Object)RequestContext.get().getCurrUserId());
        taskBill.set("creator", (Object)creatorDyo);
        taskBill.set("enable", (Object)"1");
        Long sscId = dataJson.getJSONObject("ssccenter").getLong("id");
        DynamicObject sscDyo = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        sscDyo.set("id", (Object)sscId);
        taskBill.set("ssccenter", (Object)sscDyo);
        DynamicObject externalErpDyo = BusinessDataServiceHelper.newDynamicObject((String)"bas_extenderp");
        externalErpDyo.set("id", (Object)dataJson.getJSONObject("externalerp").getLong("id"));
        taskBill.set("externalerp", (Object)externalErpDyo);
        taskBill.set("description", (Object)dataJson.getString("description"));
        DynamicObject bindBillNewDyo = BusinessDataServiceHelper.loadSingle((Object)dataJson.getJSONObject("bindbill_new").getString("number"), (String)"bos_entityobject");
        taskBill.set("bindbill_new", (Object)bindBillNewDyo);
        DynamicObject bindBillDyo = BusinessDataServiceHelper.newDynamicObject((String)"bos_formmeta");
        bindBillDyo.set("id", (Object)bindBillNewDyo.getString("dentityid"));
        taskBill.set("bindbill", (Object)bindBillDyo);
        taskBill.set("isembed", (Object)dataJson.getBoolean("isembed"));
        taskBill.set("isneedimage", (Object)dataJson.getBoolean("isneedimage"));
        taskBill.set("uselang", (Object)ResManager.getLanguage());
        taskBill.set("effective", (Object)"1");
        taskBill.set("autosynorg", (Object)"0");
        taskBill.set("createtaskmodel", (Object)dataJson.getString("createtaskmodel"));
        DynamicObject billClassfyDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_billclassify");
        billClassfyDyo.set("id", (Object)dataJson.getJSONObject("group").getLong("id"));
        taskBill.set("group", (Object)billClassfyDyo);
        DynamicObject taskPoolDyo = null;
        if (dataJson.getJSONObject("taskpool") != null) {
            taskPoolDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_querylistpool");
            taskPoolDyo.set("id", (Object)dataJson.getJSONObject("taskpool").getLong("id"));
        }
        taskBill.set("taskpool", (Object)taskPoolDyo);
        DynamicObject applyCondDyo = null;
        if (dataJson.getJSONObject("applycond") != null) {
            applyCondDyo = BusinessDataServiceHelper.newDynamicObject((String)"ssc_apply_condition");
            applyCondDyo.set("id", (Object)dataJson.getJSONObject("applycond").getLong("id"));
        }
        taskBill.set("applycond", (Object)applyCondDyo);
        taskBill.set("isuseimage", (Object)dataJson.getString("isuseimage"));
        DynamicObjectCollection orgCol = taskBill.getDynamicObjectCollection("sscbillorgpar");
        ArrayList orgIds = (ArrayList)dataJson.get((Object)"orgCollection");
        for (Long id : orgIds) {
            DynamicObject dynamicObject = orgCol.addNew();
            dynamicObject.set("fbasedataid_id", (Object)id);
        }
        DynamicObjectCollection collection = taskBill.getDynamicObjectCollection("entryentityfield");
        JSONArray fieldEntity = dataJson.getJSONArray("entryentityfield");
        for (int i = 0; i < fieldEntity.size(); ++i) {
            entry = fieldEntity.getJSONObject(i);
            curEntry = collection.addNew();
            curEntry.set("seq", (Object)(i + 1));
            curEntry.set("fieldconfiguration", (Object)entry.getString("fieldconfiguration"));
            curEntry.set("sourcefieldname", (Object)entry.getString("sourcefieldname"));
            curEntry.set("sourcefieldnumber", (Object)entry.getString("sourcefieldnumber"));
        }
        collection = taskBill.getDynamicObjectCollection("entryentity");
        JSONArray taskChildEntity = dataJson.getJSONArray("childbillentryentity");
        ArrayList<DynamicObject> taskBillChildList = new ArrayList<DynamicObject>(taskChildEntity.size());
        long[] taskChildIds_ = DBServiceHelper.genLongIds((String)"t_tk_taskbillchild", (int)taskChildEntity.size());
        Long[] taskChildIds = (Long[])Arrays.stream(taskChildIds_).boxed().toArray(Long[]::new);
        for (int i = 0; i < taskChildEntity.size(); ++i) {
            Long curChildId = taskChildIds[i];
            entry = taskChildEntity.getJSONObject(i);
            DynamicObject childEntity = BusinessDataServiceHelper.newDynamicObject((String)"task_taskbill_child");
            childEntity.set("id", (Object)curChildId);
            DynamicObject taskTypeDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_tasktype");
            taskTypeDyo.set("id", (Object)entry.getJSONObject("tasktype").getLong("id"));
            childEntity.set("tasktype", (Object)taskTypeDyo);
            childEntity.set("taskoriginal", (Object)entry.getString("taskoriginal"));
            childEntity.set("nexttasks", (Object)entry.getString("nexttasks"));
            childEntity.set("issame", (Object)entry.getBoolean("issame"));
            childEntity.set("childssc", (Object)taskBill.getDynamicObject("ssccenter"));
            childEntity.set("taskcount", (Object)1000);
            childEntity.set("taskhour", (Object)4);
            DynamicObjectCollection levelEntity = childEntity.getDynamicObjectCollection("entryentitylevel");
            DynamicObject obj1 = levelEntity.addNew();
            DynamicObject taskLevelDyo1 = BusinessDataServiceHelper.newDynamicObject((String)"task_tasklevel");
            taskLevelDyo1.set("id", (Object)1L);
            DynamicObject taskLevelDyo2 = BusinessDataServiceHelper.newDynamicObject((String)"task_tasklevel");
            taskLevelDyo2.set("id", (Object)2L);
            obj1.set("priority", (Object)taskLevelDyo1);
            obj1.set("timeliness", (Object)4);
            obj1.set("isdefault", (Object)false);
            DynamicObject obj2 = levelEntity.addNew();
            obj2.set("priority", (Object)taskLevelDyo2);
            obj2.set("timeliness", (Object)48);
            obj2.set("isdefault", (Object)true);
            this.fillMulF7Data(entry, childEntity);
            BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{childEntity}, (IDataEntityType)childEntity.getDynamicObjectType());
            taskBillChildList.add(childEntity);
            curEntry = collection.addNew();
            curEntry.set("seq", (Object)(i + 1));
            curEntry.set("childpkid", (Object)curChildId);
            curEntry.set("tasktype", (Object)taskTypeDyo);
        }
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{taskBill}, (IDataEntityType)taskBill.getDynamicObjectType());
        return new AbstractMap.SimpleEntry<DynamicObject, List<DynamicObject>>(taskBill, taskBillChildList);
    }

    private void fillMulF7Data(JSONObject entry, DynamicObject childEntry) {
        DynamicObject dynamicObject;
        if (entry.containsKey((Object)"preTaskCollection")) {
            DynamicObjectCollection col = childEntry.getDynamicObjectCollection("pretasks");
            ArrayList ids = (ArrayList)entry.get((Object)"preTaskCollection");
            for (Long id : ids) {
                dynamicObject = col.addNew();
                dynamicObject.set("fbasedataid_id", (Object)id);
            }
        }
        if (entry.containsKey((Object)"insightSchemaCollection")) {
            DynamicObjectCollection col1 = childEntry.getDynamicObjectCollection("datainsightschema");
            ArrayList ids1 = (ArrayList)entry.get((Object)"insightSchemaCollection");
            for (Long id : ids1) {
                dynamicObject = col1.addNew();
                dynamicObject.set("fbasedataid_id", (Object)id);
            }
        }
        if (entry.containsKey((Object)"checkPointCollection")) {
            ArrayList ids2 = (ArrayList)entry.get((Object)"checkPointCollection");
            DynamicObjectCollection checkEntity = childEntry.getDynamicObjectCollection("entryentityarticheck");
            for (Long id : ids2) {
                DynamicObject obj = checkEntity.addNew();
                DynamicObject taskCheckpoint = BusinessDataServiceHelper.newDynamicObject((String)"task_checkpoint");
                taskCheckpoint.set("id", (Object)id);
                obj.set("articheck", (Object)taskCheckpoint);
            }
        }
    }

    private void opFailedHandling(OperationResult opResult) {
        List allErrorOrInfo = opResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorOrInfo)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        allErrorOrInfo.forEach(error -> sb.append(error.getMessage()));
        throw new KDBizException(sb.toString());
    }
}

