/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.formplugin.imports.InitOperationEnum;

public class TaskInitToolPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    public static final String EXPORT_ON_PAGE_OPEN = "invokeExport";
    private static final String entryEntityPrefix = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"schlabel", "wfdesignlabel"});
        this.addHyperClickListener4F7();
        ((EntryGrid)this.getControl("entryentity1")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("entryentity2")).addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean success = this.setShareCenter();
        if (!success) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"TaskInitToolPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showConfigOfSelectedSsc();
    }

    private boolean setShareCenter() {
        String entityName = this.getModel().getDataEntityType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        List<ComboItem> list = TeamLeaderApi.getSscenters(RequestContext.get().getCurrUserId(), entityName, appId);
        if (list.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl("sharecenter");
            combo.setComboItems(list);
            long orgId = RequestContext.get().getOrgId();
            for (ComboItem item : list) {
                if (Long.parseLong(item.getValue()) != orgId) continue;
                this.getModel().setValue("sharecenter", (Object)orgId);
                return true;
            }
            this.getModel().setValue("sharecenter", (Object)list.get(0).getValue());
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("sharecenter".equals(key)) {
            this.showConfigOfSelectedSsc();
        } else if (key.startsWith("isconfigured")) {
            this.updateConfiguredState4Row(e);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("schlabel".equalsIgnoreCase(control.getKey())) {
            this.showList("sch_schedule");
        } else if ("wfdesignlabel".equalsIgnoreCase(control.getKey())) {
            this.showList("wf_model");
        }
    }

    private void showConfigOfSelectedSsc() {
        List<DynamicObject> items = this.syncConfigItem();
        this.fillEntryEntity(items);
    }

    private List<DynamicObject> syncConfigItem() {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"task_init_config", (String)"id,f7,requirement,isrequired,operation,area", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray(), (String)"id");
        Map<String, DynamicObject> f72Config = Arrays.stream(configs).collect(Collectors.toMap(k -> k.getDynamicObject("f7").getString("id"), v -> v, BinaryOperator.minBy(Comparator.comparingLong(a -> a.getLong("id")))));
        Long sscId = Long.parseLong(this.getModel().getValue("sharecenter").toString());
        DynamicObject[] itemArr = BusinessDataServiceHelper.load((String)"task_init_config_item", (String)"id,config,isconfigured,modifytime", (QFilter[])new QFilter("ssccenter", "=", (Object)sscId).and(new QFilter("enable", "=", (Object)"1")).toArray(), (String)"id");
        ArrayList<DynamicObject> items = new ArrayList<DynamicObject>();
        Collections.addAll(items, itemArr);
        ArrayList<Long> itemsToBeRemove = new ArrayList<Long>();
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            DynamicObject item = (DynamicObject)iterator.next();
            if (f72Config.containsKey(item.getDynamicObject("config").getDynamicObject("f7").getString("id"))) continue;
            itemsToBeRemove.add(item.getLong("id"));
            iterator.remove();
        }
        if (!itemsToBeRemove.isEmpty()) {
            DeleteServiceHelper.delete((String)"task_init_config_item", (QFilter[])new QFilter("id", "in", itemsToBeRemove).toArray());
        }
        for (DynamicObject item : items) {
            f72Config.remove(item.getDynamicObject("config").getDynamicObject("f7").getString("id"));
        }
        DynamicObject[] absentConfigItems = this.createAbsentConfigItems(sscId, f72Config.values());
        if (absentConfigItems.length > 0) {
            Collections.addAll(items, absentConfigItems);
        }
        return items;
    }

    private DynamicObject[] createAbsentConfigItems(Long sscId, Collection<DynamicObject> configs) {
        if (configs.isEmpty()) {
            return new DynamicObject[0];
        }
        List sortedItems = configs.stream().sorted(Comparator.comparingLong(a -> a.getLong("id"))).collect(Collectors.toList());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_init_config_item");
        ArrayList<DynamicObject> configItems = new ArrayList<DynamicObject>();
        for (DynamicObject config : sortedItems) {
            DynamicObject item = new DynamicObject((DynamicObjectType)type);
            item.set("ssccenter", (Object)sscId);
            item.set("config", (Object)config);
            item.set("isconfigured", (Object)false);
            item.set("enable", (Object)"1");
            configItems.add(item);
        }
        Object[] savedItems = SaveServiceHelper.save((DynamicObject[])configItems.toArray(new DynamicObject[0]));
        return (DynamicObject[])savedItems;
    }

    private void fillEntryEntity(List<DynamicObject> configItems) {
        if (configItems.isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                String entity = entryEntityPrefix + i;
                this.getModel().deleteEntryData(entity);
                this.getView().updateView(entity);
            }
            return;
        }
        Map<String, List<DynamicObject>> areaMap = configItems.stream().collect(Collectors.groupingBy(k -> k.getDynamicObject("config").getString("area")));
        IDataModel model = this.getModel();
        for (int areaIndex = 0; areaIndex < 3; ++areaIndex) {
            String entityKey = entryEntityPrefix + areaIndex;
            List<DynamicObject> items = areaMap.get(areaIndex + "");
            if (items == null) {
                this.getModel().deleteEntryData(entityKey);
                this.getView().updateView(entityKey);
                continue;
            }
            EntryGrid grid = (EntryGrid)this.getControl(entityKey);
            model.deleteEntryData(entityKey);
            model.beginInit();
            model.batchCreateNewEntryRow(entityKey, items.size());
            DynamicObjectCollection entryEntity = model.getEntryEntity(entityKey);
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject curDO = items.get(i);
                DynamicObject curEntry = (DynamicObject)entryEntity.get(i);
                DynamicObject config = curDO.getDynamicObject("config");
                curEntry.set("id", (Object)curDO.getLong("id"));
                curEntry.set("f7" + areaIndex, (Object)config.getDynamicObject("f7"));
                curEntry.set("requirement" + areaIndex, (Object)config.getString("requirement"));
                curEntry.set("isrequired" + areaIndex, (Object)config.getBoolean("isrequired"));
                curEntry.set("isconfigured" + areaIndex, (Object)curDO.getBoolean("isconfigured"));
                curEntry.set("modifytime" + areaIndex, (Object)curDO.getDate("modifytime"));
                this.hideOperationItems(grid, areaIndex, i, config.getString("operation"));
            }
            model.endInit();
            this.getView().updateView(entityKey);
        }
    }

    private void hideOperationItems(EntryGrid grid, int areaIndex, int row, String opStr) {
        ArrayList<String> opList = new ArrayList<String>();
        for (InitOperationEnum op : InitOperationEnum.values()) {
            if (opStr.contains("," + op.ordinal() + ",")) continue;
            opList.add(op.getOpKey());
        }
        if (opList.isEmpty()) {
            return;
        }
        grid.hideOperateItems("operation" + areaIndex, row, opList);
    }

    private void updateConfiguredState4Row(PropertyChangedArgs e) {
        ChangeData curRow = e.getChangeSet()[0];
        Date modifyTime = new Date();
        boolean success = DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_init_config_item set fisconfigured = ?, fmodifytime = ? where fid = ?", (Object[])new Object[]{curRow.getNewValue(), modifyTime, curRow.getDataEntity().getLong("id")});
        if (success) {
            DynamicObject dataEntity = curRow.getDataEntity();
            String entityName = dataEntity.getDataEntityType().getName();
            String fieldKey = "modifytime" + entityName.charAt(entityName.length() - 1);
            dataEntity.set(fieldKey, (Object)modifyTime);
            this.getView().updateView(fieldKey, curRow.getRowIndex());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskInitToolPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TaskInitToolPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void addHyperClickListener4F7() {
        for (int i = 0; i < 3; ++i) {
            int index = i;
            ((EntryGrid)this.getControl(entryEntityPrefix + i)).addHyperClickListener(event -> {
                if (event.getFieldName().startsWith("f7")) {
                    DynamicObject curRow = ((EntryGrid)event.getSource()).getEntryData().getDataEntitys()[event.getRowIndex()];
                    DynamicObject mainEntityInfo = curRow.getDynamicObject("f7" + index);
                    if ("DynamicFormModel".equals(mainEntityInfo.getString("modeltype"))) {
                        this.showDynamicForm(mainEntityInfo.getString("number"));
                    } else {
                        this.showList(mainEntityInfo.getString("number"));
                    }
                }
            });
        }
    }

    private void showList(String f7Number) {
        this.showList(f7Number, false);
    }

    private void showList(String f7Number, boolean exportOnPageOpen) {
        BaseShowParameter parameter;
        if ("task_taskquantcoefficient".equals(f7Number) || "task_dealopinionsopen".equals(f7Number)) {
            parameter = new BaseShowParameter();
            parameter.setFormId(f7Number);
        } else {
            ListShowParameter listParameter = new ListShowParameter();
            listParameter.setBillFormId(f7Number);
            if ("wf_model".equals(f7Number)) {
                listParameter.setFormId("wf_modeltreelist");
            } else if ("task_usergroup".equals(f7Number)) {
                listParameter.setMultiSelect(false);
            }
            parameter = listParameter;
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("sscId", this.getView().getFormShowParameter().getCustomParam("sscId"));
        if (exportOnPageOpen) {
            parameter.getCustomParams().put(EXPORT_ON_PAGE_OPEN, "1");
            parameter.getCustomParams().put("billFormId", this.getView().getFormShowParameter().getCustomParam("billFormId"));
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showDynamicForm(String f7Number) {
        FormShowParameter formParameter = new FormShowParameter();
        formParameter.setFormId(f7Number);
        formParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formParameter.setCustomParam("sscId", this.getView().getFormShowParameter().getCustomParam("sscId"));
        this.getView().showForm(formParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("entryentity1") || key.equals("entryentity2")) {
            DynamicObject curRow = ((EntryGrid)evt.getSource()).getEntryData().getDataEntitys()[evt.getRow()];
            DynamicObject f7 = curRow.getDynamicObject("f7" + key.charAt(key.length() - 1));
            this.getView().getFormShowParameter().setCustomParam("billFormId", (Object)f7.getString("number"));
            this.getView().getFormShowParameter().setCustomParam("billFormName", (Object)f7.getString("name"));
            this.getView().getFormShowParameter().setCustomParam("sscId", this.getModel().getValue("sharecenter"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String opKey = ((Donothing)source).getOperateKey();
            if (InitOperationEnum.TASK_EXPORT.getOpKey().equals(opKey)) {
                this.showList((String)this.getView().getFormShowParameter().getCustomParam("billFormId"), true);
            } else if (((Donothing)source).getOperateName().getLocaleValue().equals("switchsys")) {
                this.switchComment(opKey);
            }
        }
    }

    private void switchComment(String systemNumber) {
        DynamicObjectCollection comments = QueryServiceHelper.query((String)"task_init_relation", (String)"f7,comment", (QFilter[])new QFilter("system", "=", (Object)systemNumber).toArray());
        Map<String, String> f7ToComment = comments.stream().collect(Collectors.toMap(k -> k.getString("f7"), v -> v.getString("comment")));
        IDataModel model = this.getModel();
        for (int areaIndex = 0; areaIndex < 3; ++areaIndex) {
            String entityKey = entryEntityPrefix + areaIndex;
            String fieldKey = "comment" + areaIndex;
            DynamicObjectCollection entryEntity = model.getEntryEntity(entityKey);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                row.set(fieldKey, (Object)f7ToComment.getOrDefault(row.getDynamicObject("f7" + areaIndex).getString("number"), ""));
                this.getView().updateView(fieldKey, i);
            }
        }
    }
}

