/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.platform.engine.FormulaException;
import kd.bos.lang.Lang;
import kd.ssc.task.business.indicators.CalFormulaUtil;

public class BaseFormulaPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_btnClr = "clr";
    public static final String Key_btnBackSpace = "backspace";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_FExpression = "fexpression";
    public static final String Key_FDescription = "fdescription";
    public static final String Key_FTranExpr = "ftranexpr";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_Formula = "formula";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        this.addClickListeners(new String[]{Key_btnClr, Key_btnBackSpace});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright", "btnfuncavg", "btnfuncsum", "btnfunccount", "btnfuncmax", "btnfuncmin", "trycal"});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formulaJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_Formula);
        CRFormula formulaObj = this.deserialize(formulaJson);
        this.setFormulaObj(formulaObj);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"BaseFormulaPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        String openStatus = (String)this.getView().getFormShowParameter().getCustomParam("openstatus");
        if ("EDIT".equals(openStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", Key_btnClr, Key_btnBackSpace, Key_FExpression, Key_FDescription, "btnand", "btnor", "btnleft", "btnright", "btnfuncavg", "btnfuncsum", "btnfunccount", "btnfuncmax", "btnfuncmin", "trycal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_btnOK});
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if (Key_btnOK.equalsIgnoreCase(key)) {
            CRFormula formulaObj = this.checkFormula();
            if (formulaObj != null) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
                this.getView().close();
            }
        } else if (Key_btnCancel.equalsIgnoreCase(key)) {
            this.getView().close();
        } else if (Key_btnClr.equalsIgnoreCase(key)) {
            this.getModel().setValue(Key_FExpression, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)Key_FExpression, (int)0);
        } else if (Key_btnBackSpace.equalsIgnoreCase(key)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)Key_btnBackSpace, (String)Key_FExpression);
        } else if (key.contains("btnfunc")) {
            this.clickFunctionButton(key);
        } else if ("trycal".equals(key)) {
            CRFormula formulaObj = this.checkFormula();
            if (formulaObj == null) {
                return;
            }
            String bizNumber = (String)this.getView().getFormShowParameter().getCustomParam("bizNumber");
            Object result = null;
            try {
                result = CalFormulaUtil.tryCalBaseIndicators((String)bizNumber, (CRFormula)formulaObj);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bd5\u7b97\u5931\u8d25\uff1a%s\u3002", (String)"BaseFormulaPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u8bd5\u7b97\u6210\u529f\uff0c\u7ed3\u679c\u4e3a\uff1a%s\u3002", (String)"BaseFormulaPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), result));
        } else {
            this.clickCompareButton(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FExpression)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Exception exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"BaseFormulaPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    protected CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue(Key_FExpression, (Object)formulaObj.getExpression());
        this.getModel().setValue(Key_FDescription, (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
    }

    protected String tranFormula(CRFormula formulaObj) {
        String expressionDesc = this.tranExpression(formulaObj.getExpression());
        return expressionDesc;
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(node);
    }

    private String currentSelectNode() {
        String nodeId;
        TreeView treeView = (TreeView)this.getControl(Key_TreeView);
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8c61\u5c5e\u6027\u3002", (String)"BaseFormulaPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        if (node.getTreeNode(nodeId = (String)focusNode.get("id")).getChildren() != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u5c5e\u6027\u3002", (String)"BaseFormulaPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        return nodeId;
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(Key_FDescription);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    private void clickFunctionButton(String key) {
        String selectedNode = this.currentSelectNode();
        if (selectedNode == null) {
            return;
        }
        String functionName = "";
        switch (key) {
            case "btnfuncsum": {
                functionName = "sum(%s)";
                break;
            }
            case "btnfunccount": {
                functionName = "count(%s)";
                break;
            }
            case "btnfuncmax": {
                functionName = "max(%s)";
                break;
            }
            case "btnfuncmin": {
                functionName = "min(%s)";
                break;
            }
            case "btnfuncavg": {
                functionName = "avg(%s)";
                break;
            }
        }
        functionName = String.format(functionName, selectedNode);
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)Key_FExpression, (String)functionName);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)Key_FExpression, (String)compareValue);
        }
    }

    private CRFormula checkFormula() {
        String formulaJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_Formula);
        CRFormula formulaObj = this.deserialize(formulaJson);
        this.getFormulaObj(formulaObj);
        String expression = formulaObj.getExpression();
        if (expression.length() > 255) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u957f\u5ea6\u8d85\u51fa\u9650\u5236\u3002", (String)"BaseFormulaPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        try {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"BaseFormulaPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return null;
        }
        catch (Exception exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"BaseFormulaPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), exp.getMessage()));
            return null;
        }
        return formulaObj;
    }
}

