/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;

public class MonitorIndexShowFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MonitorIndexShowFormPlugin.class);

    public void initialize() {
        super.initialize();
        this.intiColumnMeta();
    }

    public void createNewData(BizDataEventArgs e) {
        this.buildColumnUI();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.openFlex();
        this.fillData();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        Map<Object, Object> rowData;
        List<Map<String, Object>> columnInfo;
        block4: {
            columnInfo = this.getColumnInfo();
            rowData = this.getRowData();
            if (CollectionUtils.isEmpty(columnInfo) || rowData == null || rowData.isEmpty()) {
                return;
            }
            MainEntityType oldMainType = e.getOriginalEntityType();
            newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException ex) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("[FI-PA]MainType Clone Failure!", (Throwable)ex);
            }
        }
        if (Objects.isNull(newMainType)) {
            return;
        }
        this.registerDynamicProps(newMainType, columnInfo, rowData);
        newMainType.createPropIndexsNoCache();
        e.setNewEntityType(newMainType);
    }

    private void registerDynamicProps(MainEntityType newMainType, List<Map<String, Object>> columnInfo, Map<Object, Object> rowData) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        for (Map<String, Object> map : columnInfo) {
            String columnName = map.get("columnName").toString();
            String columnNumber = map.get("columnNumber").toString();
            TextProp newProperty = new TextProp();
            newProperty.setName(columnNumber);
            newProperty.setDisplayName(new LocaleString(columnName));
            entryType.addProperty((DynamicProperty)newProperty);
        }
    }

    private void openFlex() {
        Container con = (Container)this.getView().getControl("flexpanelap");
        con.setCollapse(false);
    }

    private void fillData() {
        List<Map<String, Object>> columnInfo = this.getColumnInfo();
        Map<Object, Object> rowData = this.getRowData();
        if (CollectionUtils.isEmpty(columnInfo) || rowData == null || rowData.isEmpty()) {
            return;
        }
        this.fillDataRatio(columnInfo, rowData);
    }

    private void fillDataRatio(List<Map<String, Object>> columnInfo, Map<Object, Object> rowData) {
        ArrayList<String> fieldList = new ArrayList<String>(columnInfo.size());
        for (Map<String, Object> param : columnInfo) {
            String columnField = param.get("columnNumber").toString();
            fieldList.add(columnField);
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        this.setFieldValue(columnInfo, entry, fieldList, rowData);
    }

    private void setFieldValue(List<Map<String, Object>> columnInfo, DynamicObjectCollection cols, List<String> fieldList, Map<Object, Object> rowData) {
        Map<Object, Object> columnMap = columnInfo.stream().collect(Collectors.toMap(m -> m.get("columnId"), m -> m.get("columnNumber")));
        for (Map.Entry<Object, Object> entry : rowData.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)((String)entry.getValue()), Map.class);
            DynamicObject dy = new DynamicObject(cols.getDynamicObjectType());
            dy.set("monitor", entry.getKey());
            for (Map.Entry subEntry : map.entrySet()) {
                dy.set((String)columnMap.get(Long.parseLong((String)subEntry.getKey())), subEntry.getValue());
            }
            cols.add((Object)dy);
        }
    }

    private void buildColumnUI() {
        List<Map<String, Object>> paramList = this.getColumnInfo();
        if (paramList == null || paramList.isEmpty()) {
            return;
        }
        HashMap<String, Object> entryEntityMap = new HashMap<String, Object>();
        entryEntityMap.put("rk", "rk");
        entryEntityMap.put("fseq", "fseq");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(paramList.size());
        list.add(this.genRKColumn());
        int i = 0;
        String reportStatus = (String)this.getView().getFormShowParameter().getCustomParam("reportStatus");
        boolean isTempSave = reportStatus.equals("A");
        for (Map<String, Object> map : paramList) {
            Object columnName = map.get("columnName");
            Object columnNumber = map.get("columnNumber");
            Object columnType = map.get("columnType");
            boolean enable = isTempSave && StringUtils.equals((CharSequence)IndicatorsTypeEnum.MANUAL.getType(), (CharSequence)columnType.toString());
            Map<String, Object> cssMap = this.genColumn(columnNumber.toString(), columnName.toString(), this.genTextEditor(enable));
            list.add(cssMap);
            ++i;
        }
        entryEntityMap.put("columns", list);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{entryEntityMap});
    }

    private Map<String, Object> genTextEditor(boolean enable) {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "text");
        editor.put("eb", enable);
        editor.put("showEditButton", Boolean.FALSE);
        editor.put("isshowtooltip", Boolean.TRUE);
        editor.put("maxlength", 50);
        return editor;
    }

    private Map<String, Object> genColumn(String key, String name, Map<String, Object> editor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", key);
        map.put("filter", Boolean.TRUE);
        map.put("l", 0);
        map.put("vi", 63);
        map.put("sort", Boolean.FALSE);
        map.put("w", new LocaleString("100px"));
        map.put("header", new LocaleString(name));
        map.put("editor", editor);
        return map;
    }

    private Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", "seq");
        map.put("header", new LocaleString("#"));
        map.put("visible", Boolean.TRUE);
        map.put("width", 50);
        return map;
    }

    private void intiColumnMeta() {
        ArrayList<TextEdit> controlList = new ArrayList<TextEdit>(16);
        Container entryContainer = (Container)this.getControl("entryentity");
        MainEntityType mainType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        List<Map<String, Object>> paramList = this.getColumnInfo();
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        int i = 0;
        for (Map<String, Object> map : paramList) {
            String columnName = map.get("columnName").toString();
            String columnNumber = map.get("columnNumber").toString();
            Object columnType = map.get("columnType");
            TextField textField = new TextField();
            textField.setId(Uuid8.generateShortUuid());
            textField.setKey(columnNumber);
            textField.setName(new LocaleString(columnName));
            textField.setMustInput(true);
            textField.setEntityMetadata(entityMeta);
            entityMeta.getItems().add(textField);
            entryFieldAp.setId(Uuid8.generateShortUuid());
            entryFieldAp.setFieldId(Uuid8.generateShortUuid());
            entryFieldAp.setKey(columnNumber);
            entryFieldAp.setName(new LocaleString(columnName));
            entryFieldAp.setField((Field)textField);
            entryFieldAp.setWidth(new LocaleString("100px"));
            TextEdit textEdit = (TextEdit)entryFieldAp.buildRuntimeControl();
            textEdit.setFieldKey(columnNumber);
            textEdit.setModel(this.getModel());
            textEdit.setView(this.getView());
            textEdit.setEntryKey("entryentity");
            entryContainer.getItems().add(textEdit);
            controlList.add(textEdit);
            ++i;
        }
        if (!controlList.isEmpty()) {
            this.getView().createControlIndex(controlList);
        }
    }

    private List<Map<String, Object>> getColumnInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object params = formShowParameter.getCustomParam("columnInfo");
        if (Objects.isNull(params)) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.fromJsonString((String)((String)params), List.class);
    }

    private Map<Object, Object> getRowData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object params = formShowParameter.getCustomParam("rowData");
        if (Objects.isNull(params)) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.fromJsonString((String)((String)params), Map.class);
    }
}

