/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class MultiTaskUserFormPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
F7SelectedListRemoveListener {
    private static final String BILL_LIST = "billlistap";
    private static final String F7_SELECTED_LIST = "f7selectedlistap";
    private static final String CACHED_SELECTED_IDS = "selectedIds";
    private static final String CACHED_F7_SELECTED_DATA = "f7selectedData";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.addListRowClickListener((ListRowClickListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener(f7SelectedListRemoveEvent -> {
            this.getPageCache().remove(CACHED_SELECTED_IDS);
            this.getPageCache().remove(CACHED_F7_SELECTED_DATA);
            billList.clearSelection();
        });
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getControl(BILL_LIST);
        Long sscId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("sscId"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)sscId), new QFilter("enable", "=", (Object)"1")});
        List userGroups = Arrays.asList(load).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] loadUser = BusinessDataServiceHelper.load((String)"task_user", (String)"entryid,userfield.id", (QFilter[])new QFilter[]{new QFilter("groupid", "in", userGroups), new QFilter("usestatus", "=", (Object)"1")});
        HashSet<Long> userIds = new HashSet<Long>(loadUser.length);
        HashSet<Long> taskUserIds = new HashSet<Long>(loadUser.length);
        for (DynamicObject dynamicObject2 : loadUser) {
            Long userId = dynamicObject2.getLong("userfield.id");
            if (!userIds.contains(userId)) {
                taskUserIds.add((Long)dynamicObject2.getPkValue());
            }
            userIds.add(userId);
        }
        QFilter filter = new QFilter("id", "in", taskUserIds);
        billList.setFilter(filter);
        List selectedData = (List)this.getView().getFormShowParameter().getCustomParam("selectedData");
        if (selectedData != null) {
            List selectedIdList = selectedData.stream().map(select -> Long.valueOf((String)select.get("value"))).collect(Collectors.toList());
            this.getPageCache().put(CACHED_SELECTED_IDS, SerializationUtils.toJsonString(selectedIdList));
            ListSelectedRowCollection selectedRowCollection = new ListSelectedRowCollection();
            for (Long selectedId : selectedIdList) {
                ListSelectedRow row = new ListSelectedRow((Object)selectedId);
                selectedRowCollection.add((Object)row);
            }
            billList.putSelectedRows(selectedRowCollection);
            QFilter idFilter = new QFilter("id", "in", selectedIdList);
            DynamicObject[] taskUsers = BusinessDataServiceHelper.load((String)"task_user", (String)"entryid,userfield.name", (QFilter[])new QFilter[]{idFilter});
            ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(taskUsers.length);
            for (DynamicObject taskUser : taskUsers) {
                ValueTextItem valueTextItem = new ValueTextItem(String.valueOf(taskUser.getPkValue()), taskUser.getString("userfield.name"));
                valueTextItems.add(valueTextItem);
            }
            F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST);
            f7SelectedList.addItems(valueTextItems);
            this.getPageCache().put(CACHED_F7_SELECTED_DATA, JSONArray.toJSONString(valueTextItems));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST);
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        List currentSelectedIds = listSelectedRowCollection.stream().map(listSelectRow -> (Long)listSelectRow.getPrimaryKeyValue()).collect(Collectors.toList());
        boolean isCancelSelect = true;
        String cachedSelectIdStr = this.getPageCache().get(CACHED_SELECTED_IDS);
        List cachedSelectIds = new ArrayList(16);
        if (StringUtils.isEmpty((String)cachedSelectIdStr)) {
            isCancelSelect = false;
        } else {
            cachedSelectIds = JSONArray.parseArray((String)cachedSelectIdStr).toJavaList(Long.class);
            if (cachedSelectIds.size() == currentSelectedIds.size()) {
                return;
            }
            isCancelSelect = cachedSelectIds.size() > currentSelectedIds.size();
        }
        this.getPageCache().put(CACHED_SELECTED_IDS, SerializationUtils.toJsonString(currentSelectedIds));
        if (isCancelSelect) {
            cachedSelectIds.removeAll(currentSelectedIds);
            String cachedSelectedData = this.getPageCache().get(CACHED_F7_SELECTED_DATA);
            if (StringUtils.isEmpty((String)cachedSelectedData)) {
                return;
            }
            List valueTextItems = JSONArray.parseArray((String)cachedSelectedData).toJavaList(ValueTextItem.class);
            for (Long id : cachedSelectIds) {
                f7SelectedList.removeItem((Object)String.valueOf(id));
            }
            Iterator iterator = valueTextItems.iterator();
            while (iterator.hasNext()) {
                ValueTextItem next = (ValueTextItem)iterator.next();
                Long value = Long.valueOf(next.getValue());
                if (!cachedSelectIds.contains(value)) continue;
                iterator.remove();
            }
            this.getPageCache().put(CACHED_F7_SELECTED_DATA, JSONArray.toJSONString((Object)valueTextItems));
        } else {
            currentSelectedIds.removeAll(cachedSelectIds);
            QFilter idFilter = new QFilter("id", "in", currentSelectedIds);
            DynamicObject[] taskUsers = BusinessDataServiceHelper.load((String)"task_user", (String)"entryid,userfield.name", (QFilter[])new QFilter[]{idFilter});
            String cachedSelectedData = this.getPageCache().get(CACHED_F7_SELECTED_DATA);
            List<ValueTextItem> valueTextItems = new ArrayList(taskUsers.length);
            if (StringUtils.isNotEmpty((String)cachedSelectedData)) {
                valueTextItems = JSONArray.parseArray((String)cachedSelectedData).toJavaList(ValueTextItem.class);
            }
            for (DynamicObject taskUser : taskUsers) {
                ValueTextItem valueTextItem = new ValueTextItem(String.valueOf(taskUser.getPkValue()), taskUser.getString("userfield.name"));
                valueTextItems.add(valueTextItem);
            }
            f7SelectedList.addItems(valueTextItems);
            this.getPageCache().put(CACHED_F7_SELECTED_DATA, JSONArray.toJSONString(valueTextItems));
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        String cachedIds = this.getPageCache().get(CACHED_SELECTED_IDS);
        if (StringUtils.isNotEmpty((String)cachedIds)) {
            String param = (String)f7SelectedListRemoveEvent.getParam();
            List cachedIdList = JSONArray.parseArray((String)cachedIds).toJavaList(Long.class);
            if (!cachedIdList.contains(Long.valueOf(param))) {
                return;
            }
            BillList billList = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection selectedRowCollection = billList.getSelectedRows();
            Iterator iterator = selectedRowCollection.iterator();
            while (iterator.hasNext()) {
                ListSelectedRow next = (ListSelectedRow)iterator.next();
                if (!String.valueOf(next.getPrimaryKeyValue()).equals(param)) continue;
                iterator.remove();
                break;
            }
            billList.putSelectedRows(selectedRowCollection);
            billList.refresh();
            cachedIdList.remove(Long.valueOf(param));
            this.getPageCache().put(CACHED_SELECTED_IDS, JSONArray.toJSONString((Object)cachedIdList));
            String cachedData = this.getPageCache().get(CACHED_F7_SELECTED_DATA);
            if (StringUtils.isNotEmpty((String)cachedData)) {
                List valueTextItems = JSONArray.parseArray((String)cachedData).toJavaList(ValueTextItem.class);
                Iterator itemIterator = valueTextItems.iterator();
                while (itemIterator.hasNext()) {
                    ValueTextItem valueTextItem = (ValueTextItem)itemIterator.next();
                    String value = valueTextItem.getValue();
                    if (!value.equals(param)) continue;
                    itemIterator.remove();
                }
                this.getPageCache().put(CACHED_F7_SELECTED_DATA, JSONArray.toJSONString((Object)valueTextItems));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if ("btnok".equals(key)) {
            String cachedF7SelectedData = this.getPageCache().get(CACHED_F7_SELECTED_DATA);
            this.getView().returnDataToParent((Object)cachedF7SelectedData);
            this.getView().close();
        }
    }
}

