/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.formplugin.rpt.RptQualityCheckCommon;

public class RptQualityCheckProgressDetailQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String ENTITY_TASK = "task_task";
    private static final String ENTITY_TASKHISTORY = "task_taskhistory";
    private static final String FIELDS_TASKANDTASKHISTORY = "id,subject, orignalperson as personid,qualitysamplelibrary,state,qualityresult,reformperson,creator,receivetime";
    private static final Log log = LogFactory.getLog(RptQualityCheckProgressDetailQueryPlugin.class);
    private String[] detailShowFields = new String[]{"id", "subject", "personid", "state", "reformperson", "creator", "pointname"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam rqParam, Object arg1) throws Throwable {
        DataSet dsRet = null;
        String state = this.isHistoryTask(rqParam);
        if (StringUtils.isBlank((CharSequence)state)) {
            return dsRet;
        }
        DataSet dsTempRet = null;
        DataSet dsTask = null;
        DataSet dsTaskHistory = null;
        DataSet dsMessageRecord = null;
        DataSet dsCheckingPoint = null;
        try {
            List<QFilter> filters = RptQualityCheckCommon.getFilters(rqParam);
            dsMessageRecord = RptQualityCheckCommon.getAllMessageRecordDataSet();
            dsCheckingPoint = RptQualityCheckCommon.getAllCheckPointDataSet();
            if ("done".equalsIgnoreCase(state)) {
                dsTaskHistory = this.getTaskHistoryDataSet(filters);
                dsTempRet = dsTaskHistory.filter("qualityresult = '0'").join(dsMessageRecord.filter("reviewmethod = '1' and messagetype = '0' and isnewmessage = 1"), JoinType.LEFT).on("id", "taskid").select(new String[]{"id", "subject", "personid", "state", "reformperson", "creator", "pointid", "receivetime"}).finish().orderBy(new String[]{"receivetime"});
            } else {
                dsTask = this.getTaskDataSet(filters);
                dsTempRet = dsTask.filter("qualityresult = '0' and state in ('15','16')").join(dsMessageRecord.filter("ischeckok = false and isnewmessage = 1"), JoinType.LEFT).on("id", "taskid").select(new String[]{"id", "subject", "personid", "state", "reformperson", "creator", "pointid", "receivetime"}).finish().orderBy(new String[]{"receivetime"});
            }
            dsTempRet = dsTempRet.join(dsCheckingPoint, JoinType.LEFT).on("pointid", "id").select(new String[]{"id", "subject", "personid", "state", "reformperson", "creator", "name as pointname"}).finish();
            dsRet = dsTempRet.select(this.detailShowFields).groupBy(this.detailShowFields).finish();
        }
        catch (Exception e) {
            log.error("kd.ssc.task.formplugin.rpt.RptQualityCheckProgressDetailQueryPlugin.query\u9519\u8bef\uff1a", (Throwable)e);
        }
        finally {
            if (dsTempRet != null) {
                dsTempRet.close();
            }
            if (dsTask != null) {
                dsTask.close();
            }
            if (dsTaskHistory != null) {
                dsTaskHistory.close();
            }
            if (dsMessageRecord != null) {
                dsMessageRecord.close();
            }
            if (dsCheckingPoint != null) {
                dsCheckingPoint.close();
            }
        }
        return dsRet;
    }

    private String isHistoryTask(ReportQueryParam rqParam) {
        FilterInfo filter = rqParam.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if (!"state".equalsIgnoreCase(propName)) continue;
            String state = itemInfo.getValue().toString();
            return state;
        }
        return null;
    }

    private DataSet getTaskHistoryDataSet(List<QFilter> filters) {
        ORM orm = ORM.create();
        QFilter[] filterArr = new QFilter[filters.size()];
        filterArr = filters.toArray(filterArr);
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getTaskDataSet", ENTITY_TASKHISTORY, FIELDS_TASKANDTASKHISTORY, filterArr);
        return dsRet;
    }

    private DataSet getTaskDataSet(List<QFilter> filters) {
        ORM orm = ORM.create();
        filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
        QFilter[] filterArr = new QFilter[filters.size()];
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getTaskDataSet", ENTITY_TASK, FIELDS_TASKANDTASKHISTORY, filters.toArray(filterArr));
        return dsRet;
    }
}

