/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;

public class RptTaskQualityStatisticsPlugin
extends AbstractReportListDataPlugin {
    private Boolean istasktypedim = Boolean.FALSE;
    private Boolean isorgdim = Boolean.FALSE;
    private Boolean ishandlepersondim = Boolean.FALSE;
    private Boolean isbilltypedim = Boolean.FALSE;
    private static final Log log = LogFactory.getLog(RptTaskQualityStatisticsPlugin.class);

    private void init(ReportQueryParam param) {
        FilterItemInfo filterItem = param.getFilter().getFilterItem("dimension");
        List value = (List)filterItem.getValue();
        this.istasktypedim = value.contains("tasktypedim");
        this.isorgdim = value.contains("orgdim");
        this.ishandlepersondim = value.contains("handlepersondim");
        this.isbilltypedim = value.contains("bussinessbilldim");
    }

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        DataSet unionData;
        this.init(param);
        List filterItems = param.getFilter().getFilterItems();
        List headFilterItems = param.getFilter().getTableHeadFilterItems();
        filterItems.addAll(headFilterItems);
        Date startDate = null;
        Date endDate = null;
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if (!"receivetime".equalsIgnoreCase(propName)) continue;
            if (">=".equalsIgnoreCase(itemInfo.getCompareType())) {
                startDate = itemInfo.getDate();
                continue;
            }
            endDate = itemInfo.getDate();
        }
        if (startDate == null || endDate == null) {
            unionData = this.slowQuery(param, o);
        } else {
            DateRangeEnum dateRangeEnum = DateRangeUtil.getDateRangeEnum(startDate, endDate);
            unionData = dateRangeEnum != null ? this.fastQuery(param, dateRangeEnum) : this.slowQuery(param, o);
            if (dateRangeEnum != null && (unionData == null || unionData.isEmpty())) {
                unionData = this.slowQuery(param, o);
            }
        }
        return unionData;
    }

    private DataSet fastQuery(ReportQueryParam param, DateRangeEnum dateRangeEnum) {
        List filterItems = param.getFilter().getFilterItems();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        block16: for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if ("sharecenter.id".equalsIgnoreCase(propName)) {
                qFilters.add(new QFilter("ssc.id", itemInfo.getCompareType(), itemInfo.getValue()));
                continue;
            }
            if ("tasktype.id".equalsIgnoreCase(propName)) {
                qFilters.add(new QFilter("tasktype.id", itemInfo.getCompareType(), itemInfo.getValue()));
                continue;
            }
            if ("org.id".equalsIgnoreCase(propName)) {
                qFilters.add(new QFilter("org.id", itemInfo.getCompareType(), itemInfo.getValue()));
                continue;
            }
            if (!"personid".equalsIgnoreCase(propName)) continue;
            switch (itemInfo.getCompareType()) {
                case "LIKE": {
                    qFilters.add(new QFilter("person.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue() + "%")));
                    continue block16;
                }
                case "NOT LIKE": {
                    qFilters.add(new QFilter("person.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue() + "%")));
                    continue block16;
                }
                case "lIKE": {
                    qFilters.add(new QFilter("person.name", itemInfo.getCompareType(), (Object)(itemInfo.getValue() + "%")));
                    continue block16;
                }
                case "like": {
                    qFilters.add(new QFilter("person.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue())));
                    continue block16;
                }
                case "NOTISNULL": {
                    qFilters.add(new QFilter("person.name", "is not null", (Object)""));
                    continue block16;
                }
                case "ISNULL": {
                    qFilters.add(new QFilter("person.name", "is null", (Object)""));
                    continue block16;
                }
            }
            qFilters.add(new QFilter("person.name", itemInfo.getCompareType(), itemInfo.getValue()));
        }
        qFilters.add(new QFilter("daterange", "=", (Object)dateRangeEnum.getValue()));
        String field = "org.id as orgid, org.name as orgname, tasktype.id as tasktypeid, tasktype.name as tasktypename, billtype.id as billtypeid, billtype.name as billtypename, person.id as personid, person.name as personname, person.number as personnumber, person.picturefield as personpic, taskcount, unpasscount, returncount, pendingcount, exceptioncount";
        DataSet qualityStatistics = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".fastQuery"), (String)"task_qualitystatistics_t", (String)field, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        ORMUtil.dumpDataSet((DataSet)qualityStatistics.copy());
        if (this.istasktypedim.booleanValue() && this.isorgdim.booleanValue() && this.ishandlepersondim.booleanValue() && this.isbilltypedim.booleanValue()) {
            return qualityStatistics;
        }
        GroupbyDataSet groupbyDataSet = null;
        if (this.istasktypedim.booleanValue()) {
            groupbyDataSet = qualityStatistics.groupBy(new String[]{"tasktypeid", "tasktypename"});
        } else if (this.isorgdim.booleanValue()) {
            groupbyDataSet = qualityStatistics.groupBy(new String[]{"orgid", "orgname"});
        } else if (this.ishandlepersondim.booleanValue()) {
            groupbyDataSet = qualityStatistics.groupBy(new String[]{"personid", "personname", "personpic", "personnumber"});
        } else if (this.isbilltypedim.booleanValue()) {
            groupbyDataSet = qualityStatistics.groupBy(new String[]{"billtypeid", "billtypename"});
        }
        if (groupbyDataSet != null) {
            return groupbyDataSet.sum("taskcount").sum("unpasscount").sum("returncount").sum("pendingcount").sum("exceptioncount").finish();
        }
        log.error("\u6309\u9875\u9762\u9009\u62e9\u7684\u7edf\u8ba1\u7ef4\u5ea6\u8fdb\u884c\u7edf\u8ba1\u53d1\u751f\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a");
        return null;
    }

    private DataSet slowQuery(ReportQueryParam param, Object obj) {
        DataSet taskDataSet = null;
        DataSet stateDataSet = null;
        DataSet taskHisDataSet = null;
        DataSet stateHisDateSet = null;
        DataSet unionDataSet = null;
        taskDataSet = this.getTaskDataSet(param, obj);
        stateDataSet = this.getStateDataSet(param, obj);
        taskHisDataSet = this.getTaskHisDataSet(param, obj);
        stateHisDateSet = this.getStateHisDataSet(param, obj);
        String[] selTask = this.getSel(param, "taskFlag");
        String[] selState = this.getSel(param, "stateFlag");
        String[] selAll = this.getSel(param, "allFlag");
        String[] groupBy = this.getGroupBy(param, null);
        ArrayList<String> groupList = new ArrayList<String>(Arrays.asList(groupBy));
        groupList.add("id");
        String[] groupByWithId = groupList.toArray(new String[0]);
        DataSet taskDataSetCopy = this.getAllTaskDataSet(param, obj);
        DataSet taskHisDataSetCopy = this.getAllTaskHisDataSet(param, obj);
        DataSet taskStateDataSetCopy = taskDataSetCopy.join(stateDataSet, JoinType.INNER).select(new String[]{"id", "tasktypename", "tasktypeid", "billtypename", "billtypeid", "orgname", "orgid", "personname", "personid", "personpic", "personnumber", "jobid", "state"}).on("id", "jobid").finish();
        DataSet taskStateHisDataSetCopy = taskHisDataSetCopy.join(stateHisDateSet, JoinType.INNER).select(new String[]{"id", "tasktypename", "tasktypeid", "billtypename", "billtypeid", "orgname", "orgid", "personname", "personid", "personpic", "personnumber", "jobid", "state"}).on("id", "jobid").finish();
        DataSet taskcountDataSet = taskStateDataSetCopy.union(taskStateHisDataSetCopy);
        taskcountDataSet = taskcountDataSet.select(selTask).groupBy(groupBy).count("taskcount").finish();
        DataSet taskStateDataSet = taskDataSet.join(stateDataSet, JoinType.INNER).select(selTask, selState).on("id", "jobid").finish();
        DataSet taskStateHisDataSet = taskHisDataSet.join(stateHisDateSet, JoinType.INNER).select(selTask, selState).on("id", "jobid").finish();
        unionDataSet = taskStateDataSet.union(taskStateHisDataSet);
        unionDataSet = unionDataSet.select(selAll).groupBy(groupByWithId).sum("cast(case when state = '4' then 1 else 0 end as integer)", "unpasscount").sum("cast(case when state = '2' then 1 else 0 end as integer)", "returncount").sum("cast(case when state = '0' then 1 else 0 end as integer)", "pendingcount").sum("cast(case when state = '4' or state = '2' or state = '0' then 1 else 0 end as integer)", "exceptioncount").finish();
        ArrayList<String> selList = new ArrayList<String>(Arrays.asList(selTask));
        selList.add("unpasscount");
        selList.add("returncount");
        selList.add("pendingcount");
        selList.add("exceptioncount");
        unionDataSet = unionDataSet.select(selList.toArray(new String[0])).groupBy(groupBy).sum("case when unpasscount >= 1 then 1 else 0 end", "unpasscount").sum("cast(case when returncount >= 1 then 1 else 0 end as integer)", "returncount").sum("cast(case when pendingcount >= 1 then 1 else 0 end as integer)", "pendingcount").sum("cast(case when exceptioncount >= 1 then 1 else 0 end as integer)", "exceptioncount").finish();
        JoinDataSet joinDataSet = unionDataSet.join(taskcountDataSet, JoinType.LEFT);
        if (this.istasktypedim.booleanValue()) {
            joinDataSet.on("tasktypeid", "tasktypeid");
        }
        if (this.isbilltypedim.booleanValue()) {
            joinDataSet.on("billtypeid", "billtypeid");
        }
        if (this.isorgdim.booleanValue()) {
            joinDataSet.on("orgid", "orgid");
        }
        if (this.ishandlepersondim.booleanValue()) {
            joinDataSet.on("personid", "personid");
            joinDataSet.on("personnumber", "personnumber");
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(selTask));
        list.remove(0);
        String[] orderBy = list.toArray(new String[list.size()]);
        list.add("unpasscount");
        list.add("returncount");
        list.add("pendingcount");
        list.add("exceptioncount");
        String[] selField = list.toArray(new String[list.size()]);
        unionDataSet = joinDataSet.select(selField, new String[]{"taskcount"}).finish();
        return unionDataSet.orderBy(orderBy);
    }

    private DataSet getStateHisDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "stateFlag");
        QFilter[] filters = this.getFilters(param, "stateFlag");
        DataSet queryDataSet = orm.queryDataSet("task_stateHis", "task_statechangehis", selField, filters);
        return queryDataSet;
    }

    private DataSet getTaskHisDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "taskFlag");
        QFilter[] filters = this.getFilters(param, "taskFlag");
        DataSet queryDataSet = orm.queryDataSet("task_taskHis", "task_taskhistory", selField, filters);
        return queryDataSet;
    }

    private DataSet getStateDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "stateFlag");
        QFilter[] filters = this.getFilters(param, "stateFlag");
        DataSet queryDataSet = orm.queryDataSet("task_state", "task_statechange", selField, filters);
        return queryDataSet;
    }

    private DataSet getTaskDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "taskFlag");
        QFilter[] filters = this.getFilters(param, "taskFlag");
        DataSet queryDataSet = orm.queryDataSet("task_task", "task_task", selField, filters);
        return queryDataSet;
    }

    private DataSet getAllTaskDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = "id, tasktypeid.name as tasktypename, tasktypeid.id as tasktypeid, billtype.name as billtypename, billtype.id as billtypeid, orgid.name as orgname, orgid.id as orgid, personid.name as personname, personid.id as personid, personid.picturefield as personpic, personid.number as personnumber";
        QFilter[] filters = this.getFilters(param, "taskFlag");
        DataSet queryDataSet = orm.queryDataSet("task_task", "task_task", selField, filters);
        return queryDataSet;
    }

    private DataSet getAllTaskHisDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = "id, tasktypeid.name as tasktypename, tasktypeid.id as tasktypeid, billtype.name as billtypename, billtype.id as billtypeid, orgid.name as orgname, orgid.id as orgid, personid.name as personname, personid.id as personid, personid.picturefield as personpic, personid.number as personnumber";
        QFilter[] filters = this.getFilters(param, "taskFlag");
        DataSet queryDataSet = orm.queryDataSet("task_taskHis", "task_taskhistory", selField, filters);
        return queryDataSet;
    }

    private String getFields(ReportQueryParam param, String flag) {
        ArrayList<String> fieldList = new ArrayList<String>();
        if ("taskFlag".equals(flag)) {
            fieldList.add("id");
            if (this.istasktypedim.booleanValue()) {
                fieldList.add("tasktypeid.name as tasktypename");
                fieldList.add("tasktypeid.id as tasktypeid");
            }
            if (this.isbilltypedim.booleanValue()) {
                fieldList.add("billtype.name as billtypename");
                fieldList.add("billtype.id as billtypeid");
            }
            if (this.isorgdim.booleanValue()) {
                fieldList.add("orgid.name as orgname");
                fieldList.add("orgid.id as orgid");
            }
            if (this.ishandlepersondim.booleanValue()) {
                fieldList.add("personid.name as personname");
                fieldList.add("personid.id as personid");
                fieldList.add("personid.picturefield as personpic");
                fieldList.add("personid.number as personnumber");
            }
        } else if ("stateFlag".equals(flag)) {
            fieldList.add("jobid");
            fieldList.add("newjobstate as state");
        }
        String fieldListStr = ((Object)fieldList).toString();
        return fieldListStr.substring(1, fieldListStr.length() - 1);
    }

    private String[] getSel(ReportQueryParam param, String flag) {
        ArrayList<String> fieldList = new ArrayList<String>();
        if ("taskFlag".equals(flag) || "allFlag".equals(flag)) {
            fieldList.add("id");
            if (this.istasktypedim.booleanValue()) {
                fieldList.add("tasktypename");
                fieldList.add("tasktypeid");
            }
            if (this.isbilltypedim.booleanValue()) {
                fieldList.add("billtypename");
                fieldList.add("billtypeid");
            }
            if (this.isorgdim.booleanValue()) {
                fieldList.add("orgname");
                fieldList.add("orgid");
            }
            if (this.ishandlepersondim.booleanValue()) {
                fieldList.add("personname");
                fieldList.add("personid");
                fieldList.add("personpic");
                fieldList.add("personnumber");
            }
        }
        if ("stateFlag".equals(flag) || "allFlag".equals(flag)) {
            fieldList.add("jobid");
            fieldList.add("state");
        }
        return fieldList.toArray(new String[0]);
    }

    private String[] getGroupBy(ReportQueryParam param, String flag) {
        ArrayList<String> groupList = new ArrayList<String>();
        if (this.istasktypedim.booleanValue()) {
            groupList.add("tasktypename");
            groupList.add("tasktypeid");
        }
        if (this.isbilltypedim.booleanValue()) {
            groupList.add("billtypename");
            groupList.add("billtypeid");
        }
        if (this.isorgdim.booleanValue()) {
            groupList.add("orgname");
            groupList.add("orgid");
        }
        if (this.ishandlepersondim.booleanValue()) {
            groupList.add("personname");
            groupList.add("personid");
            groupList.add("personpic");
            groupList.add("personnumber");
        }
        return groupList.toArray(new String[groupList.size()]);
    }

    private QFilter[] getFilters(ReportQueryParam param, String flag) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        QFilter qFilter = null;
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        if ("taskFlag".equals(flag)) {
            qfList.add(notQuaCheckTask);
            qfList.add(notAutoProcess);
            block16: for (FilterItemInfo itemInfo : filterItems) {
                String propName = itemInfo.getPropName();
                if ("receivetime".equals(propName)) {
                    qFilter = new QFilter("receivetime", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("sharecenter.id".equals(propName)) {
                    qFilter = new QFilter("sscid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("tasktype.id".equals(propName)) {
                    qFilter = new QFilter("tasktypeid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("handleperson".equals(propName)) {
                    qFilter = new QFilter("personid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("org.id".equals(propName)) {
                    qFilter = new QFilter("orgid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("billtype".equals(propName)) {
                    qFilter = new QFilter("billtype.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if (!"personid".equalsIgnoreCase(propName)) continue;
                switch (itemInfo.getCompareType()) {
                    case "LIKE": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue() + "%"));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "NOT LIKE": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue() + "%"));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "lIKE": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)(itemInfo.getValue() + "%"));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "like": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue()));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "NOTISNULL": {
                        qFilter = new QFilter("personid.name", "is not null", (Object)"");
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "ISNULL": {
                        qFilter = new QFilter("personid.name", "is null", (Object)"");
                        qfList.add(qFilter);
                        continue block16;
                    }
                }
                qFilter = new QFilter("personid.name", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
            }
        } else if ("stateFlag".equals(flag)) {
            FilterItemInfo filterItem = filter.getFilterItem("jobstate");
            if (filterItem == null) {
                ArrayList<String> stateList = new ArrayList<String>();
                stateList.add(TaskStateEnum.AUDIT_PASSED.getValue());
                stateList.add(TaskStateEnum.AUDIT_NOTPASSED.getValue());
                stateList.add(TaskStateEnum.PAUSE.getValue());
                stateList.add(TaskStateEnum.RESCAN.getValue());
                qFilter = new QFilter("newjobstate", "in", stateList);
                qfList.add(qFilter);
            } else {
                qFilter = new QFilter("newjobstate", filterItem.getCompareType(), filterItem.getValue());
                qfList.add(qFilter);
            }
        }
        return qfList.toArray(new QFilter[qfList.size()]);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columnList = super.getColumns(columns);
        ReportQueryParam queryParam = this.getQueryParam();
        TaskRptHelper.createDimensionColumns(columnList, queryParam, columns);
        return columnList;
    }
}

