/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.satisfiedmanage;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.task.formplugin.satisfiedmanage.ProjectInfoDTO;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedQStatusEnum;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil;

public class SatisfiedQCopyPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SatisfiedQCopyPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String title = (String)showParameter.getCustomParam("title");
        this.getModel().setValue("title", (Object)String.format(ResManager.loadKDString((String)"%s-\u526f\u672c", (String)"SatisfiedQuestionListPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]), title));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Long questionId = (Long)showParameter.getCustomParam("questionId");
            String newTitle = this.getModel().getValue("title") + "";
            if (StringUtils.isNotEmpty((String)newTitle)) {
                DynamicObject question = QueryServiceHelper.queryOne((String)"task_satisfiedquestion", (String)"id,name,createorg,bestcemqid,thirdorgid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)questionId)});
                String bestCemQId = question.getString("bestcemqid");
                Long sscId = question.getLong("createorg");
                String thirdOrgId = question.getString("thirdorgid");
                JSONObject copyResult = null;
                try {
                    String result = SatisfiedRequestUtil.copySatisfiedQ(sscId, bestCemQId, newTitle);
                    copyResult = JSONObject.parseObject((String)result);
                    if (copyResult == null || !"0".equals(copyResult.getString("code"))) {
                        log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u95ee\u5377\u590d\u52361\uff1a\u5931\u8d25" + result);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u590d\u5236\u9879\u76ee\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (Exception ex) {
                    log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u95ee\u5377\u590d\u52362\uff1a\u5931\u8d25", (Throwable)ex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u590d\u5236\u9879\u76ee\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    ProjectInfoDTO infoDTO = (ProjectInfoDTO)copyResult.getJSONObject("data").toJavaObject(ProjectInfoDTO.class);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_satisfiedquestion");
                    dynamicObject.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"task_satisfiedquestion", (DynamicObject)dynamicObject, (String)(sscId + "")));
                    dynamicObject.set("questionstatus", (Object)SatisfiedQStatusEnum.prelaunch.getValue());
                    dynamicObject.set("enable", (Object)EnableStatusEnum.Enable.getValue());
                    dynamicObject.set("status", (Object)"C");
                    dynamicObject = SatisfiedRequestUtil.createProject(dynamicObject, infoDTO, sscId, thirdOrgId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    this.getView().returnDataToParent((Object)"success");
                    this.getView().close();
                }
                catch (Exception ex) {
                    log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u95ee\u5377\u590d\u5236\uff1a\u590d\u5236\u6210\u529f\uff0c\u4fdd\u5b58\u5931\u8d25", (Throwable)ex);
                    this.getView().returnDataToParent((Object)"fail");
                    this.getView().close();
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9879\u76ee\u540d\u79f0\u3002", (String)"SatisfiedQuestionListPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

