/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.satisfiedmanage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.SatisfiedDeliveryTypeEnum;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.domain.RecordExceptionDO;
import kd.ssc.task.formplugin.satisfiedmanage.ProjectInfoDTO;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedAesUtil;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedQStatusEnum;
import kd.ssc.task.https.HttpsClientUtil;
import kd.ssc.task.util.RecordExceptionUtil;
import kd.ssc.task.util.SSCBosUtil;

public class SatisfiedRequestUtil {
    private static final Log log = LogFactory.getLog(SatisfiedRequestUtil.class);
    private static final String DAY_FORMAT = "yyyy/MM/dd";
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static boolean getProjectInfo(String satisfiedSscId, String satisfiedInteval) {
        DynamicObject[] objects;
        HashSet<String> paramSet = new HashSet<String>(2);
        paramSet.add("satisfiedSscId");
        paramSet.add("satisfiedInteval");
        for (DynamicObject dyn : objects = BusinessDataServiceHelper.load((String)"task_paramcontrol", (String)"paramname,paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "in", paramSet)})) {
            if ("satisfiedSscId".equals(dyn.getString("paramname")) && StringUtils.isNotBlank((CharSequence)dyn.getString("paramvalue"))) {
                satisfiedSscId = dyn.getString("paramvalue");
            }
            if (!"satisfiedInteval".equals(dyn.getString("paramname")) || !StringUtils.isNotBlank((CharSequence)dyn.getString("paramvalue"))) continue;
            satisfiedInteval = dyn.getString("paramvalue");
        }
        QFilter enableQFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        if (StringUtils.isNotBlank((CharSequence)satisfiedSscId)) {
            enableQFilter.and(new QFilter("sscid", "=", (Object)Long.valueOf(satisfiedSscId)));
        }
        DynamicObjectCollection tenants = QueryServiceHelper.query((String)"task_satisfiedtenant", (String)"id,sscid,secretkey,thirdorgid,aeskey", (QFilter[])new QFilter[]{enableQFilter});
        String manageUrl = SSCBosUtil.getSscSettingInfo((String)"satisfiedmanageurl");
        for (DynamicObject tenant : tenants) {
            Long sscId = tenant.getLong("sscid");
            String secretkey = tenant.getString("secretkey");
            String thirdOrgId = tenant.getString("thirdorgid");
            String aeskey = tenant.getString("aeskey");
            if (sscId == null || StringUtils.isBlank((CharSequence)secretkey) || StringUtils.isBlank((CharSequence)thirdOrgId) || StringUtils.isBlank((CharSequence)aeskey)) {
                SatisfiedRequestUtil.prinfLog("SatisfiedUtil-getProjectInfo : Tenant Config Not Completed " + SerializationUtils.toJsonString((Object)tenant));
                continue;
            }
            String accessToken = SatisfiedRequestUtil.getAccessToken(thirdOrgId, secretkey, manageUrl);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                RecordExceptionDO recordExceptionDO = RecordExceptionDO.builder().build();
                recordExceptionDO.setAppId("ssc");
                recordExceptionDO.setMethod("kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil.getProjectinfo");
                recordExceptionDO.setErrorMsg(ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u7ba1\u7406\u83b7\u53d6token\u5931\u8d25\u3002", (String)"SatisfiedRequestUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                RecordExceptionUtil.saveRecordExcept((RecordExceptionDO)recordExceptionDO);
                return false;
            }
            int dayInteval = -2;
            if (StringUtils.isNotBlank((CharSequence)satisfiedInteval)) {
                dayInteval = -Integer.parseInt(satisfiedInteval);
            }
            if (SatisfiedRequestUtil.projectInfoRequest(thirdOrgId, sscId, accessToken, aeskey, dayInteval, manageUrl)) continue;
            return false;
        }
        SatisfiedRequestUtil.getDeliverInfo(manageUrl);
        return true;
    }

    public static String getAccessToken(String thirdOrgId, String secretKey, String manageUrl) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("org_id", (Object)thirdOrgId);
        dataObject.put("secret_key", (Object)secretKey);
        HashMap headerMap = new HashMap();
        try {
            String ret = HttpsClientUtil.executePost((String)(manageUrl + "/api/open/v1/auth/platform/"), (String)dataObject.toJSONString(), headerMap);
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest GetToken Result : " + ret);
            if (StringUtils.isBlank((CharSequence)ret)) {
                SatisfiedRequestUtil.prinfLog("SatisfiedRequest GetToken : Interface Result is Null");
                return null;
            }
            JSONObject resultJson = JSONObject.parseObject((String)ret);
            String accessToken = resultJson.getJSONObject("data").getString("access_token");
            return accessToken;
        }
        catch (Exception e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u83b7\u53d6token\uff1a\u8bf7\u6c42token\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static boolean projectInfoRequest(String thirdOrgId, Long sscid, String accessToken, String aesKey, int dayInteval, String manageUrl) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DAY_FORMAT);
        Date date = new Date();
        String endUdt = dateFormat.format(SatisfiedRequestUtil.dateBeforeOrAfter(date, 0));
        String startUdt = dateFormat.format(SatisfiedRequestUtil.dateBeforeOrAfter(date, dayInteval));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("authorization", "Bearer " + accessToken);
        String url = manageUrl + "/api/open/v1/project/" + "?org_id=" + thirdOrgId + "&start_udt=" + startUdt + "&end_udt=" + endUdt;
        try {
            String ret = HttpsClientUtil.executeGet((String)url, headerMap);
            SatisfiedRequestUtil.prinfLog("SatisfiedRequestUtil-projectInfoRequest(): Questionnaire item list result " + ret);
            if (StringUtils.isBlank((CharSequence)ret)) {
                SatisfiedRequestUtil.prinfLog("SatisfiedRequestUtil-projectInfoRequest(): Questionnaire item list result is null");
                return false;
            }
            JSONObject retObject = JSONObject.parseObject((String)ret);
            if (!"0".equals(retObject.getString("code"))) {
                String errorInfo = String.format(ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u7ba1\u7406-\u8bf7\u6c42\u6e05\u5355\u603b\u6570\uff0c\u518d\u5206\u9875\u8bf7\u6c42\uff1a\u8bf7\u6c42\u95ee\u5377\u9879\u76ee\u6e05\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u51fa\u9519,sscId=%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"SatisfiedRequestUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), sscid, retObject.getString("msg"));
                SatisfiedRequestUtil.prinfLog(errorInfo);
                RecordExceptionDO recordExceptionDO = RecordExceptionDO.builder().build();
                recordExceptionDO.setAppId("ssc");
                recordExceptionDO.setMethod("kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil.getProjectinfo");
                recordExceptionDO.setErrorMsg(errorInfo);
                RecordExceptionUtil.saveRecordExcept((RecordExceptionDO)recordExceptionDO);
                return false;
            }
            String data = SatisfiedAesUtil.decryptByAes(retObject.getString("encrypt"), aesKey);
            SatisfiedRequestUtil.prinfLog("SatisfiedRequestUtil-projectInfoRequest(): Questionnaire item list result decrypt " + data);
            JSONObject resultJson = JSONObject.parseObject((String)data);
            int total = resultJson.getJSONObject("data").getInteger("total");
            SatisfiedRequestUtil.projectInfoEveryRequest(sscid, thirdOrgId, aesKey, headerMap, url, total);
        }
        catch (Exception e) {
            StringBuilder errorInfo = new StringBuilder().append(String.format(ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u7ba1\u7406-\u8bf7\u6c42\u6e05\u5355\u603b\u6570\uff0c\u518d\u5206\u9875\u8bf7\u6c42\uff1a\u8bf7\u6c42\u95ee\u5377\u9879\u76ee\u6e05\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u51fa\u9519,sscId=%s", (String)"SatisfiedRequestUtil_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), sscid));
            RecordExceptionDO recordExceptionDO = RecordExceptionDO.builder().build();
            recordExceptionDO.setAppId("ssc");
            recordExceptionDO.setMethod("kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil.getProjectinfo");
            recordExceptionDO.setErrorMsg(errorInfo.toString());
            recordExceptionDO.setErrorStack(ExceptionUtil.getStackTrace((Throwable)e));
            RecordExceptionUtil.saveRecordExcept((RecordExceptionDO)recordExceptionDO);
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u8bf7\u6c42\u6e05\u5355\u603b\u6570\uff0c\u518d\u5206\u9875\u8bf7\u6c42\uff1a" + errorInfo, (Throwable)e);
            return false;
        }
        return true;
    }

    private static void projectInfoEveryRequest(Long sscid, String thirdOrgId, String aesKey, Map<String, String> headerMap, String commonUrl, int total) throws Exception {
        ArrayList<DynamicObject> newDynamicObjectList = new ArrayList<DynamicObject>(total);
        ArrayList<DynamicObject> updateDynamicObjectList = new ArrayList<DynamicObject>(total);
        int count = total / 10 + (total % 10 == 0 ? 0 : 1);
        SatisfiedRequestUtil.prinfLog("SatisfiedRequest-projectInfoEveryRequest() : request total pages" + count);
        for (int i = count; i > 0; --i) {
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-projectInfoEveryRequest() : current request page = " + i);
            String url = commonUrl + "&page=" + i + "&rowsPerPage=10";
            String ret = HttpsClientUtil.executeGet((String)url, headerMap);
            if (StringUtils.isBlank((CharSequence)ret)) {
                SatisfiedRequestUtil.prinfLog("SatisfiedRequest-projectInfoEveryRequest() : request result is null");
                continue;
            }
            JSONObject retObject = JSONObject.parseObject((String)ret);
            if ("0".equals(retObject.getString("code"))) {
                String data = SatisfiedAesUtil.decryptByAes(retObject.getString("encrypt"), aesKey);
                SatisfiedRequestUtil.prinfLog("SatisfiedRequest-projectInfoEveryRequest() : question item detail list interface page " + i + "decrypt result :" + data);
                JSONObject resultJson = JSONObject.parseObject((String)data);
                JSONArray jsonArray = resultJson.getJSONObject("data").getJSONArray("rows");
                List list = jsonArray.toJavaList(ProjectInfoDTO.class);
                HashSet qidset = new HashSet(20);
                list.stream().forEach(it -> qidset.add(it.getSurvey_id()));
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"task_satisfiedquestion", (String)"id,bestcemqid,questionstatus,name,deadline,bestcemcustomattr,bestcemdelivertype,createorg,bestcemqstatus,sheetnum,thirdorgid,questionstatus,delivertype,createtime,modifytime,bestcemuid,bestcemqid,bestcempreviewlink,bestcemeditlink,bestcemresponselink", (QFilter[])new QFilter[]{new QFilter("bestcemqid", "in", qidset)});
                HashMap<String, DynamicObject> existIdMap = new HashMap<String, DynamicObject>(16);
                for (DynamicObject dyo : dynamicObjects) {
                    existIdMap.put(dyo.getString("bestcemqid"), dyo);
                }
                for (ProjectInfoDTO dto : list) {
                    DynamicObject existDy = (DynamicObject)existIdMap.get(dto.getSurvey_id());
                    if (existDy != null) {
                        SatisfiedRequestUtil.createProject(existDy, dto, sscid, thirdOrgId);
                        updateDynamicObjectList.add(existDy);
                        continue;
                    }
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_satisfiedquestion");
                    SatisfiedRequestUtil.prinfLog("SatisfiedRequest-projectInfoEveryRequest() : detail list page request, sscId = " + sscid);
                    dynamicObject.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"task_satisfiedquestion", (DynamicObject)dynamicObject, (String)(sscid + "")));
                    dynamicObject.set("questionstatus", (Object)SatisfiedQStatusEnum.prelaunch.getValue());
                    dynamicObject.set("enable", (Object)EnableStatusEnum.Enable.getValue());
                    dynamicObject.set("status", (Object)"C");
                    SatisfiedRequestUtil.createProject(dynamicObject, dto, sscid, thirdOrgId);
                    newDynamicObjectList.add(dynamicObject);
                }
                continue;
            }
            StringBuilder errorInfo = new StringBuilder().append("SatisfiedRequest-projectInfoEveryRequest(): question item detail list interface return error").append(retObject.getString("msg")).append("\uff0csscid =").append(sscid);
            RecordExceptionDO recordExceptionDO = RecordExceptionDO.builder().build();
            recordExceptionDO.setAppId("ssc");
            recordExceptionDO.setMethod("kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil.projectInfoRequest");
            recordExceptionDO.setErrorMsg(errorInfo.toString());
            RecordExceptionUtil.saveRecordExcept((RecordExceptionDO)recordExceptionDO);
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-projectInfoEveryRequest(): detail list page request :" + errorInfo);
        }
        if (!CollectionUtils.isEmpty(newDynamicObjectList)) {
            SaveServiceHelper.save((DynamicObject[])newDynamicObjectList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(updateDynamicObjectList)) {
            SaveServiceHelper.update((DynamicObject[])updateDynamicObjectList.toArray(new DynamicObject[0]));
        }
    }

    public static void getDeliverInfo(String manageUrl) {
        DynamicObject[] questionQuery = BusinessDataServiceHelper.load((String)"task_satisfiedquestion", (String)"id,thirdorgid,bestcemqid,deliverurl", (QFilter[])new QFilter[]{QFilter.isNull((String)"deliverurl").or("deliverurl", "=", (Object)" ")});
        if (questionQuery.length == 0) {
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): no questionnaire need get link");
            return;
        }
        HashMap orgIdQuestionMap = new HashMap(16);
        HashMap<String, DynamicObject> surveyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject question : questionQuery) {
            List<DynamicObject> dynamicObjects;
            surveyMap.put(question.getString("bestcemqid"), question);
            if (orgIdQuestionMap.get(question.getString("thirdorgid")) == null) {
                dynamicObjects = new ArrayList<DynamicObject>();
                dynamicObjects.add(question);
                orgIdQuestionMap.put(question.getString("thirdorgid"), dynamicObjects);
                continue;
            }
            dynamicObjects = (List)orgIdQuestionMap.get(question.getString("thirdorgid"));
            dynamicObjects.add(question);
        }
        String commonUrl = manageUrl + "/api/open/v1/deliver/third/";
        DynamicObjectCollection tenantList = QueryServiceHelper.query((String)"task_satisfiedtenant", (String)"id,thirdorgid,aeskey,secretkey", (QFilter[])new QFilter[]{new QFilter("thirdorgid", "in", orgIdQuestionMap.keySet())});
        if (CollectionUtils.isEmpty((Collection)tenantList)) {
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): no tenant need get link");
            return;
        }
        HashMap tenantMap = new HashMap(16);
        tenantList.stream().forEach(s -> tenantMap.put(s.getString("thirdorgid"), s));
        JSONObject param = new JSONObject();
        for (Map.Entry entry : orgIdQuestionMap.entrySet()) {
            String orgId = (String)entry.getKey();
            DynamicObject tenant = (DynamicObject)tenantMap.get(orgId);
            if (tenant == null) {
                SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): tenant not exist, thirdorgid = " + orgId);
                continue;
            }
            List entryList = (List)entry.getValue();
            List<List<DynamicObject>> lists = SatisfiedRequestUtil.splitList(entryList, 20);
            String accessToken = SatisfiedRequestUtil.getAccessToken(orgId, tenant.getString("secretkey"), manageUrl);
            for (List<DynamicObject> list : lists) {
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(20);
                ArrayList surveyList = new ArrayList();
                list.stream().forEach(it -> surveyList.add(it.getString("bestcemqid")));
                param.put("org_id", (Object)orgId);
                param.put("survey_id", surveyList);
                param.put("ttype", (Object)0);
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("authorization", "Bearer " + accessToken);
                String url = commonUrl;
                try {
                    String ret = HttpsClientUtil.executePost((String)url, (String)param.toJSONString(), headerMap);
                    SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): request param = " + param.toJSONString() + "; aeskey = " + tenant.getString("aeskey"));
                    SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): request result = " + ret);
                    if (StringUtils.isBlank((CharSequence)ret)) {
                        SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): request result is null");
                        continue;
                    }
                    JSONObject retObject = JSONObject.parseObject((String)ret);
                    if ("0".equals(retObject.getString("code"))) {
                        String data = SatisfiedAesUtil.decryptByAes(retObject.getString("encrypt"), tenant.getString("aeskey"));
                        JSONObject resultJson = JSONObject.parseObject((String)data);
                        JSONArray surveyArray = resultJson.getJSONObject("data").getJSONArray("rows");
                        for (int i = 0; i < surveyArray.size(); ++i) {
                            JSONObject surveyObject = surveyArray.getJSONObject(i);
                            JSONArray rows = surveyObject.getJSONArray("link_rows");
                            if (CollectionUtils.isEmpty((Collection)rows)) continue;
                            String surveyId = rows.getJSONObject(0).getString("survey_id");
                            String link = rows.getJSONObject(0).getString("link");
                            DynamicObject updateObject = (DynamicObject)surveyMap.get(surveyId);
                            updateObject.set("deliverurl", (Object)link);
                            updateList.add(updateObject);
                            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): request update data :" + surveyId + " " + link);
                        }
                    } else {
                        SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): request result exception: " + retObject.getString("msg"));
                    }
                }
                catch (Exception e) {
                    log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u83b7\u53d6\u6295\u653e\u94fe\u63a5\uff1a\u8bf7\u6c42\u6295\u653e\u63a5\u53e3\u5f02\u5e38 ", (Throwable)e);
                }
                SatisfiedRequestUtil.prinfLog("SatisfiedRequest-getDeliverInfo(): request updated link count " + updateList.size());
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
    }

    public static List<List<DynamicObject>> splitList(List<DynamicObject> list, int num) {
        int i;
        int size = list.size();
        int count = size / num + (size % num > 0 ? 1 : 0);
        ArrayList<List<DynamicObject>> resList = new ArrayList<List<DynamicObject>>(count);
        for (i = 0; i < count - 1; ++i) {
            List<DynamicObject> dynamicObjectList = list.subList(i * num, (i + 1) * num);
            resList.add(dynamicObjectList);
        }
        resList.add(list.subList(i * num, size));
        return resList;
    }

    private static Date dateBeforeOrAfter(Date date, int interval) {
        SimpleDateFormat format = new SimpleDateFormat(DAY_FORMAT);
        String formatDate = format.format(date);
        Calendar calendar = Calendar.getInstance();
        try {
            date = format.parse(formatDate);
        }
        catch (ParseException e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u65e5\u671f\u524d\u63a8\u6216\u540e\u79fb\uff1a\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
        }
        calendar.setTime(date);
        calendar.add(5, interval + 1);
        return calendar.getTime();
    }

    public static String copySatisfiedQ(Object sscId, String surveyId, String newTitle) throws Exception {
        String manageUrl = SSCBosUtil.getSscSettingInfo((String)"satisfiedmanageurl");
        if (StringUtils.isBlank((CharSequence)manageUrl)) {
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-copySatisfiedQ(): address not config");
            return null;
        }
        QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        filter.and(new QFilter("sscid", "=", sscId));
        DynamicObject satisfiedTenant = QueryServiceHelper.queryOne((String)"task_satisfiedtenant", (String)"id,sscid,secretkey,thirdorgid,aeskey", (QFilter[])new QFilter[]{filter});
        if (satisfiedTenant == null || StringUtils.isBlank((CharSequence)satisfiedTenant.getString("thirdorgid")) || StringUtils.isBlank((CharSequence)satisfiedTenant.getString("aeskey")) || StringUtils.isBlank((CharSequence)satisfiedTenant.getString("secretkey"))) {
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-copySatisfiedQ(): tenant not config");
            return null;
        }
        String thirdOrgId = satisfiedTenant.getString("thirdorgid");
        String aesKey = satisfiedTenant.getString("aeskey");
        String secretKey = satisfiedTenant.getString("secretkey");
        String accessToken = SatisfiedRequestUtil.getAccessToken(thirdOrgId, secretKey, manageUrl);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            SatisfiedRequestUtil.prinfLog("SatisfiedRequest-copySatisfiedQ(): access token get failed");
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("authorization", "Bearer " + accessToken);
        HashMap<String, String> orParam2 = new HashMap<String, String>();
        orParam2.put("title", newTitle);
        orParam2.put("survey_id", surveyId);
        String result = HttpsClientUtil.executePost((String)(manageUrl + "/api/open/v1/project/copy/"), (String)JSONObject.toJSONString(orParam2), headerMap);
        SatisfiedRequestUtil.prinfLog("SatisfiedRequest-copySatisfiedQ(): result :" + result);
        JSONObject parse = JSONObject.parseObject((String)result);
        return SatisfiedAesUtil.decryptByAes(parse.getString("encrypt"), aesKey);
    }

    protected static DynamicObject createProject(DynamicObject dynamicObject, ProjectInfoDTO dto, Long sscId, String thirdOrgId) {
        dynamicObject.set("createorg", (Object)sscId);
        dynamicObject.set("name", (Object)dto.getSurvey_name());
        dynamicObject.set("bestcemqstatus", (Object)dto.getStatus());
        dynamicObject.set("sheetnum", (Object)dto.getFcount());
        dynamicObject.set("createtime", (Object)SatisfiedRequestUtil.dateParse(dto.getCreateDT()));
        dynamicObject.set("modifytime", (Object)SatisfiedRequestUtil.dateParse(dto.getUpdateDT()));
        dynamicObject.set("bestcemuid", (Object)dto.getUid());
        dynamicObject.set("bestcemqid", (Object)dto.getSurvey_id());
        dynamicObject.set("bestcemqstatus", (Object)dto.getStatus());
        dynamicObject.set("bestcempreviewlink", (Object)dto.getPreview_link());
        dynamicObject.set("bestcemeditlink", (Object)dto.getEdit_link());
        dynamicObject.set("bestcemresponselink", (Object)dto.getResponse_link());
        dynamicObject.set("thirdorgid", (Object)thirdOrgId);
        if ((dto.getStatus() + "").equals(SatisfiedQStatusEnum.finish.getValue())) {
            dynamicObject.set("questionstatus", (Object)SatisfiedQStatusEnum.recycled.getValue());
        } else if ((dto.getStatus() + "").equals(SatisfiedQStatusEnum.delete.getValue())) {
            dynamicObject.set("questionstatus", (Object)SatisfiedQStatusEnum.delete_kd.getValue());
        } else if ((dto.getStatus() + "").equals(SatisfiedQStatusEnum.start.getValue())) {
            dynamicObject.set("questionstatus", (Object)SatisfiedQStatusEnum.start_kd.getValue());
        } else if ((dto.getStatus() + "").equals(SatisfiedQStatusEnum.publish.getValue()) && !dynamicObject.getString("questionstatus").equals(SatisfiedQStatusEnum.launched.getValue())) {
            dynamicObject.set("questionstatus", (Object)SatisfiedQStatusEnum.prelaunch.getValue());
        }
        String customAttr = dto.getCustomAttr();
        JSONObject customAttrObject = JSONObject.parseObject((String)customAttr);
        Date endTime = customAttrObject.getDate("end_time");
        dynamicObject.set("deadline", (Object)endTime);
        if (customAttr.length() > 1000) {
            customAttr = customAttr.substring(0, 1000);
        }
        dynamicObject.set("bestcemcustomattr", (Object)customAttr);
        List<String> deliverTypes = dto.getDeliver_types();
        if (!CollectionUtils.isEmpty(deliverTypes)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String it : deliverTypes) {
                if (SatisfiedDeliveryTypeEnum.getDeliveryType((String)it) == null) continue;
                stringBuilder.append(SatisfiedDeliveryTypeEnum.getDeliveryType((String)it).getName()).append(',');
            }
            dynamicObject.set("delivertype", (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
            dynamicObject.set("bestcemdelivertype", (Object)String.join((CharSequence)";", deliverTypes));
        }
        return dynamicObject;
    }

    public static void prinfLog(String msg) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"satisfiedprintlog")});
        if ("false".equals(dynamicObject.getString("paramvalue"))) {
            return;
        }
        log.info(msg);
    }

    private static Date dateParse(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
        Date date = new Date();
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
        }
        return date;
    }

    public static boolean codeRule() {
        QFilter filter = new QFilter("bizobjectid", "=", (Object)"task_satisfiedquestion");
        filter.and("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        DynamicObject codeRule = QueryServiceHelper.queryOne((String)"bos_coderule", (String)"id,enable", (QFilter[])new QFilter[]{filter});
        return codeRule != null;
    }
}

