/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.sla;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.constant.EntityField;
import kd.ssc.task.common.BillStatus;

public class SlaContractDetailsFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BILLING_QTY = "qty";
    private static final String BILLING_FIXED = "fixed";
    private static final String ENTRY_DETAIL = "detailsentry";
    private static final String CACHE_NORSETAMT = "cache_norsetamt";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject evt) {
        BasedataEdit servicePro = (BasedataEdit)this.getControl("serviceproject");
        servicePro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit serviceCla = (BasedataEdit)this.getControl("serviceclassify");
        serviceCla.addBeforeF7ViewDetailListener(e -> {
            BasedataEdit serviceClassify = (BasedataEdit)e.getSource();
            serviceClassify.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String billStatus = (String)model.getValue("status");
        if (BillStatus.AUDIT.getStatus().equals(billStatus)) {
            this.initNorUnits(view);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.setButtonVisible();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String proName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if (ENTRY_DETAIL.equals(proName)) {
            int rowCount = model.getEntryRowCount(ENTRY_DETAIL);
            model.setValue("serviceproject", null, rowCount - 1);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        if ("serviceproject".equals(key)) {
            this.addServiceProjectFilter(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"billing")) {
            this.changeBillingAction(model, propValue, rowIndex);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"serviceproject")) {
            this.changeServiceProjectAction(model, propValue, rowIndex);
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObject currencyDy;
        long id;
        Object dynamicObject;
        String enable;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object currency = model.getValue("currency");
        if (!Objects.isNull(currency) && "0".equals(enable = (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)(id = (currencyDy = (DynamicObject)currency).getLong("id")), (String)"bd_currency")).getString("enable"))) {
            model.setValue("currency", null);
        }
        DynamicObjectCollection entity = model.getEntryEntity(ENTRY_DETAIL);
        HashSet<Long> projects = new HashSet<Long>(8);
        HashSet<Long> servicestandardIds = new HashSet<Long>(8);
        for (DynamicObject dy : entity) {
            Object servicestandardObj;
            Object serviceprojectObj = dy.get("serviceproject");
            if (!Objects.isNull(serviceprojectObj)) {
                DynamicObject serviceproject = (DynamicObject)serviceprojectObj;
                long id2 = serviceproject.getLong("id");
                projects.add(id2);
            }
            if (Objects.isNull(servicestandardObj = dy.get("servicestandard"))) continue;
            DynamicObject servicestandard = (DynamicObject)servicestandardObj;
            long id3 = servicestandard.getLong("id");
            servicestandardIds.add(id3);
        }
        QFilter qFilter1 = new QFilter("id", "in", projects);
        QFilter qFilter2 = new QFilter("id", "in", servicestandardIds);
        Map slaServiceproject = BusinessDataServiceHelper.loadFromCache((String)"sla_serviceproject", (QFilter[])qFilter1.toArray());
        Map slaServicelevel = BusinessDataServiceHelper.loadFromCache((String)"sla_servicelevel", (QFilter[])qFilter2.toArray());
        for (DynamicObject dy : entity) {
            String enable2;
            DynamicObject servicestandard;
            long id4;
            DynamicObject dynamicObject2;
            Object servicestandardObj;
            String enable3;
            DynamicObject serviceproject;
            long id5;
            DynamicObject dynamicObject3;
            Object serviceprojectObj = dy.get("serviceproject");
            if (!Objects.isNull(serviceprojectObj) && !Objects.isNull(dynamicObject3 = (DynamicObject)slaServiceproject.get(id5 = (serviceproject = (DynamicObject)serviceprojectObj).getLong("id"))) && "0".equals(enable3 = dynamicObject3.getString("enable"))) {
                dy.set("serviceproject", null);
                dy.set("serviceclassify", null);
            }
            if (Objects.isNull(servicestandardObj = dy.get("servicestandard")) || Objects.isNull(dynamicObject2 = (DynamicObject)slaServicelevel.get(id4 = (servicestandard = (DynamicObject)servicestandardObj).getLong("id"))) || !"0".equals(enable2 = dynamicObject2.getString("enable"))) continue;
            dy.set("servicestandard", null);
        }
    }

    private void changeBillingAction(IDataModel model, Object propValue, int rowIndex) {
        if (StringUtils.isBlank((Object)propValue)) {
            model.setValue("price", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("norprice", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("fixedamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("norfixedamount", (Object)BigDecimal.ZERO, rowIndex);
        } else if (StringUtils.equals((CharSequence)((String)propValue), (CharSequence)BILLING_QTY)) {
            model.setValue("fixedamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("norfixedamount", (Object)BigDecimal.ZERO, rowIndex);
        } else if (StringUtils.equals((CharSequence)((String)propValue), (CharSequence)BILLING_FIXED)) {
            model.setValue("price", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("norprice", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void changeServiceProjectAction(IDataModel model, Object propValue, int rowIndex) {
        if (propValue == null) {
            model.setValue("serviceclassify", null, rowIndex);
        } else {
            Long id = ((DynamicObject)propValue).getLong("id");
            DynamicObject classify = QueryServiceHelper.queryOne((String)"sla_serviceproject", (String)EntityField.buildSelectField((String[])new String[]{"group"}), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (classify != null) {
                model.setValue("serviceclassify", (Object)classify.getLong("group"), rowIndex);
            }
        }
        this.getView().updateView("serviceclassify", rowIndex);
    }

    private void addServiceProjectFilter(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        List ids = model.getEntryEntity(ENTRY_DETAIL).stream().map(v -> v.getLong("serviceproject.id")).collect(Collectors.toList());
        QFilter addFilter = new QFilter("id", "not in", ids);
        List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
        qFilters.add(addFilter);
    }

    private void initNorUnits(IFormView view) {
        Map paramMap = view.getFormShowParameter().getCustomParams();
        if (!ObjectUtils.isEmpty((Object)paramMap)) {
            Object setNorAmt = paramMap.get("setnoramt");
            if (setNorAmt != null) {
                if (((Boolean)setNorAmt).booleanValue()) {
                    this.getPageCache().put(CACHE_NORSETAMT, "Y");
                    this.setNorColEditablePropByProxy(view, Boolean.TRUE);
                } else {
                    this.setNorColEditablePropByProxy(view, Boolean.FALSE);
                }
            } else {
                this.setNorColEditablePropByProxy(view, Boolean.FALSE);
            }
        } else {
            this.setNorColEditablePropByProxy(view, Boolean.FALSE);
        }
    }

    private void setNorColEditablePropByProxy(IFormView view, Boolean enable) {
        view.setVisible(enable, new String[]{"bar_save"});
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(ENTRY_DETAIL, "setColEditorProp", new Object[]{"norprice", "eb", enable});
        proxy.invokeControlMethod(ENTRY_DETAIL, "setColEditorProp", new Object[]{"norfixedamount", "eb", enable});
    }

    private void setButtonVisible() {
        String status = (String)this.getModel().getValue("status");
        IFormView view = this.getView();
        String norSetAmt = this.getPageCache().get(CACHE_NORSETAMT);
        switch (status) {
            case "A": {
                this.setNorColEditablePropByProxy(view, Boolean.TRUE);
                break;
            }
            case "B": {
                this.setNorColEditablePropByProxy(view, Boolean.FALSE);
                break;
            }
            case "C": {
                if ("Y".equals(norSetAmt)) break;
                this.setNorColEditablePropByProxy(view, Boolean.FALSE);
                break;
            }
        }
    }
}

