/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.sla;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.ssc.sla.SlaUtil;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;

public class SlaServiceContractFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_DETAIL = "condetails";
    private static final String Caller_BindData = "binddata";
    private static final String Caller_PropChange = "propchange";
    private static final String RelationType_Accounting = "1";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject evt) {
        BasedataEdit conDetails = (BasedataEdit)this.getControl("contractdetails");
        conDetails.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit relationOrg = (BasedataEdit)this.getControl("relationorg");
        relationOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit customer = (BasedataEdit)this.getControl("customer");
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBillInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object hisValue = valueSet[0].getOldValue();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"contractdetails")) {
            this.changeConDetailAction(model, propValue);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"currency")) {
            this.initLableValue(Caller_PropChange);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"startdate")) {
            Date endDate = (Date)model.getValue("enddate");
            if (propValue != null && endDate != null && ((Date)propValue).after(endDate)) {
                model.setValue("startdate", hisValue);
                view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u8d77\u59cb\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5408\u540c\u622a\u6b62\u65e5\u671f\u3002", (String)"SlaServiceContractFormPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"enddate")) {
            Date startDate = (Date)model.getValue("startdate");
            if (propValue != null && startDate != null && ((Date)propValue).before(startDate)) {
                model.setValue("enddate", hisValue);
                view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5408\u540c\u8d77\u59cb\u65e5\u671f\u3002", (String)"SlaServiceContractFormPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"relationorg") && propValue != null) {
            Long sscId;
            Long orgId = ((DynamicObject)propValue).getLong("id");
            QFilter[] qFilters = new QFilter[]{new QFilter("internal_company", "=", (Object)orgId), new QFilter("enable", "=", (Object)RelationType_Accounting), new QFilter("status", "=", (Object)"C"), BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)(sscId = Long.valueOf(((DynamicObject)model.getValue("org")).getLong("id"))))};
            DynamicObject[] result = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])qFilters);
            if (result.length > 0) {
                Long setCustomerId = result[0].getLong("id");
                model.setValue("customer", (Object)setCustomerId);
            } else {
                model.setValue("customer", null);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObjectCollection conDetailsEntry = this.getModel().getEntryEntity(ENTRY_DETAIL);
        this.getModel().updateEntryCache(conDetailsEntry);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        if ("relationorg".equals(key)) {
            IDataModel model = this.getModel();
            Object ssc = model.getValue("org");
            if (ssc == null) {
                e.setCancel(true);
                return;
            }
            Long sscId = ((DynamicObject)ssc).getLong("id");
            OrgF7ViewShowHelper.beforeF7Select((BeforeF7SelectEvent)e, (Long)sscId);
        } else if ("customer".equals(key)) {
            this.addCustomerFilter(e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setButtonVisible();
        this.initLableValue(Caller_BindData);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.setButtonVisible();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        this.initBillInfo();
        this.clearWbProperty(model);
    }

    private void clearWbProperty(IDataModel model) {
        model.setValue("billamtsum", (Object)BigDecimal.ZERO);
        model.setValue("taxsum", (Object)BigDecimal.ZERO);
        model.setValue("billamtrecsum", (Object)BigDecimal.ZERO);
        model.setValue("billamtinvsum", (Object)BigDecimal.ZERO);
        model.setValue("billamtsumstd", (Object)BigDecimal.ZERO);
    }

    private void changeConDetailAction(IDataModel model, Object propValue) {
        DynamicObjectCollection conDetailsEntry = model.getEntryEntity(ENTRY_DETAIL);
        if (propValue == null) {
            model.setValue("currency", null);
            conDetailsEntry.clear();
            model.updateEntryCache(conDetailsEntry);
            this.getView().updateView(ENTRY_DETAIL);
            return;
        }
        DynamicObject contractDetail = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)propValue).getPkValue(), (String)"sla_contractdetails");
        model.setValue("currency", (Object)contractDetail.getDynamicObject("currency"));
        DynamicObjectCollection detailsEntry = contractDetail.getDynamicObjectCollection("detailsentry");
        conDetailsEntry.clear();
        List<String> excludeFields = Arrays.asList("id", "sourceentryid");
        for (DynamicObject rowH : detailsEntry) {
            DynamicObject newRowH = conDetailsEntry.addNew();
            DataEntityPropertyCollection properties = newRowH.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (!excludeFields.contains(propertyName)) {
                    newRowH.set(propertyName, rowH.get(propertyName));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"sourceentryid", (CharSequence)propertyName)) continue;
                newRowH.set(propertyName, rowH.getPkValue());
            }
        }
        model.updateEntryCache(conDetailsEntry);
        this.getView().updateView(ENTRY_DETAIL);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initBillInfo() {
        DynamicObject initData;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object orgTemp = model.getValue("org");
        DynamicObject org = null;
        if (orgTemp == null) {
            String sscOrgId;
            String appId = this.getView().getFormShowParameter().getAppId();
            String cusAppId = (String)this.getView().getFormShowParameter().getCustomParam("cusAppId");
            if (StringUtils.isNotEmpty((CharSequence)cusAppId)) {
                appId = cusAppId;
            }
            if (!StringUtils.isNotEmpty((CharSequence)(sscOrgId = SlaUtil.getSscOrgOnNew((Long)RequestContext.get().getOrgId(), (Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)this.getView().getEntityId())))) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u5171\u4eab\u4e2d\u5fc3\u6570\u636e\u6743\u9650\u540e\u518d\u63d0\u5355\u3002", (String)"SlaServiceContractFormPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.lockPanel(view);
                return;
            }
            model.setValue("org", (Object)Long.valueOf(sscOrgId));
            org = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sscOrgId), (String)"bos_org", (String)"name");
            this.unlockPanel(view);
        } else {
            org = (DynamicObject)orgTemp;
        }
        if ((initData = SlaUtil.getSscInitData((Long)org.getLong("id"))) == null) {
            this.lockPanel(view);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4SLA\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"SlaServiceContractFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), org.getLocaleString("name")));
            return;
        }
        BillShowParameter parameter = (BillShowParameter)view.getFormShowParameter();
        Object isPeriod = parameter.getCustomParam("isPeriod");
        model.setValue("isperiod", isPeriod);
        boolean isFinishInit = (Boolean)initData.get("isfinishinit");
        if (isPeriod != null && ((Boolean)isPeriod).booleanValue()) {
            if (isFinishInit) {
                this.lockPanel(view);
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"SlaServiceContractFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), org.getLocaleString("name")));
                return;
            }
            this.unlockPanel(view);
            this.initSscInitData(model, initData);
            return;
        }
        if (isFinishInit) {
            this.unlockPanel(view);
            this.initSscInitData(model, initData);
            return;
        }
        this.lockPanel(view);
        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u521d\u59cb\u5316\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u975e\u671f\u521d\u5355\u636e\u3002", (String)"SlaServiceContractFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), org.getLocaleString("name")));
    }

    private void initSscInitData(IDataModel model, DynamicObject initData) {
        model.setValue("isperiod", (Object)(!initData.getBoolean("isfinishinit") ? 1 : 0));
        model.setValue("tallyorg", initData.get("accountingorg"));
        model.setValue("basecurrency", initData.get("standardcurrency"));
        model.setValue("exratetable", initData.get("exratetable"));
    }

    private void addCustomerFilter(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        Object relationOrg = model.getValue("relationorg");
        if (relationOrg == null) {
            e.setCancel(true);
            return;
        }
        Long relationOrgId = ((DynamicObject)relationOrg).getLong("id");
        List<Object> ids = new ArrayList(16);
        QFilter internalFilter = new QFilter("internal_company", "=", (Object)relationOrgId);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{internalFilter});
        ids = Arrays.stream(result).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter addFilter = new QFilter("id", "in", ids);
        List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
        qFilters.add(addFilter);
    }

    private void lockPanel(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
        view.setEnable(Boolean.FALSE, new String[]{"advconap", "advconap1", "attachmentpanel", "contractdetails"});
    }

    private void unlockPanel(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
        view.setEnable(Boolean.TRUE, new String[]{"advconap", "advconap1", "attachmentpanel", "contractdetails"});
    }

    private void initLableValue(String caller) {
        IDataModel model = this.getModel();
        Object currency = model.getValue("currency");
        if (currency != null) {
            String val3;
            String val2;
            String val1;
            String currName = ((DynamicObject)currency).getString("name");
            String currSign = ((DynamicObject)currency).getString("sign");
            int precision = ((DynamicObject)currency).getInt("amtprecision");
            if (precision == 0) {
                precision = 10;
            }
            Label lbCurrencyVal = (Label)this.getControl("lbcurrencyval");
            lbCurrencyVal.setText(currName);
            BigDecimal billAmtSum = (BigDecimal)model.getValue("billamtsum");
            Label lbBillAmtSumVal = (Label)this.getControl("lbbillamtsumval");
            if (BigDecimal.ZERO.compareTo(billAmtSum) != 0) {
                billAmtSum = billAmtSum.setScale(precision);
                val1 = currSign.concat(billAmtSum.toString());
            } else {
                val1 = currSign.concat("0.00");
            }
            lbBillAmtSumVal.setText(val1);
            BigDecimal billAmtRecSum = (BigDecimal)model.getValue("billamtrecsum");
            Label lbBillAmtRecSumVal = (Label)this.getControl("lbbillamtrecsumval");
            if (BigDecimal.ZERO.compareTo(billAmtRecSum) != 0) {
                billAmtRecSum = billAmtRecSum.setScale(precision);
                val2 = currSign.concat(billAmtRecSum.toString());
            } else {
                val2 = currSign.concat("0.00");
            }
            lbBillAmtRecSumVal.setText(val2);
            BigDecimal billAmtInvSum = (BigDecimal)model.getValue("billamtinvsum");
            Label lbBillAmtInvSumVal = (Label)this.getControl("lbbillamtinvsumval");
            if (BigDecimal.ZERO.compareTo(billAmtInvSum) != 0) {
                billAmtInvSum = billAmtInvSum.setScale(precision);
                val3 = currSign.concat(billAmtInvSum.toString());
            } else {
                val3 = currSign.concat("0.00");
            }
            lbBillAmtInvSumVal.setText(val3);
        }
    }

    private void setButtonVisible() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String billStatus = (String)model.getValue("billstatus");
        boolean isPeriod = (Boolean)model.getValue("isperiod");
        switch (billStatus) {
            case "A": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_viewimage"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_viewflow"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_track"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_push"});
                break;
            }
            case "B": {
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewimage"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewflow"});
                if (isPeriod) {
                    view.setVisible(Boolean.TRUE, new String[]{"bar_push"});
                    view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                    break;
                }
                view.setVisible(Boolean.FALSE, new String[]{"bar_push"});
                break;
            }
            case "C": {
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewimage"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewflow"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_track"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_push"});
                if (!isPeriod) break;
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                break;
            }
        }
    }
}

