/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.sla;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.ssc.constant.EntityField;
import kd.ssc.task.util.SscLicenseUtil;

public class SlaServiceContractListPlugin
extends AbstractListPlugin {
    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        if ("5.0".equals(version)) {
            SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"sla_servicecontract");
        }
        super.preOpenForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("isPeriod", "false");
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (param.getCustomParam("isPeriod") != null) {
            this.getPageCache().put("isPeriod", "true");
            this.getView().setEnable(Boolean.FALSE, new String[]{"tblcheck"});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isPeriod()) {
            List listColumns = args.getListColumns();
            for (int i = listColumns.size() - 1; i >= 0; --i) {
                IListColumn column = (IListColumn)listColumns.get(i);
                if (!"nextauditor".equals(column.getListFieldKey()) && !"isperiod".equals(column.getListFieldKey())) continue;
                listColumns.remove(column);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        ListSelectedRowCollection selectRows = args.getListSelectedData();
        Object[] selectPks = selectRows.getPrimaryKeyValues();
        if (source instanceof Audit) {
            QFilter qfilter1 = new QFilter("id", "in", (Object)selectPks);
            QFilter qFilter2 = new QFilter("isperiod", "=", (Object)"1");
            boolean hasPeriod = QueryServiceHelper.exists((String)"sla_servicecontract", (QFilter[])new QFilter[]{qfilter1, qFilter2});
            if (hasPeriod) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u671f\u521d\u5408\u540c\uff0c\u4e0d\u80fd\u5728\u6b64\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SlaServiceContractListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (source instanceof UnAudit) {
            QFilter qFilter = new QFilter("id", "in", (Object)selectPks);
            DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"sla_servicecontract", (String)EntityField.buildSelectField((String[])new String[]{"org", "isperiod"}), (QFilter[])new QFilter[]{qFilter});
            List periodContracts = Arrays.stream(contracts).filter(v -> v.getBoolean("isperiod")).collect(Collectors.toList());
            Set<Object> orgIds = new HashSet();
            orgIds = periodContracts.stream().map(v -> v.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            QFilter finishFilter = new QFilter("isfinishinit", "=", (Object)"1");
            boolean hasFinish = QueryServiceHelper.exists((String)"sla_init_new", (QFilter[])new QFilter[]{orgFilter, finishFilter});
            if (hasFinish) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u7684\u671f\u521d\u5408\u540c\uff0c\u4e0d\u80fd\u5728\u6b64\u53cd\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SlaServiceContractListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection collection = super.getData(start, limit);
                ArrayList ids = new ArrayList();
                collection.forEach(v -> ids.add(String.valueOf(v.getPkValue())));
                if (ids.size() > 0 && ((DynamicObject)collection.get(0)).containsProperty("nextauditor") && !SlaServiceContractListPlugin.this.isPeriod()) {
                    SlaServiceContractListPlugin.this.setNextAuditor(collection, ids);
                }
                return collection;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isPeriod()) {
            List qFilters = e.getQFilters();
            QFilter qFilter = new QFilter("isperiod", "=", (Object)Boolean.TRUE);
            qFilters.add(qFilter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        boolean isPeriod;
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        OperationStatus opStatus = parameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            isPeriod = this.isPeriod();
        } else {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)parameter.getPkId(), (String)"sla_servicecontract", (String)"isperiod");
            isPeriod = bill.getBoolean("isperiod");
        }
        parameter.setCustomParam("isPeriod", (Object)isPeriod);
        if (isPeriod) {
            parameter.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u5171\u4eab\u670d\u52a1\u5408\u540c", (String)"SlaServiceContractListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean isValid;
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        IFormView view = this.getView();
        int size = selectedRows.size();
        if (("tbltrackdown".equals(itemKey) || "tblviewimage".equals(itemKey) || "tblviewflow".equals(itemKey)) && (isValid = this.isSelectRowsInvalid(view, size, false))) {
            evt.setCancel(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fileldName = args.getHyperLinkClickEvent().getFieldName();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if ("nextauditor".equals(fileldName)) {
            args.setCancel(true);
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SlaServiceContractListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Object billid = selectedRows.get(0).getPrimaryKeyValue();
            ListShowParameter listshow = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listshow.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billid);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object initOrg = formShowParameter.getCustomParam("initOrg");
        if (!ObjectUtils.isEmpty((Object)initOrg)) {
            FilterColumn filterColumn = args.getFilterColumn("org.name");
            filterColumn.setDefaultValues(new Object[]{initOrg.toString()});
        }
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> ids) {
        Map<String, String> nextAuditor = this.getNextAuditor(ids);
        collection.forEach(v -> {
            String id = String.valueOf(v.getPkValue());
            v.set("nextauditor", (Object)(nextAuditor.get(id) == null ? "" : nextAuditor.get(id)));
        });
    }

    public Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>(10);
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        Iterator var5 = allPro.entrySet().iterator();
        while (var5.hasNext()) {
            String pkid = (String)var5.next().getKey();
            List node = (List)allPro.get(pkid);
            node.forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (auditor != null && !"".equals(auditor.trim())) {
                    nodeStr = nodeStr + " / " + auditor;
                }
                nodeMap.put(pkid, nodeStr);
            });
        }
        return nodeMap;
    }

    private boolean isSelectRowsInvalid(IFormView view, Integer size, boolean canMultipleSelect) {
        if (size == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SlaContractDetailsListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (size > 1 && !canMultipleSelect) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"SlaContractDetailsListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isPeriod() {
        return "true".equals(this.getPageCache().get("isPeriod"));
    }
}

