/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.sla.init;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.EnableStatusEnum;

public class SlaInitSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnnew", "btnok"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        BasedataEdit sscEdit = (BasedataEdit)view.getControl("ssc");
        sscEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String ssc = (String)showParameter.getCustomParam("ssc");
        Object slaInitId = showParameter.getCustomParam("slainit");
        if (slaInitId == null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"ssc"});
            if (StringUtils.isNotEmpty((CharSequence)ssc)) {
                model.setValue("ssc", (Object)Long.parseLong(ssc));
                Long accountingOrg = this.getAccountingOrg(Long.parseLong(ssc));
                model.setValue("accountingorg", (Object)accountingOrg);
                DynamicObject accountInfo = this.getAccountInfo(accountingOrg);
                if (accountInfo != null) {
                    model.setValue("standardcurrency", accountInfo.get("basecurrency"));
                    model.setValue("exratetable", accountInfo.get("exratetable"));
                    view.setEnable(Boolean.FALSE, new String[]{"standardcurrency"});
                } else {
                    model.setValue("standardcurrency", (Object)1);
                    view.setEnable(Boolean.TRUE, new String[]{"standardcurrency"});
                }
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ssc"});
            DynamicObject slaInit = BusinessDataServiceHelper.loadSingle((Object)slaInitId, (String)"sla_init_new", (String)"standardcurrency,exratetable,accountingorg,org");
            if (slaInit != null) {
                model.setValue("standardcurrency", slaInit.get("standardcurrency"));
                model.setValue("exratetable", slaInit.get("exratetable"));
                model.setValue("accountingorg", slaInit.get("accountingorg"));
                model.setValue("ssc", slaInit.get("org"));
                if (this.getAccountInfo(((DynamicObject)slaInit.get("accountingorg")).getLong("id")) == null) {
                    view.setEnable(Boolean.TRUE, new String[]{"standardcurrency"});
                } else {
                    view.setEnable(Boolean.FALSE, new String[]{"standardcurrency"});
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        if ("btnok".equals(btn.getKey()) || "btnnew".equals(btn.getKey())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object slaInitId = showParameter.getCustomParam("slainit");
            if (slaInitId != null) {
                DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)slaInitId, (String)"sla_init_new", (String)"standardcurrency,exratetable,accountingorg");
                dyn.set("standardcurrency", this.getModel().getValue("standardcurrency"));
                dyn.set("accountingorg", this.getModel().getValue("accountingorg"));
                dyn.set("exratetable", this.getModel().getValue("exratetable"));
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyn});
            } else {
                Object ssc = this.getModel().getValue("ssc");
                if (ssc != null) {
                    Object sscId = ((DynamicObject)ssc).getPkValue();
                    QFilter qFilters = new QFilter("org", "=", sscId);
                    boolean existsInit = QueryServiceHelper.exists((String)"sla_init_new", (QFilter[])qFilters.toArray());
                    if (existsInit) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"SlaInitListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"sla_init_new");
                    dyn.set("standardcurrency", this.getModel().getValue("standardcurrency"));
                    dyn.set("accountingorg", this.getModel().getValue("accountingorg"));
                    dyn.set("exratetable", this.getModel().getValue("exratetable"));
                    dyn.set("org", ssc);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
                }
            }
            if ("btnok".equals(btn.getKey())) {
                this.getView().returnDataToParent((Object)"save");
                this.getView().close();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String fieldName = edit.getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"ssc")) {
            this.addSscFilter(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"ssc")) {
            if (propValue != null) {
                Long accountingOrg = this.getAccountingOrg(((DynamicObject)propValue).getLong("id"));
                model.setValue("accountingorg", (Object)accountingOrg);
                DynamicObject accountInfo = this.getAccountInfo(accountingOrg);
                if (accountInfo != null) {
                    model.setValue("standardcurrency", accountInfo.get("basecurrency"));
                    model.setValue("exratetable", accountInfo.get("exratetable"));
                    view.setEnable(Boolean.FALSE, new String[]{"standardcurrency"});
                } else {
                    model.setValue("standardcurrency", (Object)1);
                    view.setEnable(Boolean.TRUE, new String[]{"standardcurrency"});
                }
            } else {
                model.setValue("accountingorg", null);
                model.setValue("standardcurrency", null);
                model.setValue("exratetable", null);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"accountingorg")) {
            if (propValue != null) {
                DynamicObject accountInfo = this.getAccountInfo(((DynamicObject)propValue).getLong("id"));
                if (accountInfo != null) {
                    model.setValue("standardcurrency", accountInfo.get("basecurrency"));
                    model.setValue("exratetable", accountInfo.get("exratetable"));
                    view.setEnable(Boolean.FALSE, new String[]{"standardcurrency"});
                } else {
                    model.setValue("standardcurrency", (Object)1);
                    view.setEnable(Boolean.TRUE, new String[]{"standardcurrency"});
                }
            } else {
                model.setValue("standardcurrency", null);
                model.setValue("exratetable", null);
            }
        }
    }

    private void addSscFilter(BeforeF7SelectEvent e) {
        HasPermOrgResult hasPermOrgResult;
        List valuebleIds = new ArrayList(16);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "som";
        }
        if (!(hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()), (String)"12", (String)appId, (String)"sla_init_new", (String)"47150e89000000ac")).hasAllOrgPerm()) {
            valuebleIds = hasPermOrgResult.getHasPermOrgs();
            QFilter addFilter = new QFilter("id", "in", valuebleIds);
            List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(addFilter);
        }
    }

    private Long getAccountingOrg(Long sscId) {
        Long accountingOrg = null;
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)sscId, (String)"10");
        if (!isAccounting) {
            Map orgInfoMap = OrgUnitServiceHelper.getCompanyByAdminOrg((Long)sscId);
            if (!CollectionUtils.isEmpty((Map)orgInfoMap)) {
                accountingOrg = Long.parseLong(orgInfoMap.get("id") + "");
            }
        } else {
            accountingOrg = sscId;
        }
        return accountingOrg;
    }

    private DynamicObject getAccountInfo(Long accountingOrg) {
        if (accountingOrg == null) {
            return null;
        }
        QFilter qFilters = new QFilter("org", "=", (Object)accountingOrg).and(new QFilter("bookstype.accounttype", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue()));
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency,exratetable", (QFilter[])qFilters.toArray());
        if (dyn == null) {
            qFilters = new QFilter("baseacctorg", "=", (Object)accountingOrg);
            dyn = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"basecurrrency basecurrency,exratetable", (QFilter[])qFilters.toArray());
        }
        return dyn;
    }
}

